/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;

public class EntityUtils {
    public static TypeElement asEntityElement(VariableElement parameter, Map<Name, TypeElement> typeParameters) {
        return EntityUtils.asEntityElement(parameter.asType(), typeParameters);
    }

    public static TypeElement typeArgumentAsEntityElement(TypeMirror mirror, Map<Name, TypeElement> typeParameters) {
        DeclaredType declaredType = (DeclaredType)mirror;
        assert (!declaredType.getTypeArguments().isEmpty());
        return EntityUtils.asEntityElement(declaredType.getTypeArguments().get(0), typeParameters);
    }

    public static TypeElement asEntityElement(TypeMirror mirror, Map<Name, TypeElement> typeParameters) {
        Element element;
        if (mirror.getKind() == TypeKind.TYPEVAR) {
            TypeVariable typeVariable = (TypeVariable)mirror;
            Name name = typeVariable.asElement().getSimpleName();
            element = typeParameters.get(name);
            if (element == null) {
                return null;
            }
        } else if (mirror.getKind() == TypeKind.DECLARED) {
            element = ((DeclaredType)mirror).asElement();
        } else {
            return null;
        }
        if (element.getKind() != ElementKind.CLASS) {
            return null;
        }
        TypeElement typeElement = (TypeElement)element;
        if (typeElement.getAnnotation(Entity.class) == null) {
            return null;
        }
        return typeElement;
    }

    public static boolean areParametersValid(TypeElement entityElement, EntityDefinition entityDefinition, List<? extends VariableElement> parameters, Class<? extends Annotation> annotationClass, ProcessorContext context, ExecutableElement methodElement, TypeElement processedType, String exceptionCondition) {
        List primaryKeyTypes = entityDefinition.getPrimaryKey().stream().map(d -> d.getType().asTypeName()).collect(Collectors.toList());
        List partitionKeyTypes = entityDefinition.getPartitionKey().stream().map(d -> d.getType().asTypeName()).collect(Collectors.toList());
        List parameterTypes = parameters.stream().map(p -> TypeName.get((TypeMirror)p.asType())).collect(Collectors.toList());
        if (parameterTypes.size() < partitionKeyTypes.size()) {
            context.getMessager().error(methodElement, processedType, "Invalid parameter list: %s methods that %s must at least specify partition key components (expected partition key of %s: %s)", annotationClass.getSimpleName(), exceptionCondition, entityElement.getSimpleName(), partitionKeyTypes);
            return false;
        }
        if (parameterTypes.size() > primaryKeyTypes.size()) {
            context.getMessager().error(methodElement, processedType, "Invalid parameter list: %s methods that %s must match the primary key components in the exact order (expected primary key of %s: %s). Too many parameters provided", annotationClass.getSimpleName(), exceptionCondition, entityElement.getSimpleName(), primaryKeyTypes);
            return false;
        }
        for (int parameterIndex = 0; parameterIndex < parameterTypes.size(); ++parameterIndex) {
            TypeName primaryKeyParameterType;
            TypeName parameterType = (TypeName)parameterTypes.get(parameterIndex);
            if (parameterType.equals((Object)(primaryKeyParameterType = (TypeName)primaryKeyTypes.get(parameterIndex)))) continue;
            context.getMessager().error(methodElement, processedType, "Invalid parameter list: %s methods that %s must match the primary key components in the exact order (expected primary key of %s: %s). Mismatch at index %d: %s should be %s", annotationClass.getSimpleName(), exceptionCondition, entityElement.getSimpleName(), primaryKeyTypes, parameterIndex, parameterType, primaryKeyParameterType);
            return false;
        }
        return true;
    }
}

