/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor;

import com.datastax.oss.driver.internal.core.util.concurrent.CycleDetector;
import com.datastax.oss.driver.internal.core.util.concurrent.LazyReference;
import com.datastax.oss.driver.internal.mapper.processor.CodeGeneratorFactory;
import com.datastax.oss.driver.internal.mapper.processor.DecoratedMessager;
import com.datastax.oss.driver.internal.mapper.processor.DefaultCodeGeneratorFactory;
import com.datastax.oss.driver.internal.mapper.processor.JavaPoetFiler;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.LoggingGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.DefaultEntityFactory;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityFactory;
import com.datastax.oss.driver.internal.mapper.processor.util.Classes;
import javax.annotation.processing.Filer;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class DefaultProcessorContext
implements ProcessorContext {
    private final CycleDetector cycleDetector = new CycleDetector("Detected cycle in context initialization");
    private final LazyReference<CodeGeneratorFactory> codeGeneratorFactoryRef = new LazyReference("codeGeneratorFactory", this::buildCodeGeneratorFactory, this.cycleDetector);
    private final LazyReference<EntityFactory> entityFactoryRef = new LazyReference("entityFactory", this::buildEntityFactory, this.cycleDetector);
    private final DecoratedMessager messager;
    private final Types typeUtils;
    private final Elements elementUtils;
    private final Classes classUtils;
    private final JavaPoetFiler filer;
    private final LoggingGenerator loggingGenerator;
    private final boolean customResultsEnabled;

    public DefaultProcessorContext(DecoratedMessager messager, Types typeUtils, Elements elementUtils, Filer filer, String indent, boolean logsEnabled, boolean customResultsEnabled) {
        this.messager = messager;
        this.typeUtils = typeUtils;
        this.elementUtils = elementUtils;
        this.classUtils = new Classes(typeUtils, elementUtils);
        this.filer = new JavaPoetFiler(filer, indent);
        this.loggingGenerator = new LoggingGenerator(logsEnabled);
        this.customResultsEnabled = customResultsEnabled;
    }

    protected CodeGeneratorFactory buildCodeGeneratorFactory() {
        return new DefaultCodeGeneratorFactory(this);
    }

    protected EntityFactory buildEntityFactory() {
        return new DefaultEntityFactory(this);
    }

    @Override
    public DecoratedMessager getMessager() {
        return this.messager;
    }

    @Override
    public Types getTypeUtils() {
        return this.typeUtils;
    }

    @Override
    public Elements getElementUtils() {
        return this.elementUtils;
    }

    @Override
    public Classes getClassUtils() {
        return this.classUtils;
    }

    @Override
    public JavaPoetFiler getFiler() {
        return this.filer;
    }

    @Override
    public CodeGeneratorFactory getCodeGeneratorFactory() {
        return (CodeGeneratorFactory)this.codeGeneratorFactoryRef.get();
    }

    @Override
    public EntityFactory getEntityFactory() {
        return (EntityFactory)this.entityFactoryRef.get();
    }

    @Override
    public LoggingGenerator getLoggingGenerator() {
        return this.loggingGenerator;
    }

    @Override
    public boolean areCustomResultsEnabled() {
        return this.customResultsEnabled;
    }
}

