/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.dse.driver.internal.core.cql.reactive.FailedReactiveResultSet;
import com.datastax.dse.driver.internal.mapper.reactive.FailedMappedReactiveResultSet;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.datastax.oss.driver.shaded.guava.common.base.Throwables;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.TypeName;
import java.util.Map;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public enum DefaultDaoReturnTypeKind implements DaoReturnTypeKind
{
    VOID{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("execute(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return innerBlock;
        }
    }
    ,
    BOOLEAN{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAndMapWasAppliedToBoolean(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return innerBlock;
        }
    }
    ,
    LONG{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAndMapFirstColumnToLong(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return innerBlock;
        }
    }
    ,
    ROW{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAndExtractFirstRow(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return innerBlock;
        }
    }
    ,
    ENTITY{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAndMapToSingleEntity(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return innerBlock;
        }
    }
    ,
    OPTIONAL_ENTITY{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAndMapToOptionalEntity(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return innerBlock;
        }
    }
    ,
    RESULT_SET{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return execute(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return innerBlock;
        }
    }
    ,
    BOUND_STATEMENT{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return boundStatement", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return innerBlock;
        }
    }
    ,
    PAGING_ITERABLE{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAndMapToEntityIterable(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return innerBlock;
        }
    }
    ,
    FUTURE_OF_VOID{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAsyncAndMapToVoid(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 10.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_BOOLEAN{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAsyncAndMapWasAppliedToBoolean(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 11.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_LONG{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAsyncAndMapFirstColumnToLong(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 12.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_ROW{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAsyncAndExtractFirstRow(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 13.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_ENTITY{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAsyncAndMapToSingleEntity(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 14.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_OPTIONAL_ENTITY{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAsyncAndMapToOptionalEntity(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 15.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_ASYNC_RESULT_SET{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAsync(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 16.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    FUTURE_OF_ASYNC_PAGING_ITERABLE{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAsyncAndMapToEntityIterable(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 17.wrapWithErrorHandling(innerBlock, FAILED_FUTURE);
        }
    }
    ,
    REACTIVE_RESULT_SET{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeReactive(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 18.wrapWithErrorHandling(innerBlock, FAILED_REACTIVE_RESULT_SET);
        }
    }
    ,
    MAPPED_REACTIVE_RESULT_SET{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeReactiveAndMap(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return 19.wrapWithErrorHandling(innerBlock, FAILED_MAPPED_REACTIVE_RESULT_SET);
        }
    }
    ,
    CUSTOM{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            TypeName returnTypeName = GeneratedCodePatterns.getTypeName(methodElement.getReturnType(), typeParameters);
            methodBuilder.addStatement("@$1T(\"unchecked\") $2T result =\n($2T) producer.execute(boundStatement, context, $3L)", new Object[]{SuppressWarnings.class, returnTypeName, helperFieldName}).addStatement("return result", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            TypeName returnTypeName = GeneratedCodePatterns.getTypeName(methodElement.getReturnType(), typeParameters);
            CodeBlock.Builder callWrapError = CodeBlock.builder().beginControlFlow("try", new Object[0]).addStatement("@$1T(\"unchecked\") $2T result =\n($2T) producer.wrapError(e)", new Object[]{SuppressWarnings.class, returnTypeName}).addStatement("return result", new Object[0]);
            for (TypeMirror typeMirror : methodElement.getThrownTypes()) {
                callWrapError.nextControlFlow("catch ($T e2)", new Object[]{typeMirror}).addStatement("throw e2", new Object[0]);
            }
            callWrapError.nextControlFlow("catch ($T e2)", new Object[]{Exception.class}).addStatement("$T.throwIfUnchecked(e2)", new Object[]{Throwables.class}).addStatement("throw new $T(e2)", new Object[]{RuntimeException.class}).endControlFlow();
            return 20.wrapWithErrorHandling(innerBlock, callWrapError.build());
        }
    }
    ,
    UNSUPPORTED{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            throw new AssertionError((Object)"Should never get here");
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            throw new AssertionError((Object)"Should never get here");
        }
    }
    ,
    STREAM{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            methodBuilder.addStatement("return executeAndMapToEntityStream(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, ExecutableElement methodElement, Map<Name, TypeElement> typeParameters) {
            return innerBlock;
        }
    };

    private static final CodeBlock FAILED_FUTURE;
    private static final CodeBlock FAILED_REACTIVE_RESULT_SET;
    private static final CodeBlock FAILED_MAPPED_REACTIVE_RESULT_SET;

    @Override
    public String getDescription() {
        return this.name();
    }

    @Override
    public boolean requiresReactive() {
        return this == REACTIVE_RESULT_SET || this == MAPPED_REACTIVE_RESULT_SET;
    }

    static CodeBlock wrapWithErrorHandling(CodeBlock innerBlock, CodeBlock catchBlock) {
        return CodeBlock.builder().beginControlFlow("try", new Object[0]).add(innerBlock).nextControlFlow("catch ($T e)", new Object[]{Exception.class}).add(catchBlock).endControlFlow().build();
    }

    static {
        FAILED_FUTURE = CodeBlock.builder().addStatement("return $T.failedFuture(e)", new Object[]{CompletableFutures.class}).build();
        FAILED_REACTIVE_RESULT_SET = CodeBlock.builder().addStatement("return new $T(e)", new Object[]{FailedReactiveResultSet.class}).build();
        FAILED_MAPPED_REACTIVE_RESULT_SET = CodeBlock.builder().addStatement("return new $T(e)", new Object[]{FailedMappedReactiveResultSet.class}).build();
    }
}

