/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor;

import com.datastax.oss.driver.internal.mapper.processor.CodeGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;

public abstract class SingleFileCodeGenerator
implements CodeGenerator {
    public static final String JAVADOC_GENERATED_WARNING = "Generated by the DataStax driver mapper, do not edit directly.\n";
    public static final String JAVADOC_PARAGRAPH_SEPARATOR = "\n\n<p>";
    protected final ProcessorContext context;

    protected SingleFileCodeGenerator(ProcessorContext context) {
        this.context = context;
    }

    @Override
    public void generate() {
        ClassName typeName = this.getPrincipalTypeName();
        String fileName = typeName.simpleName();
        if (!typeName.packageName().isEmpty()) {
            fileName = typeName.packageName() + '.' + fileName;
        }
        this.context.getFiler().write(fileName, this.getContents());
    }

    protected abstract ClassName getPrincipalTypeName();

    protected abstract JavaFile.Builder getContents();
}

