/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.token.Partitioner;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.DefaultNodeFilterHelper;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.OptionalLocalDcHelper;
import com.datastax.oss.driver.internal.core.util.ArrayUtils;
import com.datastax.oss.driver.internal.core.util.collection.QueryPlan;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BasicLoadBalancingPolicy
implements LoadBalancingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(BasicLoadBalancingPolicy.class);
    protected static final IntUnaryOperator INCREMENT = i -> i == Integer.MAX_VALUE ? 0 : i + 1;
    @NonNull
    protected final InternalDriverContext context;
    @NonNull
    protected final DriverExecutionProfile profile;
    @NonNull
    protected final String logPrefix;
    protected final AtomicInteger roundRobinAmount = new AtomicInteger();
    protected final CopyOnWriteArraySet<Node> liveNodes = new CopyOnWriteArraySet();
    private volatile LoadBalancingPolicy.DistanceReporter distanceReporter;
    private volatile Predicate<Node> filter;
    private volatile String localDc;

    public BasicLoadBalancingPolicy(@NonNull DriverContext context, @NonNull String profileName) {
        this.context = (InternalDriverContext)context;
        this.profile = context.getConfig().getProfile(profileName);
        this.logPrefix = context.getSessionName() + "|" + profileName;
    }

    public Optional<String> getLocalDatacenter() {
        return Optional.ofNullable(this.localDc);
    }

    public Set<Node> getLiveNodes() {
        return ImmutableSet.copyOf(this.liveNodes);
    }

    @Override
    public void init(@NonNull Map<UUID, Node> nodes, @NonNull LoadBalancingPolicy.DistanceReporter distanceReporter) {
        this.distanceReporter = distanceReporter;
        this.localDc = this.discoverLocalDc(nodes).orElse(null);
        this.filter = this.createNodeFilter(this.localDc, nodes);
        for (Node node : nodes.values()) {
            if (this.filter.test(node)) {
                distanceReporter.setDistance(node, NodeDistance.LOCAL);
                if (node.getState() == NodeState.DOWN) continue;
                this.liveNodes.add(node);
                continue;
            }
            distanceReporter.setDistance(node, NodeDistance.IGNORED);
        }
    }

    @NonNull
    protected Optional<String> discoverLocalDc(@NonNull Map<UUID, Node> nodes) {
        return new OptionalLocalDcHelper(this.context, this.profile, this.logPrefix).discoverLocalDc(nodes);
    }

    @NonNull
    protected Predicate<Node> createNodeFilter(@Nullable String localDc, @NonNull Map<UUID, Node> nodes) {
        return new DefaultNodeFilterHelper(this.context, this.profile, this.logPrefix).createNodeFilter(localDc, nodes);
    }

    @Override
    @NonNull
    public Queue<Node> newQueryPlan(@Nullable Request request, @Nullable Session session) {
        Object[] currentNodes = this.liveNodes.toArray();
        Set<Node> allReplicas = this.getReplicas(request, session);
        int replicaCount = 0;
        if (!allReplicas.isEmpty()) {
            for (int i = 0; i < currentNodes.length; ++i) {
                Node node = (Node)currentNodes[i];
                if (!allReplicas.contains(node)) continue;
                ArrayUtils.bubbleUp(currentNodes, i, replicaCount);
                ++replicaCount;
            }
            if (replicaCount > 1) {
                this.shuffleHead(currentNodes, replicaCount);
            }
        }
        LOG.trace("[{}] Prioritizing {} local replicas", (Object)this.logPrefix, (Object)replicaCount);
        ArrayUtils.rotate(currentNodes, replicaCount, currentNodes.length - replicaCount, this.roundRobinAmount.getAndUpdate(INCREMENT));
        return new QueryPlan(currentNodes);
    }

    @NonNull
    protected Set<Node> getReplicas(@Nullable Request request, @Nullable Session session) {
        if (request == null || session == null) {
            return Collections.emptySet();
        }
        Optional<TokenMap> maybeTokenMap = this.context.getMetadataManager().getMetadata().getTokenMap();
        if (!maybeTokenMap.isPresent()) {
            return Collections.emptySet();
        }
        CqlIdentifier keyspace = null;
        Token token = null;
        ByteBuffer key = null;
        Partitioner partitioner = null;
        try {
            keyspace = request.getKeyspace();
            if (keyspace == null) {
                keyspace = request.getRoutingKeyspace();
            }
            if (keyspace == null && session.getKeyspace().isPresent()) {
                keyspace = session.getKeyspace().get();
            }
            if (keyspace == null) {
                return Collections.emptySet();
            }
            token = request.getRoutingToken();
            ByteBuffer byteBuffer = key = token == null ? request.getRoutingKey() : null;
            if (token == null && key == null) {
                return Collections.emptySet();
            }
            partitioner = request.getPartitioner();
        }
        catch (Exception e) {
            LOG.error("Unexpected error while trying to compute query plan", (Throwable)e);
            return Collections.emptySet();
        }
        TokenMap tokenMap = maybeTokenMap.get();
        return token != null ? tokenMap.getReplicas(keyspace, token) : tokenMap.getReplicas(keyspace, partitioner, key);
    }

    protected void shuffleHead(Object[] currentNodes, int replicaCount) {
        ArrayUtils.shuffleHead(currentNodes, replicaCount);
    }

    @Override
    public void onAdd(@NonNull Node node) {
        if (this.filter.test(node)) {
            LOG.debug("[{}] {} was added, setting distance to LOCAL", (Object)this.logPrefix, (Object)node);
            this.distanceReporter.setDistance(node, NodeDistance.LOCAL);
        } else {
            this.distanceReporter.setDistance(node, NodeDistance.IGNORED);
        }
    }

    @Override
    public void onUp(@NonNull Node node) {
        if (this.filter.test(node)) {
            this.distanceReporter.setDistance(node, NodeDistance.LOCAL);
            if (this.liveNodes.add(node)) {
                LOG.debug("[{}] {} came back UP, added to live set", (Object)this.logPrefix, (Object)node);
            }
        } else {
            this.distanceReporter.setDistance(node, NodeDistance.IGNORED);
        }
    }

    @Override
    public void onDown(@NonNull Node node) {
        if (this.liveNodes.remove(node)) {
            LOG.debug("[{}] {} went DOWN, removed from live set", (Object)this.logPrefix, (Object)node);
        }
    }

    @Override
    public void onRemove(@NonNull Node node) {
        if (this.liveNodes.remove(node)) {
            LOG.debug("[{}] {} was removed, removed from live set", (Object)this.logPrefix, (Object)node);
        }
    }

    @Override
    public void close() {
    }
}

