/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.data.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPoint;
import com.datastax.dse.driver.internal.core.data.geometry.WkbUtil;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.esri.core.geometry.ogc.OGCLineString;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.jcip.annotations.Immutable;

@Immutable
public abstract class DefaultGeometry
implements Geometry,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final SpatialReference SPATIAL_REFERENCE_4326 = SpatialReference.create((int)4326);
    private final OGCGeometry ogcGeometry;

    @NonNull
    public static <T extends OGCGeometry> T fromOgcWellKnownText(@NonNull String source, @NonNull Class<T> klass) {
        OGCGeometry geometry;
        try {
            geometry = OGCGeometry.fromText((String)source);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        DefaultGeometry.validateType(geometry, klass);
        return (T)((OGCGeometry)klass.cast(geometry));
    }

    @NonNull
    public static <T extends OGCGeometry> T fromOgcWellKnownBinary(@NonNull ByteBuffer source, @NonNull Class<T> klass) {
        OGCGeometry geometry;
        try {
            geometry = OGCGeometry.fromBinary((ByteBuffer)source);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        DefaultGeometry.validateType(geometry, klass);
        return (T)((OGCGeometry)klass.cast(geometry));
    }

    @NonNull
    public static <T extends OGCGeometry> T fromOgcGeoJson(@NonNull String source, @NonNull Class<T> klass) {
        OGCGeometry geometry;
        try {
            geometry = OGCGeometry.fromGeoJson((String)source);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        DefaultGeometry.validateType(geometry, klass);
        return (T)((OGCGeometry)klass.cast(geometry));
    }

    private static void validateType(OGCGeometry geometry, Class<? extends OGCGeometry> klass) {
        if (!geometry.getClass().equals(klass)) {
            throw new IllegalArgumentException(String.format("%s is not of type %s", geometry.getClass().getSimpleName(), klass.getSimpleName()));
        }
    }

    protected DefaultGeometry(@NonNull OGCGeometry ogcGeometry) {
        this.ogcGeometry = ogcGeometry;
        Preconditions.checkNotNull((Object)ogcGeometry);
        DefaultGeometry.validateOgcGeometry(ogcGeometry);
    }

    private static void validateOgcGeometry(OGCGeometry geometry) {
        try {
            if (geometry.is3D()) {
                throw new IllegalArgumentException(String.format("'%s' is not 2D", geometry.asText()));
            }
            if (!geometry.isSimple()) {
                throw new IllegalArgumentException(String.format("'%s' is not simple. Points and edges cannot self-intersect.", geometry.asText()));
            }
        }
        catch (GeometryException e) {
            throw new IllegalArgumentException("Invalid geometry" + e.getMessage());
        }
    }

    @NonNull
    public static ImmutableList<Point> getPoints(@NonNull OGCLineString lineString) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < lineString.numPoints(); ++i) {
            builder.add((Object)new DefaultPoint(lineString.pointN(i)));
        }
        return builder.build();
    }

    protected static com.esri.core.geometry.Point toEsri(Point p) {
        return new com.esri.core.geometry.Point(p.X(), p.Y());
    }

    @NonNull
    public OGCGeometry getOgcGeometry() {
        return this.ogcGeometry;
    }

    @NonNull
    public com.esri.core.geometry.Geometry getEsriGeometry() {
        return this.ogcGeometry.getEsriGeometry();
    }

    @Override
    @NonNull
    public String asWellKnownText() {
        return this.ogcGeometry.asText();
    }

    @Override
    @NonNull
    public ByteBuffer asWellKnownBinary() {
        return WkbUtil.asLittleEndianBinary(this.ogcGeometry);
    }

    @Override
    @NonNull
    public String asGeoJson() {
        return this.ogcGeometry.asGeoJson();
    }

    @Override
    public boolean contains(@NonNull Geometry other) {
        Preconditions.checkNotNull((Object)other);
        if (other instanceof DefaultGeometry) {
            DefaultGeometry defautlOther = (DefaultGeometry)other;
            return this.getOgcGeometry().contains(defautlOther.getOgcGeometry());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultGeometry)) {
            return false;
        }
        DefaultGeometry that = (DefaultGeometry)o;
        return this.getOgcGeometry().equals(that.getOgcGeometry());
    }

    public int hashCode() {
        return this.getEsriGeometry().hashCode();
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public String toString() {
        return this.asWellKnownText();
    }
}

