/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.TimestampCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ZonedTimestampCodec
implements TypeCodec<ZonedDateTime> {
    private final TypeCodec<Instant> instantCodec;
    private final ZoneId timeZone;

    public ZonedTimestampCodec() {
        this(ZoneId.systemDefault());
    }

    public ZonedTimestampCodec(ZoneId timeZone) {
        this.instantCodec = new TimestampCodec(timeZone);
        this.timeZone = timeZone;
    }

    @Override
    @NonNull
    public GenericType<ZonedDateTime> getJavaType() {
        return GenericType.ZONED_DATE_TIME;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.TIMESTAMP;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof ZonedDateTime;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return javaClass == ZonedDateTime.class;
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable ZonedDateTime value, @NonNull ProtocolVersion protocolVersion) {
        return this.instantCodec.encode(value != null ? value.toInstant() : null, protocolVersion);
    }

    @Override
    @Nullable
    public ZonedDateTime decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        Instant instant = this.instantCodec.decode(bytes, protocolVersion);
        if (instant == null) {
            return null;
        }
        return instant.atZone(this.timeZone);
    }

    @Override
    @NonNull
    public String format(@Nullable ZonedDateTime value) {
        return this.instantCodec.format(value != null ? value.toInstant() : null);
    }

    @Override
    @Nullable
    public ZonedDateTime parse(@Nullable String value) {
        Instant instant = this.instantCodec.parse(value);
        if (instant == null) {
            return null;
        }
        return instant.atZone(this.timeZone);
    }
}

