/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights.schema;

import com.datastax.dse.driver.internal.core.insights.schema.SessionStateForNode;
import com.datastax.oss.driver.shaded.fasterxml.jackson.annotation.JsonCreator;
import com.datastax.oss.driver.shaded.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;

public class InsightsStatusData {
    @JsonProperty(value="clientId")
    private final String clientId;
    @JsonProperty(value="sessionId")
    private final String sessionId;
    @JsonProperty(value="controlConnection")
    private final String controlConnection;
    @JsonProperty(value="connectedNodes")
    private final Map<String, SessionStateForNode> connectedNodes;

    @JsonCreator
    private InsightsStatusData(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="sessionId") String sessionId, @JsonProperty(value="controlConnection") String controlConnection, @JsonProperty(value="connectedNodes") Map<String, SessionStateForNode> connectedNodes) {
        this.clientId = clientId;
        this.sessionId = sessionId;
        this.controlConnection = controlConnection;
        this.connectedNodes = connectedNodes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getControlConnection() {
        return this.controlConnection;
    }

    public Map<String, SessionStateForNode> getConnectedNodes() {
        return this.connectedNodes;
    }

    public String toString() {
        return "InsightsStatusData{clientId='" + this.clientId + '\'' + ", sessionId='" + this.sessionId + '\'' + ", controlConnection=" + this.controlConnection + ", connectedNodes=" + this.connectedNodes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InsightsStatusData)) {
            return false;
        }
        InsightsStatusData that = (InsightsStatusData)o;
        return Objects.equals(this.clientId, that.clientId) && Objects.equals(this.sessionId, that.sessionId) && Objects.equals(this.controlConnection, that.controlConnection) && Objects.equals(this.connectedNodes, that.connectedNodes);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.sessionId, this.controlConnection, this.connectedNodes);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String clientId;
        private String sessionId;
        private String controlConnection;
        private Map<String, SessionStateForNode> connectedNodes;

        public Builder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder withSessionId(String id) {
            this.sessionId = id;
            return this;
        }

        public Builder withControlConnection(String controlConnection) {
            this.controlConnection = controlConnection;
            return this;
        }

        public Builder withConnectedNodes(Map<String, SessionStateForNode> connectedNodes) {
            this.connectedNodes = connectedNodes;
            return this;
        }

        public InsightsStatusData build() {
            return new InsightsStatusData(this.clientId, this.sessionId, this.controlConnection, this.connectedNodes);
        }
    }
}

