/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.binary;

import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import com.datastax.dse.driver.internal.core.data.geometry.Distance;
import com.datastax.dse.driver.internal.core.graph.EditDistance;
import com.datastax.dse.driver.internal.core.graph.binary.CqlDurationSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.DistanceSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.EditDistanceSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.LineStringSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.PairSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.PointSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.PolygonSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.TupleValueSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.UdtValueSerializer;
import com.datastax.dse.driver.internal.core.graph.binary.buffer.DseNettyBufferFactory;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.shaded.netty.buffer.ByteBuf;
import com.datastax.oss.driver.shaded.netty.buffer.UnpooledByteBufAllocator;
import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.BufferFactory;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.TypeSerializerRegistry;
import org.apache.tinkerpop.gremlin.structure.io.binary.types.CustomTypeSerializer;
import org.javatuples.Pair;

public class GraphBinaryModule {
    public static final UnpooledByteBufAllocator ALLOCATOR = new UnpooledByteBufAllocator(false);
    private static final BufferFactory<ByteBuf> FACTORY = new DseNettyBufferFactory();
    static final String GRAPH_BINARY_POINT_TYPE_NAME = "driver.dse.geometry.Point";
    static final String GRAPH_BINARY_LINESTRING_TYPE_NAME = "driver.dse.geometry.LineString";
    static final String GRAPH_BINARY_POLYGON_TYPE_NAME = "driver.dse.geometry.Polygon";
    static final String GRAPH_BINARY_DISTANCE_TYPE_NAME = "driver.dse.geometry.Distance";
    static final String GRAPH_BINARY_DURATION_TYPE_NAME = "driver.core.Duration";
    static final String GRAPH_BINARY_EDIT_DISTANCE_TYPE_NAME = "driver.dse.search.EditDistance";
    static final String GRAPH_BINARY_TUPLE_VALUE_TYPE_NAME = "driver.core.TupleValue";
    static final String GRAPH_BINARY_UDT_VALUE_TYPE_NAME = "driver.core.UDTValue";
    static final String GRAPH_BINARY_PAIR_TYPE_NAME = "org.javatuples.Pair";
    private final GraphBinaryReader reader;
    private final GraphBinaryWriter writer;

    public GraphBinaryModule(GraphBinaryReader reader, GraphBinaryWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    public static TypeSerializerRegistry createDseTypeSerializerRegistry(DefaultDriverContext driverContext) {
        return TypeSerializerRegistry.build().addCustomType(CqlDuration.class, (CustomTypeSerializer)new CqlDurationSerializer()).addCustomType(Point.class, (CustomTypeSerializer)new PointSerializer()).addCustomType(LineString.class, (CustomTypeSerializer)new LineStringSerializer()).addCustomType(Polygon.class, (CustomTypeSerializer)new PolygonSerializer()).addCustomType(Distance.class, (CustomTypeSerializer)new DistanceSerializer()).addCustomType(EditDistance.class, (CustomTypeSerializer)new EditDistanceSerializer()).addCustomType(TupleValue.class, (CustomTypeSerializer)new TupleValueSerializer(driverContext)).addCustomType(UdtValue.class, (CustomTypeSerializer)new UdtValueSerializer(driverContext)).addCustomType(Pair.class, (CustomTypeSerializer)new PairSerializer()).create();
    }

    public <T> T deserialize(Buffer buffer) throws IOException {
        return (T)this.reader.read(buffer);
    }

    public <T> Buffer serialize(T value) throws IOException {
        return this.serialize(value, FACTORY.create((Object)ALLOCATOR.heapBuffer()));
    }

    public <T> Buffer serialize(T value, Buffer buffer) throws IOException {
        try {
            this.writer.write(value, buffer);
            return buffer;
        }
        catch (Exception e) {
            buffer.release();
            throw e;
        }
    }
}

