/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.api.core.connection.FrameTooLongException;
import com.datastax.oss.driver.shaded.netty.buffer.ByteBuf;
import com.datastax.oss.driver.shaded.netty.channel.ChannelHandler;
import com.datastax.oss.driver.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.oss.driver.shaded.netty.handler.codec.MessageToMessageEncoder;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.FrameCodec;
import com.datastax.oss.protocol.internal.ProtocolFeatures;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ChannelHandler.Sharable
@ThreadSafe
public class FrameEncoder
extends MessageToMessageEncoder<Frame> {
    private final FrameCodec<ByteBuf> frameCodec;
    private final ProtocolFeatures protocolFeatures;
    private final int maxFrameLength;

    public FrameEncoder(FrameCodec<ByteBuf> frameCodec, ProtocolFeatures protocolFeatures, int maxFrameLength) {
        super(Frame.class);
        this.frameCodec = frameCodec;
        this.protocolFeatures = protocolFeatures;
        this.maxFrameLength = maxFrameLength;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
        ByteBuf buffer = (ByteBuf)this.frameCodec.encode(frame, this.protocolFeatures);
        int actualLength = buffer.readableBytes();
        if (actualLength > this.maxFrameLength) {
            throw new FrameTooLongException(ctx.channel().remoteAddress(), String.format("Outgoing frame length exceeds %d: %d", this.maxFrameLength, actualLength));
        }
        out.add(buffer);
    }
}

