/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.api.core.connection.FrameTooLongException;
import com.datastax.oss.driver.internal.core.protocol.FrameDecodingException;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.shaded.netty.buffer.ByteBuf;
import com.datastax.oss.driver.shaded.netty.channel.ChannelHandlerContext;
import com.datastax.oss.driver.shaded.netty.handler.codec.LengthFieldBasedFrameDecoder;
import com.datastax.oss.driver.shaded.netty.handler.codec.TooLongFrameException;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.FrameCodec;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.ProtocolFeatures;
import com.datastax.oss.protocol.internal.response.Error;
import java.util.Collections;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class FrameDecoder
extends LengthFieldBasedFrameDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(FrameDecoder.class);
    private static final int LENGTH_FIELD_OFFSET = 5;
    private static final int LENGTH_FIELD_LENGTH = 4;
    private final FrameCodec<ByteBuf> frameCodec;
    private final ProtocolFeatures protocolFeatures;
    private boolean isFirstResponse;

    public FrameDecoder(FrameCodec<ByteBuf> frameCodec, ProtocolFeatures protocolFeatures, int maxFrameLengthInBytes) {
        super(maxFrameLengthInBytes, 5, 4, 0, 0, true);
        this.frameCodec = frameCodec;
        this.protocolFeatures = protocolFeatures;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        int startIndex = in.readerIndex();
        if (this.isFirstResponse) {
            this.isFirstResponse = false;
            if (in.readableBytes() < 8) {
                return null;
            }
            int protocolVersion = in.getByte(startIndex) & 0x7F;
            if (protocolVersion < 3) {
                byte streamId = in.getByte(startIndex + 2);
                int length = in.getInt(startIndex + 4);
                if (in.readableBytes() < 8 + length) {
                    return null;
                }
                in.readerIndex(startIndex + 8 + length);
                return Frame.forResponse((int)protocolVersion, (int)streamId, null, (Map)Frame.NO_PAYLOAD, Collections.emptyList(), (Message)new Error(10, "Invalid or unsupported protocol version"));
            }
        }
        try {
            ByteBuf buffer = (ByteBuf)super.decode(ctx, in);
            return buffer == null ? null : this.frameCodec.decode((Object)buffer, this.protocolFeatures);
        }
        catch (Exception e2) {
            FrameTooLongException e2;
            int streamId;
            try {
                streamId = in.getShort(startIndex + 2);
            }
            catch (Exception e1) {
                Loggers.warnWithException(LOG, "Unexpected error while reading stream id", e1);
                streamId = -1;
            }
            if (e2 instanceof TooLongFrameException) {
                e2 = new FrameTooLongException(ctx.channel().remoteAddress(), e2.getMessage());
            }
            throw new FrameDecodingException(streamId, (Throwable)e2);
        }
    }

    @Override
    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

