/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.metadata.KeyspaceTableNamePair;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.Tablet;
import com.datastax.oss.driver.api.core.metadata.TabletMap;
import com.datastax.oss.driver.shaded.guava.common.annotations.Beta;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class DefaultTabletMap
implements TabletMap {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTabletMap.class);
    @NonNull
    private final ConcurrentMap<KeyspaceTableNamePair, ConcurrentSkipListSet<Tablet>> mapping;

    private DefaultTabletMap(@NonNull ConcurrentMap<KeyspaceTableNamePair, ConcurrentSkipListSet<Tablet>> mapping) {
        this.mapping = mapping;
    }

    public static DefaultTabletMap emptyMap() {
        return new DefaultTabletMap(new ConcurrentHashMap<KeyspaceTableNamePair, ConcurrentSkipListSet<Tablet>>());
    }

    @Override
    @NonNull
    public ConcurrentMap<KeyspaceTableNamePair, ConcurrentSkipListSet<Tablet>> getMapping() {
        return this.mapping;
    }

    @Override
    public Tablet getTablet(CqlIdentifier keyspace, CqlIdentifier table, long token) {
        KeyspaceTableNamePair key = new KeyspaceTableNamePair(keyspace, table);
        NavigableSet set = (NavigableSet)this.mapping.get(key);
        if (set == null) {
            LOG.trace("There is no tablets for {}.{} in current mapping. Returning null.", (Object)keyspace, (Object)table);
            return null;
        }
        Tablet result = ((ConcurrentSkipListSet)this.mapping.get(key)).ceiling(DefaultTablet.malformedTablet(token));
        if (result == null || result.getFirstToken() >= token) {
            LOG.trace("Could not find tablet for {}.{} that owns token {}. Returning null.", new Object[]{keyspace, table, token});
            return null;
        }
        return result;
    }

    @Override
    public void addTablet(CqlIdentifier keyspace, CqlIdentifier table, Tablet tablet) {
        Tablet nextTablet;
        LOG.trace("Adding tablet for {}.{} with contents {}", new Object[]{keyspace, table, tablet});
        KeyspaceTableNamePair ktPair = new KeyspaceTableNamePair(keyspace, table);
        NavigableSet existingTablets = this.mapping.computeIfAbsent(ktPair, k -> new ConcurrentSkipListSet());
        Iterator<Tablet> it = existingTablets.headSet(tablet, true).descendingIterator();
        while (it.hasNext() && (nextTablet = it.next()).getLastToken() > tablet.getFirstToken()) {
            it.remove();
        }
        it = existingTablets.tailSet(tablet, true).iterator();
        while (it.hasNext() && (nextTablet = it.next()).getFirstToken() < tablet.getLastToken()) {
            it.remove();
        }
        existingTablets.add(tablet);
    }

    @Override
    public void removeByNode(Node node) {
        for (ConcurrentSkipListSet tabletSet : this.mapping.values()) {
            Iterator it = tabletSet.iterator();
            while (it.hasNext()) {
                if (!((Tablet)it.next()).getReplicaNodes().contains(node)) continue;
                it.remove();
            }
        }
    }

    @Override
    public void removeByKeyspace(CqlIdentifier keyspace) {
        this.mapping.keySet().removeIf(keyspaceTableNamePair -> keyspaceTableNamePair.getKeyspace().equals(keyspace));
    }

    @Override
    public void removeByTable(CqlIdentifier table) {
        this.mapping.keySet().removeIf(keyspaceTableNamePair -> keyspaceTableNamePair.getTableName().equals(table));
    }

    public static class DefaultTablet
    implements Tablet {
        private final long firstToken;
        private final long lastToken;
        @NonNull
        private final Set<Node> replicaNodes;
        @NonNull
        private final Map<Node, Integer> replicaShards;

        @VisibleForTesting
        DefaultTablet(long firstToken, long lastToken, @NonNull Set<Node> replicaNodes, @NonNull Map<Node, Integer> replicaShards) {
            this.firstToken = firstToken;
            this.lastToken = lastToken;
            this.replicaNodes = replicaNodes;
            this.replicaShards = replicaShards;
        }

        public static DefaultTablet parseTabletPayloadV1(TupleValue tupleValue, Map<UUID, Node> nodes) {
            long firstToken = tupleValue.getLong(0);
            long lastToken = tupleValue.getLong(1);
            HashSet<Node> replicaNodes = new HashSet<Node>();
            HashMap<Node, Integer> replicaShards = new HashMap<Node, Integer>();
            List<TupleValue> list = tupleValue.getList(2, TupleValue.class);
            assert (list != null);
            for (TupleValue tuple : list) {
                Node node = nodes.get(tuple.getUuid(0));
                if (node == null) continue;
                int shard = tuple.getInt(1);
                replicaNodes.add(node);
                replicaShards.put(node, shard);
            }
            return new DefaultTablet(firstToken, lastToken, replicaNodes, replicaShards);
        }

        public static DefaultTablet malformedTablet(long lastToken) {
            return new DefaultTablet(lastToken, lastToken, Collections.emptySet(), Collections.emptyMap());
        }

        @Override
        public long getFirstToken() {
            return this.firstToken;
        }

        @Override
        public long getLastToken() {
            return this.lastToken;
        }

        @Override
        public Set<Node> getReplicaNodes() {
            return this.replicaNodes;
        }

        @Override
        public int getShardForNode(Node n) {
            return this.replicaShards.getOrDefault(n, -1);
        }

        public String toString() {
            return "DefaultTablet{firstToken=" + this.firstToken + ", lastToken=" + this.lastToken + ", replicaNodes=" + this.replicaNodes + ", replicaShards=" + this.replicaShards + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DefaultTablet)) {
                return false;
            }
            DefaultTablet that = (DefaultTablet)o;
            return this.firstToken == that.firstToken && this.lastToken == that.lastToken && this.replicaNodes.equals(that.replicaNodes) && this.replicaShards.equals(that.replicaShards);
        }

        public int hashCode() {
            return Objects.hash(this.firstToken, this.lastToken, this.replicaNodes, this.replicaShards);
        }

        @Override
        public int compareTo(Tablet tablet) {
            return Long.compare(this.lastToken, tablet.getLastToken());
        }
    }
}

