/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.connection;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantReconnectionPolicy
implements ReconnectionPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(ConstantReconnectionPolicy.class);
    private final String logPrefix;
    private final ReconnectionPolicy.ReconnectionSchedule schedule;

    public ConstantReconnectionPolicy(DriverContext context) {
        this.logPrefix = context.getSessionName();
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        Duration delay = config.getDuration(DefaultDriverOption.RECONNECTION_BASE_DELAY);
        if (delay.isNegative()) {
            throw new IllegalArgumentException(String.format("Invalid negative delay for " + DefaultDriverOption.RECONNECTION_BASE_DELAY.getPath() + " (got %d)", delay));
        }
        this.schedule = () -> delay;
    }

    @Override
    @NonNull
    public ReconnectionPolicy.ReconnectionSchedule newNodeSchedule(@NonNull Node node) {
        LOG.debug("[{}] Creating new schedule for {}", (Object)this.logPrefix, (Object)node);
        return this.schedule;
    }

    @Override
    @NonNull
    public ReconnectionPolicy.ReconnectionSchedule newControlConnectionSchedule(boolean isInitialConnection) {
        LOG.debug("[{}] Creating new schedule for the control connection", (Object)this.logPrefix);
        return this.schedule;
    }

    @Override
    public void close() {
    }
}

