/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.esri.core.geometry;

import com.datastax.oss.driver.shaded.esri.core.geometry.AttributeStreamBase;
import com.datastax.oss.driver.shaded.esri.core.geometry.AttributeStreamOfDbl;
import com.datastax.oss.driver.shaded.esri.core.geometry.AttributeStreamOfInt32;
import com.datastax.oss.driver.shaded.esri.core.geometry.AttributeStreamOfInt8;
import com.datastax.oss.driver.shaded.esri.core.geometry.ByteBufferCursor;
import com.datastax.oss.driver.shaded.esri.core.geometry.Envelope;
import com.datastax.oss.driver.shaded.esri.core.geometry.Envelope1D;
import com.datastax.oss.driver.shaded.esri.core.geometry.Geometry;
import com.datastax.oss.driver.shaded.esri.core.geometry.GeometryCursor;
import com.datastax.oss.driver.shaded.esri.core.geometry.GeometryException;
import com.datastax.oss.driver.shaded.esri.core.geometry.Interop;
import com.datastax.oss.driver.shaded.esri.core.geometry.MultiPath;
import com.datastax.oss.driver.shaded.esri.core.geometry.MultiPathImpl;
import com.datastax.oss.driver.shaded.esri.core.geometry.MultiPoint;
import com.datastax.oss.driver.shaded.esri.core.geometry.MultiPointImpl;
import com.datastax.oss.driver.shaded.esri.core.geometry.NumberUtils;
import com.datastax.oss.driver.shaded.esri.core.geometry.Point;
import com.datastax.oss.driver.shaded.esri.core.geometry.Polygon;
import com.datastax.oss.driver.shaded.esri.core.geometry.Polyline;
import com.datastax.oss.driver.shaded.esri.core.geometry.VertexDescription;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class OperatorImportFromESRIShapeCursor
extends GeometryCursor {
    ByteBufferCursor m_inputShapeBuffers;
    int m_importFlags;
    int m_type;
    int m_index = -1;

    public OperatorImportFromESRIShapeCursor(int importFlags, int type, ByteBufferCursor shapeBuffers) {
        if (shapeBuffers == null) {
            throw new GeometryException("invalid argument");
        }
        this.m_importFlags = importFlags;
        this.m_type = type;
        this.m_inputShapeBuffers = shapeBuffers;
    }

    @Override
    public Geometry next() {
        ByteBuffer shapeBuffer = this.m_inputShapeBuffers.next();
        if (shapeBuffer != null) {
            this.m_index = this.m_inputShapeBuffers.getByteBufferID();
            return this.importFromESRIShape(shapeBuffer);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Geometry importFromESRIShape(ByteBuffer shapeBuffer) {
        int modifiers;
        int generaltype;
        int shapetype = shapeBuffer.getInt(0);
        switch (shapetype & 0xFF) {
            case 5: {
                generaltype = 51;
                modifiers = 0;
                break;
            }
            case 15: {
                generaltype = 51;
                modifiers = -1073741824;
                break;
            }
            case 25: {
                generaltype = 51;
                modifiers = 0x40000000;
                break;
            }
            case 19: {
                generaltype = 51;
                modifiers = Integer.MIN_VALUE;
                break;
            }
            case 51: {
                generaltype = 51;
                modifiers = shapetype & 0xFF000000;
                break;
            }
            case 3: {
                generaltype = 50;
                modifiers = 0;
                break;
            }
            case 13: {
                generaltype = 50;
                modifiers = -1073741824;
                break;
            }
            case 23: {
                generaltype = 50;
                modifiers = 0x40000000;
                break;
            }
            case 10: {
                generaltype = 50;
                modifiers = Integer.MIN_VALUE;
                break;
            }
            case 50: {
                generaltype = 50;
                modifiers = shapetype & 0xFF000000;
                break;
            }
            case 8: {
                generaltype = 53;
                modifiers = 0;
                break;
            }
            case 18: {
                generaltype = 53;
                modifiers = -1073741824;
                break;
            }
            case 28: {
                generaltype = 53;
                modifiers = 0x40000000;
                break;
            }
            case 20: {
                generaltype = 53;
                modifiers = Integer.MIN_VALUE;
                break;
            }
            case 53: {
                generaltype = 53;
                modifiers = shapetype & 0xFF000000;
                break;
            }
            case 1: {
                generaltype = 52;
                modifiers = 0;
                break;
            }
            case 11: {
                generaltype = 52;
                modifiers = -1073741824;
                break;
            }
            case 21: {
                generaltype = 52;
                modifiers = 0x40000000;
                break;
            }
            case 9: {
                generaltype = 52;
                modifiers = Integer.MIN_VALUE;
                break;
            }
            case 52: {
                generaltype = 52;
                modifiers = shapetype & 0xFF000000;
                break;
            }
            case 0: {
                return null;
            }
            default: {
                throw new GeometryException("invalid shape type");
            }
        }
        ByteOrder initialOrder = shapeBuffer.order();
        shapeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        try {
            switch (generaltype) {
                case 51: {
                    if (this.m_type != 1736 && this.m_type != 0 && this.m_type != 197) {
                        throw new GeometryException("invalid shape type");
                    }
                    Geometry geometry = this.importFromESRIShapeMultiPath(true, modifiers, shapeBuffer);
                    return geometry;
                }
                case 50: {
                    if (this.m_type != 1607 && this.m_type != 0 && this.m_type != 197) {
                        throw new GeometryException("invalid shape type");
                    }
                    Geometry geometry = this.importFromESRIShapeMultiPath(false, modifiers, shapeBuffer);
                    return geometry;
                }
                case 53: {
                    if (this.m_type != 550 && this.m_type != 0 && this.m_type != 197) {
                        throw new GeometryException("invalid shape type");
                    }
                    Geometry geometry = this.importFromESRIShapeMultiPoint(modifiers, shapeBuffer);
                    return geometry;
                }
                case 52: {
                    if (this.m_type != 33 && this.m_type != 550 && this.m_type != 0 && this.m_type != 197) {
                        throw new GeometryException("invalid shape type");
                    }
                    Geometry geometry = this.importFromESRIShapePoint(modifiers, shapeBuffer);
                    return geometry;
                }
            }
            Geometry geometry = null;
            return geometry;
        }
        finally {
            shapeBuffer.order(initialOrder);
        }
    }

    private Geometry importFromESRIShapeMultiPath(boolean bPolygon, int modifiers, ByteBuffer shapeBuffer) {
        int endpartActual;
        int startpart;
        boolean bCreate;
        int offset = 4;
        boolean bZs = (modifiers & Integer.MIN_VALUE) != 0;
        boolean bMs = (modifiers & 0x40000000) != 0;
        boolean bIDs = (modifiers & 0x10000000) != 0;
        boolean bHasAttributes = bZs || bMs || bIDs;
        boolean bHasBadRings = false;
        double xmin = shapeBuffer.getDouble(offset);
        double ymin = shapeBuffer.getDouble(offset += 8);
        double xmax = shapeBuffer.getDouble(offset += 8);
        double ymax = shapeBuffer.getDouble(offset += 8);
        int originalPartCount = shapeBuffer.getInt(offset += 8);
        int partCount = 0;
        int pointCount = shapeBuffer.getInt(offset += 4);
        offset += 4;
        AttributeStreamOfDbl position = null;
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfInt32 ids = null;
        AttributeStreamOfInt32 parts = null;
        AttributeStreamOfInt8 pathFlags = null;
        Envelope bbox = null;
        MultiPath multipath = null;
        MultiPathImpl multipathImpl = null;
        if (this.m_type == 1736 || this.m_type == 1607 || this.m_type == 0) {
            multipath = bPolygon ? new Polygon() : new Polyline();
            multipathImpl = (MultiPathImpl)multipath._getImpl();
            if (pointCount > 0) {
                bbox = new Envelope();
                bbox.setCoords(xmin, ymin, xmax, ymax);
                parts = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(originalPartCount + 1);
                int previstart = -1;
                int lastCount = 0;
                for (int i = 0; i < originalPartCount; ++i) {
                    int istart = shapeBuffer.getInt(offset);
                    offset += 4;
                    lastCount = istart;
                    if (previstart > istart || istart < 0) {
                        throw new GeometryException("corrupted geometry");
                    }
                    if (istart == previstart) continue;
                    parts.write(partCount, istart);
                    previstart = istart;
                    ++partCount;
                }
                parts.resize(partCount + 1);
                if (pointCount < lastCount) {
                    throw new GeometryException("corrupted geometry");
                }
                parts.write(partCount, pointCount);
                pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(parts.size(), (byte)0);
                position = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(0, pointCount);
                int startpart2 = parts.read(0);
                int xyindex = 0;
                for (int ipart = 0; ipart < partCount; ++ipart) {
                    int endpartActual2 = parts.read(ipart + 1);
                    int endpart = bPolygon ? endpartActual2 - 1 : endpartActual2;
                    double startx = shapeBuffer.getDouble(offset);
                    double starty = shapeBuffer.getDouble(offset += 8);
                    offset += 8;
                    position.write(2 * xyindex, startx);
                    position.write(2 * xyindex + 1, starty);
                    ++xyindex;
                    for (int i = startpart2 + 1; i < endpart; ++i) {
                        double x = shapeBuffer.getDouble(offset);
                        double y = shapeBuffer.getDouble(offset += 8);
                        offset += 8;
                        position.write(2 * xyindex, x);
                        position.write(2 * xyindex + 1, y);
                        ++xyindex;
                    }
                    if (endpart - startpart2 < 2) {
                        multipathImpl.setIsSimple(-1, 0.0, false);
                    }
                    if (bPolygon) {
                        if (startpart2 == endpart) {
                            parts.write(ipart + 1, xyindex);
                        } else {
                            double x = shapeBuffer.getDouble(offset);
                            double y = shapeBuffer.getDouble(offset += 8);
                            offset += 8;
                            if (x != startx || y != starty) {
                                position.write(2 * xyindex, x);
                                position.write(2 * xyindex + 1, y);
                                multipathImpl.setIsSimple(-1, 0.0, false);
                                bHasBadRings = true;
                                parts.write(ipart + 1, bHasAttributes ? -xyindex : ++xyindex);
                            } else {
                                parts.write(ipart + 1, xyindex);
                            }
                        }
                        pathFlags.setBits(ipart, (byte)1);
                    }
                    startpart2 = endpartActual2;
                }
                if (bZs) {
                    bbox.addAttribute(1);
                }
                if (bMs) {
                    bbox.addAttribute(2);
                }
                if (bIDs) {
                    bbox.addAttribute(3);
                }
            }
        } else {
            bbox = new Envelope();
            if (bZs) {
                bbox.addAttribute(1);
            }
            if (bMs) {
                bbox.addAttribute(2);
            }
            if (bIDs) {
                bbox.addAttribute(3);
            }
            if (pointCount > 0) {
                bbox.setCoords(xmin, ymin, xmax, ymax);
                offset += pointCount * 16 + originalPartCount * 4;
            } else {
                return bbox;
            }
        }
        if (bZs) {
            if (pointCount > 0) {
                double zmin = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset));
                double zmax = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset += 8));
                offset += 8;
                Envelope1D env = new Envelope1D();
                env.setCoords(zmin, zmax);
                bbox.setInterval(1, 0, env);
                if (this.m_type == 1736 || this.m_type == 1607 || this.m_type == 0) {
                    zs = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(1, pointCount);
                    bCreate = false;
                    startpart = parts.read(0);
                    for (int ipart = 0; ipart < partCount; ++ipart) {
                        endpartActual = parts.read(ipart + 1);
                        int endpart = Math.abs(endpartActual);
                        double startz = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset));
                        offset += 8;
                        zs.write(startpart, startz);
                        if (!VertexDescription.isDefaultValue(1, startz)) {
                            bCreate = true;
                        }
                        for (int i = startpart + 1; i < endpart; ++i) {
                            double z = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset));
                            offset += 8;
                            zs.write(i, z);
                            if (VertexDescription.isDefaultValue(1, z)) continue;
                            bCreate = true;
                        }
                        if (bPolygon && endpartActual > 0) {
                            offset += 8;
                        }
                        startpart = endpart;
                    }
                    if (!bCreate) {
                        zs = null;
                    }
                } else {
                    offset += pointCount * 8;
                }
            }
            if (this.m_type == 1736 || this.m_type == 1607 || this.m_type == 0) {
                multipathImpl.setAttributeStreamRef(1, zs);
            }
        }
        if (bMs) {
            if (pointCount > 0) {
                double mmin = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset));
                double mmax = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset += 8));
                offset += 8;
                Envelope1D env = new Envelope1D();
                env.setCoords(mmin, mmax);
                bbox.setInterval(2, 0, env);
                if (this.m_type == 1736 || this.m_type == 1607 || this.m_type == 0) {
                    ms = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(2, pointCount);
                    bCreate = false;
                    startpart = parts.read(0);
                    for (int ipart = 0; ipart < partCount; ++ipart) {
                        endpartActual = parts.read(ipart + 1);
                        int endpart = Math.abs(endpartActual);
                        double startm = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset));
                        offset += 8;
                        ms.write(startpart, startm);
                        if (!VertexDescription.isDefaultValue(2, startm)) {
                            bCreate = true;
                        }
                        for (int i = startpart + 1; i < endpart; ++i) {
                            double m = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset));
                            offset += 8;
                            ms.write(i, m);
                            if (VertexDescription.isDefaultValue(2, m)) continue;
                            bCreate = true;
                        }
                        if (bPolygon && endpartActual > 0) {
                            offset += 8;
                        }
                        startpart = endpart;
                    }
                    if (!bCreate) {
                        ms = null;
                    }
                } else {
                    offset += pointCount * 8;
                }
            }
            if (this.m_type == 1736 || this.m_type == 1607 || this.m_type == 0) {
                multipathImpl.setAttributeStreamRef(2, ms);
            }
        }
        if (bIDs) {
            if (pointCount > 0) {
                double idmin = NumberUtils.doubleMax();
                double idmax = -NumberUtils.doubleMax();
                if (this.m_type == 1736 || this.m_type == 1607 || this.m_type == 0) {
                    ids = (AttributeStreamOfInt32)AttributeStreamBase.createAttributeStreamWithSemantics(3, pointCount);
                    boolean bCreate2 = false;
                    int startpart3 = parts.read(0);
                    for (int ipart = 0; ipart < partCount; ++ipart) {
                        int endpartActual3 = parts.read(ipart + 1);
                        int endpart = Math.abs(endpartActual3);
                        int startid = shapeBuffer.getInt(offset);
                        offset += 4;
                        ids.write(startpart3, startid);
                        if (!VertexDescription.isDefaultValue(3, startid)) {
                            bCreate2 = true;
                        }
                        for (int i = startpart3 + 1; i < endpart; ++i) {
                            int id = shapeBuffer.getInt(offset);
                            offset += 4;
                            ids.write(i, id);
                            if (!bCreate2 && !VertexDescription.isDefaultValue(3, id)) {
                                bCreate2 = true;
                            }
                            if (idmin > (double)id) {
                                idmin = id;
                                continue;
                            }
                            if (!(idmax < (double)id)) continue;
                            idmax = id;
                        }
                        if (bPolygon && endpartActual3 > 0) {
                            offset += 4;
                        }
                        startpart3 = endpart;
                    }
                    if (!bCreate2) {
                        ids = null;
                    }
                } else {
                    for (int i = 0; i < pointCount; ++i) {
                        int id = shapeBuffer.getInt(offset);
                        offset += 4;
                        if (idmin > (double)id) {
                            idmin = id;
                            continue;
                        }
                        if (!(idmax < (double)id)) continue;
                        idmax = id;
                    }
                }
                Envelope1D env = new Envelope1D();
                env.setCoords(idmin, idmax);
                bbox.setInterval(3, 0, env);
            }
            if (this.m_type == 1736 || this.m_type == 1607 || this.m_type == 0) {
                multipathImpl.setAttributeStreamRef(3, ids);
            }
        }
        if (bHasBadRings && bHasAttributes) {
            for (int ipart = 1; ipart < partCount + 1; ++ipart) {
                int v = parts.read(ipart);
                if (v >= 0) continue;
                parts.write(ipart, -v);
            }
        }
        if (this.m_type == 197) {
            return bbox;
        }
        if (pointCount > 0) {
            multipathImpl.setPathStreamRef(parts);
            multipathImpl.setPathFlagsStreamRef(pathFlags);
            multipathImpl.setAttributeStreamRef(0, position);
            multipathImpl.setEnvelope(bbox);
        }
        if ((this.m_importFlags & 2) == 0) {
            multipathImpl.setIsSimple(1, 0.0, false);
        }
        return multipath;
    }

    private Geometry importFromESRIShapeMultiPoint(int modifiers, ByteBuffer shapeBuffer) {
        double value;
        int i;
        boolean bCreate;
        Envelope1D env;
        int offset = 4;
        boolean bZs = (modifiers & Integer.MIN_VALUE) != 0;
        boolean bMs = (modifiers & 0x40000000) != 0;
        boolean bIDs = (modifiers & modifiers & 0x10000000) != 0;
        double xmin = shapeBuffer.getDouble(offset);
        double ymin = shapeBuffer.getDouble(offset += 8);
        double xmax = shapeBuffer.getDouble(offset += 8);
        double ymax = shapeBuffer.getDouble(offset += 8);
        int cPoints = shapeBuffer.getInt(offset += 8);
        offset += 4;
        AttributeStreamOfDbl position = null;
        AttributeStreamOfDbl zs = null;
        AttributeStreamOfDbl ms = null;
        AttributeStreamOfInt32 ids = null;
        Envelope bbox = null;
        MultiPoint multipoint = null;
        MultiPointImpl multipointImpl = null;
        if (this.m_type == 550 || this.m_type == 0) {
            multipoint = new MultiPoint();
            multipointImpl = (MultiPointImpl)multipoint._getImpl();
            if (cPoints > 0) {
                bbox = new Envelope();
                multipointImpl.resize(cPoints);
                position = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(0, cPoints);
                for (int i2 = 0; i2 < cPoints; ++i2) {
                    double x = shapeBuffer.getDouble(offset);
                    double y = shapeBuffer.getDouble(offset += 8);
                    offset += 8;
                    position.write(2 * i2, x);
                    position.write(2 * i2 + 1, y);
                }
                multipointImpl.resize(cPoints);
                bbox.setCoords(xmin, ymin, xmax, ymax);
                if (bZs) {
                    bbox.addAttribute(1);
                }
                if (bMs) {
                    bbox.addAttribute(2);
                }
                if (bIDs) {
                    bbox.addAttribute(3);
                }
            }
        } else {
            bbox = new Envelope();
            if (bZs) {
                bbox.addAttribute(1);
            }
            if (bMs) {
                bbox.addAttribute(2);
            }
            if (bIDs) {
                bbox.addAttribute(3);
            }
            if (cPoints > 0) {
                bbox.setCoords(xmin, ymin, xmax, ymax);
                offset += cPoints * 16;
            } else {
                return bbox;
            }
        }
        if (bZs) {
            if (cPoints > 0) {
                double zmin = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset));
                double zmax = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset += 8));
                offset += 8;
                env = new Envelope1D();
                env.setCoords(zmin, zmax);
                bbox.setInterval(1, 0, env);
                if (this.m_type == 550 || this.m_type == 0) {
                    zs = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(1, cPoints);
                    bCreate = false;
                    for (i = 0; i < cPoints; ++i) {
                        value = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset));
                        offset += 8;
                        zs.write(i, value);
                        if (VertexDescription.isDefaultValue(1, value)) continue;
                        bCreate = true;
                    }
                    if (!bCreate) {
                        zs = null;
                    }
                } else {
                    offset += cPoints * 8;
                }
            }
            if (this.m_type == 550 || this.m_type == 0) {
                multipointImpl.setAttributeStreamRef(1, zs);
            }
        }
        if (bMs) {
            if (cPoints > 0) {
                double mmin = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset));
                double mmax = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset += 8));
                offset += 8;
                env = new Envelope1D();
                env.setCoords(mmin, mmax);
                bbox.setInterval(2, 0, env);
                if (this.m_type == 550 || this.m_type == 0) {
                    ms = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithSemantics(2, cPoints);
                    bCreate = false;
                    for (i = 0; i < cPoints; ++i) {
                        value = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset));
                        offset += 8;
                        ms.write(i, value);
                        if (VertexDescription.isDefaultValue(2, value)) continue;
                        bCreate = true;
                    }
                    if (!bCreate) {
                        ms = null;
                    }
                } else {
                    offset += cPoints * 8;
                }
            }
            if (this.m_type == 550 || this.m_type == 0) {
                multipointImpl.setAttributeStreamRef(2, ms);
            }
        }
        if (bIDs) {
            if (cPoints > 0) {
                double idmin = NumberUtils.doubleMax();
                double idmax = -NumberUtils.doubleMax();
                if (this.m_type == 550 || this.m_type == 0) {
                    ids = (AttributeStreamOfInt32)AttributeStreamBase.createAttributeStreamWithSemantics(3, cPoints);
                    boolean bCreate2 = false;
                    for (int i3 = 0; i3 < cPoints; ++i3) {
                        int value2 = shapeBuffer.getInt(offset);
                        offset += 4;
                        ids.write(i3, value2);
                        if (!VertexDescription.isDefaultValue(3, value2)) {
                            bCreate2 = true;
                        }
                        if (idmin > (double)value2) {
                            idmin = value2;
                            continue;
                        }
                        if (!(idmax < (double)value2)) continue;
                        idmax = value2;
                    }
                    if (!bCreate2) {
                        ids = null;
                    }
                } else {
                    for (int i4 = 0; i4 < cPoints; ++i4) {
                        int id = shapeBuffer.getInt(offset);
                        offset += 4;
                        if (idmin > (double)id) {
                            idmin = id;
                            continue;
                        }
                        if (!(idmax < (double)id)) continue;
                        idmax = id;
                    }
                }
                Envelope1D env2 = new Envelope1D();
                env2.setCoords(idmin, idmax);
                bbox.setInterval(3, 0, env2);
            }
            if (this.m_type == 550 || this.m_type == 0) {
                multipointImpl.setAttributeStreamRef(3, ids);
            }
        }
        if (this.m_type == 197) {
            return bbox;
        }
        if (cPoints > 0) {
            multipointImpl.setAttributeStreamRef(0, position);
            multipointImpl.setEnvelope(bbox);
        }
        return multipoint;
    }

    private Geometry importFromESRIShapePoint(int modifiers, ByteBuffer shapeBuffer) {
        int offset = 4;
        boolean bZs = (modifiers & Integer.MIN_VALUE) != 0;
        boolean bMs = (modifiers & 0x40000000) != 0;
        boolean bIDs = (modifiers & modifiers & 0x10000000) != 0;
        double x = shapeBuffer.getDouble(offset);
        double y = shapeBuffer.getDouble(offset += 8);
        offset += 8;
        boolean bEmpty = NumberUtils.isNaN(x);
        double z = NumberUtils.NaN();
        if (bZs) {
            z = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset));
            offset += 8;
        }
        double m = NumberUtils.NaN();
        if (bMs) {
            m = Interop.translateFromAVNaN(shapeBuffer.getDouble(offset));
            offset += 8;
        }
        int id = -1;
        if (bIDs) {
            id = shapeBuffer.getInt(offset);
            offset += 4;
        }
        if (this.m_type == 550) {
            MultiPoint newmultipoint = new MultiPoint();
            MultiPointImpl multipointImpl = (MultiPointImpl)newmultipoint._getImpl();
            if (!bEmpty) {
                AttributeStreamBase newPositionStream = AttributeStreamBase.createAttributeStreamWithSemantics(0, 1);
                AttributeStreamOfDbl position = (AttributeStreamOfDbl)newPositionStream;
                position.write(0, x);
                position.write(1, y);
                multipointImpl.setAttributeStreamRef(0, newPositionStream);
                multipointImpl.resize(1);
            }
            if (bZs) {
                multipointImpl.addAttribute(1);
                if (!bEmpty && !VertexDescription.isDefaultValue(1, z)) {
                    AttributeStreamBase newZStream = AttributeStreamBase.createAttributeStreamWithSemantics(1, 1);
                    newZStream.writeAsDbl(0, z);
                    multipointImpl.setAttributeStreamRef(1, newZStream);
                }
            }
            if (bMs) {
                multipointImpl.addAttribute(2);
                if (!bEmpty && !VertexDescription.isDefaultValue(2, m)) {
                    AttributeStreamBase newMStream = AttributeStreamBase.createAttributeStreamWithSemantics(2, 1);
                    newMStream.writeAsDbl(0, m);
                    multipointImpl.setAttributeStreamRef(2, newMStream);
                }
            }
            if (bIDs) {
                multipointImpl.addAttribute(3);
                if (!bEmpty && !VertexDescription.isDefaultValue(3, id)) {
                    AttributeStreamBase newIDStream = AttributeStreamBase.createAttributeStreamWithSemantics(3, 1);
                    newIDStream.writeAsInt(0, id);
                    multipointImpl.setAttributeStreamRef(3, newIDStream);
                }
            }
            return newmultipoint;
        }
        if (this.m_type == 197) {
            Envelope1D interval;
            Envelope envelope = new Envelope();
            envelope.setCoords(x, y, x, y);
            if (bZs) {
                interval = new Envelope1D();
                interval.vmin = z;
                interval.vmax = z;
                envelope.addAttribute(1);
                envelope.setInterval(1, 0, interval);
            }
            if (bMs) {
                interval = new Envelope1D();
                interval.vmin = m;
                interval.vmax = m;
                envelope.addAttribute(2);
                envelope.setInterval(2, 0, interval);
            }
            if (bIDs) {
                interval = new Envelope1D();
                interval.vmin = id;
                interval.vmax = id;
                envelope.addAttribute(3);
                envelope.setInterval(3, 0, interval);
            }
            return envelope;
        }
        Point point = new Point();
        if (!bEmpty) {
            point.setX(Interop.translateFromAVNaN(x));
            point.setY(Interop.translateFromAVNaN(y));
        }
        if (bZs) {
            point.addAttribute(1);
            if (!bEmpty) {
                point.setZ(Interop.translateFromAVNaN(z));
            }
        }
        if (bMs) {
            point.addAttribute(2);
            if (!bEmpty) {
                point.setM(Interop.translateFromAVNaN(m));
            }
        }
        if (bIDs) {
            point.addAttribute(3);
            if (!bEmpty) {
                point.setID(id);
            }
        }
        return point;
    }
}

