/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.shaded.esri.core.geometry;

import com.datastax.oss.driver.shaded.esri.core.geometry.Geometry;
import com.datastax.oss.driver.shaded.esri.core.geometry.GeometryCursor;
import com.datastax.oss.driver.shaded.esri.core.geometry.Operator;
import com.datastax.oss.driver.shaded.esri.core.geometry.OperatorBuffer;
import com.datastax.oss.driver.shaded.esri.core.geometry.OperatorBufferCursor;
import com.datastax.oss.driver.shaded.esri.core.geometry.OperatorFactoryLocal;
import com.datastax.oss.driver.shaded.esri.core.geometry.OperatorUnion;
import com.datastax.oss.driver.shaded.esri.core.geometry.ProgressTracker;
import com.datastax.oss.driver.shaded.esri.core.geometry.SimpleGeometryCursor;
import com.datastax.oss.driver.shaded.esri.core.geometry.SpatialReference;

class OperatorBufferLocal
extends OperatorBuffer {
    OperatorBufferLocal() {
    }

    @Override
    public GeometryCursor execute(GeometryCursor inputGeometries, SpatialReference sr, double[] distances, boolean bUnion, ProgressTracker progressTracker) {
        if (bUnion) {
            OperatorBufferCursor cursor = new OperatorBufferCursor(inputGeometries, sr, distances, false, progressTracker);
            return ((OperatorUnion)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Union)).execute(cursor, sr, progressTracker);
        }
        return new OperatorBufferCursor(inputGeometries, sr, distances, false, progressTracker);
    }

    @Override
    public Geometry execute(Geometry inputGeometry, SpatialReference sr, double distance, ProgressTracker progressTracker) {
        SimpleGeometryCursor inputCursor = new SimpleGeometryCursor(inputGeometry);
        double[] distances = new double[]{distance};
        GeometryCursor outputCursor = this.execute(inputCursor, sr, distances, false, progressTracker);
        return outputCursor.next();
    }
}

