/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.retry;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryVerdict;
import com.datastax.oss.driver.api.core.session.Request;
import edu.umd.cs.findbugs.annotations.NonNull;

public class ConsistencyDowngradingRetryVerdict
implements RetryVerdict {
    private final ConsistencyLevel consistencyLevel;

    public ConsistencyDowngradingRetryVerdict(@NonNull ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    @Override
    @NonNull
    public RetryDecision getRetryDecision() {
        return RetryDecision.RETRY_SAME;
    }

    @Override
    @NonNull
    public <RequestT extends Request> RequestT getRetryRequest(@NonNull RequestT previous) {
        if (previous instanceof Statement) {
            Statement statement = (Statement)previous;
            Object toRetry = statement.setConsistencyLevel(this.consistencyLevel);
            return (RequestT)toRetry;
        }
        return previous;
    }

    public String toString() {
        return (Object)((Object)this.getRetryDecision()) + " at consistency " + this.consistencyLevel;
    }
}

