/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.cql.continuous;

import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.internal.core.DseProtocolFeature;
import com.datastax.dse.driver.internal.core.cql.DseConversions;
import com.datastax.dse.protocol.internal.request.Revise;
import com.datastax.dse.protocol.internal.response.result.DseRowsMetadata;
import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.RequestThrottlingException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.connection.FrameTooLongException;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.retry.RetryVerdict;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.FunctionFailureException;
import com.datastax.oss.driver.api.core.servererrors.ProtocolError;
import com.datastax.oss.driver.api.core.servererrors.QueryValidationException;
import com.datastax.oss.driver.api.core.servererrors.ReadTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.UnavailableException;
import com.datastax.oss.driver.api.core.servererrors.WriteTimeoutException;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.api.core.session.throttling.Throttled;
import com.datastax.oss.driver.internal.core.adminrequest.ThrottledAdminRequestHandler;
import com.datastax.oss.driver.internal.core.adminrequest.UnexpectedResponseException;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.driver.internal.core.cql.DefaultExecutionInfo;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.session.RepreparePayload;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.internal.core.util.collection.SimpleQueryPlan;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.netty.handler.codec.EncoderException;
import com.datastax.oss.driver.shaded.netty.util.Timeout;
import com.datastax.oss.driver.shaded.netty.util.Timer;
import com.datastax.oss.driver.shaded.netty.util.concurrent.Future;
import com.datastax.oss.driver.shaded.netty.util.concurrent.GenericFutureListener;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Prepare;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.error.Unprepared;
import com.datastax.oss.protocol.internal.response.result.Rows;
import com.datastax.oss.protocol.internal.response.result.RowsMetadata;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class ContinuousRequestHandlerBase<StatementT extends Request, ResultSetT>
implements Throttled {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousRequestHandlerBase.class);
    protected final String logPrefix;
    protected final StatementT initialStatement;
    protected final DefaultSession session;
    private final CqlIdentifier keyspace;
    protected final InternalDriverContext context;
    private final Queue<Node> queryPlan;
    protected final RequestThrottler throttler;
    private final boolean protocolBackpressureAvailable;
    private final Timer timer;
    private final SessionMetricUpdater sessionMetricUpdater;
    private final boolean specExecEnabled;
    private final SessionMetric clientTimeoutsMetric;
    private final SessionMetric continuousRequestsMetric;
    private final NodeMetric messagesMetric;
    private final List<Timeout> scheduledExecutions;
    protected final List<Map.Entry<Node, Throwable>> errors = new CopyOnWriteArrayList<Map.Entry<Node, Throwable>>();
    private final List<NodeResponseCallback> inFlightCallbacks = new CopyOnWriteArrayList<NodeResponseCallback>();
    private final CompletableFuture<NodeResponseCallback> chosenCallback = new CompletableFuture();
    private final AtomicInteger activeExecutionsCount = new AtomicInteger(0);
    protected final AtomicInteger startedSpeculativeExecutionsCount = new AtomicInteger(0);
    private final long startTimeNanos;
    private volatile Timeout globalTimeout;
    private final Class<ResultSetT> resultSetClass;

    public ContinuousRequestHandlerBase(@NonNull StatementT statement, @NonNull DefaultSession session, @NonNull InternalDriverContext context, @NonNull String sessionLogPrefix, @NonNull Class<ResultSetT> resultSetClass, boolean specExecEnabled, SessionMetric clientTimeoutsMetric, SessionMetric continuousRequestsMetric, NodeMetric messagesMetric) {
        this.resultSetClass = resultSetClass;
        ProtocolVersion protocolVersion = context.getProtocolVersion();
        if (!context.getProtocolVersionRegistry().supports(protocolVersion, DseProtocolFeature.CONTINUOUS_PAGING)) {
            throw new IllegalStateException("Cannot execute continuous paging requests with protocol version " + protocolVersion);
        }
        this.clientTimeoutsMetric = clientTimeoutsMetric;
        this.continuousRequestsMetric = continuousRequestsMetric;
        this.messagesMetric = messagesMetric;
        this.logPrefix = sessionLogPrefix + "|" + this.hashCode();
        LOG.trace("[{}] Creating new continuous handler for request {}", (Object)this.logPrefix, statement);
        this.initialStatement = statement;
        this.session = session;
        this.keyspace = session.getKeyspace().orElse(null);
        this.context = context;
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(statement, context);
        this.queryPlan = statement.getNode() != null ? new SimpleQueryPlan(statement.getNode()) : context.getLoadBalancingPolicyWrapper().newQueryPlan((Request)statement, executionProfile.getName(), session);
        this.timer = context.getNettyOptions().getTimer();
        this.protocolBackpressureAvailable = protocolVersion.getCode() >= DseProtocolVersion.DSE_V2.getCode();
        this.throttler = context.getRequestThrottler();
        this.sessionMetricUpdater = session.getMetricUpdater();
        this.startTimeNanos = System.nanoTime();
        this.specExecEnabled = specExecEnabled;
        this.scheduledExecutions = this.specExecEnabled ? new CopyOnWriteArrayList() : null;
    }

    @NonNull
    protected abstract Duration getGlobalTimeout();

    @NonNull
    protected abstract Duration getPageTimeout(@NonNull StatementT var1, int var2);

    @NonNull
    protected abstract Duration getReviseRequestTimeout(@NonNull StatementT var1);

    protected abstract int getMaxEnqueuedPages(@NonNull StatementT var1);

    protected abstract int getMaxPages(@NonNull StatementT var1);

    @NonNull
    protected abstract Message getMessage(@NonNull StatementT var1);

    protected abstract boolean isTracingEnabled(@NonNull StatementT var1);

    @NonNull
    protected abstract Map<String, ByteBuffer> createPayload(@NonNull StatementT var1);

    @NonNull
    protected abstract ResultSetT createEmptyResultSet(@NonNull ExecutionInfo var1);

    protected abstract int pageNumber(@NonNull ResultSetT var1);

    @NonNull
    protected abstract ResultSetT createResultSet(@NonNull StatementT var1, @NonNull Rows var2, @NonNull ExecutionInfo var3, @NonNull ColumnDefinitions var4) throws IOException;

    @Override
    public void onThrottleReady(boolean wasDelayed) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(this.initialStatement, this.context);
        if (wasDelayed && this.sessionMetricUpdater.isEnabled(DefaultSessionMetric.THROTTLING_DELAY, executionProfile.getName())) {
            this.session.getMetricUpdater().updateTimer(DefaultSessionMetric.THROTTLING_DELAY, executionProfile.getName(), System.nanoTime() - this.startTimeNanos, TimeUnit.NANOSECONDS);
        }
        this.activeExecutionsCount.incrementAndGet();
        this.sendRequest(this.initialStatement, null, 0, 0, this.specExecEnabled);
    }

    @Override
    public void onThrottleFailure(@NonNull RequestThrottlingException error) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(this.initialStatement, this.context);
        this.session.getMetricUpdater().incrementCounter(DefaultSessionMetric.THROTTLING_ERRORS, executionProfile.getName());
        this.abortGlobalRequestOrChosenCallback(error);
    }

    private void abortGlobalRequestOrChosenCallback(@NonNull Throwable error) {
        if (!this.chosenCallback.completeExceptionally(error)) {
            this.chosenCallback.thenAccept(callback -> ((NodeResponseCallback)callback).abort(error, false));
        }
    }

    public CompletionStage<ResultSetT> handle() {
        this.globalTimeout = this.scheduleGlobalTimeout();
        return this.fetchNextPage();
    }

    public CompletionStage<ResultSetT> fetchNextPage() {
        CompletableFuture result = new CompletableFuture();
        this.chosenCallback.whenComplete((callback, callbackError) -> {
            if (callbackError != null) {
                result.completeExceptionally((Throwable)callbackError);
            } else {
                callback.dequeueOrCreatePending().whenComplete((resultSet, resultSetError) -> {
                    if (resultSetError != null) {
                        result.completeExceptionally((Throwable)resultSetError);
                    } else {
                        result.complete(resultSet);
                    }
                });
            }
        });
        result.whenComplete((rs, t) -> {
            if (t instanceof CancellationException) {
                this.cancel();
            }
        });
        return result;
    }

    private void sendRequest(StatementT statement, @Nullable Node node, int currentExecutionIndex, int retryCount, boolean scheduleSpeculativeExecution) {
        DriverChannel channel = null;
        if (node == null || (channel = this.session.getChannel(node, this.logPrefix)) == null) {
            while ((node = this.queryPlan.poll()) != null && (channel = this.session.getChannel(node, this.logPrefix)) == null) {
            }
        }
        if (channel == null) {
            if (this.activeExecutionsCount.decrementAndGet() == 0) {
                this.abortGlobalRequestOrChosenCallback(AllNodesFailedException.fromErrors(this.errors));
            }
        } else if (!this.chosenCallback.isDone()) {
            NodeResponseCallback nodeResponseCallback = new NodeResponseCallback(this, statement, node, channel, currentExecutionIndex, retryCount, scheduleSpeculativeExecution, this.logPrefix);
            this.inFlightCallbacks.add(nodeResponseCallback);
            channel.write(this.getMessage(statement), this.isTracingEnabled(statement), this.createPayload(statement), nodeResponseCallback).addListener(nodeResponseCallback);
        }
    }

    private Timeout scheduleGlobalTimeout() {
        Duration globalTimeout = this.getGlobalTimeout();
        if (globalTimeout.toNanos() <= 0L) {
            return null;
        }
        LOG.trace("[{}] Scheduling global timeout for pages in {}", (Object)this.logPrefix, (Object)globalTimeout);
        return this.timer.newTimeout(timeout -> this.abortGlobalRequestOrChosenCallback(new DriverTimeoutException("Query timed out after " + globalTimeout)), globalTimeout.toNanos(), TimeUnit.NANOSECONDS);
    }

    public void cancel() {
        this.chosenCallback.cancel(true);
        this.cancelScheduledTasks(null);
        this.cancelGlobalTimeout();
    }

    private void cancelGlobalTimeout() {
        if (this.globalTimeout != null) {
            this.globalTimeout.cancel();
        }
    }

    private void cancelScheduledTasks(@Nullable NodeResponseCallback toIgnore) {
        if (this.scheduledExecutions != null) {
            for (Timeout scheduledExecution : this.scheduledExecutions) {
                scheduledExecution.cancel();
            }
        }
        for (NodeResponseCallback callback : this.inFlightCallbacks) {
            if (toIgnore != null && toIgnore == callback) continue;
            callback.cancel();
        }
    }

    @VisibleForTesting
    int getState() {
        try {
            return this.chosenCallback.get().getState();
        }
        catch (CancellationException e) {
            return -2;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError("Unexpected error", e);
        }
    }

    @VisibleForTesting
    CompletableFuture<ResultSetT> getPendingResult() {
        try {
            return this.chosenCallback.get().getPendingResult();
        }
        catch (Exception e) {
            throw new AssertionError((Object)"Expected callback to be chosen at this point");
        }
    }

    private static class NodeResponseCallback
    implements ResponseCallback,
    GenericFutureListener<Future<Void>> {
        private final long messageStartTimeNanos = System.nanoTime();
        private final StatementT statement;
        private final Node node;
        private final DriverChannel channel;
        private final int executionIndex;
        private final String logPrefix;
        private final boolean scheduleSpeculativeExecution;
        private final DriverExecutionProfile executionProfile;
        private final ReentrantLock lock = new ReentrantLock();
        @GuardedBy(value="lock")
        private Queue<Object> queue;
        @GuardedBy(value="lock")
        private CompletableFuture<ResultSetT> pendingResult;
        @GuardedBy(value="lock")
        private int numPagesRequested;
        @GuardedBy(value="lock")
        private int state = 1;
        @GuardedBy(value="lock")
        private boolean sawLastResponse;
        @GuardedBy(value="lock")
        private boolean sentCancelRequest;
        private static final int STATE_FINISHED = -1;
        private static final int STATE_FAILED = -2;
        @GuardedBy(value="lock")
        private int streamId = -1;
        private volatile ColumnDefinitions columnDefinitions;
        private volatile Timeout pageTimeout;
        private final int retryCount;
        private final AtomicBoolean stopNodeMessageTimerReported = new AtomicBoolean(false);
        private final AtomicBoolean nodeErrorReported = new AtomicBoolean(false);
        private final AtomicBoolean nodeSuccessReported = new AtomicBoolean(false);
        final /* synthetic */ ContinuousRequestHandlerBase this$0;

        public NodeResponseCallback(StatementT statement, Node node, DriverChannel channel, int executionIndex, int retryCount, boolean scheduleSpeculativeExecution, String logPrefix) {
            this.this$0 = var1_1;
            this.statement = statement;
            this.node = node;
            this.channel = channel;
            this.executionIndex = executionIndex;
            this.retryCount = retryCount;
            this.scheduleSpeculativeExecution = scheduleSpeculativeExecution;
            this.logPrefix = logPrefix + "|" + executionIndex;
            this.executionProfile = Conversions.resolveExecutionProfile(statement, var1_1.context);
        }

        @Override
        public void onStreamIdAssigned(int streamId) {
            LOG.trace("[{}] Assigned streamId {} on node {}", new Object[]{this.logPrefix, streamId, this.node});
            this.lock.lock();
            try {
                this.streamId = streamId;
                if (this.state < 0) {
                    this.releaseStreamId();
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isLastResponse(@NonNull Frame responseFrame) {
            this.lock.lock();
            try {
                boolean isLastResponse;
                Message message = responseFrame.message;
                if (this.sentCancelRequest) {
                    if (message instanceof Error) {
                        Error error = (Error)message;
                        isLastResponse = error.code == 0 && error.message.contains("Session cancelled by the user");
                    } else {
                        isLastResponse = false;
                    }
                } else if (message instanceof Rows) {
                    Rows rows = (Rows)message;
                    DseRowsMetadata metadata = (DseRowsMetadata)rows.getMetadata();
                    isLastResponse = metadata.isLastContinuousPage;
                } else {
                    isLastResponse = message instanceof Error;
                }
                if (isLastResponse) {
                    this.sawLastResponse = true;
                }
                boolean bl = isLastResponse;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public void operationComplete(@NonNull Future<Void> future) {
            if (!future.isSuccess()) {
                Throwable error = future.cause();
                if (error instanceof EncoderException && error.getCause() instanceof FrameTooLongException) {
                    this.trackNodeError(this.node, error.getCause());
                    this.lock.lock();
                    try {
                        this.abort(error.getCause(), false);
                    }
                    finally {
                        this.lock.unlock();
                    }
                } else {
                    LOG.trace("[{}] Failed to send request on {}, trying next node (cause: {})", new Object[]{this.logPrefix, this.channel, error});
                    ((DefaultNode)this.node).getMetricUpdater().incrementCounter(DefaultNodeMetric.UNSENT_REQUESTS, this.executionProfile.getName());
                    this.recordError(this.node, error);
                    this.trackNodeError(this.node, error.getCause());
                    this.this$0.sendRequest(this.statement, null, this.executionIndex, this.retryCount, this.scheduleSpeculativeExecution);
                }
            } else {
                LOG.trace("[{}] Request sent on {}", (Object)this.logPrefix, (Object)this.channel);
                if (this.scheduleSpeculativeExecution && Conversions.resolveIdempotence(this.statement, this.this$0.context)) {
                    int nextExecution = this.executionIndex + 1;
                    long nextDelay = Conversions.resolveSpeculativeExecutionPolicy(this.statement, this.this$0.context).nextExecution(this.node, this.this$0.keyspace, (Request)this.statement, nextExecution);
                    if (nextDelay >= 0L) {
                        this.scheduleSpeculativeExecution(nextExecution, nextDelay);
                    } else {
                        LOG.trace("[{}] Speculative execution policy returned {}, no next execution", (Object)this.logPrefix, (Object)nextDelay);
                    }
                }
                this.pageTimeout = this.schedulePageTimeout(1);
            }
        }

        private void scheduleSpeculativeExecution(int nextExecutionIndex, long delay) {
            LOG.trace("[{}] Scheduling speculative execution {} in {} ms", new Object[]{this.logPrefix, nextExecutionIndex, delay});
            try {
                this.this$0.scheduledExecutions.add(this.this$0.timer.newTimeout(timeout -> {
                    if (!this.this$0.chosenCallback.isDone()) {
                        LOG.trace("[{}] Starting speculative execution {}", (Object)this.logPrefix, (Object)nextExecutionIndex);
                        this.this$0.activeExecutionsCount.incrementAndGet();
                        this.this$0.startedSpeculativeExecutionsCount.incrementAndGet();
                        NodeMetricUpdater nodeMetricUpdater = ((DefaultNode)this.node).getMetricUpdater();
                        if (nodeMetricUpdater.isEnabled(DefaultNodeMetric.SPECULATIVE_EXECUTIONS, this.executionProfile.getName())) {
                            nodeMetricUpdater.incrementCounter(DefaultNodeMetric.SPECULATIVE_EXECUTIONS, this.executionProfile.getName());
                        }
                        this.this$0.sendRequest(this.statement, null, nextExecutionIndex, 0, true);
                    }
                }, delay, TimeUnit.MILLISECONDS));
            }
            catch (IllegalStateException e) {
                this.logTimeoutSchedulingError(e);
            }
        }

        private Timeout schedulePageTimeout(int expectedPage) {
            if (expectedPage < 0) {
                return null;
            }
            Duration timeout = this.this$0.getPageTimeout(this.statement, expectedPage);
            if (timeout.toNanos() <= 0L) {
                return null;
            }
            LOG.trace("[{}] Scheduling timeout for page {} in {}", new Object[]{this.logPrefix, expectedPage, timeout});
            return this.this$0.timer.newTimeout(t -> this.onPageTimeout(expectedPage), timeout.toNanos(), TimeUnit.NANOSECONDS);
        }

        private void onPageTimeout(int expectedPage) {
            this.lock.lock();
            try {
                if (this.state == expectedPage) {
                    this.abort(new DriverTimeoutException(String.format("Timed out waiting for page %d", expectedPage)), false);
                } else {
                    LOG.trace("[{}] Timeout fired for page {} but query already at state {}, skipping", new Object[]{this.logPrefix, expectedPage, this.state});
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponse(@NonNull Frame response) {
            block9: {
                this.stopNodeMessageTimer();
                this.cancelTimeout(this.pageTimeout);
                this.lock.lock();
                try {
                    if (this.state < 0) {
                        LOG.trace("[{}] Got result but the request has been cancelled, ignoring", (Object)this.logPrefix);
                        return;
                    }
                    try {
                        Message responseMessage = response.message;
                        if (responseMessage instanceof Result) {
                            LOG.trace("[{}] Got result", (Object)this.logPrefix);
                            this.processResultResponse((Result)responseMessage, response);
                            break block9;
                        }
                        if (responseMessage instanceof Error) {
                            LOG.trace("[{}] Got error response", (Object)this.logPrefix);
                            this.processErrorResponse((Error)responseMessage);
                            break block9;
                        }
                        IllegalStateException error = new IllegalStateException("Unexpected response " + responseMessage);
                        this.trackNodeError(this.node, error);
                        this.abort(error, false);
                    }
                    catch (Throwable t) {
                        this.trackNodeError(this.node, t);
                        this.abort(t, false);
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(@NonNull Throwable error) {
            RetryVerdict verdict;
            this.cancelTimeout(this.pageTimeout);
            LOG.trace(String.format("[%s] Request failure", this.logPrefix), error);
            if (!Conversions.resolveIdempotence(this.statement, this.this$0.context) || error instanceof FrameTooLongException) {
                verdict = RetryVerdict.RETHROW;
            } else {
                try {
                    RetryPolicy retryPolicy = Conversions.resolveRetryPolicy(this.statement, this.this$0.context);
                    verdict = retryPolicy.onRequestAbortedVerdict((Request)this.statement, error, this.retryCount);
                }
                catch (Throwable cause) {
                    this.abort(new IllegalStateException("Unexpected error while invoking the retry policy", cause), false);
                    return;
                }
            }
            this.updateErrorMetrics(((DefaultNode)this.node).getMetricUpdater(), verdict, DefaultNodeMetric.ABORTED_REQUESTS, DefaultNodeMetric.RETRIES_ON_ABORTED, DefaultNodeMetric.IGNORES_ON_ABORTED);
            this.lock.lock();
            try {
                this.processRetryVerdict(verdict, error);
            }
            finally {
                this.lock.unlock();
            }
        }

        private void processResultResponse(@NonNull Result result, @Nullable Frame frame) {
            assert (this.lock.isHeldByCurrentThread());
            try {
                ExecutionInfo executionInfo = this.createExecutionInfo(result, frame);
                if (result instanceof Rows) {
                    int currentPage;
                    int pageNumber;
                    DseRowsMetadata rowsMetadata = (DseRowsMetadata)((Rows)result).getMetadata();
                    if (this.columnDefinitions == null) {
                        this.columnDefinitions = Conversions.toColumnDefinitions((RowsMetadata)rowsMetadata, this.this$0.context);
                    }
                    if ((pageNumber = rowsMetadata.continuousPageNumber) != (currentPage = this.state)) {
                        this.abort(new IllegalStateException(String.format("Received page %d but was expecting %d", pageNumber, currentPage)), false);
                    } else {
                        int pageSize = ((Rows)result).getData().size();
                        Object resultSet = this.this$0.createResultSet(this.statement, (Rows)result, executionInfo, this.columnDefinitions);
                        if (rowsMetadata.isLastContinuousPage) {
                            LOG.trace("[{}] Received last page ({} - {} rows)", new Object[]{this.logPrefix, pageNumber, pageSize});
                            this.state = -1;
                            this.reenableAutoReadIfNeeded();
                            this.enqueueOrCompletePending(resultSet);
                            this.stopGlobalRequestTimer();
                            this.cancelTimeout(this.this$0.globalTimeout);
                        } else {
                            LOG.trace("[{}] Received page {} ({} rows)", new Object[]{this.logPrefix, pageNumber, pageSize});
                            if (currentPage > 0) {
                                this.state = currentPage + 1;
                            }
                            this.enqueueOrCompletePending(resultSet);
                        }
                    }
                } else {
                    assert (result instanceof com.datastax.oss.protocol.internal.response.result.Void);
                    Object resultSet = this.this$0.createEmptyResultSet(executionInfo);
                    LOG.trace("[{}] Continuous paging interrupted by retry policy decision to ignore error", (Object)this.logPrefix);
                    this.state = -1;
                    this.reenableAutoReadIfNeeded();
                    this.enqueueOrCompletePending(resultSet);
                    this.stopGlobalRequestTimer();
                    this.cancelTimeout(this.this$0.globalTimeout);
                }
            }
            catch (Throwable error) {
                this.abort(error, false);
            }
        }

        private void processErrorResponse(@NonNull Error errorMessage) {
            assert (this.lock.isHeldByCurrentThread());
            if (errorMessage instanceof Unprepared) {
                this.processUnprepared((Unprepared)errorMessage);
            } else {
                CoordinatorException error = DseConversions.toThrowable(this.node, errorMessage, this.this$0.context);
                if (error instanceof BootstrappingException) {
                    LOG.trace("[{}] {} is bootstrapping, trying next node", (Object)this.logPrefix, (Object)this.node);
                    this.recordError(this.node, error);
                    this.trackNodeError(this.node, error);
                    this.this$0.sendRequest(this.statement, null, this.executionIndex, this.retryCount, false);
                } else if (error instanceof QueryValidationException || error instanceof FunctionFailureException || error instanceof ProtocolError || this.state > 1) {
                    LOG.trace("[{}] Unrecoverable error, rethrowing", (Object)this.logPrefix);
                    NodeMetricUpdater metricUpdater = ((DefaultNode)this.node).getMetricUpdater();
                    metricUpdater.incrementCounter(DefaultNodeMetric.OTHER_ERRORS, this.executionProfile.getName());
                    this.trackNodeError(this.node, error);
                    this.abort(error, true);
                } else {
                    try {
                        this.processRecoverableError(error);
                    }
                    catch (Throwable cause) {
                        this.abort(cause, false);
                    }
                }
            }
        }

        private void processRecoverableError(@NonNull CoordinatorException error) {
            RetryVerdict verdict;
            assert (this.lock.isHeldByCurrentThread());
            NodeMetricUpdater metricUpdater = ((DefaultNode)this.node).getMetricUpdater();
            RetryPolicy retryPolicy = Conversions.resolveRetryPolicy(this.statement, this.this$0.context);
            if (error instanceof ReadTimeoutException) {
                ReadTimeoutException readTimeout = (ReadTimeoutException)error;
                verdict = retryPolicy.onReadTimeoutVerdict((Request)this.statement, readTimeout.getConsistencyLevel(), readTimeout.getBlockFor(), readTimeout.getReceived(), readTimeout.wasDataPresent(), this.retryCount);
                this.updateErrorMetrics(metricUpdater, verdict, DefaultNodeMetric.READ_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_READ_TIMEOUT, DefaultNodeMetric.IGNORES_ON_READ_TIMEOUT);
            } else if (error instanceof WriteTimeoutException) {
                WriteTimeoutException writeTimeout = (WriteTimeoutException)error;
                verdict = Conversions.resolveIdempotence(this.statement, this.this$0.context) ? retryPolicy.onWriteTimeoutVerdict((Request)this.statement, writeTimeout.getConsistencyLevel(), writeTimeout.getWriteType(), writeTimeout.getBlockFor(), writeTimeout.getReceived(), this.retryCount) : RetryVerdict.RETHROW;
                this.updateErrorMetrics(metricUpdater, verdict, DefaultNodeMetric.WRITE_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_WRITE_TIMEOUT, DefaultNodeMetric.IGNORES_ON_WRITE_TIMEOUT);
            } else if (error instanceof UnavailableException) {
                UnavailableException unavailable = (UnavailableException)error;
                verdict = retryPolicy.onUnavailableVerdict((Request)this.statement, unavailable.getConsistencyLevel(), unavailable.getRequired(), unavailable.getAlive(), this.retryCount);
                this.updateErrorMetrics(metricUpdater, verdict, DefaultNodeMetric.UNAVAILABLES, DefaultNodeMetric.RETRIES_ON_UNAVAILABLE, DefaultNodeMetric.IGNORES_ON_UNAVAILABLE);
            } else {
                verdict = Conversions.resolveIdempotence(this.statement, this.this$0.context) ? retryPolicy.onErrorResponseVerdict((Request)this.statement, error, this.retryCount) : RetryVerdict.RETHROW;
                this.updateErrorMetrics(metricUpdater, verdict, DefaultNodeMetric.OTHER_ERRORS, DefaultNodeMetric.RETRIES_ON_OTHER_ERROR, DefaultNodeMetric.IGNORES_ON_OTHER_ERROR);
            }
            this.processRetryVerdict(verdict, error);
        }

        private void processUnprepared(@NonNull Unprepared errorMessage) {
            assert (this.lock.isHeldByCurrentThread());
            ByteBuffer idToReprepare = ByteBuffer.wrap(errorMessage.id);
            LOG.trace("[{}] Statement {} is not prepared on {}, re-preparing", new Object[]{this.logPrefix, Bytes.toHexString((ByteBuffer)idToReprepare), this.node});
            RepreparePayload repreparePayload = (RepreparePayload)this.this$0.session.getRepreparePayloads().get(idToReprepare);
            if (repreparePayload == null) {
                throw new IllegalStateException(String.format("Tried to execute unprepared query %s but we don't have the data to re-prepare it", Bytes.toHexString((ByteBuffer)idToReprepare)));
            }
            Prepare prepare = repreparePayload.toMessage();
            Duration timeout = this.executionProfile.getDuration(DefaultDriverOption.REQUEST_TIMEOUT);
            ThrottledAdminRequestHandler.prepare(this.channel, true, (Message)prepare, repreparePayload.customPayload, timeout, this.this$0.throttler, this.this$0.sessionMetricUpdater, this.logPrefix).start().whenComplete((repreparedId, exception) -> {
                Throwable fatalError = null;
                if (exception == null) {
                    if (!repreparedId.equals(idToReprepare)) {
                        IllegalStateException illegalStateException = new IllegalStateException(String.format("ID mismatch while trying to reprepare (expected %s, got %s). This prepared statement won't work anymore. This usually happens when you run a 'USE...' query after the statement was prepared.", Bytes.toHexString((ByteBuffer)idToReprepare), Bytes.toHexString((ByteBuffer)repreparedId)));
                        this.trackNodeError(this.node, illegalStateException);
                        fatalError = illegalStateException;
                    } else {
                        LOG.trace("[{}] Re-prepare successful, retrying on the same node ({})", (Object)this.logPrefix, (Object)this.node);
                        this.this$0.sendRequest(this.statement, this.node, this.executionIndex, this.retryCount, false);
                    }
                } else {
                    if (exception instanceof UnexpectedResponseException) {
                        CoordinatorException prepareError;
                        Message prepareErrorMessage = ((UnexpectedResponseException)exception).message;
                        if (prepareErrorMessage instanceof Error && ((prepareError = DseConversions.toThrowable(this.node, (Error)prepareErrorMessage, this.this$0.context)) instanceof QueryValidationException || prepareError instanceof FunctionFailureException || prepareError instanceof ProtocolError)) {
                            LOG.trace("[{}] Unrecoverable error on re-prepare, rethrowing", (Object)this.logPrefix);
                            this.trackNodeError(this.node, prepareError);
                            fatalError = prepareError;
                        }
                    } else if (exception instanceof RequestThrottlingException) {
                        this.trackNodeError(this.node, (Throwable)exception);
                        fatalError = exception;
                    }
                    if (fatalError == null) {
                        LOG.trace("[{}] Re-prepare failed, trying next node", (Object)this.logPrefix);
                        this.recordError(this.node, (Throwable)exception);
                        this.trackNodeError(this.node, (Throwable)exception);
                        this.this$0.sendRequest(this.statement, null, this.executionIndex, this.retryCount, false);
                    }
                }
                if (fatalError != null) {
                    this.lock.lock();
                    try {
                        this.abort(fatalError, true);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            });
        }

        private void processRetryVerdict(@NonNull RetryVerdict verdict, @NonNull Throwable error) {
            assert (this.lock.isHeldByCurrentThread());
            LOG.trace("[{}] Processing retry decision {}", (Object)this.logPrefix, (Object)verdict);
            switch (verdict.getRetryDecision()) {
                case RETRY_SAME: {
                    this.recordError(this.node, error);
                    this.trackNodeError(this.node, error);
                    this.this$0.sendRequest(verdict.getRetryRequest(this.statement), this.node, this.executionIndex, this.retryCount + 1, false);
                    break;
                }
                case RETRY_NEXT: {
                    this.recordError(this.node, error);
                    this.trackNodeError(this.node, error);
                    this.this$0.sendRequest(verdict.getRetryRequest(this.statement), null, this.executionIndex, this.retryCount + 1, false);
                    break;
                }
                case RETHROW: {
                    this.trackNodeError(this.node, error);
                    this.abort(error, true);
                    break;
                }
                case IGNORE: {
                    this.processResultResponse((Result)com.datastax.oss.protocol.internal.response.result.Void.INSTANCE, null);
                }
            }
        }

        private void enqueueOrCompletePending(@NonNull Object pageOrError) {
            assert (this.lock.isHeldByCurrentThread());
            if (this.queue == null) {
                if (!this.this$0.chosenCallback.complete(this)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("[{}] Trying to enqueue {} but another callback was already chosen, aborting", (Object)this.logPrefix, (Object)this.asTraceString(pageOrError));
                    }
                    return;
                }
                this.queue = new ArrayDeque<Object>(this.this$0.getMaxEnqueuedPages(this.statement));
                this.numPagesRequested = this.this$0.protocolBackpressureAvailable ? this.this$0.getMaxEnqueuedPages(this.statement) : 0;
                this.this$0.cancelScheduledTasks(this);
            }
            if (this.pendingResult != null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("[{}] Client was waiting on empty queue, completing with {}", (Object)this.logPrefix, (Object)this.asTraceString(pageOrError));
                }
                CompletableFuture tmp = this.pendingResult;
                this.pendingResult = null;
                this.completeResultSetFuture(tmp, pageOrError);
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("[{}] Enqueuing {}", (Object)this.logPrefix, (Object)this.asTraceString(pageOrError));
                }
                this.queue.add(pageOrError);
                if (!this.this$0.protocolBackpressureAvailable && this.queue.size() == this.this$0.getMaxEnqueuedPages(this.statement) && this.state > 0) {
                    LOG.trace("[{}] Exceeded {} queued response pages, disabling auto-read", (Object)this.logPrefix, (Object)this.queue.size());
                    this.channel.config().setAutoRead(false);
                }
            }
        }

        @NonNull
        public CompletableFuture<ResultSetT> dequeueOrCreatePending() {
            this.lock.lock();
            try {
                assert (this.pendingResult == null);
                Object head = null;
                if (this.queue != null) {
                    head = this.queue.poll();
                    if (!this.this$0.protocolBackpressureAvailable && head != null && this.queue.size() == this.this$0.getMaxEnqueuedPages(this.statement) - 1) {
                        LOG.trace("[{}] Back to {} queued response pages, re-enabling auto-read", (Object)this.logPrefix, (Object)this.queue.size());
                        this.channel.config().setAutoRead(true);
                    }
                    this.maybeRequestMore();
                }
                if (head != null) {
                    if (this.state == -2 && !(head instanceof Throwable)) {
                        LOG.trace("[{}] Client requested next page on cancelled queue, discarding page and returning cancelled future", (Object)this.logPrefix);
                        CompletableFuture completableFuture = this.cancelledResultSetFuture();
                        return completableFuture;
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("[{}] Client requested next page on non-empty queue, returning immediate future of {}", (Object)this.logPrefix, (Object)this.asTraceString(head));
                    }
                    CompletableFuture completableFuture = this.immediateResultSetFuture(head);
                    return completableFuture;
                }
                if (this.state == -2) {
                    LOG.trace("[{}] Client requested next page on cancelled empty queue, returning cancelled future", (Object)this.logPrefix);
                    CompletableFuture completableFuture = this.cancelledResultSetFuture();
                    return completableFuture;
                }
                LOG.trace("[{}] Client requested next page but queue is empty, installing future", (Object)this.logPrefix);
                this.pendingResult = new CompletableFuture();
                if (this.state > 1) {
                    this.pageTimeout = this.schedulePageTimeout(this.state);
                }
                CompletableFuture completableFuture = this.pendingResult;
                return completableFuture;
            }
            finally {
                this.lock.unlock();
            }
        }

        private void maybeRequestMore() {
            int inFlight;
            assert (this.lock.isHeldByCurrentThread());
            if (this.state < 2 || this.streamId == -1 || !this.this$0.protocolBackpressureAvailable) {
                return;
            }
            int maxPages = this.this$0.getMaxPages(this.statement);
            if (maxPages > 0 && this.numPagesRequested >= maxPages) {
                return;
            }
            int received = this.state - 1;
            int requested = this.numPagesRequested;
            int freeSpace = this.this$0.getMaxEnqueuedPages(this.statement) - this.queue.size();
            int numPagesFittingInQueue = freeSpace - (inFlight = requested - received);
            if (numPagesFittingInQueue > 0 && numPagesFittingInQueue >= this.this$0.getMaxEnqueuedPages(this.statement) / 2) {
                LOG.trace("[{}] Requesting more {} pages", (Object)this.logPrefix, (Object)numPagesFittingInQueue);
                this.numPagesRequested = requested + numPagesFittingInQueue;
                this.sendMorePagesRequest(numPagesFittingInQueue);
            }
        }

        private void sendMorePagesRequest(int nextPages) {
            assert (this.lock.isHeldByCurrentThread());
            assert (this.channel != null) : "expected valid connection in order to request more pages";
            assert (this.this$0.protocolBackpressureAvailable);
            assert (this.streamId != -1);
            LOG.trace("[{}] Sending request for more pages", (Object)this.logPrefix);
            ThrottledAdminRequestHandler.query(this.channel, true, (Message)Revise.requestMoreContinuousPages((int)this.streamId, (int)nextPages), this.statement.getCustomPayload(), this.this$0.getReviseRequestTimeout(this.statement), this.this$0.throttler, this.this$0.session.getMetricUpdater(), this.logPrefix, "request " + nextPages + " more pages for id " + this.streamId).start().handle((result, error) -> {
                if (error != null) {
                    Loggers.warnWithException(LOG, "[{}] Error requesting more pages, aborting.", this.logPrefix, error);
                    this.lock.lock();
                    try {
                        this.abort((Throwable)error, false);
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
                return null;
            });
        }

        private void cancelTimeout(Timeout timeout) {
            if (timeout != null) {
                LOG.trace("[{}] Cancelling timeout", (Object)this.logPrefix);
                timeout.cancel();
            }
        }

        public void cancel() {
            this.lock.lock();
            try {
                if (this.state < 0) {
                    return;
                }
                LOG.trace("[{}] Cancelling continuous paging session with state {} on node {}", new Object[]{this.logPrefix, this.state, this.node});
                this.state = -2;
                if (this.pendingResult != null) {
                    this.pendingResult.cancel(true);
                }
                this.releaseStreamId();
            }
            finally {
                this.lock.unlock();
            }
            this.reenableAutoReadIfNeeded();
        }

        private void releaseStreamId() {
            assert (this.lock.isHeldByCurrentThread());
            if (this.streamId >= 0 && !this.sawLastResponse && !this.channel.closeFuture().isDone()) {
                this.channel.cancel(this);
                this.sendCancelRequest();
            }
        }

        private void sendCancelRequest() {
            assert (this.lock.isHeldByCurrentThread());
            LOG.trace("[{}] Sending cancel request", (Object)this.logPrefix);
            ThrottledAdminRequestHandler.query(this.channel, true, (Message)Revise.cancelContinuousPaging((int)this.streamId), this.statement.getCustomPayload(), this.this$0.getReviseRequestTimeout(this.statement), this.this$0.throttler, this.this$0.session.getMetricUpdater(), this.logPrefix, "cancel request").start().handle((result, error) -> {
                if (error != null) {
                    Loggers.warnWithException(LOG, "[{}] Error sending cancel request. This is not critical (the request will eventually time out server-side).", this.logPrefix, error);
                } else {
                    LOG.trace("[{}] Continuous paging session cancelled successfully", (Object)this.logPrefix);
                }
                return null;
            });
            this.sentCancelRequest = true;
        }

        private void reenableAutoReadIfNeeded() {
            LOG.trace("[{}] Re-enabling auto-read", (Object)this.logPrefix);
            if (!this.this$0.protocolBackpressureAvailable) {
                this.channel.config().setAutoRead(true);
            }
        }

        private void recordError(@NonNull Node node, @NonNull Throwable error) {
            this.this$0.errors.add(new AbstractMap.SimpleEntry<Node, Throwable>(node, error));
        }

        private void trackNodeError(@NonNull Node node, @NonNull Throwable error) {
            if (this.nodeErrorReported.compareAndSet(false, true)) {
                long latencyNanos = System.nanoTime() - this.messageStartTimeNanos;
                this.this$0.context.getRequestTracker().onNodeError((Request)this.statement, error, latencyNanos, this.executionProfile, node, this.logPrefix);
            }
        }

        private void abort(@NonNull Throwable error, boolean fromServer) {
            assert (this.lock.isHeldByCurrentThread());
            LOG.trace("[{}] Aborting due to {} ({})", new Object[]{this.logPrefix, error.getClass().getSimpleName(), error.getMessage()});
            if (this.channel == null) {
                this.enqueueOrCompletePending(error);
                this.state = -2;
            } else if (this.state > 0) {
                this.enqueueOrCompletePending(error);
                if (fromServer) {
                    this.state = -2;
                    this.reenableAutoReadIfNeeded();
                } else {
                    this.cancel();
                }
            }
            this.stopGlobalRequestTimer();
            this.cancelTimeout(this.this$0.globalTimeout);
        }

        private void stopNodeMessageTimer() {
            if (this.stopNodeMessageTimerReported.compareAndSet(false, true)) {
                ((DefaultNode)this.node).getMetricUpdater().updateTimer(this.this$0.messagesMetric, this.executionProfile.getName(), System.nanoTime() - this.messageStartTimeNanos, TimeUnit.NANOSECONDS);
            }
        }

        private void stopGlobalRequestTimer() {
            this.this$0.session.getMetricUpdater().updateTimer(this.this$0.continuousRequestsMetric, null, System.nanoTime() - this.this$0.startTimeNanos, TimeUnit.NANOSECONDS);
        }

        private void updateErrorMetrics(@NonNull NodeMetricUpdater metricUpdater, @NonNull RetryVerdict verdict, @NonNull DefaultNodeMetric error, @NonNull DefaultNodeMetric retriesOnError, @NonNull DefaultNodeMetric ignoresOnError) {
            metricUpdater.incrementCounter(error, this.executionProfile.getName());
            switch (verdict.getRetryDecision()) {
                case RETRY_SAME: 
                case RETRY_NEXT: {
                    metricUpdater.incrementCounter(DefaultNodeMetric.RETRIES, this.executionProfile.getName());
                    metricUpdater.incrementCounter(retriesOnError, this.executionProfile.getName());
                    break;
                }
                case IGNORE: {
                    metricUpdater.incrementCounter(DefaultNodeMetric.IGNORES, this.executionProfile.getName());
                    metricUpdater.incrementCounter(ignoresOnError, this.executionProfile.getName());
                    break;
                }
            }
        }

        @NonNull
        private CompletableFuture<ResultSetT> immediateResultSetFuture(@NonNull Object pageOrError) {
            CompletableFuture future = new CompletableFuture();
            this.completeResultSetFuture(future, pageOrError);
            return future;
        }

        @NonNull
        private CompletableFuture<ResultSetT> cancelledResultSetFuture() {
            return this.immediateResultSetFuture(new CancellationException("Can't get more results because the continuous query has failed already. Most likely this is because the query was cancelled"));
        }

        private void completeResultSetFuture(@NonNull CompletableFuture<ResultSetT> future, @NonNull Object pageOrError) {
            long now = System.nanoTime();
            long totalLatencyNanos = now - this.this$0.startTimeNanos;
            long nodeLatencyNanos = now - this.messageStartTimeNanos;
            if (this.this$0.resultSetClass.isInstance(pageOrError)) {
                if (future.complete(this.this$0.resultSetClass.cast(pageOrError))) {
                    this.this$0.throttler.signalSuccess(this.this$0);
                    if (this.nodeSuccessReported.compareAndSet(false, true)) {
                        this.this$0.context.getRequestTracker().onNodeSuccess((Request)this.statement, nodeLatencyNanos, this.executionProfile, this.node, this.logPrefix);
                    }
                    this.this$0.context.getRequestTracker().onSuccess((Request)this.statement, totalLatencyNanos, this.executionProfile, this.node, this.logPrefix);
                }
            } else {
                Throwable error = (Throwable)pageOrError;
                if (future.completeExceptionally(error)) {
                    this.this$0.context.getRequestTracker().onError((Request)this.statement, error, totalLatencyNanos, this.executionProfile, this.node, this.logPrefix);
                    if (error instanceof DriverTimeoutException) {
                        this.this$0.throttler.signalTimeout(this.this$0);
                        this.this$0.session.getMetricUpdater().incrementCounter(this.this$0.clientTimeoutsMetric, this.executionProfile.getName());
                    } else if (!(error instanceof RequestThrottlingException)) {
                        this.this$0.throttler.signalError(this.this$0, error);
                    }
                }
            }
        }

        @NonNull
        private ExecutionInfo createExecutionInfo(@NonNull Result result, @Nullable Frame response) {
            ByteBuffer pagingState = result instanceof Rows ? ((Rows)result).getMetadata().pagingState : null;
            return new DefaultExecutionInfo((Request)this.statement, this.node, this.this$0.startedSpeculativeExecutionsCount.get(), this.executionIndex, this.this$0.errors, pagingState, response, true, this.this$0.session, this.this$0.context, this.executionProfile);
        }

        private void logTimeoutSchedulingError(IllegalStateException timeoutError) {
            if (!"cannot be started once stopped".equals(timeoutError.getMessage())) {
                Loggers.warnWithException(LOG, "[{}] Error while scheduling timeout", this.logPrefix, timeoutError);
            }
        }

        @NonNull
        private String asTraceString(@NonNull Object pageOrError) {
            return this.this$0.resultSetClass.isInstance(pageOrError) ? "page " + this.this$0.pageNumber(this.this$0.resultSetClass.cast(pageOrError)) : ((Exception)pageOrError).getClass().getSimpleName();
        }

        private int getState() {
            this.lock.lock();
            try {
                int n = this.state;
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        private CompletableFuture<ResultSetT> getPendingResult() {
            this.lock.lock();
            try {
                CompletableFuture completableFuture = this.pendingResult;
                return completableFuture;
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

