/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.wave;

import android.graphics.Path;
import com.scwang.wave.Util;

class Wave {
    Path path;
    int width;
    int wave;
    float offsetX;
    float offsetY;
    float velocity;
    private float scaleX;
    private float scaleY;
    private int curWave;

    Wave(int offsetX, int offsetY, int velocity, float scaleX, float scaleY, int wave) {
        this.wave = wave;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.velocity = velocity;
        this.path = new Path();
    }

    protected void updateWavePath(int w, int h, int waveHeight, boolean fullScreen, float progress) {
        this.wave = waveHeight;
        this.width = (int)(2.0f * this.scaleX * (float)w);
        this.path = this.buildWavePath(this.width, h, fullScreen, progress);
    }

    protected void updateWavePath(int w, int h, float progress) {
        int wave = (int)(this.scaleY * (float)this.wave);
        float maxWave = (float)h * Math.max(0.0f, 1.0f - progress);
        if ((float)wave > maxWave) {
            wave = (int)maxWave;
        }
        if (this.curWave != wave) {
            this.width = (int)(2.0f * this.scaleX * (float)w);
            this.path = this.buildWavePath(this.width, h, true, progress);
        }
    }

    protected Path buildWavePath(int width, int height, boolean fullScreen, float progress) {
        float maxWave;
        int DP = Util.dp2px(1.0f);
        if (DP < 1) {
            DP = 1;
        }
        int wave = (int)(this.scaleY * (float)this.wave);
        if (fullScreen && (float)wave > (maxWave = (float)height * Math.max(0.0f, 1.0f - progress))) {
            wave = (int)maxWave;
        }
        this.curWave = wave;
        this.path.reset();
        this.path.moveTo(0.0f, 0.0f);
        this.path.lineTo(0.0f, (float)(height - wave));
        if (wave > 0) {
            for (int x = DP; x < width; x += DP) {
                this.path.lineTo((float)x, (float)(height - wave) - (float)wave * (float)Math.sin(Math.PI * 4 * (double)x / (double)width));
            }
        }
        this.path.lineTo((float)width, (float)(height - wave));
        this.path.lineTo((float)width, 0.0f);
        this.path.close();
        return this.path;
    }
}

