/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.wave;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.core.graphics.ColorUtils;
import com.scwang.wave.R;
import com.scwang.wave.ShapeType;
import com.scwang.wave.Util;
import com.scwang.wave.Wave;
import java.util.ArrayList;
import java.util.List;

public class MultiWaveHeader
extends ViewGroup {
    protected Path mPath;
    protected ShapeType mShape = ShapeType.Rect;
    protected Paint mPaint = new Paint();
    protected Matrix mMatrix = new Matrix();
    protected List<Wave> mltWave = new ArrayList<Wave>();
    protected float mCornerRadius;
    protected int mWaveHeight;
    protected int mStartColor;
    protected int mCloseColor;
    protected int mGradientAngle;
    protected boolean mIsRunning;
    protected boolean mEnableFullScreen;
    protected float mVelocity;
    protected float mColorAlpha;
    protected float mProgress;
    protected float mCurProgress;
    protected long mLastTime = 0L;
    protected ValueAnimator reboundAnimator;

    public MultiWaveHeader(Context context) {
        this(context, null, 0);
    }

    public MultiWaveHeader(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MultiWaveHeader(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mPaint.setAntiAlias(true);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.MultiWaveHeader);
        this.mWaveHeight = ta.getDimensionPixelOffset(R.styleable.MultiWaveHeader_mwhWaveHeight, Util.dp2px(50.0f));
        this.mStartColor = ta.getColor(R.styleable.MultiWaveHeader_mwhStartColor, -16421680);
        this.mCloseColor = ta.getColor(R.styleable.MultiWaveHeader_mwhCloseColor, -13520898);
        this.mColorAlpha = ta.getFloat(R.styleable.MultiWaveHeader_mwhColorAlpha, 0.45f);
        this.mVelocity = ta.getFloat(R.styleable.MultiWaveHeader_mwhVelocity, 1.0f);
        this.mGradientAngle = ta.getInt(R.styleable.MultiWaveHeader_mwhGradientAngle, 45);
        this.mIsRunning = ta.getBoolean(R.styleable.MultiWaveHeader_mwhIsRunning, true);
        this.mEnableFullScreen = ta.getBoolean(R.styleable.MultiWaveHeader_mwhEnableFullScreen, false);
        this.mCornerRadius = ta.getDimensionPixelOffset(R.styleable.MultiWaveHeader_mwhCornerRadius, Util.dp2px(25.0f));
        this.mShape = ShapeType.values()[ta.getInt(R.styleable.MultiWaveHeader_mwhShape, this.mShape.ordinal())];
        this.mProgress = this.mCurProgress = ta.getFloat(R.styleable.MultiWaveHeader_mwhProgress, 1.0f);
        if (ta.hasValue(R.styleable.MultiWaveHeader_mwhWaves)) {
            this.setTag(ta.getString(R.styleable.MultiWaveHeader_mwhWaves));
        } else if (this.getTag() == null) {
            this.setTag("70,25,1.4,1.4,-26\n100,5,1.4,1.2,15\n420,0,1.15,1,-10\n520,10,1.7,1.5,20\n220,0,1,1,-15");
        }
        ta.recycle();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mltWave.isEmpty()) {
            this.updateWavePath();
            this.updateWavePath(r - l, b - t);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateShapePath();
        this.updateWavePath(w, h);
        this.updateLinearGradient(w, h);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mltWave.size() > 0) {
            if (this.mPath != null) {
                canvas.save();
                canvas.clipPath(this.mPath);
            }
            MultiWaveHeader thisView = this;
            int height = thisView.getHeight();
            long thisTime = System.currentTimeMillis();
            for (Wave wave : this.mltWave) {
                this.mMatrix.reset();
                canvas.save();
                if (this.mIsRunning && this.mLastTime > 0L && wave.velocity != 0.0f) {
                    float offsetX;
                    if (-wave.velocity > 0.0f) {
                        offsetX %= (float)wave.width / 2.0f;
                    } else {
                        for (offsetX = wave.offsetX - wave.velocity * this.mVelocity * (float)(thisTime - this.mLastTime) / 1000.0f; offsetX < 0.0f; offsetX += (float)wave.width / 2.0f) {
                        }
                    }
                    wave.offsetX = offsetX;
                    this.mMatrix.setTranslate(offsetX, (1.0f - this.mCurProgress) * (float)height);
                    canvas.translate(-offsetX, -wave.offsetY - (1.0f - this.mCurProgress) * (float)height);
                } else {
                    this.mMatrix.setTranslate(wave.offsetX, (1.0f - this.mCurProgress) * (float)height);
                    canvas.translate(-wave.offsetX, -wave.offsetY - (1.0f - this.mCurProgress) * (float)height);
                }
                this.mPaint.getShader().setLocalMatrix(this.mMatrix);
                canvas.drawPath(wave.path, this.mPaint);
                canvas.restore();
            }
            this.mLastTime = thisTime;
            if (this.mPath != null) {
                canvas.restore();
            }
            if (this.mIsRunning) {
                this.invalidate();
            }
        }
    }

    private void updateLinearGradient(int width, int height) {
        int startColor = ColorUtils.setAlphaComponent((int)this.mStartColor, (int)((int)(this.mColorAlpha * 255.0f)));
        int closeColor = ColorUtils.setAlphaComponent((int)this.mCloseColor, (int)((int)(this.mColorAlpha * 255.0f)));
        double w = width;
        double h = (float)height * this.mCurProgress;
        double r = Math.sqrt(w * w + h * h) / 2.0;
        double y = r * Math.sin(Math.PI * 2 * (double)this.mGradientAngle / 360.0);
        double x = r * Math.cos(Math.PI * 2 * (double)this.mGradientAngle / 360.0);
        this.mPaint.setShader((Shader)new LinearGradient((float)((int)(w / 2.0 - x)), (float)((int)(h / 2.0 - y)), (float)((int)(w / 2.0 + x)), (float)((int)(h / 2.0 + y)), startColor, closeColor, Shader.TileMode.CLAMP));
    }

    protected void updateShapePath() {
        MultiWaveHeader thisView = this;
        int w = thisView.getWidth();
        int h = thisView.getHeight();
        if (w > 0 && h > 0 && this.mShape != null && this.mShape != ShapeType.Rect) {
            this.mPath = new Path();
            switch (this.mShape) {
                case RoundRect: {
                    this.mPath.addRoundRect(new RectF(0.0f, 0.0f, (float)w, (float)h), this.mCornerRadius, this.mCornerRadius, Path.Direction.CW);
                    break;
                }
                case Oval: {
                    this.mPath.addOval(new RectF(0.0f, 0.0f, (float)w, (float)h), Path.Direction.CW);
                }
            }
        } else {
            this.mPath = null;
        }
    }

    protected void updateWavePath() {
        this.mltWave.clear();
        if (this.getTag() instanceof String) {
            String[] waves = this.getTag().toString().split("\\s+");
            if ("-1".equals(this.getTag())) {
                waves = "70,25,1.4,1.4,-26\n100,5,1.4,1.2,15\n420,0,1.15,1,-10\n520,10,1.7,1.5,20\n220,0,1,1,-15".split("\\s+");
            } else if ("-2".equals(this.getTag())) {
                waves = "0,0,1,0.5,90\n90,0,1,0.5,90".split("\\s+");
            }
            for (String wave : waves) {
                String[] args = wave.split("\\s*,\\s*");
                if (args.length != 5) continue;
                this.mltWave.add(new Wave(Util.dp2px(Float.parseFloat(args[0])), Util.dp2px(Float.parseFloat(args[1])), Util.dp2px(Float.parseFloat(args[4])), Float.parseFloat(args[2]), Float.parseFloat(args[3]), this.mWaveHeight / 2));
            }
        } else {
            this.mltWave.add(new Wave(Util.dp2px(50.0f), Util.dp2px(0.0f), Util.dp2px(5.0f), 1.7f, 2.0f, this.mWaveHeight / 2));
        }
    }

    protected void updateWavePath(int w, int h) {
        for (Wave wave : this.mltWave) {
            wave.updateWavePath(w, h, this.mWaveHeight / 2, this.mEnableFullScreen, this.mCurProgress);
        }
    }

    protected void animProgress(float progress, Interpolator interpolator, int duration) {
        if (this.mCurProgress != progress) {
            if (this.reboundAnimator != null) {
                this.reboundAnimator.cancel();
            }
            this.reboundAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mCurProgress, progress});
            this.reboundAnimator.setDuration((long)duration);
            this.reboundAnimator.setInterpolator((TimeInterpolator)interpolator);
            this.reboundAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    MultiWaveHeader.this.reboundAnimator = null;
                }
            });
            this.reboundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    MultiWaveHeader.this.updateProgress(((Float)animation.getAnimatedValue()).floatValue());
                }
            });
            this.reboundAnimator.start();
        }
    }

    protected void updateProgress(float progress) {
        MultiWaveHeader thisView = this;
        this.mCurProgress = progress;
        this.updateLinearGradient(thisView.getWidth(), thisView.getHeight());
        if (this.mEnableFullScreen) {
            for (Wave wave : this.mltWave) {
                wave.updateWavePath(thisView.getWidth(), thisView.getHeight(), this.mCurProgress);
            }
        }
        if (!this.mIsRunning) {
            this.invalidate();
        }
    }

    public void setWaves(String waves) {
        this.setTag(waves);
        if (this.mLastTime > 0L) {
            MultiWaveHeader thisView = this;
            this.updateWavePath();
            this.updateWavePath(thisView.getWidth(), thisView.getHeight());
        }
    }

    public int getWaveHeight() {
        return this.mWaveHeight;
    }

    public void setWaveHeight(int waveHeight) {
        this.mWaveHeight = Util.dp2px(waveHeight);
        if (!this.mltWave.isEmpty()) {
            MultiWaveHeader thisView = this;
            this.updateWavePath(thisView.getWidth(), thisView.getHeight());
        }
    }

    public float getVelocity() {
        return this.mVelocity;
    }

    public void setVelocity(float velocity) {
        this.mVelocity = velocity;
    }

    public float getProgress() {
        return this.mProgress;
    }

    public void setProgress(float progress) {
        this.mProgress = progress;
        if (!this.mIsRunning) {
            this.updateProgress(progress);
        } else {
            this.animProgress(progress, (Interpolator)new DecelerateInterpolator(), 300);
        }
    }

    public void setProgress(float progress, Interpolator interpolator, int duration) {
        this.mProgress = progress;
        this.animProgress(progress, (Interpolator)new DecelerateInterpolator(), duration);
    }

    public int getGradientAngle() {
        return this.mGradientAngle;
    }

    public void setGradientAngle(int angle) {
        this.mGradientAngle = angle;
        if (!this.mltWave.isEmpty()) {
            MultiWaveHeader thisView = this;
            this.updateLinearGradient(thisView.getWidth(), thisView.getHeight());
        }
    }

    public int getStartColor() {
        return this.mStartColor;
    }

    public void setStartColor(int color) {
        this.mStartColor = color;
        if (!this.mltWave.isEmpty()) {
            MultiWaveHeader thisView = this;
            this.updateLinearGradient(thisView.getWidth(), thisView.getHeight());
        }
    }

    public void setStartColorId(@ColorRes int colorId) {
        MultiWaveHeader thisView = this;
        this.setStartColor(Util.getColor(thisView.getContext(), colorId));
    }

    public int getCloseColor() {
        return this.mCloseColor;
    }

    public void setCloseColor(int color) {
        this.mCloseColor = color;
        if (!this.mltWave.isEmpty()) {
            MultiWaveHeader thisView = this;
            this.updateLinearGradient(thisView.getWidth(), thisView.getHeight());
        }
    }

    public void setCloseColorId(@ColorRes int colorId) {
        MultiWaveHeader thisView = this;
        this.setCloseColor(Util.getColor(thisView.getContext(), colorId));
    }

    public float getColorAlpha() {
        return this.mColorAlpha;
    }

    public void setColorAlpha(float alpha) {
        this.mColorAlpha = alpha;
        if (!this.mltWave.isEmpty()) {
            MultiWaveHeader thisView = this;
            this.updateLinearGradient(thisView.getWidth(), thisView.getHeight());
        }
    }

    public void start() {
        if (!this.mIsRunning) {
            this.mIsRunning = true;
            this.mLastTime = System.currentTimeMillis();
            this.invalidate();
        }
    }

    public void stop() {
        this.mIsRunning = false;
    }

    public boolean isRunning() {
        return this.mIsRunning;
    }

    public void setEnableFullScreen(boolean fullScreen) {
        this.mEnableFullScreen = fullScreen;
    }

    public boolean isEnableFullScreen() {
        return this.mEnableFullScreen;
    }

    public void setShape(ShapeType shape) {
        this.mShape = shape;
        this.updateShapePath();
    }

    public ShapeType getShape() {
        return this.mShape;
    }
}

