/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.internal;

import android.content.Context;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshInternal;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.InternalAbstract;
import com.scwang.smartrefresh.layout.internal.PaintDrawable;
import com.scwang.smartrefresh.layout.util.SmartUtil;

public abstract class InternalClassics<T extends InternalClassics>
extends InternalAbstract
implements RefreshInternal {
    public static final int ID_TEXT_TITLE = R.id.srl_classics_title;
    public static final int ID_IMAGE_ARROW = R.id.srl_classics_arrow;
    public static final int ID_IMAGE_PROGRESS = R.id.srl_classics_progress;
    protected TextView mTitleText;
    protected ImageView mArrowView;
    protected ImageView mProgressView;
    protected RefreshKernel mRefreshKernel;
    protected PaintDrawable mArrowDrawable;
    protected PaintDrawable mProgressDrawable;
    protected boolean mSetAccentColor;
    protected boolean mSetPrimaryColor;
    protected int mBackgroundColor;
    protected int mFinishDuration = 500;
    protected int mPaddingTop = 20;
    protected int mPaddingBottom = 20;
    protected int mMinHeightOfContent = 0;

    public InternalClassics(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mSpinnerStyle = SpinnerStyle.Translate;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        InternalClassics thisView = this;
        if (this.mMinHeightOfContent == 0) {
            this.mPaddingTop = thisView.getPaddingTop();
            this.mPaddingBottom = thisView.getPaddingBottom();
            if (this.mPaddingTop == 0 || this.mPaddingBottom == 0) {
                int paddingLeft = thisView.getPaddingLeft();
                int paddingRight = thisView.getPaddingRight();
                this.mPaddingTop = this.mPaddingTop == 0 ? SmartUtil.dp2px(20.0f) : this.mPaddingTop;
                this.mPaddingBottom = this.mPaddingBottom == 0 ? SmartUtil.dp2px(20.0f) : this.mPaddingBottom;
                thisView.setPadding(paddingLeft, this.mPaddingTop, paddingRight, this.mPaddingBottom);
            }
            InternalClassics thisGroup = this;
            thisGroup.setClipToPadding(false);
        }
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0x40000000) {
            int parentHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (parentHeight < this.mMinHeightOfContent) {
                int padding = (parentHeight - this.mMinHeightOfContent) / 2;
                thisView.setPadding(thisView.getPaddingLeft(), padding, thisView.getPaddingRight(), padding);
            } else {
                thisView.setPadding(thisView.getPaddingLeft(), 0, thisView.getPaddingRight(), 0);
            }
        } else {
            thisView.setPadding(thisView.getPaddingLeft(), this.mPaddingTop, thisView.getPaddingRight(), this.mPaddingBottom);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mMinHeightOfContent == 0) {
            InternalClassics thisGroup = this;
            for (int i = 0; i < thisGroup.getChildCount(); ++i) {
                int height = thisGroup.getChildAt(i).getMeasuredHeight();
                if (this.mMinHeightOfContent >= height) continue;
                this.mMinHeightOfContent = height;
            }
        }
    }

    protected void onDetachedFromWindow() {
        Drawable drawable;
        super.onDetachedFromWindow();
        if (Build.VERSION.SDK_INT >= 14) {
            ImageView arrowView = this.mArrowView;
            ImageView progressView = this.mProgressView;
            arrowView.animate().cancel();
            progressView.animate().cancel();
        }
        if ((drawable = this.mProgressView.getDrawable()) instanceof Animatable && ((Animatable)drawable).isRunning()) {
            ((Animatable)drawable).stop();
        }
    }

    protected T self() {
        return (T)this;
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        this.mRefreshKernel = kernel;
        this.mRefreshKernel.requestDrawBackgroundFor(this, this.mBackgroundColor);
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        ImageView progressView = this.mProgressView;
        if (progressView.getVisibility() != 0) {
            progressView.setVisibility(0);
            Drawable drawable = this.mProgressView.getDrawable();
            if (drawable instanceof Animatable) {
                ((Animatable)drawable).start();
            } else {
                progressView.animate().rotation(36000.0f).setDuration(100000L);
            }
        }
    }

    @Override
    public void onReleased(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        this.onStartAnimator(refreshLayout, height, maxDragHeight);
    }

    @Override
    public int onFinish(@NonNull RefreshLayout refreshLayout, boolean success) {
        ImageView progressView = this.mProgressView;
        Drawable drawable = this.mProgressView.getDrawable();
        if (drawable instanceof Animatable) {
            if (((Animatable)drawable).isRunning()) {
                ((Animatable)drawable).stop();
            }
        } else {
            progressView.animate().rotation(0.0f).setDuration(0L);
        }
        progressView.setVisibility(8);
        return this.mFinishDuration;
    }

    @Override
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0) {
            InternalClassics thisView = this;
            if (!(thisView.getBackground() instanceof BitmapDrawable) && !this.mSetPrimaryColor) {
                this.setPrimaryColor(colors[0]);
                this.mSetPrimaryColor = false;
            }
            if (!this.mSetAccentColor) {
                if (colors.length > 1) {
                    this.setAccentColor(colors[1]);
                } else {
                    this.setAccentColor(colors[0] == -1 ? -10066330 : -1);
                }
                this.mSetAccentColor = false;
            }
        }
    }

    public T setProgressDrawable(Drawable drawable) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageDrawable(drawable);
        return this.self();
    }

    public T setProgressResource(@DrawableRes int resId) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageResource(resId);
        return this.self();
    }

    public T setArrowDrawable(Drawable drawable) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageDrawable(drawable);
        return this.self();
    }

    public T setArrowResource(@DrawableRes int resId) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageResource(resId);
        return this.self();
    }

    public T setSpinnerStyle(SpinnerStyle style) {
        this.mSpinnerStyle = style;
        return this.self();
    }

    public T setPrimaryColor(@ColorInt int primaryColor) {
        this.mSetPrimaryColor = true;
        this.mBackgroundColor = primaryColor;
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestDrawBackgroundFor(this, primaryColor);
        }
        return this.self();
    }

    public T setAccentColor(@ColorInt int accentColor) {
        this.mSetAccentColor = true;
        this.mTitleText.setTextColor(accentColor);
        if (this.mArrowDrawable != null) {
            this.mArrowDrawable.setColor(accentColor);
            this.mArrowView.invalidateDrawable((Drawable)this.mArrowDrawable);
        }
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setColor(accentColor);
            this.mProgressView.invalidateDrawable((Drawable)this.mProgressDrawable);
        }
        return this.self();
    }

    public T setPrimaryColorId(@ColorRes int colorId) {
        InternalClassics thisView = this;
        this.setPrimaryColor(ContextCompat.getColor((Context)thisView.getContext(), (int)colorId));
        return this.self();
    }

    public T setAccentColorId(@ColorRes int colorId) {
        InternalClassics thisView = this;
        this.setAccentColor(ContextCompat.getColor((Context)thisView.getContext(), (int)colorId));
        return this.self();
    }

    public T setFinishDuration(int delay) {
        this.mFinishDuration = delay;
        return this.self();
    }

    public T setTextSizeTitle(float size) {
        this.mTitleText.setTextSize(size);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightFor(this);
        }
        return this.self();
    }

    public T setDrawableMarginRight(float dp) {
        ImageView arrowView = this.mArrowView;
        ImageView progressView = this.mProgressView;
        ViewGroup.MarginLayoutParams lpArrow = (ViewGroup.MarginLayoutParams)arrowView.getLayoutParams();
        ViewGroup.MarginLayoutParams lpProgress = (ViewGroup.MarginLayoutParams)progressView.getLayoutParams();
        lpArrow.rightMargin = lpProgress.rightMargin = SmartUtil.dp2px(dp);
        arrowView.setLayoutParams((ViewGroup.LayoutParams)lpArrow);
        progressView.setLayoutParams((ViewGroup.LayoutParams)lpProgress);
        return this.self();
    }

    public T setDrawableSize(float dp) {
        ImageView arrowView = this.mArrowView;
        ImageView progressView = this.mProgressView;
        ViewGroup.LayoutParams lpArrow = arrowView.getLayoutParams();
        ViewGroup.LayoutParams lpProgress = progressView.getLayoutParams();
        lpArrow.width = lpProgress.width = SmartUtil.dp2px(dp);
        lpArrow.height = lpProgress.height = SmartUtil.dp2px(dp);
        arrowView.setLayoutParams(lpArrow);
        progressView.setLayoutParams(lpProgress);
        return this.self();
    }

    public T setDrawableArrowSize(float dp) {
        ImageView arrowView = this.mArrowView;
        ViewGroup.LayoutParams lpArrow = arrowView.getLayoutParams();
        lpArrow.height = lpArrow.width = SmartUtil.dp2px(dp);
        arrowView.setLayoutParams(lpArrow);
        return this.self();
    }

    public T setDrawableProgressSize(float dp) {
        ImageView progressView = this.mProgressView;
        ViewGroup.LayoutParams lpProgress = progressView.getLayoutParams();
        lpProgress.height = lpProgress.width = SmartUtil.dp2px(dp);
        progressView.setLayoutParams(lpProgress);
        return this.self();
    }
}

