/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.internal;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.view.animation.LinearInterpolator;
import androidx.annotation.NonNull;
import com.scwang.smartrefresh.layout.internal.PaintDrawable;

public class ProgressDrawable
extends PaintDrawable
implements Animatable,
ValueAnimator.AnimatorUpdateListener {
    protected int mWidth = 0;
    protected int mHeight = 0;
    protected int mProgressDegree = 0;
    protected ValueAnimator mValueAnimator;
    protected Path mPath = new Path();

    public ProgressDrawable() {
        this.mValueAnimator = ValueAnimator.ofInt((int[])new int[]{30, 3600});
        this.mValueAnimator.setDuration(10000L);
        this.mValueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mValueAnimator.setRepeatCount(-1);
        this.mValueAnimator.setRepeatMode(1);
    }

    public void onAnimationUpdate(ValueAnimator animation) {
        int value = (Integer)animation.getAnimatedValue();
        this.mProgressDegree = 30 * (value / 30);
        ProgressDrawable drawable = this;
        drawable.invalidateSelf();
    }

    public void draw(@NonNull Canvas canvas) {
        ProgressDrawable drawable = this;
        Rect bounds = drawable.getBounds();
        int width = bounds.width();
        int height = bounds.height();
        int r = Math.max(1, width / 20);
        if (this.mWidth != width || this.mHeight != height) {
            this.mPath.reset();
            this.mPath.addCircle((float)(width - r), (float)(height / 2), (float)r, Path.Direction.CW);
            this.mPath.addRect((float)(width - 5 * r), (float)(height / 2 - r), (float)(width - r), (float)(height / 2 + r), Path.Direction.CW);
            this.mPath.addCircle((float)(width - 5 * r), (float)(height / 2), (float)r, Path.Direction.CW);
            this.mWidth = width;
            this.mHeight = height;
        }
        canvas.save();
        canvas.rotate((float)this.mProgressDegree, (float)(width / 2), (float)(height / 2));
        for (int i = 0; i < 12; ++i) {
            this.mPaint.setAlpha((i + 5) * 17);
            canvas.rotate(30.0f, (float)(width / 2), (float)(height / 2));
            canvas.drawPath(this.mPath, this.mPaint);
        }
        canvas.restore();
    }

    public void start() {
        if (!this.mValueAnimator.isRunning()) {
            this.mValueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)this);
            this.mValueAnimator.start();
        }
    }

    public void stop() {
        if (this.mValueAnimator.isRunning()) {
            this.mValueAnimator.removeAllListeners();
            this.mValueAnimator.removeAllUpdateListeners();
            this.mValueAnimator.cancel();
        }
    }

    public boolean isRunning() {
        return this.mValueAnimator.isRunning();
    }
}

