/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.header;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.internal.InternalAbstract;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class FalsifyHeader
extends InternalAbstract
implements RefreshHeader {
    protected RefreshKernel mRefreshKernel;

    public FalsifyHeader(Context context) {
        this(context, null);
    }

    public FalsifyHeader(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FalsifyHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        FalsifyHeader thisView = this;
        if (thisView.isInEditMode()) {
            int d = DensityUtil.dp2px(5.0f);
            Paint paint = new Paint();
            paint.setStyle(Paint.Style.STROKE);
            paint.setColor(-858993460);
            paint.setStrokeWidth((float)DensityUtil.dp2px(1.0f));
            paint.setPathEffect((PathEffect)new DashPathEffect(new float[]{d, d, d, d}, 1.0f));
            canvas.drawRect((float)d, (float)d, (float)(thisView.getWidth() - d), (float)(thisView.getBottom() - d), paint);
            TextView textView = new TextView(thisView.getContext());
            textView.setText((CharSequence)thisView.getResources().getString(R.string.srl_component_falsify, new Object[]{this.getClass().getSimpleName(), Float.valueOf(DensityUtil.px2dp(thisView.getHeight()))}));
            textView.setTextColor(-858993460);
            textView.setGravity(17);
            TextView view = textView;
            view.measure(View.MeasureSpec.makeMeasureSpec((int)thisView.getWidth(), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)thisView.getHeight(), (int)0x40000000));
            view.layout(0, 0, thisView.getWidth(), thisView.getHeight());
            view.draw(canvas);
        }
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        this.mRefreshKernel = kernel;
    }

    @Override
    public void onReleased(@NonNull RefreshLayout layout, int height, int maxDragHeight) {
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.setState(RefreshState.None);
            this.mRefreshKernel.setState(RefreshState.RefreshFinish);
        }
    }
}

