/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.impl;

import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshInternal;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.impl.RefreshInternalWrapper;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class RefreshHeaderWrapper
extends RefreshInternalWrapper
implements RefreshHeader,
InvocationHandler {
    private RefreshKernel mRefreshKernel;
    private Method mRequestDrawBackgroundForFooterMethod;
    private Method mRequestRemeasureHeightForFooterMethod;
    private Method mRequestNeedTouchEventWhenLoadingMethod;

    public RefreshHeaderWrapper(View wrapper) {
        super(wrapper);
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
        if (this.mWrapperView instanceof RefreshInternal) {
            RefreshKernel proxy = (RefreshKernel)Proxy.newProxyInstance(RefreshKernel.class.getClassLoader(), new Class[]{RefreshKernel.class}, (InvocationHandler)this);
            proxy.requestDrawBackgroundForFooter(0);
            proxy.requestRemeasureHeightForFooter();
            proxy.requestNeedTouchEventWhenLoading(false);
            this.mRefreshKernel = kernel;
            ((RefreshInternal)this.mWrapperView).onInitialized(proxy, height, extendHeight);
        } else {
            ViewGroup.LayoutParams params = this.mWrapperView.getLayoutParams();
            if (params instanceof SmartRefreshLayout.LayoutParams) {
                kernel.requestDrawBackgroundForHeader(((SmartRefreshLayout.LayoutParams)params).backgroundColor);
            }
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object returnValue = null;
        if (this.mRefreshKernel != null) {
            if (method.equals(this.mRequestDrawBackgroundForFooterMethod)) {
                this.mRefreshKernel.requestDrawBackgroundForHeader((Integer)args[0]);
            } else if (method.equals(this.mRequestRemeasureHeightForFooterMethod)) {
                this.mRefreshKernel.requestRemeasureHeightForHeader();
            } else if (method.equals(this.mRequestNeedTouchEventWhenLoadingMethod)) {
                this.mRefreshKernel.requestNeedTouchEventWhenRefreshing((Boolean)args[0]);
            } else {
                returnValue = method.invoke((Object)this.mRefreshKernel, args);
            }
        }
        if (method.getReturnType().equals(RefreshKernel.class)) {
            if (this.mRefreshKernel == null && RefreshKernel.class.equals(method.getDeclaringClass())) {
                if (this.mRequestDrawBackgroundForFooterMethod == null) {
                    this.mRequestDrawBackgroundForFooterMethod = method;
                } else if (this.mRequestRemeasureHeightForFooterMethod == null) {
                    this.mRequestRemeasureHeightForFooterMethod = method;
                } else if (this.mRequestNeedTouchEventWhenLoadingMethod == null) {
                    this.mRequestNeedTouchEventWhenLoadingMethod = method;
                }
            }
            return proxy;
        }
        return returnValue;
    }
}

