/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.impl;

import android.animation.ValueAnimator;
import android.graphics.PointF;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.ScrollingView;
import android.support.v4.view.ViewPager;
import android.support.v4.widget.NestedScrollView;
import android.support.v4.widget.Space;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.ListView;
import android.widget.ScrollView;
import com.scwang.smartrefresh.layout.api.RefreshContent;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.ScrollBoundaryDecider;
import com.scwang.smartrefresh.layout.impl.ScrollBoundaryDeciderAdapter;
import com.scwang.smartrefresh.layout.util.CoordinatorLayoutListener;
import com.scwang.smartrefresh.layout.util.DesignUtil;
import com.scwang.smartrefresh.layout.util.ScrollBoundaryUtil;
import java.util.Collections;
import java.util.concurrent.LinkedBlockingQueue;

public class RefreshContentWrapper
implements RefreshContent {
    protected int mHeaderHeight = Integer.MAX_VALUE;
    protected int mFooterHeight = this.mHeaderHeight - 1;
    protected View mContentView;
    protected View mRealContentView;
    protected View mScrollableView;
    protected View mFixedHeader;
    protected View mFixedFooter;
    protected boolean mEnableRefresh = true;
    protected boolean mEnableLoadMore = true;
    protected MotionEvent mMotionEvent;
    protected ScrollBoundaryDeciderAdapter mBoundaryAdapter = new ScrollBoundaryDeciderAdapter();

    public RefreshContentWrapper(View view) {
        this.mContentView = this.mRealContentView = view;
    }

    protected void findScrollableView(View content, RefreshKernel kernel) {
        this.mScrollableView = null;
        CoordinatorLayoutListener listener = null;
        boolean isInEditMode = this.mContentView.isInEditMode();
        while ((this.mScrollableView == null || this.mScrollableView instanceof NestedScrollingParent && !(this.mScrollableView instanceof NestedScrollingChild)) && (content = this.findScrollableViewInternal(content, this.mScrollableView == null)) != this.mScrollableView) {
            if (!isInEditMode) {
                if (listener == null) {
                    listener = new CoordinatorLayoutListener(){

                        @Override
                        public void update(boolean enableRefresh, boolean enableLoadMore) {
                            RefreshContentWrapper.this.mEnableRefresh = enableRefresh;
                            RefreshContentWrapper.this.mEnableLoadMore = enableLoadMore;
                        }
                    };
                }
                DesignUtil.checkCoordinatorLayout(content, kernel, listener);
            }
            this.mScrollableView = content;
        }
    }

    protected View findScrollableViewInternal(View content, boolean selfable) {
        View scrollableView = null;
        LinkedBlockingQueue<View> views = new LinkedBlockingQueue<View>(Collections.singletonList(content));
        while (!views.isEmpty() && scrollableView == null) {
            View view = (View)views.poll();
            if (view == null) continue;
            if ((selfable || view != content) && RefreshContentWrapper.isScrollableView(view)) {
                scrollableView = view;
                continue;
            }
            if (!(view instanceof ViewGroup)) continue;
            ViewGroup group = (ViewGroup)view;
            for (int j = 0; j < group.getChildCount(); ++j) {
                views.add(group.getChildAt(j));
            }
        }
        return scrollableView == null ? content : scrollableView;
    }

    protected View findScrollableViewByEvent(View content, MotionEvent event, View orgScrollableView) {
        if (content instanceof ViewGroup && event != null) {
            ViewGroup viewGroup = (ViewGroup)content;
            int childCount = viewGroup.getChildCount();
            PointF point = new PointF();
            for (int i = childCount; i > 0; --i) {
                View child = viewGroup.getChildAt(i - 1);
                if (!ScrollBoundaryUtil.isTransformedTouchPointInView(viewGroup, child, event.getX(), event.getY(), point)) continue;
                if (!(child instanceof ViewPager) && RefreshContentWrapper.isScrollableView(child)) {
                    return child;
                }
                event = MotionEvent.obtain((MotionEvent)event);
                event.offsetLocation(point.x, point.y);
                return this.findScrollableViewByEvent(child, event, orgScrollableView);
            }
        }
        return orgScrollableView;
    }

    @Override
    @NonNull
    public View getView() {
        return this.mContentView;
    }

    @Override
    public void moveSpinner(int spinner) {
        this.mRealContentView.setTranslationY((float)spinner);
        if (this.mFixedHeader != null) {
            this.mFixedHeader.setTranslationY((float)Math.max(0, spinner));
        }
        if (this.mFixedFooter != null) {
            this.mFixedFooter.setTranslationY((float)Math.min(0, spinner));
        }
    }

    @Override
    public boolean canRefresh() {
        return this.mEnableRefresh && this.mBoundaryAdapter.canRefresh(this.mContentView);
    }

    @Override
    public boolean canLoadMore() {
        return this.mEnableLoadMore && this.mBoundaryAdapter.canLoadMore(this.mContentView);
    }

    @Override
    public void measure(int widthSpec, int heightSpec) {
        this.mContentView.measure(widthSpec, heightSpec);
    }

    @Override
    public ViewGroup.LayoutParams getLayoutParams() {
        return this.mContentView.getLayoutParams();
    }

    @Override
    public int getMeasuredWidth() {
        return this.mContentView.getMeasuredWidth();
    }

    @Override
    public int getMeasuredHeight() {
        return this.mContentView.getMeasuredHeight();
    }

    @Override
    public void layout(int left, int top, int right, int bottom) {
        this.mContentView.layout(left, top, right, bottom);
    }

    @Override
    public View getScrollableView() {
        return this.mScrollableView;
    }

    @Override
    public void onActionDown(MotionEvent e) {
        this.mMotionEvent = MotionEvent.obtain((MotionEvent)e);
        this.mMotionEvent.offsetLocation((float)(-this.mContentView.getLeft()), (float)(-this.mContentView.getTop()));
        if (this.mScrollableView != this.mContentView) {
            this.mScrollableView = this.findScrollableViewByEvent(this.mContentView, this.mMotionEvent, this.mScrollableView);
        }
        if (this.mScrollableView == this.mContentView) {
            this.mBoundaryAdapter.setActionEvent(null);
        } else {
            this.mBoundaryAdapter.setActionEvent(this.mMotionEvent);
        }
    }

    @Override
    public void onActionUpOrCancel() {
        this.mMotionEvent = null;
    }

    @Override
    public void fling(int velocity) {
        if (this.mScrollableView instanceof ScrollView) {
            ((ScrollView)this.mScrollableView).fling(velocity);
        } else if (this.mScrollableView instanceof AbsListView) {
            if (Build.VERSION.SDK_INT >= 21) {
                ((AbsListView)this.mScrollableView).fling(velocity);
            }
        } else if (this.mScrollableView instanceof WebView) {
            ((WebView)this.mScrollableView).flingScroll(0, velocity);
        } else if (this.mScrollableView instanceof RecyclerView) {
            ((RecyclerView)this.mScrollableView).fling(0, velocity);
        } else if (this.mScrollableView instanceof NestedScrollView) {
            ((NestedScrollView)this.mScrollableView).fling(velocity);
        }
    }

    @Override
    public void setUpComponent(RefreshKernel kernel, View fixedHeader, View fixedFooter) {
        this.findScrollableView(this.mContentView, kernel);
        if (fixedHeader != null || fixedFooter != null) {
            int index;
            ViewGroup parent;
            ViewGroup.LayoutParams lp;
            this.mFixedHeader = fixedHeader;
            this.mFixedFooter = fixedFooter;
            FrameLayout frameLayout = new FrameLayout(this.mContentView.getContext());
            kernel.getRefreshLayout().getLayout().removeView(this.mContentView);
            ViewGroup.LayoutParams layoutParams = this.mContentView.getLayoutParams();
            frameLayout.addView(this.mContentView, -1, -1);
            kernel.getRefreshLayout().getLayout().addView((View)frameLayout, layoutParams);
            this.mContentView = frameLayout;
            if (fixedHeader != null) {
                fixedHeader.setClickable(true);
                lp = fixedHeader.getLayoutParams();
                parent = (ViewGroup)fixedHeader.getParent();
                index = parent.indexOfChild(fixedHeader);
                parent.removeView(fixedHeader);
                lp.height = RefreshContentWrapper.measureViewHeight(fixedHeader);
                parent.addView((View)new Space(this.mContentView.getContext()), index, lp);
                frameLayout.addView(fixedHeader);
            }
            if (fixedFooter != null) {
                fixedFooter.setClickable(true);
                lp = fixedFooter.getLayoutParams();
                parent = (ViewGroup)fixedFooter.getParent();
                index = parent.indexOfChild(fixedFooter);
                parent.removeView(fixedFooter);
                FrameLayout.LayoutParams flp = new FrameLayout.LayoutParams(lp);
                lp.height = RefreshContentWrapper.measureViewHeight(fixedFooter);
                parent.addView((View)new Space(this.mContentView.getContext()), index, lp);
                flp.gravity = 80;
                frameLayout.addView(fixedFooter, (ViewGroup.LayoutParams)flp);
            }
        }
    }

    @Override
    public void onInitialHeaderAndFooter(int headerHeight, int footerHeight) {
        this.mHeaderHeight = headerHeight;
        this.mFooterHeight = footerHeight;
    }

    @Override
    public void setScrollBoundaryDecider(ScrollBoundaryDecider boundary) {
        if (boundary instanceof ScrollBoundaryDeciderAdapter) {
            this.mBoundaryAdapter = (ScrollBoundaryDeciderAdapter)boundary;
        } else {
            this.mBoundaryAdapter.setScrollBoundaryDecider(boundary);
        }
    }

    @Override
    public void setEnableLoadMoreWhenContentNotFull(boolean enable) {
        this.mBoundaryAdapter.setEnableLoadMoreWhenContentNotFull(enable);
    }

    @Override
    public ValueAnimator.AnimatorUpdateListener scrollContentWhenFinished(final int spinner) {
        if (this.mScrollableView != null && spinner != 0 && (spinner < 0 && ScrollBoundaryUtil.canScrollDown(this.mScrollableView) || spinner > 0 && ScrollBoundaryUtil.canScrollUp(this.mScrollableView))) {
            return new ValueAnimator.AnimatorUpdateListener(){
                int lastValue;
                {
                    this.lastValue = spinner;
                }

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    try {
                        if (RefreshContentWrapper.this.mScrollableView instanceof AbsListView) {
                            RefreshContentWrapper.scrollListBy((AbsListView)RefreshContentWrapper.this.mScrollableView, value - this.lastValue);
                        } else {
                            RefreshContentWrapper.this.mScrollableView.scrollBy(0, value - this.lastValue);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.lastValue = value;
                }
            };
        }
        return null;
    }

    protected static int measureViewHeight(View view) {
        ViewGroup.LayoutParams p = view.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int childWidthSpec = ViewGroup.getChildMeasureSpec((int)0, (int)0, (int)p.width);
        int childHeightSpec = p.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)p.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        view.measure(childWidthSpec, childHeightSpec);
        return view.getMeasuredHeight();
    }

    protected static void scrollListBy(@NonNull AbsListView listView, int y) {
        if (Build.VERSION.SDK_INT >= 19) {
            listView.scrollListBy(y);
        } else if (listView instanceof ListView) {
            int firstPosition = listView.getFirstVisiblePosition();
            if (firstPosition == -1) {
                return;
            }
            View firstView = listView.getChildAt(0);
            if (firstView == null) {
                return;
            }
            int newTop = firstView.getTop() - y;
            ((ListView)listView).setSelectionFromTop(firstPosition, newTop);
        } else {
            listView.smoothScrollBy(y, 0);
        }
    }

    public static boolean isScrollableView(View view) {
        return view instanceof AbsListView || view instanceof ScrollView || view instanceof ScrollingView || view instanceof NestedScrollingChild || view instanceof NestedScrollingParent || view instanceof WebView || view instanceof ViewPager;
    }
}

