/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.header;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.ProgressDrawable;
import com.scwang.smartrefresh.layout.internal.pathview.PathsDrawable;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class ClassicsHeader
extends RelativeLayout
implements RefreshHeader {
    public static String REFRESH_HEADER_PULLDOWN = "\u4e0b\u62c9\u53ef\u4ee5\u5237\u65b0";
    public static String REFRESH_HEADER_REFRESHING = "\u6b63\u5728\u5237\u65b0...";
    public static String REFRESH_HEADER_LOADING = "\u6b63\u5728\u52a0\u8f7d...";
    public static String REFRESH_HEADER_RELEASE = "\u91ca\u653e\u7acb\u5373\u5237\u65b0";
    public static String REFRESH_HEADER_FINISH = "\u5237\u65b0\u5b8c\u6210";
    public static String REFRESH_HEADER_FAILED = "\u5237\u65b0\u5931\u8d25";
    public static String REFRESH_HEADER_LASTTIME = "\u4e0a\u6b21\u66f4\u65b0 M-d HH:mm";
    public static String REFRESH_HEADER_SECOND_FLOOR = "\u91ca\u653e\u8fdb\u5165\u4e8c\u697c";
    protected String KEY_LAST_UPDATE_TIME = "LAST_UPDATE_TIME";
    protected Date mLastTime;
    protected TextView mTitleText;
    protected TextView mLastUpdateText;
    protected ImageView mArrowView;
    protected ImageView mProgressView;
    protected SharedPreferences mShared;
    protected RefreshKernel mRefreshKernel;
    protected PathsDrawable mArrowDrawable;
    protected ProgressDrawable mProgressDrawable;
    protected SpinnerStyle mSpinnerStyle = SpinnerStyle.Translate;
    protected DateFormat mFormat = new SimpleDateFormat(REFRESH_HEADER_LASTTIME, Locale.getDefault());
    protected Integer mAccentColor;
    protected Integer mPrimaryColor;
    protected int mBackgroundColor;
    protected int mFinishDuration = 500;
    protected int mPaddingTop = 20;
    protected int mPaddingBottom = 20;
    protected boolean mEnableLastTime = true;

    public ClassicsHeader(Context context) {
        super(context);
        this.initView(context, null);
    }

    public ClassicsHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public ClassicsHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    @RequiresApi(value=21)
    public ClassicsHeader(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        DensityUtil density = new DensityUtil();
        LinearLayout layout = new LinearLayout(context);
        layout.setId(16908312);
        layout.setGravity(1);
        layout.setOrientation(1);
        this.mTitleText = new TextView(context);
        this.mTitleText.setText((CharSequence)REFRESH_HEADER_PULLDOWN);
        this.mTitleText.setTextColor(-10066330);
        this.mLastUpdateText = new TextView(context);
        this.mLastUpdateText.setTextColor(-8618884);
        LinearLayout.LayoutParams lpHeaderText = new LinearLayout.LayoutParams(-2, -2);
        layout.addView((View)this.mTitleText, (ViewGroup.LayoutParams)lpHeaderText);
        LinearLayout.LayoutParams lpUpdateText = new LinearLayout.LayoutParams(-2, -2);
        layout.addView((View)this.mLastUpdateText, (ViewGroup.LayoutParams)lpUpdateText);
        RelativeLayout.LayoutParams lpHeaderLayout = new RelativeLayout.LayoutParams(-2, -2);
        lpHeaderLayout.addRule(13);
        this.addView((View)layout, (ViewGroup.LayoutParams)lpHeaderLayout);
        RelativeLayout.LayoutParams lpArrow = new RelativeLayout.LayoutParams(density.dip2px(20.0f), density.dip2px(20.0f));
        lpArrow.addRule(15);
        lpArrow.addRule(0, 16908312);
        this.mArrowView = new ImageView(context);
        this.addView((View)this.mArrowView, (ViewGroup.LayoutParams)lpArrow);
        RelativeLayout.LayoutParams lpProgress = new RelativeLayout.LayoutParams((ViewGroup.LayoutParams)lpArrow);
        lpProgress.addRule(15);
        lpProgress.addRule(0, 16908312);
        this.mProgressView = new ImageView(context);
        this.mProgressView.animate().setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.addView((View)this.mProgressView, (ViewGroup.LayoutParams)lpProgress);
        if (this.isInEditMode()) {
            this.mArrowView.setVisibility(8);
            this.mTitleText.setText((CharSequence)REFRESH_HEADER_REFRESHING);
        } else {
            this.mProgressView.setVisibility(8);
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ClassicsHeader);
        lpUpdateText.topMargin = ta.getDimensionPixelSize(R.styleable.ClassicsHeader_srlTextTimeMarginTop, density.dip2px(0.0f));
        lpArrow.rightMargin = lpProgress.rightMargin = ta.getDimensionPixelSize(R.styleable.ClassicsFooter_srlDrawableMarginRight, density.dip2px(20.0f));
        lpArrow.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableArrowSize, lpArrow.width);
        lpArrow.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableArrowSize, lpArrow.height);
        lpProgress.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableProgressSize, lpProgress.width);
        lpProgress.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableProgressSize, lpProgress.height);
        lpArrow.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpArrow.width);
        lpArrow.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpArrow.height);
        lpProgress.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpProgress.width);
        lpProgress.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpProgress.height);
        this.mFinishDuration = ta.getInt(R.styleable.ClassicsHeader_srlFinishDuration, this.mFinishDuration);
        this.mEnableLastTime = ta.getBoolean(R.styleable.ClassicsHeader_srlEnableLastTime, this.mEnableLastTime);
        this.mSpinnerStyle = SpinnerStyle.values()[ta.getInt(R.styleable.ClassicsHeader_srlClassicsSpinnerStyle, this.mSpinnerStyle.ordinal())];
        this.mLastUpdateText.setVisibility(this.mEnableLastTime ? 0 : 8);
        if (ta.hasValue(R.styleable.ClassicsHeader_srlDrawableArrow)) {
            this.mArrowView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsHeader_srlDrawableArrow));
        } else {
            this.mArrowDrawable = new PathsDrawable();
            this.mArrowDrawable.parserColors(-10066330);
            this.mArrowDrawable.parserPaths("M20,12l-1.41,-1.41L13,16.17V4h-2v12.17l-5.58,-5.59L4,12l8,8 8,-8z");
            this.mArrowView.setImageDrawable((Drawable)this.mArrowDrawable);
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlDrawableProgress)) {
            this.mProgressView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsHeader_srlDrawableProgress));
        } else {
            this.mProgressDrawable = new ProgressDrawable();
            this.mProgressDrawable.setColor(-10066330);
            this.mProgressView.setImageDrawable((Drawable)this.mProgressDrawable);
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlTextSizeTitle)) {
            this.mTitleText.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.ClassicsHeader_srlTextSizeTitle, DensityUtil.dp2px(16.0f)));
        } else {
            this.mTitleText.setTextSize(16.0f);
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlTextSizeTime)) {
            this.mLastUpdateText.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.ClassicsHeader_srlTextSizeTime, DensityUtil.dp2px(12.0f)));
        } else {
            this.mLastUpdateText.setTextSize(12.0f);
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlPrimaryColor)) {
            this.setPrimaryColor(ta.getColor(R.styleable.ClassicsHeader_srlPrimaryColor, 0));
        }
        if (ta.hasValue(R.styleable.ClassicsHeader_srlAccentColor)) {
            this.setAccentColor(ta.getColor(R.styleable.ClassicsHeader_srlAccentColor, 0));
        }
        ta.recycle();
        if (this.getPaddingTop() == 0) {
            if (this.getPaddingBottom() == 0) {
                this.mPaddingTop = density.dip2px(20.0f);
                this.mPaddingBottom = density.dip2px(20.0f);
                this.setPadding(this.getPaddingLeft(), this.mPaddingTop, this.getPaddingRight(), this.mPaddingBottom);
            } else {
                this.mPaddingTop = density.dip2px(20.0f);
                this.mPaddingBottom = this.getPaddingBottom();
                this.setPadding(this.getPaddingLeft(), this.mPaddingTop, this.getPaddingRight(), this.mPaddingBottom);
            }
        } else if (this.getPaddingBottom() == 0) {
            this.mPaddingTop = this.getPaddingTop();
            this.mPaddingBottom = density.dip2px(20.0f);
            this.setPadding(this.getPaddingLeft(), this.mPaddingTop, this.getPaddingRight(), this.mPaddingBottom);
        } else {
            this.mPaddingTop = this.getPaddingTop();
            this.mPaddingBottom = this.getPaddingBottom();
        }
        try {
            List fragments;
            FragmentManager manager;
            if (context instanceof FragmentActivity && (manager = ((FragmentActivity)context).getSupportFragmentManager()) != null && (fragments = manager.getFragments()) != null && fragments.size() > 0) {
                this.setLastUpdateTime(new Date());
                return;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.KEY_LAST_UPDATE_TIME = this.KEY_LAST_UPDATE_TIME + context.getClass().getName();
        this.mShared = context.getSharedPreferences("ClassicsHeader", 0);
        this.setLastUpdateTime(new Date(this.mShared.getLong(this.KEY_LAST_UPDATE_TIME, System.currentTimeMillis())));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0x40000000) {
            this.setPadding(this.getPaddingLeft(), 0, this.getPaddingRight(), 0);
        } else {
            this.setPadding(this.getPaddingLeft(), this.mPaddingTop, this.getPaddingRight(), this.mPaddingBottom);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
        this.mRefreshKernel = kernel;
        this.mRefreshKernel.requestDrawBackgroundForHeader(this.mBackgroundColor);
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return false;
    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    @Override
    public void onPulling(float percent, int offset, int height, int extendHeight) {
    }

    @Override
    public void onReleasing(float percent, int offset, int height, int extendHeight) {
    }

    @Override
    public void onReleased(RefreshLayout layout, int height, int extendHeight) {
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.start();
        } else {
            Drawable drawable = this.mProgressView.getDrawable();
            if (drawable instanceof Animatable) {
                ((Animatable)drawable).start();
            } else {
                this.mProgressView.animate().rotation(36000.0f).setDuration(100000L);
            }
        }
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int extendHeight) {
    }

    @Override
    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.stop();
        } else {
            Drawable drawable = this.mProgressView.getDrawable();
            if (drawable instanceof Animatable) {
                ((Animatable)drawable).stop();
            } else {
                this.mProgressView.animate().rotation(0.0f).setDuration(300L);
            }
        }
        this.mProgressView.setVisibility(8);
        if (success) {
            this.mTitleText.setText((CharSequence)REFRESH_HEADER_FINISH);
            if (this.mLastTime != null) {
                this.setLastUpdateTime(new Date());
            }
        } else {
            this.mTitleText.setText((CharSequence)REFRESH_HEADER_FAILED);
        }
        return this.mFinishDuration;
    }

    @Override
    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0) {
            if (!(this.getBackground() instanceof BitmapDrawable) && this.mPrimaryColor == null) {
                this.setPrimaryColor(colors[0]);
                this.mPrimaryColor = null;
            }
            if (this.mAccentColor == null) {
                if (colors.length > 1) {
                    this.setAccentColor(colors[1]);
                } else {
                    this.setAccentColor(colors[0] == -1 ? -10066330 : -1);
                }
                this.mAccentColor = null;
            }
        }
    }

    @Override
    @NonNull
    public View getView() {
        return this;
    }

    @Override
    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        return this.mSpinnerStyle;
    }

    @Override
    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        switch (newState) {
            case None: {
                this.mLastUpdateText.setVisibility(this.mEnableLastTime ? 0 : 8);
            }
            case PullDownToRefresh: {
                this.mTitleText.setText((CharSequence)REFRESH_HEADER_PULLDOWN);
                this.mArrowView.setVisibility(0);
                this.mProgressView.setVisibility(8);
                this.mArrowView.animate().rotation(0.0f);
                break;
            }
            case Refreshing: 
            case RefreshReleased: {
                this.mTitleText.setText((CharSequence)REFRESH_HEADER_REFRESHING);
                this.mProgressView.setVisibility(0);
                this.mArrowView.setVisibility(8);
                break;
            }
            case ReleaseToRefresh: {
                this.mTitleText.setText((CharSequence)REFRESH_HEADER_RELEASE);
                this.mArrowView.animate().rotation(180.0f);
                break;
            }
            case ReleaseToTwoLevel: {
                this.mTitleText.setText((CharSequence)REFRESH_HEADER_SECOND_FLOOR);
                this.mArrowView.animate().rotation(0.0f);
                break;
            }
            case Loading: {
                this.mArrowView.setVisibility(8);
                this.mProgressView.setVisibility(8);
                this.mLastUpdateText.setVisibility(this.mEnableLastTime ? 4 : 8);
                this.mTitleText.setText((CharSequence)REFRESH_HEADER_LOADING);
            }
        }
    }

    public ClassicsHeader setProgressBitmap(Bitmap bitmap) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageBitmap(bitmap);
        return this;
    }

    public ClassicsHeader setProgressDrawable(Drawable drawable) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageDrawable(drawable);
        return this;
    }

    public ClassicsHeader setProgressResource(@DrawableRes int resId) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageResource(resId);
        return this;
    }

    public ClassicsHeader setArrowBitmap(Bitmap bitmap) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageBitmap(bitmap);
        return this;
    }

    public ClassicsHeader setArrowDrawable(Drawable drawable) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageDrawable(drawable);
        return this;
    }

    public ClassicsHeader setArrowResource(@DrawableRes int resId) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageResource(resId);
        return this;
    }

    public ClassicsHeader setLastUpdateTime(Date time) {
        this.mLastTime = time;
        this.mLastUpdateText.setText((CharSequence)this.mFormat.format(time));
        if (this.mShared != null && !this.isInEditMode()) {
            this.mShared.edit().putLong(this.KEY_LAST_UPDATE_TIME, time.getTime()).apply();
        }
        return this;
    }

    public ClassicsHeader setLastUpdateText(CharSequence text) {
        this.mLastTime = null;
        this.mLastUpdateText.setText(text);
        return this;
    }

    public ClassicsHeader setTimeFormat(DateFormat format) {
        this.mFormat = format;
        if (this.mLastTime != null) {
            this.mLastUpdateText.setText((CharSequence)this.mFormat.format(this.mLastTime));
        }
        return this;
    }

    public ClassicsHeader setSpinnerStyle(SpinnerStyle style) {
        this.mSpinnerStyle = style;
        return this;
    }

    public ClassicsHeader setPrimaryColor(@ColorInt int primaryColor) {
        this.mPrimaryColor = primaryColor;
        this.mBackgroundColor = this.mPrimaryColor;
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestDrawBackgroundForHeader(this.mPrimaryColor);
        }
        return this;
    }

    public ClassicsHeader setAccentColor(@ColorInt int accentColor) {
        this.mAccentColor = accentColor;
        if (this.mArrowDrawable != null) {
            this.mArrowDrawable.parserColors(accentColor);
        }
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setColor(accentColor);
        }
        this.mTitleText.setTextColor(accentColor);
        this.mLastUpdateText.setTextColor(accentColor & 0xFFFFFF | 0xCC000000);
        return this;
    }

    public ClassicsHeader setPrimaryColorId(@ColorRes int colorId) {
        this.setPrimaryColor(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
        return this;
    }

    public ClassicsHeader setAccentColorId(@ColorRes int colorId) {
        this.setAccentColor(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
        return this;
    }

    public ClassicsHeader setFinishDuration(int delay) {
        this.mFinishDuration = delay;
        return this;
    }

    public ClassicsHeader setEnableLastTime(boolean enable) {
        this.mEnableLastTime = enable;
        this.mLastUpdateText.setVisibility(enable ? 0 : 8);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightForHeader();
        }
        return this;
    }

    public ClassicsHeader setTextSizeTitle(float size) {
        this.mTitleText.setTextSize(size);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightForHeader();
        }
        return this;
    }

    public ClassicsHeader setTextSizeTitle(int unit, float size) {
        this.mTitleText.setTextSize(unit, size);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightForHeader();
        }
        return this;
    }

    public ClassicsHeader setTextSizeTime(float size) {
        this.mLastUpdateText.setTextSize(size);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightForHeader();
        }
        return this;
    }

    public ClassicsHeader setTextSizeTime(int unit, float size) {
        this.mLastUpdateText.setTextSize(unit, size);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightForHeader();
        }
        return this;
    }

    public ClassicsHeader setTextTimeMarginTop(float dp) {
        return this.setTextTimeMarginTopPx(DensityUtil.dp2px(dp));
    }

    public ClassicsHeader setTextTimeMarginTopPx(int px) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)this.mLastUpdateText.getLayoutParams();
        lp.topMargin = px;
        this.mLastUpdateText.setLayoutParams((ViewGroup.LayoutParams)lp);
        return this;
    }

    public ClassicsHeader setDrawableMarginRight(float dp) {
        return this.setDrawableMarginRightPx(DensityUtil.dp2px(dp));
    }

    public ClassicsHeader setDrawableMarginRightPx(int px) {
        ViewGroup.MarginLayoutParams lpArrow = (ViewGroup.MarginLayoutParams)this.mArrowView.getLayoutParams();
        ViewGroup.MarginLayoutParams lpProgress = (ViewGroup.MarginLayoutParams)this.mProgressView.getLayoutParams();
        lpArrow.rightMargin = lpProgress.rightMargin = px;
        this.mArrowView.setLayoutParams((ViewGroup.LayoutParams)lpArrow);
        this.mProgressView.setLayoutParams((ViewGroup.LayoutParams)lpProgress);
        return this;
    }

    public ClassicsHeader setDrawableSize(float dp) {
        return this.setDrawableSizePx(DensityUtil.dp2px(dp));
    }

    public ClassicsHeader setDrawableSizePx(int px) {
        ViewGroup.LayoutParams lpArrow = this.mArrowView.getLayoutParams();
        ViewGroup.LayoutParams lpProgress = this.mProgressView.getLayoutParams();
        lpArrow.width = lpProgress.width = px;
        lpArrow.height = lpProgress.height = px;
        this.mArrowView.setLayoutParams(lpArrow);
        this.mProgressView.setLayoutParams(lpProgress);
        return this;
    }

    public ClassicsHeader setDrawableArrowSize(float dp) {
        return this.setDrawableArrowSizePx(DensityUtil.dp2px(dp));
    }

    public ClassicsHeader setDrawableArrowSizePx(int px) {
        ViewGroup.LayoutParams lpArrow = this.mArrowView.getLayoutParams();
        lpArrow.width = px;
        lpArrow.height = px;
        this.mArrowView.setLayoutParams(lpArrow);
        return this;
    }

    public ClassicsHeader setDrawableProgressSize(float dp) {
        return this.setDrawableProgressSizePx(DensityUtil.dp2px(dp));
    }

    public ClassicsHeader setDrawableProgressSizePx(int px) {
        ViewGroup.LayoutParams lpProgress = this.mProgressView.getLayoutParams();
        lpProgress.width = px;
        lpProgress.height = px;
        this.mProgressView.setLayoutParams(lpProgress);
        return this;
    }

    public ImageView getArrowView() {
        return this.mArrowView;
    }

    public ImageView getProgressView() {
        return this.mProgressView;
    }

    public TextView getTitleText() {
        return this.mTitleText;
    }

    public TextView getLastUpdateText() {
        return this.mLastUpdateText;
    }
}

