/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.footer;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.ProgressDrawable;
import com.scwang.smartrefresh.layout.internal.pathview.PathsDrawable;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class ClassicsFooter
extends RelativeLayout
implements RefreshFooter {
    public static String REFRESH_FOOTER_PULLUP = "\u4e0a\u62c9\u52a0\u8f7d\u66f4\u591a";
    public static String REFRESH_FOOTER_RELEASE = "\u91ca\u653e\u7acb\u5373\u52a0\u8f7d";
    public static String REFRESH_FOOTER_LOADING = "\u6b63\u5728\u52a0\u8f7d...";
    public static String REFRESH_FOOTER_REFRESHING = "\u6b63\u5728\u5237\u65b0...";
    public static String REFRESH_FOOTER_FINISH = "\u52a0\u8f7d\u5b8c\u6210";
    public static String REFRESH_FOOTER_FAILED = "\u52a0\u8f7d\u5931\u8d25";
    public static String REFRESH_FOOTER_ALLLOADED = "\u6ca1\u6709\u66f4\u591a\u6570\u636e\u4e86";
    protected TextView mTitleText;
    protected ImageView mArrowView;
    protected ImageView mProgressView;
    protected PathsDrawable mArrowDrawable;
    protected ProgressDrawable mProgressDrawable;
    protected SpinnerStyle mSpinnerStyle = SpinnerStyle.Translate;
    protected RefreshKernel mRefreshKernel;
    protected Integer mAccentColor;
    protected Integer mPrimaryColor;
    protected int mBackgroundColor;
    protected int mFinishDuration = 500;
    protected int mPaddingTop = 20;
    protected int mPaddingBottom = 20;
    protected boolean mNoMoreData = false;

    public ClassicsFooter(Context context) {
        super(context);
        this.initView(context, null, 0);
    }

    public ClassicsFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs, 0);
    }

    public ClassicsFooter(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs, defStyleAttr);
    }

    private void initView(Context context, AttributeSet attrs, int defStyleAttr) {
        DensityUtil density = new DensityUtil();
        this.mTitleText = new TextView(context);
        this.mTitleText.setId(16908312);
        this.mTitleText.setTextColor(-10066330);
        this.mTitleText.setText((CharSequence)REFRESH_FOOTER_PULLUP);
        RelativeLayout.LayoutParams lpBottomText = new RelativeLayout.LayoutParams(-2, -2);
        lpBottomText.addRule(13);
        this.addView((View)this.mTitleText, (ViewGroup.LayoutParams)lpBottomText);
        RelativeLayout.LayoutParams lpArrow = new RelativeLayout.LayoutParams(density.dip2px(20.0f), density.dip2px(20.0f));
        lpArrow.addRule(15);
        lpArrow.addRule(0, 16908312);
        this.mArrowView = new ImageView(context);
        this.addView((View)this.mArrowView, (ViewGroup.LayoutParams)lpArrow);
        RelativeLayout.LayoutParams lpProgress = new RelativeLayout.LayoutParams((ViewGroup.LayoutParams)lpArrow);
        lpProgress.addRule(15);
        lpProgress.addRule(0, 16908312);
        this.mProgressView = new ImageView(context);
        this.mProgressView.animate().setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.addView((View)this.mProgressView, (ViewGroup.LayoutParams)lpProgress);
        if (!this.isInEditMode()) {
            this.mProgressView.setVisibility(8);
        } else {
            this.mArrowView.setVisibility(8);
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.ClassicsFooter);
        lpArrow.rightMargin = lpProgress.rightMargin = ta.getDimensionPixelSize(R.styleable.ClassicsFooter_srlDrawableMarginRight, density.dip2px(20.0f));
        lpArrow.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableArrowSize, lpArrow.width);
        lpArrow.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableArrowSize, lpArrow.height);
        lpProgress.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableProgressSize, lpProgress.width);
        lpProgress.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableProgressSize, lpProgress.height);
        lpArrow.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpArrow.width);
        lpArrow.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpArrow.height);
        lpProgress.width = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpProgress.width);
        lpProgress.height = ta.getLayoutDimension(R.styleable.ClassicsHeader_srlDrawableSize, lpProgress.height);
        this.mFinishDuration = ta.getInt(R.styleable.ClassicsFooter_srlFinishDuration, this.mFinishDuration);
        this.mSpinnerStyle = SpinnerStyle.values()[ta.getInt(R.styleable.ClassicsFooter_srlClassicsSpinnerStyle, this.mSpinnerStyle.ordinal())];
        if (ta.hasValue(R.styleable.ClassicsFooter_srlDrawableArrow)) {
            this.mArrowView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsFooter_srlDrawableArrow));
        } else {
            this.mArrowDrawable = new PathsDrawable();
            this.mArrowDrawable.parserColors(-10066330);
            this.mArrowDrawable.parserPaths("M20,12l-1.41,-1.41L13,16.17V4h-2v12.17l-5.58,-5.59L4,12l8,8 8,-8z");
            this.mArrowView.setImageDrawable((Drawable)this.mArrowDrawable);
        }
        if (ta.hasValue(R.styleable.ClassicsFooter_srlDrawableProgress)) {
            this.mProgressView.setImageDrawable(ta.getDrawable(R.styleable.ClassicsFooter_srlDrawableProgress));
        } else {
            this.mProgressDrawable = new ProgressDrawable();
            this.mProgressDrawable.setColor(-10066330);
            this.mProgressView.setImageDrawable((Drawable)this.mProgressDrawable);
        }
        if (ta.hasValue(R.styleable.ClassicsFooter_srlTextSizeTitle)) {
            this.mTitleText.setTextSize(0, (float)ta.getDimensionPixelSize(R.styleable.ClassicsFooter_srlTextSizeTitle, DensityUtil.dp2px(16.0f)));
        } else {
            this.mTitleText.setTextSize(16.0f);
        }
        if (ta.hasValue(R.styleable.ClassicsFooter_srlPrimaryColor)) {
            this.setPrimaryColor(ta.getColor(R.styleable.ClassicsFooter_srlPrimaryColor, 0));
        }
        if (ta.hasValue(R.styleable.ClassicsFooter_srlAccentColor)) {
            this.setAccentColor(ta.getColor(R.styleable.ClassicsFooter_srlAccentColor, 0));
        }
        ta.recycle();
        if (this.getPaddingTop() == 0) {
            if (this.getPaddingBottom() == 0) {
                this.mPaddingTop = density.dip2px(20.0f);
                this.mPaddingBottom = density.dip2px(20.0f);
                this.setPadding(this.getPaddingLeft(), this.mPaddingTop, this.getPaddingRight(), this.mPaddingBottom);
            } else {
                this.mPaddingTop = density.dip2px(20.0f);
                this.mPaddingBottom = this.getPaddingBottom();
                this.setPadding(this.getPaddingLeft(), this.mPaddingTop, this.getPaddingRight(), this.mPaddingBottom);
            }
        } else if (this.getPaddingBottom() == 0) {
            this.mPaddingTop = this.getPaddingTop();
            this.mPaddingBottom = density.dip2px(20.0f);
            this.setPadding(this.getPaddingLeft(), this.mPaddingTop, this.getPaddingRight(), this.mPaddingBottom);
        } else {
            this.mPaddingTop = this.getPaddingTop();
            this.mPaddingBottom = this.getPaddingBottom();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0x40000000) {
            this.setPadding(this.getPaddingLeft(), 0, this.getPaddingRight(), 0);
        } else {
            this.setPadding(this.getPaddingLeft(), this.mPaddingTop, this.getPaddingRight(), this.mPaddingBottom);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
        this.mRefreshKernel = kernel;
        this.mRefreshKernel.requestDrawBackgroundForFooter(this.mBackgroundColor);
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return false;
    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    @Override
    public void onPulling(float percent, int offset, int footerHeight, int extendHeight) {
    }

    @Override
    public void onReleasing(float percent, int offset, int height, int extendHeight) {
    }

    @Override
    public void onReleased(RefreshLayout layout, int footerHeight, int extendHeight) {
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int extendHeight) {
        if (!this.mNoMoreData) {
            this.mProgressView.setVisibility(0);
            if (this.mProgressDrawable != null) {
                this.mProgressDrawable.start();
            } else {
                Drawable drawable = this.mProgressView.getDrawable();
                if (drawable instanceof Animatable) {
                    ((Animatable)drawable).start();
                } else {
                    this.mProgressView.animate().rotation(36000.0f).setDuration(100000L);
                }
            }
        }
    }

    @Override
    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        if (!this.mNoMoreData) {
            if (this.mProgressDrawable != null) {
                this.mProgressDrawable.stop();
            } else {
                this.mProgressView.animate().rotation(0.0f).setDuration(300L);
            }
            this.mProgressView.setVisibility(8);
            if (success) {
                this.mTitleText.setText((CharSequence)REFRESH_FOOTER_FINISH);
            } else {
                this.mTitleText.setText((CharSequence)REFRESH_FOOTER_FAILED);
            }
            return this.mFinishDuration;
        }
        return 0;
    }

    @Override
    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (this.mSpinnerStyle == SpinnerStyle.FixedBehind && colors.length > 0) {
            if (!(this.getBackground() instanceof BitmapDrawable)) {
                this.setPrimaryColor(colors[0]);
            }
            if (colors.length > 1) {
                this.setAccentColor(colors[1]);
            } else {
                this.setAccentColor(colors[0] == -1 ? -10066330 : -1);
            }
        }
    }

    @Override
    public boolean setNoMoreData(boolean noMoreData) {
        if (this.mNoMoreData != noMoreData) {
            this.mNoMoreData = noMoreData;
            if (noMoreData) {
                this.mTitleText.setText((CharSequence)REFRESH_FOOTER_ALLLOADED);
                this.mArrowView.setVisibility(8);
            } else {
                this.mTitleText.setText((CharSequence)REFRESH_FOOTER_PULLUP);
                this.mArrowView.setVisibility(0);
            }
            if (this.mProgressDrawable != null) {
                this.mProgressDrawable.stop();
            } else {
                this.mProgressView.animate().rotation(0.0f).setDuration(300L);
            }
            this.mProgressView.setVisibility(8);
        }
        return true;
    }

    @Override
    @NonNull
    public View getView() {
        return this;
    }

    @Override
    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        return this.mSpinnerStyle;
    }

    @Override
    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        if (!this.mNoMoreData) {
            switch (newState) {
                case None: {
                    this.mArrowView.setVisibility(0);
                }
                case PullUpToLoad: {
                    this.mTitleText.setText((CharSequence)REFRESH_FOOTER_PULLUP);
                    this.mArrowView.animate().rotation(180.0f);
                    break;
                }
                case Loading: 
                case LoadReleased: {
                    this.mArrowView.setVisibility(8);
                    this.mTitleText.setText((CharSequence)REFRESH_FOOTER_LOADING);
                    break;
                }
                case ReleaseToLoad: {
                    this.mTitleText.setText((CharSequence)REFRESH_FOOTER_RELEASE);
                    this.mArrowView.animate().rotation(0.0f);
                    break;
                }
                case Refreshing: {
                    this.mTitleText.setText((CharSequence)REFRESH_FOOTER_REFRESHING);
                    this.mProgressView.setVisibility(8);
                    this.mArrowView.setVisibility(8);
                }
            }
        }
    }

    public ClassicsFooter setProgressBitmap(Bitmap bitmap) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageBitmap(bitmap);
        return this;
    }

    public ClassicsFooter setProgressDrawable(Drawable drawable) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageDrawable(drawable);
        return this;
    }

    public ClassicsFooter setProgressResource(@DrawableRes int resId) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageResource(resId);
        return this;
    }

    public ClassicsFooter setArrowBitmap(Bitmap bitmap) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageBitmap(bitmap);
        return this;
    }

    public ClassicsFooter setArrowDrawable(Drawable drawable) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageDrawable(drawable);
        return this;
    }

    public ClassicsFooter setArrowResource(@DrawableRes int resId) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageResource(resId);
        return this;
    }

    public ClassicsFooter setSpinnerStyle(SpinnerStyle style) {
        this.mSpinnerStyle = style;
        return this;
    }

    public ClassicsFooter setAccentColor(@ColorInt int accentColor) {
        this.mAccentColor = accentColor;
        this.mTitleText.setTextColor(accentColor);
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setColor(accentColor);
        }
        if (this.mArrowDrawable != null) {
            this.mArrowDrawable.parserColors(accentColor);
        }
        return this;
    }

    public ClassicsFooter setPrimaryColor(@ColorInt int primaryColor) {
        this.mPrimaryColor = primaryColor;
        this.mBackgroundColor = this.mPrimaryColor;
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestDrawBackgroundForFooter(this.mPrimaryColor);
        }
        return this;
    }

    public ClassicsFooter setPrimaryColorId(@ColorRes int colorId) {
        this.setPrimaryColor(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
        return this;
    }

    public ClassicsFooter setAccentColorId(@ColorRes int colorId) {
        this.setAccentColor(ContextCompat.getColor((Context)this.getContext(), (int)colorId));
        return this;
    }

    public ClassicsFooter setFinishDuration(int delay) {
        this.mFinishDuration = delay;
        return this;
    }

    public ClassicsFooter setTextSizeTitle(float size) {
        this.mTitleText.setTextSize(size);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightForFooter();
        }
        return this;
    }

    public ClassicsFooter setTextSizeTitle(int unit, float size) {
        this.mTitleText.setTextSize(unit, size);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightForFooter();
        }
        return this;
    }

    public ClassicsFooter setDrawableMarginRight(float dp) {
        return this.setDrawableMarginRightPx(DensityUtil.dp2px(dp));
    }

    public ClassicsFooter setDrawableMarginRightPx(int px) {
        ViewGroup.MarginLayoutParams lpArrow = (ViewGroup.MarginLayoutParams)this.mArrowView.getLayoutParams();
        ViewGroup.MarginLayoutParams lpProgress = (ViewGroup.MarginLayoutParams)this.mProgressView.getLayoutParams();
        lpArrow.rightMargin = lpProgress.rightMargin = px;
        this.mArrowView.setLayoutParams((ViewGroup.LayoutParams)lpArrow);
        this.mProgressView.setLayoutParams((ViewGroup.LayoutParams)lpProgress);
        return this;
    }

    public ClassicsFooter setDrawableSize(float dp) {
        return this.setDrawableSizePx(DensityUtil.dp2px(dp));
    }

    public ClassicsFooter setDrawableSizePx(int px) {
        ViewGroup.LayoutParams lpArrow = this.mArrowView.getLayoutParams();
        ViewGroup.LayoutParams lpProgress = this.mProgressView.getLayoutParams();
        lpArrow.width = lpProgress.width = px;
        lpArrow.height = lpProgress.height = px;
        this.mArrowView.setLayoutParams(lpArrow);
        this.mProgressView.setLayoutParams(lpProgress);
        return this;
    }

    public ClassicsFooter setDrawableArrowSize(float dp) {
        return this.setDrawableArrowSizePx(DensityUtil.dp2px(dp));
    }

    public ClassicsFooter setDrawableArrowSizePx(int px) {
        ViewGroup.LayoutParams lpArrow = this.mArrowView.getLayoutParams();
        lpArrow.width = px;
        lpArrow.height = px;
        this.mArrowView.setLayoutParams(lpArrow);
        return this;
    }

    public ClassicsFooter setDrawableProgressSize(float dp) {
        return this.setDrawableProgressSizePx(DensityUtil.dp2px(dp));
    }

    public ClassicsFooter setDrawableProgressSizePx(int px) {
        ViewGroup.LayoutParams lpProgress = this.mProgressView.getLayoutParams();
        lpProgress.width = px;
        lpProgress.height = px;
        this.mProgressView.setLayoutParams(lpProgress);
        return this;
    }

    public TextView getTitleText() {
        return this.mTitleText;
    }

    public ImageView getProgressView() {
        return this.mProgressView;
    }

    public ImageView getArrowView() {
        return this.mArrowView;
    }
}

