/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout.constant;

public enum RefreshState {
    None(0, false),
    PullDownToRefresh(1, true),
    PullUpToLoad(2, true),
    PullDownCanceled(1, false),
    PullUpCanceled(2, false),
    ReleaseToRefresh(1, true),
    ReleaseToLoad(2, true),
    ReleaseToTwoLevel(1, true),
    TwoLevelReleased(1, false),
    RefreshReleased(1, false),
    LoadReleased(2, false),
    Refreshing(1, false, true),
    Loading(2, false, true),
    TwoLevel(1, false, true),
    RefreshFinish(1, false, false, true),
    LoadFinish(2, false, false, true),
    TwoLevelFinish(1, false, false, true);

    private final int role;
    public final boolean dragging;
    public final boolean opening;
    public final boolean finishing;

    private RefreshState(int role, boolean dragging) {
        this.role = role;
        this.dragging = dragging;
        this.opening = false;
        this.finishing = false;
    }

    private RefreshState(int role, boolean dragging, boolean opening) {
        this.role = role;
        this.dragging = dragging;
        this.opening = opening;
        this.finishing = false;
    }

    private RefreshState(int role, boolean dragging, boolean opening, boolean finishing) {
        this.role = role;
        this.dragging = dragging;
        this.opening = opening;
        this.finishing = finishing;
    }

    public boolean isHeader() {
        return this.role == 1;
    }

    public boolean isFooter() {
        return this.role == 2;
    }
}

