/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.layout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.Scroller;
import android.widget.TextView;
import com.scwang.smartrefresh.layout.R;
import com.scwang.smartrefresh.layout.api.DefaultRefreshFooterCreater;
import com.scwang.smartrefresh.layout.api.DefaultRefreshFooterCreator;
import com.scwang.smartrefresh.layout.api.DefaultRefreshHeaderCreater;
import com.scwang.smartrefresh.layout.api.DefaultRefreshHeaderCreator;
import com.scwang.smartrefresh.layout.api.OnLoadmoreListener;
import com.scwang.smartrefresh.layout.api.OnRefreshLoadmoreListener;
import com.scwang.smartrefresh.layout.api.RefreshContent;
import com.scwang.smartrefresh.layout.api.RefreshFooter;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshInternal;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.api.ScrollBoundaryDecider;
import com.scwang.smartrefresh.layout.constant.DimensionStatus;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.footer.BallPulseFooter;
import com.scwang.smartrefresh.layout.header.BezierRadarHeader;
import com.scwang.smartrefresh.layout.impl.RefreshContentWrapper;
import com.scwang.smartrefresh.layout.impl.RefreshFooterWrapper;
import com.scwang.smartrefresh.layout.impl.RefreshHeaderWrapper;
import com.scwang.smartrefresh.layout.listener.OnLoadMoreListener;
import com.scwang.smartrefresh.layout.listener.OnMultiPurposeListener;
import com.scwang.smartrefresh.layout.listener.OnRefreshListener;
import com.scwang.smartrefresh.layout.listener.OnRefreshLoadMoreListener;
import com.scwang.smartrefresh.layout.util.DelayedRunnable;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import com.scwang.smartrefresh.layout.util.ViscousFluidInterpolator;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"RestrictedApi"})
public class SmartRefreshLayout
extends ViewGroup
implements RefreshLayout,
NestedScrollingParent,
NestedScrollingChild {
    protected int mTouchSlop;
    protected int mSpinner;
    protected int mLastSpinner;
    protected int mTouchSpinner;
    protected int mFloorDuration = 250;
    protected int mReboundDuration = 250;
    protected int mScreenHeightPixels;
    protected float mTouchX;
    protected float mTouchY;
    protected float mLastTouchX;
    protected float mLastTouchY;
    protected float mDragRate = 0.5f;
    protected char mDragDirection = (char)110;
    protected boolean mIsBeingDragged;
    protected boolean mSuperDispatchTouchEvent;
    protected int mFixedHeaderViewId;
    protected int mFixedFooterViewId;
    protected int mMinimumVelocity;
    protected int mMaximumVelocity;
    protected Scroller mScroller;
    protected VelocityTracker mVelocityTracker;
    protected Interpolator mReboundInterpolator;
    protected int[] mPrimaryColors;
    protected boolean mEnableRefresh = true;
    protected boolean mEnableLoadMore = false;
    protected boolean mEnableClipHeaderWhenFixedBehind = true;
    protected boolean mEnableClipFooterWhenFixedBehind = true;
    protected boolean mEnableHeaderTranslationContent = true;
    protected boolean mEnableFooterTranslationContent = true;
    protected boolean mEnableFooterFollowWhenLoadFinished = false;
    protected boolean mEnablePreviewInEditMode = true;
    protected boolean mEnableOverScrollBounce = true;
    protected boolean mEnableOverScrollDrag = true;
    protected boolean mEnableAutoLoadMore = true;
    protected boolean mEnablePureScrollMode = false;
    protected boolean mEnableScrollContentWhenLoaded = true;
    protected boolean mEnableScrollContentWhenRefreshed = true;
    protected boolean mEnableLoadMoreWhenContentNotFull = true;
    protected boolean mDisableContentWhenRefresh = false;
    protected boolean mDisableContentWhenLoading = false;
    protected boolean mFooterNoMoreData = false;
    protected boolean mManualLoadMore = false;
    protected boolean mManualNestedScrolling = false;
    protected boolean mManualHeaderTranslationContent = false;
    protected OnRefreshListener mRefreshListener;
    protected OnLoadMoreListener mLoadMoreListener;
    protected OnMultiPurposeListener mOnMultiPurposeListener;
    protected ScrollBoundaryDecider mScrollBoundaryDecider;
    protected int[] mParentOffsetInWindow = new int[2];
    protected int mTotalUnconsumed;
    protected boolean mNestedScrollInProgress;
    protected NestedScrollingChildHelper mNestedScrollingChildHelper;
    protected NestedScrollingParentHelper mNestedScrollingParentHelper;
    protected int mHeaderHeight;
    protected DimensionStatus mHeaderHeightStatus = DimensionStatus.DefaultUnNotify;
    protected int mFooterHeight;
    protected DimensionStatus mFooterHeightStatus = DimensionStatus.DefaultUnNotify;
    protected int mHeaderInsetStart;
    protected int mFooterInsetStart;
    protected int mHeaderExtendHeight;
    protected int mFooterExtendHeight;
    protected float mHeaderMaxDragRate = 2.5f;
    protected float mFooterMaxDragRate = 2.5f;
    protected float mHeaderTriggerRate = 1.0f;
    protected float mFooterTriggerRate = 1.0f;
    protected RefreshHeader mRefreshHeader;
    protected RefreshFooter mRefreshFooter;
    protected RefreshContent mRefreshContent;
    protected Paint mPaint;
    protected Handler mHandler;
    protected RefreshKernel mKernel;
    protected List<DelayedRunnable> mDelayedRunnables;
    protected RefreshState mState = RefreshState.None;
    protected RefreshState mViceState = RefreshState.None;
    protected boolean mVerticalPermit = false;
    protected long mLastLoadingTime = 0L;
    protected long mLastRefreshingTime = 0L;
    protected int mHeaderBackgroundColor = 0;
    protected int mFooterBackgroundColor = 0;
    protected boolean mHeaderNeedTouchEventWhenRefreshing;
    protected boolean mFooterNeedTouchEventWhenLoading;
    protected boolean mFooterLocked = false;
    protected static boolean sManualFooterCreator = false;
    protected static DefaultRefreshFooterCreator sFooterCreator = new DefaultRefreshFooterCreator(){

        @Override
        @NonNull
        public RefreshFooter createRefreshFooter(@NonNull Context context, @NonNull RefreshLayout layout) {
            return new BallPulseFooter(context);
        }
    };
    protected static DefaultRefreshHeaderCreator sHeaderCreator = new DefaultRefreshHeaderCreator(){

        @Override
        @NonNull
        public RefreshHeader createRefreshHeader(@NonNull Context context, @NonNull RefreshLayout layout) {
            return new BezierRadarHeader(context);
        }
    };
    MotionEvent mFalsifyEvent = null;
    protected Runnable animationRunnable;
    protected ValueAnimator reboundAnimator;

    public SmartRefreshLayout(Context context) {
        super(context);
        this.initView(context, null);
    }

    public SmartRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public SmartRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    @RequiresApi(value=21)
    public SmartRefreshLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        this.setClipToPadding(false);
        DensityUtil density = new DensityUtil();
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mScroller = new Scroller(context);
        this.mKernel = new RefreshKernelImpl();
        this.mVelocityTracker = VelocityTracker.obtain();
        this.mScreenHeightPixels = context.getResources().getDisplayMetrics().heightPixels;
        this.mReboundInterpolator = new ViscousFluidInterpolator();
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mNestedScrollingChildHelper = new NestedScrollingChildHelper((View)this);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SmartRefreshLayout);
        ViewCompat.setNestedScrollingEnabled((View)this, (boolean)ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableNestedScrolling, false));
        this.mDragRate = ta.getFloat(R.styleable.SmartRefreshLayout_srlDragRate, this.mDragRate);
        this.mHeaderMaxDragRate = ta.getFloat(R.styleable.SmartRefreshLayout_srlHeaderMaxDragRate, this.mHeaderMaxDragRate);
        this.mFooterMaxDragRate = ta.getFloat(R.styleable.SmartRefreshLayout_srlFooterMaxDragRate, this.mFooterMaxDragRate);
        this.mHeaderTriggerRate = ta.getFloat(R.styleable.SmartRefreshLayout_srlHeaderTriggerRate, this.mHeaderTriggerRate);
        this.mFooterTriggerRate = ta.getFloat(R.styleable.SmartRefreshLayout_srlFooterTriggerRate, this.mFooterTriggerRate);
        this.mEnableRefresh = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableRefresh, this.mEnableRefresh);
        this.mReboundDuration = ta.getInt(R.styleable.SmartRefreshLayout_srlReboundDuration, this.mReboundDuration);
        this.mEnableLoadMore = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableLoadMore, this.mEnableLoadMore);
        this.mHeaderHeight = ta.getDimensionPixelOffset(R.styleable.SmartRefreshLayout_srlHeaderHeight, density.dip2px(100.0f));
        this.mFooterHeight = ta.getDimensionPixelOffset(R.styleable.SmartRefreshLayout_srlFooterHeight, density.dip2px(60.0f));
        this.mHeaderInsetStart = ta.getDimensionPixelOffset(R.styleable.SmartRefreshLayout_srlHeaderInsetStart, 0);
        this.mFooterInsetStart = ta.getDimensionPixelOffset(R.styleable.SmartRefreshLayout_srlFooterInsetStart, 0);
        this.mDisableContentWhenRefresh = ta.getBoolean(R.styleable.SmartRefreshLayout_srlDisableContentWhenRefresh, this.mDisableContentWhenRefresh);
        this.mDisableContentWhenLoading = ta.getBoolean(R.styleable.SmartRefreshLayout_srlDisableContentWhenLoading, this.mDisableContentWhenLoading);
        this.mEnableHeaderTranslationContent = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableHeaderTranslationContent, this.mEnableHeaderTranslationContent);
        this.mEnableFooterTranslationContent = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableFooterTranslationContent, this.mEnableFooterTranslationContent);
        this.mEnablePreviewInEditMode = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnablePreviewInEditMode, this.mEnablePreviewInEditMode);
        this.mEnableAutoLoadMore = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableAutoLoadMore, this.mEnableAutoLoadMore);
        this.mEnableOverScrollBounce = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableOverScrollBounce, this.mEnableOverScrollBounce);
        this.mEnablePureScrollMode = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnablePureScrollMode, this.mEnablePureScrollMode);
        this.mEnableScrollContentWhenLoaded = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableScrollContentWhenLoaded, this.mEnableScrollContentWhenLoaded);
        this.mEnableScrollContentWhenRefreshed = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableScrollContentWhenRefreshed, this.mEnableScrollContentWhenRefreshed);
        this.mEnableLoadMoreWhenContentNotFull = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableLoadMoreWhenContentNotFull, this.mEnableLoadMoreWhenContentNotFull);
        this.mEnableFooterFollowWhenLoadFinished = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableFooterFollowWhenLoadFinished, this.mEnableFooterFollowWhenLoadFinished);
        this.mEnableClipHeaderWhenFixedBehind = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableClipHeaderWhenFixedBehind, this.mEnableClipHeaderWhenFixedBehind);
        this.mEnableClipFooterWhenFixedBehind = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableClipFooterWhenFixedBehind, this.mEnableClipFooterWhenFixedBehind);
        this.mEnableOverScrollDrag = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableOverScrollDrag, this.mEnableOverScrollDrag);
        this.mFixedHeaderViewId = ta.getResourceId(R.styleable.SmartRefreshLayout_srlFixedHeaderViewId, -1);
        this.mFixedFooterViewId = ta.getResourceId(R.styleable.SmartRefreshLayout_srlFixedFooterViewId, -1);
        this.mManualLoadMore = ta.hasValue(R.styleable.SmartRefreshLayout_srlEnableLoadMore);
        this.mManualNestedScrolling = ta.hasValue(R.styleable.SmartRefreshLayout_srlEnableNestedScrolling);
        this.mManualHeaderTranslationContent = ta.hasValue(R.styleable.SmartRefreshLayout_srlEnableHeaderTranslationContent);
        this.mHeaderHeightStatus = ta.hasValue(R.styleable.SmartRefreshLayout_srlHeaderHeight) ? DimensionStatus.XmlLayoutUnNotify : this.mHeaderHeightStatus;
        this.mFooterHeightStatus = ta.hasValue(R.styleable.SmartRefreshLayout_srlFooterHeight) ? DimensionStatus.XmlLayoutUnNotify : this.mFooterHeightStatus;
        this.mHeaderExtendHeight = (int)Math.max((float)this.mHeaderHeight * (this.mHeaderMaxDragRate - 1.0f), 0.0f);
        this.mFooterExtendHeight = (int)Math.max((float)this.mFooterHeight * (this.mFooterMaxDragRate - 1.0f), 0.0f);
        int accentColor = ta.getColor(R.styleable.SmartRefreshLayout_srlAccentColor, 0);
        int primaryColor = ta.getColor(R.styleable.SmartRefreshLayout_srlPrimaryColor, 0);
        if (primaryColor != 0) {
            this.mPrimaryColors = accentColor != 0 ? new int[]{primaryColor, accentColor} : new int[]{primaryColor};
        } else if (accentColor != 0) {
            this.mPrimaryColors = new int[]{0, accentColor};
        }
        ta.recycle();
    }

    protected void onFinishInflate() {
        int[] indexArray;
        super.onFinishInflate();
        int count = this.getChildCount();
        if (count > 3) {
            throw new RuntimeException("\u6700\u591a\u53ea\u652f\u63013\u4e2a\u5b50View\uff0cMost only support three sub view");
        }
        int indexContent = -1;
        for (int index : indexArray = new int[]{1, 0, 2}) {
            if (index >= count) continue;
            View view = this.getChildAt(index);
            if (!(view instanceof RefreshInternal)) {
                indexContent = index;
            }
            if (!RefreshContentWrapper.isScrollableView(view)) continue;
            indexContent = index;
            break;
        }
        int indexHeader = -1;
        int indexFooter = -1;
        if (indexContent >= 0) {
            this.mRefreshContent = new RefreshContentWrapper(this.getChildAt(indexContent));
            if (indexContent == 1) {
                indexHeader = 0;
                if (count == 3) {
                    indexFooter = 2;
                }
            } else if (count == 2) {
                indexFooter = 1;
            }
        }
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            if (i == indexHeader || i != indexFooter && indexHeader == -1 && this.mRefreshHeader == null && view instanceof RefreshHeader) {
                this.mRefreshHeader = view instanceof RefreshHeader ? (RefreshHeader)view : new RefreshHeaderWrapper(view);
                continue;
            }
            if (i != indexFooter && (indexFooter != -1 || !(view instanceof RefreshFooter))) continue;
            this.mEnableLoadMore = this.mEnableLoadMore || !this.mManualLoadMore;
            this.mRefreshFooter = view instanceof RefreshFooter ? (RefreshFooter)view : new RefreshFooterWrapper(view);
        }
        if (this.isInEditMode()) {
            if (this.mPrimaryColors != null) {
                if (this.mRefreshHeader != null) {
                    this.mRefreshHeader.setPrimaryColors(this.mPrimaryColors);
                }
                if (this.mRefreshFooter != null) {
                    this.mRefreshFooter.setPrimaryColors(this.mPrimaryColors);
                }
            }
            if (this.mRefreshContent != null) {
                this.bringChildToFront(this.mRefreshContent.getView());
            }
            if (this.mRefreshHeader != null && this.mRefreshHeader.getSpinnerStyle() != SpinnerStyle.FixedBehind) {
                this.bringChildToFront(this.mRefreshHeader.getView());
            }
            if (this.mRefreshFooter != null && this.mRefreshFooter.getSpinnerStyle() != SpinnerStyle.FixedBehind) {
                this.bringChildToFront(this.mRefreshFooter.getView());
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        if (this.mHandler == null) {
            this.mHandler = new Handler();
        }
        if (this.mDelayedRunnables != null) {
            for (DelayedRunnable runnable : this.mDelayedRunnables) {
                this.mHandler.postDelayed((Runnable)runnable, runnable.delayMillis);
            }
            this.mDelayedRunnables.clear();
            this.mDelayedRunnables = null;
        }
        if (this.mRefreshHeader == null) {
            this.mRefreshHeader = sHeaderCreator.createRefreshHeader(this.getContext(), this);
            if (!(this.mRefreshHeader.getView().getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) {
                if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Scale) {
                    this.addView(this.mRefreshHeader.getView(), -1, -1);
                } else {
                    this.addView(this.mRefreshHeader.getView(), -1, -2);
                }
            }
        }
        if (this.mRefreshFooter == null) {
            this.mRefreshFooter = sFooterCreator.createRefreshFooter(this.getContext(), this);
            boolean bl = this.mEnableLoadMore = this.mEnableLoadMore || !this.mManualLoadMore && sManualFooterCreator;
            if (!(this.mRefreshFooter.getView().getLayoutParams() instanceof ViewGroup.MarginLayoutParams)) {
                if (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Scale) {
                    this.addView(this.mRefreshFooter.getView(), -1, -1);
                } else {
                    this.addView(this.mRefreshFooter.getView(), -1, -2);
                }
            }
        }
        int len = this.getChildCount();
        for (int i = 0; this.mRefreshContent == null && i < len; ++i) {
            View view = this.getChildAt(i);
            if (this.mRefreshHeader != null && view == this.mRefreshHeader.getView() || this.mRefreshFooter != null && view == this.mRefreshFooter.getView()) continue;
            this.mRefreshContent = new RefreshContentWrapper(view);
        }
        if (this.mRefreshContent == null) {
            int padding = DensityUtil.dp2px(20.0f);
            TextView errorView = new TextView(this.getContext());
            errorView.setTextColor(-39424);
            errorView.setGravity(17);
            errorView.setTextSize(20.0f);
            errorView.setPadding(padding, padding, padding, padding);
            errorView.setText(R.string.srl_content_empty);
            this.addView((View)errorView, -1, -1);
            this.mRefreshContent = new RefreshContentWrapper((View)errorView);
        }
        View fixedHeaderView = this.mFixedHeaderViewId > 0 ? this.findViewById(this.mFixedHeaderViewId) : null;
        View fixedFooterView = this.mFixedFooterViewId > 0 ? this.findViewById(this.mFixedFooterViewId) : null;
        this.mRefreshContent.setScrollBoundaryDecider(this.mScrollBoundaryDecider);
        this.mRefreshContent.setEnableLoadMoreWhenContentNotFull(this.mEnableLoadMoreWhenContentNotFull);
        this.mRefreshContent.setUpComponent(this.mKernel, fixedHeaderView, fixedFooterView);
        if (this.mSpinner != 0) {
            this.notifyStateChanged(RefreshState.None);
            this.mSpinner = 0;
            this.mRefreshContent.moveSpinner(0);
        }
        this.bringChildToFront(this.mRefreshContent.getView());
        if (this.mRefreshHeader.getSpinnerStyle() != SpinnerStyle.FixedBehind) {
            this.bringChildToFront(this.mRefreshHeader.getView());
        }
        if (this.mRefreshFooter.getSpinnerStyle() != SpinnerStyle.FixedBehind) {
            this.bringChildToFront(this.mRefreshFooter.getView());
        }
        if (this.mRefreshListener == null) {
            this.mRefreshListener = new OnRefreshListener(){

                @Override
                public void onRefresh(RefreshLayout refreshLayout) {
                    refreshLayout.finishRefresh(3000);
                }
            };
        }
        if (this.mLoadMoreListener == null) {
            this.mLoadMoreListener = new OnLoadMoreListener(){

                @Override
                public void onLoadMore(RefreshLayout refreshLayout) {
                    refreshLayout.finishLoadMore(2000);
                }
            };
        }
        if (this.mPrimaryColors != null) {
            this.mRefreshHeader.setPrimaryColors(this.mPrimaryColors);
            this.mRefreshFooter.setPrimaryColors(this.mPrimaryColors);
        }
        if (!this.mManualNestedScrolling && !this.isNestedScrollingEnabled()) {
            for (ViewParent parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof NestedScrollingParent)) continue;
                this.setNestedScrollingEnabled(true);
                this.mManualNestedScrolling = false;
                break;
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minimumHeight = 0;
        boolean isInEditMode = this.isInEditMode() && this.mEnablePreviewInEditMode;
        int len = this.getChildCount();
        for (int i = 0; i < len; ++i) {
            int height;
            int measuredHeight;
            int heightSpec;
            int widthSpec;
            LayoutParams lp;
            View child = this.getChildAt(i);
            if (this.mRefreshHeader != null && this.mRefreshHeader.getView() == child) {
                View headerView = this.mRefreshHeader.getView();
                lp = (LayoutParams)headerView.getLayoutParams();
                widthSpec = SmartRefreshLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(lp.leftMargin + lp.rightMargin), (int)lp.width);
                heightSpec = heightMeasureSpec;
                if (this.mHeaderHeightStatus.gteReplaceWith(DimensionStatus.XmlLayoutUnNotify)) {
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(this.mHeaderHeight - lp.bottomMargin - lp.topMargin, 0), (int)0x40000000);
                    headerView.measure(widthSpec, heightSpec);
                } else if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.MatchLayout) {
                    int headerHeight = 0;
                    if (!this.mHeaderHeightStatus.notified) {
                        this.measureChild(headerView, widthSpec, View.MeasureSpec.makeMeasureSpec((int)Math.max(View.MeasureSpec.getSize((int)heightSpec) - lp.bottomMargin - lp.topMargin, 0), (int)Integer.MIN_VALUE));
                        headerHeight = headerView.getMeasuredHeight();
                    }
                    headerView.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)Math.max(View.MeasureSpec.getSize((int)heightSpec) - lp.bottomMargin - lp.topMargin, 0), (int)0x40000000));
                    if (headerHeight > 0 && headerHeight != headerView.getMeasuredHeight()) {
                        this.mHeaderHeight = headerHeight + lp.bottomMargin + lp.topMargin;
                    }
                } else if (lp.height > 0) {
                    if (this.mHeaderHeightStatus.canReplaceWith(DimensionStatus.XmlExactUnNotify)) {
                        this.mHeaderHeight = lp.height + lp.bottomMargin + lp.topMargin;
                        this.mHeaderHeightStatus = DimensionStatus.XmlExactUnNotify;
                    }
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000);
                    headerView.measure(widthSpec, heightSpec);
                } else if (lp.height == -2) {
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(View.MeasureSpec.getSize((int)heightMeasureSpec) - lp.bottomMargin - lp.topMargin, 0), (int)Integer.MIN_VALUE);
                    headerView.measure(widthSpec, heightSpec);
                    measuredHeight = headerView.getMeasuredHeight();
                    if (measuredHeight > 0 && this.mHeaderHeightStatus.canReplaceWith(DimensionStatus.XmlWrapUnNotify)) {
                        this.mHeaderHeightStatus = DimensionStatus.XmlWrapUnNotify;
                        this.mHeaderHeight = headerView.getMeasuredHeight() + lp.bottomMargin + lp.topMargin;
                    } else if (measuredHeight <= 0) {
                        heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(this.mHeaderHeight - lp.bottomMargin - lp.topMargin, 0), (int)0x40000000);
                        headerView.measure(widthSpec, heightSpec);
                    }
                } else if (lp.height == -1) {
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(this.mHeaderHeight - lp.bottomMargin - lp.topMargin, 0), (int)0x40000000);
                    headerView.measure(widthSpec, heightSpec);
                } else {
                    headerView.measure(widthSpec, heightSpec);
                }
                if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Scale && !isInEditMode) {
                    height = Math.max(0, this.isEnableRefresh() ? this.mSpinner : 0);
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(height - lp.bottomMargin - lp.topMargin, 0), (int)0x40000000);
                    headerView.measure(widthSpec, heightSpec);
                }
                if (!this.mHeaderHeightStatus.notified) {
                    this.mHeaderHeightStatus = this.mHeaderHeightStatus.notified();
                    this.mHeaderExtendHeight = (int)Math.max((float)this.mHeaderHeight * (this.mHeaderMaxDragRate - 1.0f), 0.0f);
                    this.mRefreshHeader.onInitialized(this.mKernel, this.mHeaderHeight, this.mHeaderExtendHeight);
                }
                if (isInEditMode && this.isEnableRefresh()) {
                    minimumHeight += headerView.getMeasuredHeight();
                }
            }
            if (this.mRefreshFooter != null && this.mRefreshFooter.getView() == child) {
                View footerView = this.mRefreshFooter.getView();
                lp = (LayoutParams)footerView.getLayoutParams();
                widthSpec = SmartRefreshLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(lp.leftMargin + lp.rightMargin), (int)lp.width);
                heightSpec = heightMeasureSpec;
                if (this.mFooterHeightStatus.gteReplaceWith(DimensionStatus.XmlLayoutUnNotify)) {
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(this.mFooterHeight - lp.topMargin - lp.bottomMargin, 0), (int)0x40000000);
                    footerView.measure(widthSpec, heightSpec);
                } else if (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.MatchLayout) {
                    int footerHeight = 0;
                    if (!this.mFooterHeightStatus.notified) {
                        this.measureChild(footerView, widthSpec, View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)heightSpec) - lp.topMargin - lp.bottomMargin), (int)Integer.MIN_VALUE));
                        footerHeight = footerView.getMeasuredHeight();
                    }
                    footerView.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)heightSpec) - lp.topMargin - lp.bottomMargin), (int)0x40000000));
                    if (footerHeight > 0 && footerHeight != footerView.getMeasuredHeight()) {
                        this.mHeaderHeight = footerHeight + lp.topMargin + lp.bottomMargin;
                    }
                } else if (lp.height > 0) {
                    if (this.mFooterHeightStatus.canReplaceWith(DimensionStatus.XmlExactUnNotify)) {
                        this.mFooterHeight = lp.height + lp.topMargin + lp.bottomMargin;
                        this.mFooterHeightStatus = DimensionStatus.XmlExactUnNotify;
                    }
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000);
                    footerView.measure(widthSpec, heightSpec);
                } else if (lp.height == -2) {
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(View.MeasureSpec.getSize((int)heightMeasureSpec) - lp.topMargin - lp.bottomMargin, 0), (int)Integer.MIN_VALUE);
                    footerView.measure(widthSpec, heightSpec);
                    measuredHeight = footerView.getMeasuredHeight();
                    if (measuredHeight > 0 && this.mFooterHeightStatus.canReplaceWith(DimensionStatus.XmlWrapUnNotify)) {
                        this.mFooterHeightStatus = DimensionStatus.XmlWrapUnNotify;
                        this.mFooterHeight = footerView.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
                    } else if (measuredHeight <= 0) {
                        heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(this.mFooterHeight - lp.topMargin - lp.bottomMargin, 0), (int)0x40000000);
                        footerView.measure(widthSpec, heightSpec);
                    }
                } else if (lp.height == -1) {
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(this.mFooterHeight - lp.topMargin - lp.bottomMargin, 0), (int)0x40000000);
                    footerView.measure(widthSpec, heightSpec);
                } else {
                    footerView.measure(widthSpec, heightSpec);
                }
                if (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Scale && !isInEditMode) {
                    height = Math.max(0, this.mEnableLoadMore ? -this.mSpinner : 0);
                    heightSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(height - lp.topMargin - lp.bottomMargin, 0), (int)0x40000000);
                    footerView.measure(widthSpec, heightSpec);
                }
                if (!this.mFooterHeightStatus.notified) {
                    this.mFooterHeightStatus = this.mFooterHeightStatus.notified();
                    this.mFooterExtendHeight = (int)Math.max((float)this.mFooterHeight * (this.mFooterMaxDragRate - 1.0f), 0.0f);
                    this.mRefreshFooter.onInitialized(this.mKernel, this.mFooterHeight, this.mFooterExtendHeight);
                }
                if (isInEditMode && this.isEnableLoadMore()) {
                    minimumHeight += footerView.getMeasuredHeight();
                }
            }
            if (this.mRefreshContent == null || this.mRefreshContent.getView() != child) continue;
            LayoutParams lp2 = (LayoutParams)this.mRefreshContent.getLayoutParams();
            int widthSpec2 = SmartRefreshLayout.getChildMeasureSpec((int)widthMeasureSpec, (int)(this.getPaddingLeft() + this.getPaddingRight() + lp2.leftMargin + lp2.rightMargin), (int)lp2.width);
            int heightSpec2 = SmartRefreshLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom() + lp2.topMargin + lp2.bottomMargin + (isInEditMode && this.isEnableRefresh() && this.mRefreshHeader != null && (this.mEnableHeaderTranslationContent || this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.FixedBehind) ? this.mHeaderHeight : 0) + (isInEditMode && this.isEnableLoadMore() && this.mRefreshFooter != null && (this.mEnableFooterTranslationContent || this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.FixedBehind) ? this.mFooterHeight : 0)), (int)lp2.height);
            this.mRefreshContent.measure(widthSpec2, heightSpec2);
            this.mRefreshContent.onInitialHeaderAndFooter(this.mHeaderHeight, this.mFooterHeight);
            minimumHeight += this.mRefreshContent.getMeasuredHeight();
        }
        this.setMeasuredDimension(SmartRefreshLayout.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), SmartRefreshLayout.resolveSize((int)minimumHeight, (int)heightMeasureSpec));
        this.mLastTouchX = this.getMeasuredWidth() / 2;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int len = this.getChildCount();
        for (int i = 0; i < len; ++i) {
            boolean isPreviewMode;
            View child = this.getChildAt(i);
            if (this.mRefreshContent != null && this.mRefreshContent.getView() == child) {
                isPreviewMode = this.isInEditMode() && this.mEnablePreviewInEditMode && this.isEnableRefresh() && this.mRefreshHeader != null;
                LayoutParams lp = (LayoutParams)this.mRefreshContent.getLayoutParams();
                int left = paddingLeft + lp.leftMargin;
                int top = paddingTop + lp.topMargin;
                int right = left + this.mRefreshContent.getMeasuredWidth();
                int bottom = top + this.mRefreshContent.getMeasuredHeight();
                if (isPreviewMode && (this.mEnableHeaderTranslationContent || this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.FixedBehind)) {
                    top += this.mHeaderHeight;
                    bottom += this.mHeaderHeight;
                }
                this.mRefreshContent.layout(left, top, right, bottom);
            }
            if (this.mRefreshHeader != null && this.mRefreshHeader.getView() == child) {
                isPreviewMode = this.isInEditMode() && this.mEnablePreviewInEditMode && this.isEnableRefresh();
                View headerView = this.mRefreshHeader.getView();
                LayoutParams lp = (LayoutParams)headerView.getLayoutParams();
                int left = lp.leftMargin;
                int top = lp.topMargin + this.mHeaderInsetStart;
                int right = left + headerView.getMeasuredWidth();
                int bottom = top + headerView.getMeasuredHeight();
                if (!isPreviewMode && this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Translate) {
                    top -= this.mHeaderHeight;
                    bottom -= this.mHeaderHeight;
                }
                headerView.layout(left, top, right, bottom);
            }
            if (this.mRefreshFooter == null || this.mRefreshFooter.getView() != child) continue;
            isPreviewMode = this.isInEditMode() && this.mEnablePreviewInEditMode && this.isEnableLoadMore();
            View footerView = this.mRefreshFooter.getView();
            LayoutParams lp = (LayoutParams)footerView.getLayoutParams();
            SpinnerStyle style = this.mRefreshFooter.getSpinnerStyle();
            int left = lp.leftMargin;
            int top = lp.topMargin + this.getMeasuredHeight() - this.mFooterInsetStart;
            if (isPreviewMode || style == SpinnerStyle.FixedFront || style == SpinnerStyle.FixedBehind) {
                top -= this.mFooterHeight;
            } else if (style == SpinnerStyle.Scale && this.mSpinner < 0) {
                top -= Math.max(this.isEnableLoadMore() ? -this.mSpinner : 0, 0);
            }
            int right = left + footerView.getMeasuredWidth();
            int bottom = top + footerView.getMeasuredHeight();
            footerView.layout(left, top, right, bottom);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.moveSpinner(0, false);
        this.notifyStateChanged(RefreshState.None);
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler = null;
        this.mManualLoadMore = true;
        this.mManualNestedScrolling = true;
        this.animationRunnable = null;
        if (this.reboundAnimator != null) {
            this.reboundAnimator.removeAllListeners();
            this.reboundAnimator.removeAllUpdateListeners();
            this.reboundAnimator.cancel();
            this.reboundAnimator = null;
        }
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        View contentView;
        View view = contentView = this.mRefreshContent != null ? this.mRefreshContent.getView() : null;
        if (this.mRefreshHeader != null && this.mRefreshHeader.getView() == child) {
            if (!this.isEnableRefresh() || !this.mEnablePreviewInEditMode && this.isInEditMode()) {
                return true;
            }
            if (contentView != null) {
                int bottom = Math.max(contentView.getTop() + contentView.getPaddingTop() + this.mSpinner, child.getTop());
                if (this.mHeaderBackgroundColor != 0 && this.mPaint != null) {
                    this.mPaint.setColor(this.mHeaderBackgroundColor);
                    if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Scale) {
                        bottom = child.getBottom();
                    } else if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Translate) {
                        bottom = child.getBottom() + this.mSpinner;
                    }
                    canvas.drawRect((float)child.getLeft(), (float)child.getTop(), (float)child.getRight(), (float)bottom, this.mPaint);
                }
                if (this.mEnableClipHeaderWhenFixedBehind && this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
                    canvas.save();
                    canvas.clipRect(child.getLeft(), child.getTop(), child.getRight(), bottom);
                    boolean ret = super.drawChild(canvas, child, drawingTime);
                    canvas.restore();
                    return ret;
                }
            }
        }
        if (this.mRefreshFooter != null && this.mRefreshFooter.getView() == child) {
            if (!this.isEnableLoadMore() || !this.mEnablePreviewInEditMode && this.isInEditMode()) {
                return true;
            }
            if (contentView != null) {
                int top = Math.min(contentView.getBottom() - contentView.getPaddingBottom() + this.mSpinner, child.getBottom());
                if (this.mFooterBackgroundColor != 0 && this.mPaint != null) {
                    this.mPaint.setColor(this.mFooterBackgroundColor);
                    if (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Scale) {
                        top = child.getTop();
                    } else if (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Translate) {
                        top = child.getTop() + this.mSpinner;
                    }
                    canvas.drawRect((float)child.getLeft(), (float)top, (float)child.getRight(), (float)child.getBottom(), this.mPaint);
                }
                if (this.mEnableClipFooterWhenFixedBehind && this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
                    canvas.save();
                    canvas.clipRect(child.getLeft(), top, child.getRight(), child.getBottom());
                    boolean ret = super.drawChild(canvas, child, drawingTime);
                    canvas.restore();
                    return ret;
                }
            }
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    public void computeScroll() {
        int lastCurY = this.mScroller.getCurrY();
        if (this.mScroller.computeScrollOffset()) {
            int finalY = this.mScroller.getFinalY();
            if (finalY < 0 && (this.mEnableOverScrollDrag || this.isEnableRefresh()) && this.mRefreshContent.canRefresh() || finalY > 0 && (this.mEnableOverScrollDrag || this.isEnableLoadMore()) && this.mRefreshContent.canLoadMore()) {
                if (this.mVerticalPermit) {
                    float velocity = Build.VERSION.SDK_INT >= 14 ? (finalY > 0 ? -this.mScroller.getCurrVelocity() : this.mScroller.getCurrVelocity()) : 1.0f * (float)(this.mScroller.getCurrY() - finalY) / (float)Math.max(this.mScroller.getDuration() - this.mScroller.timePassed(), 1);
                    this.animSpinnerBounce(velocity);
                }
                this.mScroller.forceFinished(true);
            } else {
                this.mVerticalPermit = true;
                this.invalidate();
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent e) {
        int action = e.getActionMasked();
        boolean pointerUp = action == 6;
        int skipIndex = pointerUp ? e.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        int count = e.getPointerCount();
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            sumX += e.getX(i);
            sumY += e.getY(i);
        }
        int div = pointerUp ? count - 1 : count;
        float touchX = sumX / (float)div;
        float touchY = sumY / (float)div;
        if ((action == 6 || action == 5) && this.mIsBeingDragged) {
            this.mTouchY += touchY - this.mLastTouchY;
        }
        this.mLastTouchX = touchX;
        this.mLastTouchY = touchY;
        if (this.mNestedScrollInProgress) {
            int totalUnconsumed = this.mTotalUnconsumed;
            boolean ret = super.dispatchTouchEvent(e);
            if (action == 2 && totalUnconsumed == this.mTotalUnconsumed) {
                int offsetX = (int)this.mLastTouchX;
                int offsetMax = this.getWidth();
                float percentX = this.mLastTouchX / (float)(offsetMax == 0 ? 1 : offsetMax);
                if (this.isEnableRefresh() && this.mSpinner > 0 && this.mRefreshHeader != null && this.mRefreshHeader.isSupportHorizontalDrag()) {
                    this.mRefreshHeader.onHorizontalDrag(percentX, offsetX, offsetMax);
                } else if (this.isEnableLoadMore() && this.mSpinner < 0 && this.mRefreshFooter != null && this.mRefreshFooter.isSupportHorizontalDrag()) {
                    this.mRefreshFooter.onHorizontalDrag(percentX, offsetX, offsetMax);
                }
            }
            return ret;
        }
        if (!this.isEnabled() || !this.isEnableRefresh() && !this.isEnableLoadMore() && !this.mEnableOverScrollDrag || this.mHeaderNeedTouchEventWhenRefreshing && (this.mState.opening || this.mState.finishing) && this.mState.isHeader() || this.mFooterNeedTouchEventWhenLoading && (this.mState.opening || this.mState.finishing) && this.mState.isFooter()) {
            return super.dispatchTouchEvent(e);
        }
        if (this.interceptByAnimator(action) || this.mState.finishing || this.mState == RefreshState.Loading && this.mDisableContentWhenLoading || this.mState == RefreshState.Refreshing && this.mDisableContentWhenRefresh) {
            return false;
        }
        if (this.mRefreshContent != null) {
            switch (action) {
                case 0: {
                    this.mVelocityTracker.clear();
                    this.mVelocityTracker.addMovement(e);
                    this.mRefreshContent.onActionDown(e);
                    this.mScroller.forceFinished(true);
                    break;
                }
                case 2: {
                    if (this.mNestedScrollInProgress) break;
                    this.mVelocityTracker.addMovement(e);
                    break;
                }
                case 1: {
                    if (!this.mNestedScrollInProgress) {
                        this.mVelocityTracker.addMovement(e);
                        this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    }
                }
                case 3: {
                    this.mRefreshContent.onActionUpOrCancel();
                }
            }
        }
        switch (action) {
            case 0: {
                this.mTouchX = touchX;
                this.mTouchY = touchY;
                this.mLastSpinner = 0;
                this.mTouchSpinner = this.mSpinner;
                this.mIsBeingDragged = false;
                this.mSuperDispatchTouchEvent = super.dispatchTouchEvent(e);
                if (this.mState == RefreshState.TwoLevel && this.mTouchY < (float)(5 * this.getMeasuredHeight() / 6)) {
                    this.mDragDirection = (char)104;
                    return this.mSuperDispatchTouchEvent;
                }
                return true;
            }
            case 2: {
                float dx = touchX - this.mTouchX;
                float dy = touchY - this.mTouchY;
                if (!this.mIsBeingDragged && this.mDragDirection != 'h') {
                    if (this.mDragDirection == 'v' || Math.abs(dy) >= (float)this.mTouchSlop && Math.abs(dx) < Math.abs(dy)) {
                        this.mDragDirection = (char)118;
                        if (dy > 0.0f && (this.mSpinner < 0 || (this.mEnableOverScrollDrag || this.isEnableRefresh()) && this.mRefreshContent.canRefresh())) {
                            this.mIsBeingDragged = true;
                            this.mTouchY = touchY - (float)this.mTouchSlop;
                        } else if (dy < 0.0f && (this.mSpinner > 0 || (this.mEnableOverScrollDrag || this.isEnableLoadMore()) && (this.mState == RefreshState.Loading && this.mFooterLocked || this.mRefreshContent.canLoadMore()))) {
                            this.mIsBeingDragged = true;
                            this.mTouchY = touchY + (float)this.mTouchSlop;
                        }
                        if (this.mIsBeingDragged) {
                            dy = touchY - this.mTouchY;
                            if (this.mSuperDispatchTouchEvent) {
                                e.setAction(3);
                                super.dispatchTouchEvent(e);
                            }
                            if (this.mSpinner > 0 || this.mSpinner == 0 && dy > 0.0f) {
                                this.mKernel.setState(RefreshState.PullDownToRefresh);
                            } else {
                                this.mKernel.setState(RefreshState.PullUpToLoad);
                            }
                            this.getParent().requestDisallowInterceptTouchEvent(true);
                        }
                    } else if (Math.abs(dx) >= (float)this.mTouchSlop && Math.abs(dx) > Math.abs(dy) && this.mDragDirection != 'v') {
                        this.mDragDirection = (char)104;
                    }
                }
                if (this.mIsBeingDragged) {
                    int spinner = (int)dy + this.mTouchSpinner;
                    if (this.mViceState.isHeader() && (spinner < 0 || this.mLastSpinner < 0) || this.mViceState.isFooter() && (spinner > 0 || this.mLastSpinner > 0)) {
                        this.mLastSpinner = spinner;
                        long time = e.getEventTime();
                        if (this.mFalsifyEvent == null) {
                            this.mFalsifyEvent = MotionEvent.obtain((long)time, (long)time, (int)0, (float)(this.mTouchX + dx), (float)this.mTouchY, (int)0);
                            super.dispatchTouchEvent(this.mFalsifyEvent);
                        }
                        MotionEvent em = MotionEvent.obtain((long)time, (long)time, (int)2, (float)(this.mTouchX + dx), (float)(this.mTouchY + (float)spinner), (int)0);
                        super.dispatchTouchEvent(em);
                        if (this.mFooterLocked && dy > (float)this.mTouchSlop && this.mSpinner < 0) {
                            this.mFooterLocked = false;
                        }
                        if (spinner > 0 && (this.mEnableOverScrollDrag || this.isEnableRefresh()) && this.mRefreshContent.canRefresh()) {
                            this.mTouchY = this.mLastTouchY = touchY;
                            spinner = 0;
                            this.mTouchSpinner = 0;
                            this.mKernel.setState(RefreshState.PullDownToRefresh);
                        } else if (spinner < 0 && (this.mEnableOverScrollDrag || this.isEnableLoadMore()) && this.mRefreshContent.canLoadMore()) {
                            this.mTouchY = this.mLastTouchY = touchY;
                            spinner = 0;
                            this.mTouchSpinner = 0;
                            this.mKernel.setState(RefreshState.PullUpToLoad);
                        }
                        if (this.mViceState.isHeader() && spinner < 0 || this.mViceState.isFooter() && spinner > 0) {
                            if (this.mSpinner != 0) {
                                this.moveSpinnerInfinitely(0.0f);
                            }
                            return true;
                        }
                        if (this.mFalsifyEvent != null) {
                            this.mFalsifyEvent = null;
                            em.setAction(3);
                            super.dispatchTouchEvent(em);
                        }
                        em.recycle();
                    }
                    this.moveSpinnerInfinitely(spinner);
                    return true;
                }
                if (!this.mFooterLocked || !(dy > (float)this.mTouchSlop) || this.mSpinner >= 0) break;
                this.mFooterLocked = false;
                break;
            }
            case 1: {
                this.startFlingIfNeed(null);
            }
            case 3: {
                this.mDragDirection = (char)110;
                if (this.mFalsifyEvent != null) {
                    this.mFalsifyEvent.recycle();
                    this.mFalsifyEvent = null;
                    long time = e.getEventTime();
                    MotionEvent ec = MotionEvent.obtain((long)time, (long)time, (int)action, (float)this.mTouchX, (float)touchY, (int)0);
                    super.dispatchTouchEvent(ec);
                    ec.recycle();
                }
                this.overSpinner();
                if (!this.mIsBeingDragged) break;
                this.mIsBeingDragged = false;
                return true;
            }
        }
        return super.dispatchTouchEvent(e);
    }

    protected boolean startFlingIfNeed(Float flingVelocity) {
        float velocity;
        float f = velocity = flingVelocity == null ? this.mVelocityTracker.getYVelocity() : flingVelocity.floatValue();
        if (Math.abs(velocity) > (float)this.mMinimumVelocity) {
            if (velocity < 0.0f && (this.mEnableOverScrollBounce && (this.mEnableOverScrollDrag || this.isEnableLoadMore()) || this.mState == RefreshState.Loading && this.mSpinner >= 0 || this.mEnableAutoLoadMore && this.isEnableLoadMore()) || velocity > 0.0f && (this.mEnableOverScrollBounce && (this.mEnableOverScrollDrag || this.isEnableRefresh()) || this.mState == RefreshState.Refreshing && this.mSpinner <= 0)) {
                this.mVerticalPermit = false;
                this.mScroller.fling(0, 0, 0, (int)(-velocity), 0, 0, -2147483647, Integer.MAX_VALUE);
                this.mScroller.computeScrollOffset();
                this.invalidate();
            }
            if (velocity * (float)this.mSpinner < 0.0f && this.mState != RefreshState.TwoLevel && this.mState != this.mViceState) {
                this.animationRunnable = new FlingRunnable(velocity).start();
                return true;
            }
        }
        return false;
    }

    protected boolean interceptByAnimator(int action) {
        if (action == 0) {
            this.animationRunnable = null;
            if (this.reboundAnimator != null) {
                if (this.mState.finishing) {
                    return true;
                }
                if (this.mState == RefreshState.PullDownCanceled) {
                    this.mKernel.setState(RefreshState.PullDownToRefresh);
                } else if (this.mState == RefreshState.PullUpCanceled) {
                    this.mKernel.setState(RefreshState.PullUpToLoad);
                }
                this.reboundAnimator.cancel();
                this.reboundAnimator = null;
            }
        }
        return this.reboundAnimator != null;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        View target = this.mRefreshContent.getScrollableView();
        if (!(Build.VERSION.SDK_INT < 21 && target instanceof AbsListView || target != null && !ViewCompat.isNestedScrollingEnabled((View)target))) {
            super.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    protected void notifyStateChanged(RefreshState state) {
        RefreshState oldState = this.mState;
        if (oldState != state) {
            this.mState = state;
            this.mViceState = state;
            if (this.mRefreshFooter != null) {
                this.mRefreshFooter.onStateChanged(this, oldState, state);
            }
            if (this.mRefreshHeader != null) {
                this.mRefreshHeader.onStateChanged(this, oldState, state);
            }
            if (this.mOnMultiPurposeListener != null) {
                this.mOnMultiPurposeListener.onStateChanged(this, oldState, state);
            }
        }
    }

    protected void setStateDirectLoading() {
        if (this.mState != RefreshState.Loading) {
            this.mLastLoadingTime = System.currentTimeMillis();
            this.notifyStateChanged(RefreshState.Loading);
            this.mFooterLocked = true;
            if (this.mRefreshFooter != null) {
                this.mRefreshFooter.onStartAnimator(this, this.mFooterHeight, this.mFooterExtendHeight);
            }
            if (this.mLoadMoreListener != null) {
                this.mLoadMoreListener.onLoadMore(this);
            }
            if (this.mOnMultiPurposeListener != null) {
                this.mOnMultiPurposeListener.onLoadMore(this);
                this.mOnMultiPurposeListener.onFooterStartAnimator(this.mRefreshFooter, this.mFooterHeight, this.mFooterExtendHeight);
            }
        }
    }

    protected void setStateLoading() {
        AnimatorListenerAdapter listener = new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SmartRefreshLayout.this.setStateDirectLoading();
            }
        };
        this.notifyStateChanged(RefreshState.LoadReleased);
        ValueAnimator animator = this.animSpinner(-this.mFooterHeight);
        if (animator != null) {
            animator.addListener((Animator.AnimatorListener)listener);
        }
        if (this.mRefreshFooter != null) {
            this.mRefreshFooter.onReleased(this, this.mFooterHeight, this.mFooterExtendHeight);
        }
        if (this.mOnMultiPurposeListener != null) {
            this.mOnMultiPurposeListener.onFooterReleased(this.mRefreshFooter, this.mFooterHeight, this.mFooterExtendHeight);
        }
        if (animator == null) {
            listener.onAnimationEnd(null);
        }
    }

    protected void setStateRefreshing() {
        AnimatorListenerAdapter listener = new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SmartRefreshLayout.this.mLastRefreshingTime = System.currentTimeMillis();
                SmartRefreshLayout.this.notifyStateChanged(RefreshState.Refreshing);
                if (SmartRefreshLayout.this.mRefreshListener != null) {
                    SmartRefreshLayout.this.mRefreshListener.onRefresh(SmartRefreshLayout.this);
                }
                if (SmartRefreshLayout.this.mRefreshHeader != null) {
                    SmartRefreshLayout.this.mRefreshHeader.onStartAnimator(SmartRefreshLayout.this, SmartRefreshLayout.this.mHeaderHeight, SmartRefreshLayout.this.mHeaderExtendHeight);
                }
                if (SmartRefreshLayout.this.mOnMultiPurposeListener != null) {
                    SmartRefreshLayout.this.mOnMultiPurposeListener.onRefresh(SmartRefreshLayout.this);
                    SmartRefreshLayout.this.mOnMultiPurposeListener.onHeaderStartAnimator(SmartRefreshLayout.this.mRefreshHeader, SmartRefreshLayout.this.mHeaderHeight, SmartRefreshLayout.this.mHeaderExtendHeight);
                }
            }
        };
        this.notifyStateChanged(RefreshState.RefreshReleased);
        ValueAnimator animator = this.animSpinner(this.mHeaderHeight);
        if (animator != null) {
            animator.addListener((Animator.AnimatorListener)listener);
        }
        if (this.mRefreshHeader != null) {
            this.mRefreshHeader.onReleased(this, this.mHeaderHeight, this.mHeaderExtendHeight);
        }
        if (this.mOnMultiPurposeListener != null) {
            this.mOnMultiPurposeListener.onHeaderReleased(this.mRefreshHeader, this.mHeaderHeight, this.mHeaderExtendHeight);
        }
        if (animator == null) {
            listener.onAnimationEnd(null);
        }
    }

    protected void resetStatus() {
        if (this.mState != RefreshState.None && this.mSpinner == 0) {
            this.notifyStateChanged(RefreshState.None);
        }
        if (this.mSpinner != 0) {
            this.animSpinner(0);
        }
    }

    protected void setViceState(RefreshState state) {
        if (this.mState.dragging && this.mState.isHeader() != state.isHeader()) {
            this.notifyStateChanged(RefreshState.None);
        }
        if (this.mViceState != state) {
            this.mViceState = state;
        }
    }

    protected ValueAnimator animSpinner(int endSpinner) {
        return this.animSpinner(endSpinner, 0, this.mReboundInterpolator, this.mReboundDuration);
    }

    protected ValueAnimator animSpinner(int endSpinner, int startDelay, Interpolator interpolator, int duration) {
        if (this.mSpinner != endSpinner) {
            if (this.reboundAnimator != null) {
                this.reboundAnimator.cancel();
            }
            this.animationRunnable = null;
            this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{this.mSpinner, endSpinner});
            this.reboundAnimator.setDuration((long)duration);
            this.reboundAnimator.setInterpolator((TimeInterpolator)interpolator);
            this.reboundAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationCancel(Animator animation) {
                    super.onAnimationEnd(animation);
                }

                public void onAnimationEnd(Animator animation) {
                    SmartRefreshLayout.this.reboundAnimator = null;
                    if (SmartRefreshLayout.this.mSpinner == 0) {
                        if (SmartRefreshLayout.this.mState != RefreshState.None && !SmartRefreshLayout.this.mState.opening) {
                            SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
                        }
                    } else if (SmartRefreshLayout.this.mState != SmartRefreshLayout.this.mViceState) {
                        SmartRefreshLayout.this.setViceState(SmartRefreshLayout.this.mState);
                    }
                }
            });
            this.reboundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    SmartRefreshLayout.this.moveSpinner((Integer)animation.getAnimatedValue(), true);
                }
            });
            this.reboundAnimator.setStartDelay((long)startDelay);
            this.reboundAnimator.start();
            return this.reboundAnimator;
        }
        return null;
    }

    protected void animSpinnerBounce(float velocity) {
        if (this.reboundAnimator == null) {
            if (velocity > 0.0f && (this.mState == RefreshState.Refreshing || this.mState == RefreshState.TwoLevel)) {
                this.animationRunnable = new BounceRunnable(velocity, this.mHeaderHeight);
            } else if (velocity < 0.0f && (this.mState == RefreshState.Loading || this.mEnableFooterFollowWhenLoadFinished && this.mFooterNoMoreData && this.isEnableLoadMore() || this.mEnableAutoLoadMore && !this.mFooterNoMoreData && this.isEnableLoadMore() && this.mState != RefreshState.Refreshing)) {
                this.animationRunnable = new BounceRunnable(velocity, -this.mFooterHeight);
            } else if (this.mSpinner == 0 && this.mEnableOverScrollBounce) {
                this.animationRunnable = new BounceRunnable(velocity, 0);
            }
        }
    }

    protected void overSpinner() {
        if (this.mState == RefreshState.TwoLevel) {
            if (this.mVelocityTracker.getYVelocity() > -1000.0f && this.mSpinner > this.getMeasuredHeight() / 2) {
                ValueAnimator animator = this.animSpinner(this.getMeasuredHeight());
                if (animator != null) {
                    animator.setDuration((long)this.mFloorDuration);
                }
            } else if (this.mIsBeingDragged) {
                this.mKernel.finishTwoLevel();
            }
        } else if (this.mState == RefreshState.Loading || this.mEnableFooterFollowWhenLoadFinished && this.mFooterNoMoreData && this.mSpinner < 0 && this.isEnableLoadMore()) {
            if (this.mSpinner < -this.mFooterHeight) {
                this.animSpinner(-this.mFooterHeight);
            } else if (this.mSpinner > 0) {
                this.animSpinner(0);
            }
        } else if (this.mState == RefreshState.Refreshing) {
            if (this.mSpinner > this.mHeaderHeight) {
                this.animSpinner(this.mHeaderHeight);
            } else if (this.mSpinner < 0) {
                this.animSpinner(0);
            }
        } else if (this.mState == RefreshState.PullDownToRefresh) {
            this.mKernel.setState(RefreshState.PullDownCanceled);
        } else if (this.mState == RefreshState.PullUpToLoad) {
            this.mKernel.setState(RefreshState.PullDownCanceled);
        } else if (this.mState == RefreshState.ReleaseToRefresh) {
            this.setStateRefreshing();
        } else if (this.mState == RefreshState.ReleaseToLoad) {
            this.setStateLoading();
        } else if (this.mState == RefreshState.ReleaseToTwoLevel) {
            this.mKernel.setState(RefreshState.TwoLevelReleased);
        } else if (this.mSpinner != 0) {
            this.animSpinner(0);
        }
    }

    protected void moveSpinnerInfinitely(float spinner) {
        if (this.mState == RefreshState.TwoLevel && spinner > 0.0f) {
            this.moveSpinner(Math.min((int)spinner, this.getMeasuredHeight()), false);
        } else if (this.mState == RefreshState.Refreshing && spinner >= 0.0f) {
            if (spinner < (float)this.mHeaderHeight) {
                this.moveSpinner((int)spinner, false);
            } else {
                double M = this.mHeaderExtendHeight;
                double H = Math.max(this.mScreenHeightPixels * 4 / 3, this.getHeight()) - this.mHeaderHeight;
                double x = Math.max(0.0f, (spinner - (float)this.mHeaderHeight) * this.mDragRate);
                double y = Math.min(M * (1.0 - Math.pow(100.0, -x / (H == 0.0 ? 1.0 : H))), x);
                this.moveSpinner((int)y + this.mHeaderHeight, false);
            }
        } else if (spinner < 0.0f && (this.mState == RefreshState.Loading || this.mEnableFooterFollowWhenLoadFinished && this.mFooterNoMoreData && this.isEnableLoadMore() || this.mEnableAutoLoadMore && !this.mFooterNoMoreData && this.isEnableLoadMore())) {
            if (spinner > (float)(-this.mFooterHeight)) {
                this.moveSpinner((int)spinner, false);
            } else {
                double M = this.mFooterExtendHeight;
                double H = Math.max(this.mScreenHeightPixels * 4 / 3, this.getHeight()) - this.mFooterHeight;
                double x = -Math.min(0.0f, (spinner + (float)this.mFooterHeight) * this.mDragRate);
                double y = -Math.min(M * (1.0 - Math.pow(100.0, -x / (H == 0.0 ? 1.0 : H))), x);
                this.moveSpinner((int)y - this.mFooterHeight, false);
            }
        } else if (spinner >= 0.0f) {
            double M = this.mHeaderExtendHeight + this.mHeaderHeight;
            double H = Math.max(this.mScreenHeightPixels / 2, this.getHeight());
            double x = Math.max(0.0f, spinner * this.mDragRate);
            double y = Math.min(M * (1.0 - Math.pow(100.0, -x / (H == 0.0 ? 1.0 : H))), x);
            this.moveSpinner((int)y, false);
        } else {
            double M = this.mFooterExtendHeight + this.mFooterHeight;
            double H = Math.max(this.mScreenHeightPixels / 2, this.getHeight());
            double x = -Math.min(0.0f, spinner * this.mDragRate);
            double y = -Math.min(M * (1.0 - Math.pow(100.0, -x / (H == 0.0 ? 1.0 : H))), x);
            this.moveSpinner((int)y, false);
        }
        if (this.mEnableAutoLoadMore && !this.mFooterNoMoreData && this.isEnableLoadMore() && spinner < 0.0f && this.mState != RefreshState.Refreshing && this.mState != RefreshState.Loading && this.mState != RefreshState.LoadFinish) {
            this.setStateDirectLoading();
            if (this.mDisableContentWhenLoading) {
                this.animationRunnable = null;
                this.animSpinner(-this.mFooterHeight);
            }
        }
    }

    protected void moveSpinner(int spinner, boolean isAnimator) {
        float percentX;
        int offsetMax;
        int offsetX;
        float percent;
        int extendHeight;
        if (!(this.mSpinner != spinner || this.mRefreshHeader != null && this.mRefreshHeader.isSupportHorizontalDrag() || this.mRefreshFooter != null && this.mRefreshFooter.isSupportHorizontalDrag())) {
            return;
        }
        int oldSpinner = this.mSpinner;
        this.mSpinner = spinner;
        if (!isAnimator && this.mViceState.dragging) {
            if ((float)this.mSpinner > (float)this.mHeaderHeight * this.mHeaderTriggerRate) {
                if (this.mState != RefreshState.ReleaseToTwoLevel) {
                    this.mKernel.setState(RefreshState.ReleaseToRefresh);
                }
            } else if ((float)(-this.mSpinner) > (float)this.mFooterHeight * this.mFooterTriggerRate && !this.mFooterNoMoreData) {
                this.mKernel.setState(RefreshState.ReleaseToLoad);
            } else if (this.mSpinner < 0 && !this.mFooterNoMoreData) {
                this.mKernel.setState(RefreshState.PullUpToLoad);
            } else if (this.mSpinner > 0) {
                this.mKernel.setState(RefreshState.PullDownToRefresh);
            }
        }
        if (this.mRefreshContent != null) {
            Integer tSpinner = null;
            if (spinner >= 0) {
                if (this.mEnableHeaderTranslationContent || this.mRefreshHeader == null || this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
                    tSpinner = spinner;
                } else if (oldSpinner < 0) {
                    tSpinner = 0;
                }
            }
            if (spinner <= 0) {
                if (this.mEnableFooterTranslationContent || this.mRefreshFooter == null || this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
                    tSpinner = spinner;
                } else if (oldSpinner > 0) {
                    tSpinner = 0;
                }
            }
            if (tSpinner != null) {
                this.mRefreshContent.moveSpinner(tSpinner);
                if (this.mHeaderBackgroundColor != 0 && (tSpinner >= 0 || oldSpinner > 0) || this.mFooterBackgroundColor != 0 && (tSpinner <= 0 || oldSpinner < 0)) {
                    this.invalidate();
                }
            }
        }
        if ((spinner >= 0 || oldSpinner > 0) && this.mRefreshHeader != null) {
            int offset = Math.max(spinner, 0);
            int headerHeight = this.mHeaderHeight;
            extendHeight = this.mHeaderExtendHeight;
            percent = 1.0f * (float)offset / (float)(this.mHeaderHeight == 0 ? 1 : this.mHeaderHeight);
            if (this.isEnableRefresh() || this.mState == RefreshState.RefreshFinish && isAnimator) {
                if (oldSpinner != this.mSpinner) {
                    if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Translate) {
                        this.mRefreshHeader.getView().setTranslationY((float)this.mSpinner);
                    } else if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Scale) {
                        this.mRefreshHeader.getView().requestLayout();
                    }
                    if (isAnimator) {
                        this.mRefreshHeader.onReleasing(percent, offset, headerHeight, extendHeight);
                    }
                }
                if (!isAnimator) {
                    if (this.mRefreshHeader.isSupportHorizontalDrag()) {
                        offsetX = (int)this.mLastTouchX;
                        offsetMax = this.getWidth();
                        percentX = this.mLastTouchX / (float)(offsetMax == 0 ? 1 : offsetMax);
                        this.mRefreshHeader.onHorizontalDrag(percentX, offsetX, offsetMax);
                        this.mRefreshHeader.onPulling(percent, offset, headerHeight, extendHeight);
                    } else if (oldSpinner != this.mSpinner) {
                        this.mRefreshHeader.onPulling(percent, offset, headerHeight, extendHeight);
                    }
                }
            }
            if (oldSpinner != this.mSpinner && this.mOnMultiPurposeListener != null) {
                if (isAnimator) {
                    this.mOnMultiPurposeListener.onHeaderReleasing(this.mRefreshHeader, percent, offset, headerHeight, extendHeight);
                } else {
                    this.mOnMultiPurposeListener.onHeaderPulling(this.mRefreshHeader, percent, offset, headerHeight, extendHeight);
                }
            }
        }
        if ((spinner <= 0 || oldSpinner < 0) && this.mRefreshFooter != null) {
            int offset = -Math.min(spinner, 0);
            int footerHeight = this.mFooterHeight;
            extendHeight = this.mFooterExtendHeight;
            percent = (float)offset * 1.0f / (float)(this.mFooterHeight == 0 ? 1 : this.mFooterHeight);
            if (this.isEnableLoadMore() || this.mState == RefreshState.LoadFinish && isAnimator) {
                if (oldSpinner != this.mSpinner) {
                    if (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Translate) {
                        this.mRefreshFooter.getView().setTranslationY((float)this.mSpinner);
                    } else if (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Scale) {
                        this.mRefreshFooter.getView().requestLayout();
                    }
                    if (isAnimator) {
                        this.mRefreshFooter.onReleasing(percent, offset, footerHeight, extendHeight);
                    }
                }
                if (!isAnimator) {
                    if (this.mRefreshFooter.isSupportHorizontalDrag()) {
                        offsetX = (int)this.mLastTouchX;
                        offsetMax = this.getWidth();
                        percentX = this.mLastTouchX / (float)(offsetMax == 0 ? 1 : offsetMax);
                        this.mRefreshFooter.onHorizontalDrag(percentX, offsetX, offsetMax);
                        this.mRefreshFooter.onPulling(percent, offset, footerHeight, extendHeight);
                    } else if (oldSpinner != this.mSpinner) {
                        this.mRefreshFooter.onPulling(percent, offset, footerHeight, extendHeight);
                    }
                }
            }
            if (oldSpinner != this.mSpinner && this.mOnMultiPurposeListener != null) {
                if (isAnimator) {
                    this.mOnMultiPurposeListener.onFooterReleasing(this.mRefreshFooter, percent, offset, footerHeight, extendHeight);
                } else {
                    this.mOnMultiPurposeListener.onFooterPulling(this.mRefreshFooter, percent, offset, footerHeight, extendHeight);
                }
            }
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int nestedScrollAxes) {
        boolean accepted = this.isEnabled() && this.isNestedScrollingEnabled() && (nestedScrollAxes & 2) != 0;
        accepted = accepted && (this.mEnableOverScrollDrag || this.isEnableRefresh() || this.isEnableLoadMore());
        return accepted;
    }

    public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int axes) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, axes);
        this.startNestedScroll(axes & 2);
        this.mTotalUnconsumed = this.mSpinner;
        this.mNestedScrollInProgress = true;
    }

    public void onNestedPreScroll(@NonNull View target, int dx, int dy, @NonNull int[] consumed) {
        int consumedY = 0;
        if (dy * this.mTotalUnconsumed > 0) {
            if (Math.abs(dy) > Math.abs(this.mTotalUnconsumed)) {
                consumedY = this.mTotalUnconsumed;
                this.mTotalUnconsumed = 0;
            } else {
                consumedY = dy;
                this.mTotalUnconsumed -= dy;
            }
            this.moveSpinnerInfinitely(this.mTotalUnconsumed);
            if (this.mViceState.opening || this.mViceState == RefreshState.None) {
                if (this.mSpinner > 0) {
                    this.mKernel.setState(RefreshState.PullDownToRefresh);
                } else {
                    this.mKernel.setState(RefreshState.PullUpToLoad);
                }
            }
        } else if (dy > 0 && this.mFooterLocked) {
            consumedY = dy;
            this.mTotalUnconsumed -= dy;
            this.moveSpinnerInfinitely(this.mTotalUnconsumed);
        }
        this.dispatchNestedPreScroll(dx, dy - consumedY, consumed, null);
        consumed[1] = consumed[1] + consumedY;
    }

    public void onNestedScroll(@NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, this.mParentOffsetInWindow);
        int dy = dyUnconsumed + this.mParentOffsetInWindow[1];
        if (dy != 0 && (this.mEnableOverScrollDrag || dy < 0 && this.isEnableRefresh() || dy > 0 && this.isEnableLoadMore())) {
            if (this.mViceState == RefreshState.None) {
                this.mKernel.setState(dy > 0 ? RefreshState.PullUpToLoad : RefreshState.PullDownToRefresh);
            }
            this.moveSpinnerInfinitely(this.mTotalUnconsumed -= dy);
        }
    }

    public boolean onNestedPreFling(@NonNull View target, float velocityX, float velocityY) {
        return this.mFooterLocked && velocityY > 0.0f || this.startFlingIfNeed(Float.valueOf(-velocityY)) || this.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onNestedFling(@NonNull View target, float velocityX, float velocityY, boolean consumed) {
        return this.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public void onStopNestedScroll(@NonNull View target) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(target);
        this.mNestedScrollInProgress = false;
        this.mTotalUnconsumed = 0;
        this.overSpinner();
        this.stopNestedScroll();
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mManualNestedScrolling = true;
        this.mNestedScrollingChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mNestedScrollingChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mNestedScrollingChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mNestedScrollingChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mNestedScrollingChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mNestedScrollingChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mNestedScrollingChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    @Override
    public SmartRefreshLayout setFooterHeight(float heightDp) {
        return this.setFooterHeightPx(DensityUtil.dp2px(heightDp));
    }

    @Override
    public SmartRefreshLayout setFooterHeightPx(int heightPx) {
        if (this.mFooterHeightStatus.canReplaceWith(DimensionStatus.CodeExact)) {
            this.mFooterHeight = heightPx;
            this.mFooterExtendHeight = (int)Math.max((float)heightPx * (this.mFooterMaxDragRate - 1.0f), 0.0f);
            this.mFooterHeightStatus = DimensionStatus.CodeExactUnNotify;
            if (this.mRefreshFooter != null) {
                this.mRefreshFooter.getView().requestLayout();
            }
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setHeaderHeight(float heightDp) {
        return this.setHeaderHeightPx(DensityUtil.dp2px(heightDp));
    }

    @Override
    public SmartRefreshLayout setHeaderHeightPx(int heightPx) {
        if (this.mHeaderHeightStatus.canReplaceWith(DimensionStatus.CodeExact)) {
            this.mHeaderHeight = heightPx;
            this.mHeaderExtendHeight = (int)Math.max((float)heightPx * (this.mHeaderMaxDragRate - 1.0f), 0.0f);
            this.mHeaderHeightStatus = DimensionStatus.CodeExactUnNotify;
            if (this.mRefreshHeader != null) {
                this.mRefreshHeader.getView().requestLayout();
            }
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setHeaderInsetStart(float insetDp) {
        return this.setHeaderInsetStartPx(DensityUtil.dp2px(insetDp));
    }

    @Override
    public SmartRefreshLayout setHeaderInsetStartPx(int insetPx) {
        this.mHeaderInsetStart = insetPx;
        return this;
    }

    @Override
    public SmartRefreshLayout setFooterInsetStart(float insetDp) {
        return this.setFooterInsetStartPx(DensityUtil.dp2px(insetDp));
    }

    @Override
    public SmartRefreshLayout setFooterInsetStartPx(int insetPx) {
        this.mFooterInsetStart = insetPx;
        return this;
    }

    @Override
    public SmartRefreshLayout setDragRate(float rate) {
        this.mDragRate = rate;
        return this;
    }

    @Override
    public SmartRefreshLayout setHeaderMaxDragRate(float rate) {
        this.mHeaderMaxDragRate = rate;
        this.mHeaderExtendHeight = (int)Math.max((float)this.mHeaderHeight * (this.mHeaderMaxDragRate - 1.0f), 0.0f);
        if (this.mRefreshHeader != null && this.mHandler != null) {
            this.mRefreshHeader.onInitialized(this.mKernel, this.mHeaderHeight, this.mHeaderExtendHeight);
        } else {
            this.mHeaderHeightStatus = this.mHeaderHeightStatus.unNotify();
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setFooterMaxDragRate(float rate) {
        this.mFooterMaxDragRate = rate;
        this.mFooterExtendHeight = (int)Math.max((float)this.mFooterHeight * (this.mFooterMaxDragRate - 1.0f), 0.0f);
        if (this.mRefreshFooter != null && this.mHandler != null) {
            this.mRefreshFooter.onInitialized(this.mKernel, this.mFooterHeight, this.mFooterExtendHeight);
        } else {
            this.mFooterHeightStatus = this.mFooterHeightStatus.unNotify();
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setHeaderTriggerRate(float rate) {
        this.mHeaderTriggerRate = rate;
        return this;
    }

    @Override
    public SmartRefreshLayout setFooterTriggerRate(float rate) {
        this.mFooterTriggerRate = rate;
        return this;
    }

    @Override
    public SmartRefreshLayout setReboundInterpolator(@NonNull Interpolator interpolator) {
        this.mReboundInterpolator = interpolator;
        return this;
    }

    @Override
    public SmartRefreshLayout setReboundDuration(int duration) {
        this.mReboundDuration = duration;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableLoadMore(boolean enabled) {
        this.mManualLoadMore = true;
        this.mEnableLoadMore = enabled;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableRefresh(boolean enabled) {
        this.mEnableRefresh = enabled;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableHeaderTranslationContent(boolean enabled) {
        this.mEnableHeaderTranslationContent = enabled;
        this.mManualHeaderTranslationContent = true;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableFooterTranslationContent(boolean enabled) {
        this.mEnableFooterTranslationContent = enabled;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableAutoLoadMore(boolean enabled) {
        this.mEnableAutoLoadMore = enabled;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableOverScrollBounce(boolean enabled) {
        this.mEnableOverScrollBounce = enabled;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnablePureScrollMode(boolean enabled) {
        this.mEnablePureScrollMode = enabled;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableScrollContentWhenLoaded(boolean enabled) {
        this.mEnableScrollContentWhenLoaded = enabled;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableScrollContentWhenRefreshed(boolean enabled) {
        this.mEnableScrollContentWhenRefreshed = enabled;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableLoadMoreWhenContentNotFull(boolean enabled) {
        this.mEnableLoadMoreWhenContentNotFull = enabled;
        if (this.mRefreshContent != null) {
            this.mRefreshContent.setEnableLoadMoreWhenContentNotFull(enabled);
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableOverScrollDrag(boolean enabled) {
        this.mEnableOverScrollDrag = enabled;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableFooterFollowWhenLoadFinished(boolean enabled) {
        this.mEnableFooterFollowWhenLoadFinished = enabled;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableClipHeaderWhenFixedBehind(boolean enabled) {
        this.mEnableClipHeaderWhenFixedBehind = enabled;
        return this;
    }

    @Override
    public SmartRefreshLayout setEnableClipFooterWhenFixedBehind(boolean enabled) {
        this.mEnableClipFooterWhenFixedBehind = enabled;
        return this;
    }

    @Override
    public RefreshLayout setEnableNestedScroll(boolean enabled) {
        this.setNestedScrollingEnabled(enabled);
        return this;
    }

    @Override
    public SmartRefreshLayout setDisableContentWhenRefresh(boolean disable) {
        this.mDisableContentWhenRefresh = disable;
        return this;
    }

    @Override
    public SmartRefreshLayout setDisableContentWhenLoading(boolean disable) {
        this.mDisableContentWhenLoading = disable;
        return this;
    }

    @Override
    public SmartRefreshLayout setRefreshHeader(@NonNull RefreshHeader header) {
        return this.setRefreshHeader(header, -1, -2);
    }

    @Override
    public SmartRefreshLayout setRefreshHeader(@NonNull RefreshHeader header, int width, int height) {
        if (this.mRefreshHeader != null) {
            this.removeView(this.mRefreshHeader.getView());
        }
        this.mRefreshHeader = header;
        this.mHeaderBackgroundColor = 0;
        this.mHeaderNeedTouchEventWhenRefreshing = false;
        this.mHeaderHeightStatus = this.mHeaderHeightStatus.unNotify();
        if (header.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
            this.addView(this.mRefreshHeader.getView(), 0, (ViewGroup.LayoutParams)new LayoutParams(width, height));
        } else {
            this.addView(this.mRefreshHeader.getView(), width, height);
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setRefreshFooter(@NonNull RefreshFooter footer) {
        return this.setRefreshFooter(footer, -1, -2);
    }

    @Override
    public SmartRefreshLayout setRefreshFooter(@NonNull RefreshFooter footer, int width, int height) {
        if (this.mRefreshFooter != null) {
            this.removeView(this.mRefreshFooter.getView());
        }
        this.mRefreshFooter = footer;
        this.mFooterBackgroundColor = 0;
        this.mFooterNeedTouchEventWhenLoading = false;
        this.mFooterHeightStatus = this.mFooterHeightStatus.unNotify();
        boolean bl = this.mEnableLoadMore = !this.mManualLoadMore || this.mEnableLoadMore;
        if (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
            this.addView(this.mRefreshFooter.getView(), 0, (ViewGroup.LayoutParams)new LayoutParams(width, height));
        } else {
            this.addView(this.mRefreshFooter.getView(), width, height);
        }
        return this;
    }

    @Override
    public RefreshLayout setRefreshContent(@NonNull View content) {
        return this.setRefreshContent(content, -1, -1);
    }

    @Override
    public RefreshLayout setRefreshContent(@NonNull View content, int width, int height) {
        if (this.mRefreshContent != null) {
            this.removeView(this.mRefreshContent.getView());
        }
        this.addView(content, 0, (ViewGroup.LayoutParams)new LayoutParams(width, height));
        if (this.mRefreshHeader != null && this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
            this.bringChildToFront(content);
            if (this.mRefreshFooter != null && this.mRefreshFooter.getSpinnerStyle() != SpinnerStyle.FixedBehind) {
                this.bringChildToFront(this.mRefreshFooter.getView());
            }
        } else if (this.mRefreshFooter != null && this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
            this.bringChildToFront(content);
            if (this.mRefreshHeader != null && this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.FixedBehind) {
                this.bringChildToFront(this.mRefreshHeader.getView());
            }
        }
        this.mRefreshContent = new RefreshContentWrapper(content);
        if (this.mHandler != null) {
            View fixedHeaderView = this.mFixedHeaderViewId > 0 ? this.findViewById(this.mFixedHeaderViewId) : null;
            View fixedFooterView = this.mFixedFooterViewId > 0 ? this.findViewById(this.mFixedFooterViewId) : null;
            this.mRefreshContent.setScrollBoundaryDecider(this.mScrollBoundaryDecider);
            this.mRefreshContent.setEnableLoadMoreWhenContentNotFull(this.mEnableLoadMoreWhenContentNotFull);
            this.mRefreshContent.setUpComponent(this.mKernel, fixedHeaderView, fixedFooterView);
        }
        return this;
    }

    @Override
    @Nullable
    public RefreshFooter getRefreshFooter() {
        return this.mRefreshFooter;
    }

    @Override
    @Nullable
    public RefreshHeader getRefreshHeader() {
        return this.mRefreshHeader;
    }

    @Override
    public RefreshState getState() {
        return this.mState;
    }

    @Override
    public SmartRefreshLayout getLayout() {
        return this;
    }

    @Override
    public SmartRefreshLayout setOnRefreshListener(OnRefreshListener listener) {
        this.mRefreshListener = listener;
        return this;
    }

    @Override
    public SmartRefreshLayout setOnLoadMoreListener(OnLoadMoreListener listener) {
        this.mLoadMoreListener = listener;
        this.mEnableLoadMore = this.mEnableLoadMore || !this.mManualLoadMore && listener != null;
        return this;
    }

    @Override
    public SmartRefreshLayout setOnRefreshLoadMoreListener(OnRefreshLoadMoreListener listener) {
        this.mRefreshListener = listener;
        this.mLoadMoreListener = listener;
        this.mEnableLoadMore = this.mEnableLoadMore || !this.mManualLoadMore && listener != null;
        return this;
    }

    @Override
    public SmartRefreshLayout setOnMultiPurposeListener(OnMultiPurposeListener listener) {
        this.mOnMultiPurposeListener = listener;
        return this;
    }

    @Override
    public SmartRefreshLayout setPrimaryColors(int ... primaryColors) {
        if (this.mRefreshHeader != null) {
            this.mRefreshHeader.setPrimaryColors(primaryColors);
        }
        if (this.mRefreshFooter != null) {
            this.mRefreshFooter.setPrimaryColors(primaryColors);
        }
        this.mPrimaryColors = primaryColors;
        return this;
    }

    @Override
    public SmartRefreshLayout setPrimaryColorsId(int ... primaryColorId) {
        int[] colors = new int[primaryColorId.length];
        for (int i = 0; i < primaryColorId.length; ++i) {
            colors[i] = ContextCompat.getColor((Context)this.getContext(), (int)primaryColorId[i]);
        }
        this.setPrimaryColors(colors);
        return this;
    }

    @Override
    public RefreshLayout setScrollBoundaryDecider(ScrollBoundaryDecider boundary) {
        this.mScrollBoundaryDecider = boundary;
        if (this.mRefreshContent != null) {
            this.mRefreshContent.setScrollBoundaryDecider(boundary);
        }
        return this;
    }

    @Override
    public SmartRefreshLayout setNoMoreData(boolean noMoreData) {
        this.mFooterNoMoreData = noMoreData;
        if (this.mRefreshFooter != null && !this.mRefreshFooter.setNoMoreData(noMoreData)) {
            System.out.println("Footer:" + this.mRefreshFooter + "\u4e0d\u652f\u6301\u63d0\u793a\u5b8c\u6210");
        }
        return this;
    }

    @Override
    public SmartRefreshLayout finishRefresh() {
        long passTime = System.currentTimeMillis() - this.mLastRefreshingTime;
        return this.finishRefresh(Math.max(0, 1000 - (int)passTime));
    }

    @Override
    public SmartRefreshLayout finishLoadMore() {
        long passTime = System.currentTimeMillis() - this.mLastLoadingTime;
        return this.finishLoadMore(Math.max(0, 1000 - (int)passTime));
    }

    @Override
    public SmartRefreshLayout finishRefresh(int delayed) {
        return this.finishRefresh(delayed, true);
    }

    @Override
    public SmartRefreshLayout finishRefresh(boolean success) {
        long passTime = System.currentTimeMillis() - this.mLastRefreshingTime;
        return this.finishRefresh(success ? Math.max(0, 1000 - (int)passTime) : 0, success);
    }

    @Override
    public SmartRefreshLayout finishRefresh(int delayed, final boolean success) {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (SmartRefreshLayout.this.mState == RefreshState.Refreshing && SmartRefreshLayout.this.mRefreshHeader != null && SmartRefreshLayout.this.mRefreshContent != null) {
                    SmartRefreshLayout.this.notifyStateChanged(RefreshState.RefreshFinish);
                    int startDelay = SmartRefreshLayout.this.mRefreshHeader.onFinish(SmartRefreshLayout.this, success);
                    if (SmartRefreshLayout.this.mOnMultiPurposeListener != null) {
                        SmartRefreshLayout.this.mOnMultiPurposeListener.onHeaderFinish(SmartRefreshLayout.this.mRefreshHeader, success);
                    }
                    if (startDelay < Integer.MAX_VALUE) {
                        if (SmartRefreshLayout.this.mIsBeingDragged) {
                            SmartRefreshLayout.this.mTouchSpinner = 0;
                            SmartRefreshLayout.this.mTouchY = SmartRefreshLayout.this.mLastTouchY;
                            SmartRefreshLayout.this.mIsBeingDragged = false;
                            long time = System.currentTimeMillis();
                            SmartRefreshLayout.super.dispatchTouchEvent(MotionEvent.obtain((long)time, (long)time, (int)0, (float)SmartRefreshLayout.this.mLastTouchX, (float)(SmartRefreshLayout.this.mTouchY + (float)SmartRefreshLayout.this.mSpinner - (float)(SmartRefreshLayout.this.mTouchSlop * 2)), (int)0));
                            SmartRefreshLayout.super.dispatchTouchEvent(MotionEvent.obtain((long)time, (long)time, (int)2, (float)SmartRefreshLayout.this.mLastTouchX, (float)(SmartRefreshLayout.this.mTouchY + (float)SmartRefreshLayout.this.mSpinner), (int)0));
                        }
                        if (SmartRefreshLayout.this.mSpinner > 0) {
                            ValueAnimator.AnimatorUpdateListener updateListener = null;
                            ValueAnimator valueAnimator = SmartRefreshLayout.this.animSpinner(0, startDelay, SmartRefreshLayout.this.mReboundInterpolator, SmartRefreshLayout.this.mReboundDuration);
                            if (SmartRefreshLayout.this.mEnableScrollContentWhenRefreshed) {
                                updateListener = SmartRefreshLayout.this.mRefreshContent.scrollContentWhenFinished(SmartRefreshLayout.this.mSpinner);
                            }
                            if (valueAnimator != null && updateListener != null) {
                                valueAnimator.addUpdateListener(updateListener);
                            }
                        } else if (SmartRefreshLayout.this.mSpinner < 0) {
                            SmartRefreshLayout.this.animSpinner(0, startDelay, SmartRefreshLayout.this.mReboundInterpolator, SmartRefreshLayout.this.mReboundDuration);
                        } else {
                            SmartRefreshLayout.this.moveSpinner(0, true);
                            SmartRefreshLayout.this.resetStatus();
                        }
                    }
                }
            }
        }, delayed <= 0 ? 1L : (long)delayed);
        return this;
    }

    @Override
    public SmartRefreshLayout finishLoadMore(int delayed) {
        return this.finishLoadMore(delayed, true, false);
    }

    @Override
    public SmartRefreshLayout finishLoadMore(boolean success) {
        long passTime = System.currentTimeMillis() - this.mLastLoadingTime;
        return this.finishLoadMore(success ? Math.max(0, 1000 - (int)passTime) : 0, success, false);
    }

    @Override
    public SmartRefreshLayout finishLoadMore(int delayed, final boolean success, final boolean noMoreData) {
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (SmartRefreshLayout.this.mState == RefreshState.Loading && SmartRefreshLayout.this.mRefreshFooter != null && SmartRefreshLayout.this.mRefreshContent != null) {
                    SmartRefreshLayout.this.notifyStateChanged(RefreshState.LoadFinish);
                    int startDelay = SmartRefreshLayout.this.mRefreshFooter.onFinish(SmartRefreshLayout.this, success);
                    if (SmartRefreshLayout.this.mOnMultiPurposeListener != null) {
                        SmartRefreshLayout.this.mOnMultiPurposeListener.onFooterFinish(SmartRefreshLayout.this.mRefreshFooter, success);
                    }
                    if (startDelay < Integer.MAX_VALUE) {
                        boolean needHoldFooter = noMoreData && SmartRefreshLayout.this.mEnableFooterFollowWhenLoadFinished && SmartRefreshLayout.this.mSpinner < 0 && SmartRefreshLayout.this.mRefreshContent.canLoadMore();
                        final int offset = SmartRefreshLayout.this.mSpinner - (needHoldFooter ? Math.max(SmartRefreshLayout.this.mSpinner, -SmartRefreshLayout.this.mFooterHeight) : 0);
                        if (SmartRefreshLayout.this.mIsBeingDragged) {
                            SmartRefreshLayout.this.mTouchSpinner = SmartRefreshLayout.this.mSpinner - offset;
                            SmartRefreshLayout.this.mTouchY = SmartRefreshLayout.this.mLastTouchY;
                            SmartRefreshLayout.this.mIsBeingDragged = false;
                            long time = System.currentTimeMillis();
                            SmartRefreshLayout.super.dispatchTouchEvent(MotionEvent.obtain((long)time, (long)time, (int)0, (float)SmartRefreshLayout.this.mLastTouchX, (float)(SmartRefreshLayout.this.mTouchY + (float)offset + (float)(SmartRefreshLayout.this.mTouchSlop * 2)), (int)0));
                            SmartRefreshLayout.super.dispatchTouchEvent(MotionEvent.obtain((long)time, (long)time, (int)2, (float)SmartRefreshLayout.this.mLastTouchX, (float)(SmartRefreshLayout.this.mTouchY + (float)offset), (int)0));
                        }
                        SmartRefreshLayout.this.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                ValueAnimator.AnimatorUpdateListener updateListener = null;
                                if (SmartRefreshLayout.this.mEnableScrollContentWhenLoaded && offset < 0) {
                                    updateListener = SmartRefreshLayout.this.mRefreshContent.scrollContentWhenFinished(SmartRefreshLayout.this.mSpinner);
                                }
                                if (updateListener != null) {
                                    updateListener.onAnimationUpdate(ValueAnimator.ofInt((int[])new int[]{0, 0}));
                                }
                                ValueAnimator animator = null;
                                AnimatorListenerAdapter listenerAdapter = new AnimatorListenerAdapter(){

                                    public void onAnimationCancel(Animator animation) {
                                        super.onAnimationEnd(animation);
                                    }

                                    public void onAnimationEnd(Animator animation) {
                                        SmartRefreshLayout.this.mFooterLocked = false;
                                        if (noMoreData) {
                                            SmartRefreshLayout.this.setNoMoreData(true);
                                        }
                                        if (SmartRefreshLayout.this.mState == RefreshState.LoadFinish) {
                                            SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
                                        }
                                    }
                                };
                                if (SmartRefreshLayout.this.mSpinner > 0) {
                                    animator = SmartRefreshLayout.this.animSpinner(0);
                                } else if (updateListener != null || SmartRefreshLayout.this.mSpinner == 0) {
                                    if (SmartRefreshLayout.this.reboundAnimator != null) {
                                        SmartRefreshLayout.this.reboundAnimator.cancel();
                                        SmartRefreshLayout.this.reboundAnimator = null;
                                    }
                                    SmartRefreshLayout.this.moveSpinner(0, true);
                                    SmartRefreshLayout.this.resetStatus();
                                } else if (noMoreData && SmartRefreshLayout.this.mEnableFooterFollowWhenLoadFinished) {
                                    if (SmartRefreshLayout.this.mSpinner >= -SmartRefreshLayout.this.mFooterHeight) {
                                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
                                    } else {
                                        animator = SmartRefreshLayout.this.animSpinner(-SmartRefreshLayout.this.mFooterHeight);
                                    }
                                } else {
                                    animator = SmartRefreshLayout.this.animSpinner(0);
                                }
                                if (animator != null) {
                                    animator.addListener((Animator.AnimatorListener)listenerAdapter);
                                } else {
                                    listenerAdapter.onAnimationEnd(null);
                                }
                            }
                        }, SmartRefreshLayout.this.mSpinner < 0 ? (long)startDelay : 0L);
                    }
                } else if (noMoreData) {
                    SmartRefreshLayout.this.setNoMoreData(true);
                }
            }
        }, delayed <= 0 ? 1L : (long)delayed);
        return this;
    }

    @Override
    public SmartRefreshLayout finishLoadMoreWithNoMoreData() {
        long passTime = System.currentTimeMillis() - this.mLastLoadingTime;
        return this.finishLoadMore(Math.max(0, 1000 - (int)passTime), true, true);
    }

    @Override
    public boolean isRefreshing() {
        return this.mState == RefreshState.Refreshing;
    }

    @Override
    public boolean isLoading() {
        return this.mState == RefreshState.Loading;
    }

    @Override
    public boolean autoRefresh() {
        return this.autoRefresh(this.mHandler == null ? 400 : 0);
    }

    @Override
    public boolean autoRefresh(int delayed) {
        return this.autoRefresh(delayed, this.mReboundDuration, 1.0f * (float)(this.mHeaderHeight + this.mHeaderExtendHeight / 2) / (float)(this.mHeaderHeight == 0 ? 1 : this.mHeaderHeight));
    }

    @Override
    public boolean autoRefresh(int delayed, final int duration, final float dragRate) {
        if (this.mState == RefreshState.None && this.isEnableRefresh()) {
            if (this.reboundAnimator != null) {
                this.reboundAnimator.cancel();
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SmartRefreshLayout.this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{SmartRefreshLayout.this.mSpinner, (int)((float)SmartRefreshLayout.this.mHeaderHeight * dragRate)});
                    SmartRefreshLayout.this.reboundAnimator.setDuration((long)duration);
                    SmartRefreshLayout.this.reboundAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                    SmartRefreshLayout.this.reboundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            SmartRefreshLayout.this.moveSpinner((Integer)animation.getAnimatedValue(), false);
                        }
                    });
                    SmartRefreshLayout.this.reboundAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationStart(Animator animation) {
                            SmartRefreshLayout.this.mLastTouchX = SmartRefreshLayout.this.getMeasuredWidth() / 2;
                            SmartRefreshLayout.this.mKernel.setState(RefreshState.PullDownToRefresh);
                        }

                        public void onAnimationEnd(Animator animation) {
                            SmartRefreshLayout.this.reboundAnimator = null;
                            if (SmartRefreshLayout.this.mState != RefreshState.ReleaseToRefresh) {
                                SmartRefreshLayout.this.mKernel.setState(RefreshState.ReleaseToRefresh);
                            }
                            SmartRefreshLayout.this.overSpinner();
                        }
                    });
                    SmartRefreshLayout.this.reboundAnimator.start();
                }
            };
            if (delayed > 0) {
                this.reboundAnimator = new ValueAnimator();
                this.postDelayed(runnable, delayed);
            } else {
                runnable.run();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean autoLoadMore() {
        return this.autoLoadMore(0);
    }

    @Override
    public boolean autoLoadMore(int delayed) {
        return this.autoLoadMore(delayed, this.mReboundDuration, 1.0f * (float)(this.mFooterHeight + this.mFooterExtendHeight / 2) / (float)(this.mFooterHeight == 0 ? 1 : this.mFooterHeight));
    }

    @Override
    public boolean autoLoadMore(int delayed, final int duration, final float dragRate) {
        if (this.mState == RefreshState.None && this.isEnableLoadMore() && !this.mFooterNoMoreData) {
            if (this.reboundAnimator != null) {
                this.reboundAnimator.cancel();
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SmartRefreshLayout.this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{SmartRefreshLayout.this.mSpinner, -((int)((float)SmartRefreshLayout.this.mFooterHeight * dragRate))});
                    SmartRefreshLayout.this.reboundAnimator.setDuration((long)duration);
                    SmartRefreshLayout.this.reboundAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                    SmartRefreshLayout.this.reboundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            SmartRefreshLayout.this.moveSpinner((Integer)animation.getAnimatedValue(), false);
                        }
                    });
                    SmartRefreshLayout.this.reboundAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationStart(Animator animation) {
                            SmartRefreshLayout.this.mLastTouchX = SmartRefreshLayout.this.getMeasuredWidth() / 2;
                            SmartRefreshLayout.this.mKernel.setState(RefreshState.PullUpToLoad);
                        }

                        public void onAnimationEnd(Animator animation) {
                            SmartRefreshLayout.this.reboundAnimator = null;
                            if (SmartRefreshLayout.this.mState != RefreshState.ReleaseToLoad) {
                                SmartRefreshLayout.this.mKernel.setState(RefreshState.ReleaseToLoad);
                            }
                            if (SmartRefreshLayout.this.mEnableAutoLoadMore) {
                                SmartRefreshLayout.this.mEnableAutoLoadMore = false;
                                SmartRefreshLayout.this.overSpinner();
                                SmartRefreshLayout.this.mEnableAutoLoadMore = true;
                            } else {
                                SmartRefreshLayout.this.overSpinner();
                            }
                        }
                    });
                    SmartRefreshLayout.this.reboundAnimator.start();
                }
            };
            if (delayed > 0) {
                this.reboundAnimator = new ValueAnimator();
                this.postDelayed(runnable, delayed);
            } else {
                runnable.run();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnableRefresh() {
        return this.mEnableRefresh && !this.mEnablePureScrollMode;
    }

    @Override
    public boolean isEnableLoadMore() {
        return this.mEnableLoadMore && !this.mEnablePureScrollMode;
    }

    public static void setDefaultRefreshHeaderCreator(@NonNull DefaultRefreshHeaderCreator creator) {
        sHeaderCreator = creator;
    }

    public static void setDefaultRefreshFooterCreator(@NonNull DefaultRefreshFooterCreator creator) {
        sFooterCreator = creator;
        sManualFooterCreator = true;
    }

    @Override
    @Deprecated
    public SmartRefreshLayout resetNoMoreData() {
        return this.setNoMoreData(false);
    }

    @Override
    @Deprecated
    public SmartRefreshLayout setLoadmoreFinished(boolean finished) {
        return this.setNoMoreData(finished);
    }

    @Override
    @Deprecated
    public SmartRefreshLayout finishLoadmore() {
        return this.finishLoadMore();
    }

    @Override
    @Deprecated
    public SmartRefreshLayout finishLoadmore(int delayed) {
        return this.finishLoadMore(delayed);
    }

    @Override
    @Deprecated
    public SmartRefreshLayout finishLoadmore(boolean success) {
        return this.finishLoadMore(success);
    }

    @Override
    @Deprecated
    public SmartRefreshLayout finishLoadmoreWithNoMoreData() {
        return this.finishLoadMoreWithNoMoreData();
    }

    @Override
    @Deprecated
    public boolean isLoadmoreFinished() {
        return this.mFooterNoMoreData;
    }

    @Override
    @Deprecated
    public boolean isEnableAutoLoadMore() {
        return this.mEnableAutoLoadMore;
    }

    @Override
    @Deprecated
    public boolean isEnableOverScrollBounce() {
        return this.mEnableOverScrollBounce;
    }

    @Override
    @Deprecated
    public boolean isEnablePureScrollMode() {
        return this.mEnablePureScrollMode;
    }

    @Override
    @Deprecated
    public boolean isEnableScrollContentWhenLoaded() {
        return this.mEnableScrollContentWhenLoaded;
    }

    @Override
    @Deprecated
    public SmartRefreshLayout setOnLoadmoreListener(final OnLoadmoreListener listener) {
        return this.setOnLoadMoreListener(new OnLoadMoreListener(){

            @Override
            public void onLoadMore(RefreshLayout refreshLayout) {
                listener.onLoadmore(refreshLayout);
            }
        });
    }

    @Override
    @Deprecated
    public SmartRefreshLayout setOnRefreshLoadmoreListener(final OnRefreshLoadmoreListener listener) {
        return this.setOnRefreshLoadMoreListener(new OnRefreshLoadMoreListener(){

            @Override
            public void onLoadMore(RefreshLayout refreshLayout) {
                listener.onLoadmore(refreshLayout);
            }

            @Override
            public void onRefresh(RefreshLayout refreshLayout) {
                listener.onRefresh(refreshLayout);
            }
        });
    }

    @Deprecated
    public static void setDefaultRefreshHeaderCreater(@NonNull DefaultRefreshHeaderCreater creator) {
        sHeaderCreator = creator;
    }

    @Deprecated
    public static void setDefaultRefreshFooterCreater(@NonNull DefaultRefreshFooterCreater creator) {
        sFooterCreator = creator;
        sManualFooterCreator = true;
    }

    public boolean post(@NonNull Runnable action) {
        if (this.mHandler == null) {
            this.mDelayedRunnables = this.mDelayedRunnables == null ? new ArrayList() : this.mDelayedRunnables;
            this.mDelayedRunnables.add(new DelayedRunnable(action));
            return false;
        }
        return this.mHandler.post((Runnable)new DelayedRunnable(action));
    }

    public boolean postDelayed(@NonNull Runnable action, long delayMillis) {
        if (delayMillis == 0L) {
            new DelayedRunnable(action).run();
            return true;
        }
        if (this.mHandler == null) {
            this.mDelayedRunnables = this.mDelayedRunnables == null ? new ArrayList() : this.mDelayedRunnables;
            this.mDelayedRunnables.add(new DelayedRunnable(action, delayMillis));
            return false;
        }
        return this.mHandler.postDelayed((Runnable)new DelayedRunnable(action), delayMillis);
    }

    public class RefreshKernelImpl
    implements RefreshKernel {
        @Override
        @NonNull
        public RefreshLayout getRefreshLayout() {
            return SmartRefreshLayout.this;
        }

        @Override
        @NonNull
        public RefreshContent getRefreshContent() {
            return SmartRefreshLayout.this.mRefreshContent;
        }

        @Override
        public RefreshKernel setState(@NonNull RefreshState state) {
            switch (state) {
                case None: {
                    SmartRefreshLayout.this.resetStatus();
                    break;
                }
                case PullDownToRefresh: {
                    if (!SmartRefreshLayout.this.mState.opening && SmartRefreshLayout.this.isEnableRefresh()) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.PullDownToRefresh);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.PullDownToRefresh);
                    break;
                }
                case PullUpToLoad: {
                    if (!(!SmartRefreshLayout.this.isEnableLoadMore() || SmartRefreshLayout.this.mState.opening || SmartRefreshLayout.this.mState.finishing || SmartRefreshLayout.this.mFooterNoMoreData && SmartRefreshLayout.this.mEnableFooterFollowWhenLoadFinished)) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.PullUpToLoad);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.PullUpToLoad);
                    break;
                }
                case PullDownCanceled: {
                    if (!SmartRefreshLayout.this.mState.opening && SmartRefreshLayout.this.isEnableRefresh()) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.PullDownCanceled);
                        SmartRefreshLayout.this.resetStatus();
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.PullDownCanceled);
                    break;
                }
                case PullUpCanceled: {
                    if (!(!SmartRefreshLayout.this.isEnableLoadMore() || SmartRefreshLayout.this.mState.opening || SmartRefreshLayout.this.mFooterNoMoreData && SmartRefreshLayout.this.mEnableFooterFollowWhenLoadFinished)) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.PullUpCanceled);
                        SmartRefreshLayout.this.resetStatus();
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.PullUpCanceled);
                    break;
                }
                case ReleaseToRefresh: {
                    if (!SmartRefreshLayout.this.mState.opening && SmartRefreshLayout.this.isEnableRefresh()) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.ReleaseToRefresh);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.ReleaseToRefresh);
                    break;
                }
                case ReleaseToLoad: {
                    if (!(!SmartRefreshLayout.this.isEnableLoadMore() || SmartRefreshLayout.this.mState.opening || SmartRefreshLayout.this.mState.finishing || SmartRefreshLayout.this.mFooterNoMoreData && SmartRefreshLayout.this.mEnableFooterFollowWhenLoadFinished)) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.ReleaseToLoad);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.ReleaseToLoad);
                    break;
                }
                case ReleaseToTwoLevel: {
                    if (!SmartRefreshLayout.this.mState.opening && SmartRefreshLayout.this.isEnableRefresh()) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.ReleaseToTwoLevel);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.ReleaseToTwoLevel);
                    break;
                }
                case RefreshReleased: {
                    if (!SmartRefreshLayout.this.mState.opening && SmartRefreshLayout.this.isEnableRefresh()) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.RefreshReleased);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.RefreshReleased);
                    break;
                }
                case LoadReleased: {
                    if (!SmartRefreshLayout.this.mState.opening && SmartRefreshLayout.this.isEnableLoadMore()) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.LoadReleased);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.LoadReleased);
                    break;
                }
                case Refreshing: {
                    SmartRefreshLayout.this.setStateRefreshing();
                    break;
                }
                case Loading: {
                    SmartRefreshLayout.this.setStateLoading();
                    break;
                }
                case RefreshFinish: {
                    if (SmartRefreshLayout.this.mState != RefreshState.Refreshing) break;
                    SmartRefreshLayout.this.notifyStateChanged(RefreshState.RefreshFinish);
                    break;
                }
                case LoadFinish: {
                    if (SmartRefreshLayout.this.mState != RefreshState.Loading) break;
                    SmartRefreshLayout.this.notifyStateChanged(RefreshState.LoadFinish);
                    break;
                }
                case TwoLevelReleased: {
                    SmartRefreshLayout.this.notifyStateChanged(RefreshState.TwoLevelReleased);
                    break;
                }
                case TwoLevelFinish: {
                    SmartRefreshLayout.this.notifyStateChanged(RefreshState.TwoLevelFinish);
                    break;
                }
                case TwoLevel: {
                    SmartRefreshLayout.this.notifyStateChanged(RefreshState.TwoLevel);
                }
            }
            return null;
        }

        @Override
        public RefreshKernel startTwoLevel(boolean open) {
            if (open) {
                AnimatorListenerAdapter listener = new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        SmartRefreshLayout.this.mKernel.setState(RefreshState.TwoLevel);
                    }
                };
                ValueAnimator animator = SmartRefreshLayout.this.animSpinner(SmartRefreshLayout.this.getMeasuredHeight());
                if (animator != null && animator == SmartRefreshLayout.this.reboundAnimator) {
                    animator.setDuration((long)SmartRefreshLayout.this.mFloorDuration);
                    animator.addListener((Animator.AnimatorListener)listener);
                } else {
                    listener.onAnimationEnd(null);
                }
            } else if (this.animSpinner(0) == null) {
                SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
            }
            return this;
        }

        @Override
        public RefreshKernel finishTwoLevel() {
            if (SmartRefreshLayout.this.mState == RefreshState.TwoLevel) {
                SmartRefreshLayout.this.mKernel.setState(RefreshState.TwoLevelFinish);
                if (SmartRefreshLayout.this.mSpinner == 0) {
                    this.moveSpinner(0, true);
                    SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
                } else {
                    SmartRefreshLayout.this.animSpinner(0).setDuration((long)SmartRefreshLayout.this.mFloorDuration);
                }
            }
            return this;
        }

        @Override
        public RefreshKernel moveSpinner(int spinner, boolean isAnimator) {
            SmartRefreshLayout.this.moveSpinner(spinner, isAnimator);
            return this;
        }

        @Override
        public RefreshKernel animSpinner(int endSpinner) {
            SmartRefreshLayout.this.animSpinner(endSpinner);
            return this;
        }

        @Override
        public RefreshKernel requestDrawBackgroundForHeader(int backgroundColor) {
            if (SmartRefreshLayout.this.mPaint == null && backgroundColor != 0) {
                SmartRefreshLayout.this.mPaint = new Paint();
            }
            SmartRefreshLayout.this.mHeaderBackgroundColor = backgroundColor;
            return this;
        }

        @Override
        public RefreshKernel requestDrawBackgroundForFooter(int backgroundColor) {
            if (SmartRefreshLayout.this.mPaint == null && backgroundColor != 0) {
                SmartRefreshLayout.this.mPaint = new Paint();
            }
            SmartRefreshLayout.this.mFooterBackgroundColor = backgroundColor;
            return this;
        }

        @Override
        public RefreshKernel requestNeedTouchEventWhenRefreshing(boolean request) {
            SmartRefreshLayout.this.mHeaderNeedTouchEventWhenRefreshing = request;
            return this;
        }

        @Override
        public RefreshKernel requestNeedTouchEventWhenLoading(boolean request) {
            SmartRefreshLayout.this.mFooterNeedTouchEventWhenLoading = request;
            return this;
        }

        @Override
        public RefreshKernel requestDefaultHeaderTranslationContent(boolean translation) {
            if (!SmartRefreshLayout.this.mManualHeaderTranslationContent) {
                SmartRefreshLayout.this.mManualHeaderTranslationContent = true;
                SmartRefreshLayout.this.mEnableHeaderTranslationContent = translation;
            }
            return this;
        }

        @Override
        public RefreshKernel requestRemeasureHeightForHeader() {
            if (SmartRefreshLayout.this.mHeaderHeightStatus.notified) {
                SmartRefreshLayout.this.mHeaderHeightStatus = SmartRefreshLayout.this.mHeaderHeightStatus.unNotify();
            }
            return this;
        }

        @Override
        public RefreshKernel requestRemeasureHeightForFooter() {
            if (SmartRefreshLayout.this.mFooterHeightStatus.notified) {
                SmartRefreshLayout.this.mFooterHeightStatus = SmartRefreshLayout.this.mFooterHeightStatus.unNotify();
            }
            return this;
        }

        @Override
        public RefreshKernel requestFloorDuration(int duration) {
            SmartRefreshLayout.this.mFloorDuration = duration;
            return this;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int backgroundColor = 0;
        public SpinnerStyle spinnerStyle = null;

        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SmartRefreshLayout_Layout);
            this.backgroundColor = ta.getColor(R.styleable.SmartRefreshLayout_Layout_layout_srlBackgroundColor, this.backgroundColor);
            if (ta.hasValue(R.styleable.SmartRefreshLayout_Layout_layout_srlSpinnerStyle)) {
                this.spinnerStyle = SpinnerStyle.values()[ta.getInt(R.styleable.SmartRefreshLayout_Layout_layout_srlSpinnerStyle, SpinnerStyle.Translate.ordinal())];
            }
            ta.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    protected class BounceRunnable
    implements Runnable {
        int mFrame = 0;
        int mFrameDelay = 10;
        int mSmoothDistance;
        long mLastTime;
        float mOffset = 0.0f;
        float mVelocity;

        BounceRunnable(float velocity, int smoothDistance) {
            this.mVelocity = velocity;
            this.mSmoothDistance = smoothDistance;
            this.mLastTime = AnimationUtils.currentAnimationTimeMillis();
            SmartRefreshLayout.this.postDelayed(this, this.mFrameDelay);
        }

        @Override
        public void run() {
            if (SmartRefreshLayout.this.animationRunnable == this && !SmartRefreshLayout.this.mState.finishing) {
                this.mVelocity = Math.abs(SmartRefreshLayout.this.mSpinner) >= Math.abs(this.mSmoothDistance) ? (this.mSmoothDistance != 0 ? (float)((double)this.mVelocity * Math.pow(0.45f, ++this.mFrame)) : (float)((double)this.mVelocity * Math.pow(0.85f, ++this.mFrame))) : (float)((double)this.mVelocity * Math.pow(0.95f, ++this.mFrame));
                long now = AnimationUtils.currentAnimationTimeMillis();
                float t = 1.0f * (float)(now - this.mLastTime) / 1000.0f;
                float velocity = this.mVelocity * t;
                if (Math.abs(velocity) >= 1.0f) {
                    this.mLastTime = now;
                    this.mOffset += velocity;
                    SmartRefreshLayout.this.moveSpinnerInfinitely(this.mOffset);
                    SmartRefreshLayout.this.postDelayed(this, this.mFrameDelay);
                } else {
                    SmartRefreshLayout.this.animationRunnable = null;
                    if (Math.abs(SmartRefreshLayout.this.mSpinner) >= Math.abs(this.mSmoothDistance)) {
                        int duration = 10 * Math.min(Math.max((int)DensityUtil.px2dp(Math.abs(SmartRefreshLayout.this.mSpinner - this.mSmoothDistance)), 30), 100);
                        SmartRefreshLayout.this.animSpinner(this.mSmoothDistance, 0, SmartRefreshLayout.this.mReboundInterpolator, duration);
                    }
                }
            }
        }
    }

    protected class FlingRunnable
    implements Runnable {
        int mOffset;
        int mFrame = 0;
        int mFrameDelay = 10;
        float mVelocity;
        float mDamping = 0.95f;
        long mLastTime = AnimationUtils.currentAnimationTimeMillis();

        FlingRunnable(float velocity) {
            this.mVelocity = velocity;
            this.mOffset = SmartRefreshLayout.this.mSpinner;
        }

        public Runnable start() {
            if (SmartRefreshLayout.this.mState.finishing) {
                return null;
            }
            if (SmartRefreshLayout.this.mSpinner != 0 && (!SmartRefreshLayout.this.mState.opening && (!SmartRefreshLayout.this.mFooterNoMoreData || !SmartRefreshLayout.this.mEnableFooterFollowWhenLoadFinished || !SmartRefreshLayout.this.isEnableLoadMore()) || (SmartRefreshLayout.this.mState == RefreshState.Loading || SmartRefreshLayout.this.mFooterNoMoreData && SmartRefreshLayout.this.mEnableFooterFollowWhenLoadFinished && SmartRefreshLayout.this.isEnableLoadMore()) && SmartRefreshLayout.this.mSpinner < -SmartRefreshLayout.this.mFooterHeight || SmartRefreshLayout.this.mState == RefreshState.Refreshing && SmartRefreshLayout.this.mSpinner > SmartRefreshLayout.this.mHeaderHeight)) {
                int frame = 0;
                int offset = SmartRefreshLayout.this.mSpinner;
                int spinner = SmartRefreshLayout.this.mSpinner;
                float velocity = this.mVelocity;
                while (spinner * offset > 0) {
                    float velocityFrame;
                    if (Math.abs(velocityFrame = (velocity = (float)((double)velocity * Math.pow(this.mDamping, ++frame))) * (1.0f * (float)this.mFrameDelay / 1000.0f)) < 1.0f) {
                        if (SmartRefreshLayout.this.mState.opening && (SmartRefreshLayout.this.mState != RefreshState.Refreshing || offset <= SmartRefreshLayout.this.mHeaderHeight) && (SmartRefreshLayout.this.mState == RefreshState.Refreshing || offset >= -SmartRefreshLayout.this.mFooterHeight)) break;
                        return null;
                    }
                    offset = (int)((float)offset + velocityFrame);
                }
            }
            SmartRefreshLayout.this.postDelayed(this, this.mFrameDelay);
            return this;
        }

        @Override
        public void run() {
            if (SmartRefreshLayout.this.animationRunnable == this && !SmartRefreshLayout.this.mState.finishing) {
                this.mVelocity = (float)((double)this.mVelocity * Math.pow(this.mDamping, ++this.mFrame));
                long now = AnimationUtils.currentAnimationTimeMillis();
                long span = now - this.mLastTime;
                float velocity = this.mVelocity * (1.0f * (float)span / 1000.0f);
                if (Math.abs(velocity) > 1.0f) {
                    this.mLastTime = now;
                    this.mOffset = (int)((float)this.mOffset + velocity);
                    if (SmartRefreshLayout.this.mSpinner * this.mOffset > 0) {
                        SmartRefreshLayout.this.moveSpinner(this.mOffset, false);
                        SmartRefreshLayout.this.postDelayed(this, this.mFrameDelay);
                    } else {
                        SmartRefreshLayout.this.animationRunnable = null;
                        SmartRefreshLayout.this.moveSpinner(0, false);
                        SmartRefreshLayout.this.mRefreshContent.fling((int)(-this.mVelocity));
                        if (SmartRefreshLayout.this.mFooterLocked && velocity > 0.0f) {
                            SmartRefreshLayout.this.mFooterLocked = false;
                        }
                    }
                } else {
                    SmartRefreshLayout.this.animationRunnable = null;
                }
            }
        }
    }
}

