package com.scwang.smartrefresh.layout.header.bezierradar;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;

/**
 * Created by cjj on 2015/8/5.
 * 绘制贝塞尔来绘制波浪形
 */
public class WaveView extends View {

    private int waveHeight;
    private int height;
    private Path path;
    private Paint paint;
    private int mOffsetX = -1;

    public WaveView(Context context) {
        this(context, null, 0);
    }

    public WaveView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WaveView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView();
    }

    private void initView() {
        path = new Path();
        paint = new Paint();
        paint.setColor(0xff1F2426);
        paint.setAntiAlias(true);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        setMeasuredDimension(resolveSize(getSuggestedMinimumWidth(), widthMeasureSpec),
                resolveSize(getSuggestedMinimumHeight(), heightMeasureSpec));
    }

    public void setWaveColor(@ColorInt int color) {
        paint.setColor(color);
    }

    public int getHeadHeight() {
        return height;
    }

    public void setHeadHeight(int height) {
        this.height = height;
    }

    public int getWaveHeight() {
        return waveHeight;
    }

    public void setWaveHeight(int waveHeight) {
        this.waveHeight = waveHeight;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        final int width = getWidth();
        //重置画笔
        path.reset();
        //绘制贝塞尔曲线
        path.lineTo(0, height);
        path.quadTo(mOffsetX >= 0 ? (mOffsetX) : width / 2, height + waveHeight, width, height);
        path.lineTo(width, 0);
        canvas.drawPath(path, paint);
    }

    public void setWaveOffsetX(int offset) {
        mOffsetX = offset;
    }
}
