/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.waterdrop;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.ColorInt;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.scwang.smartrefresh.header.waterdrop.Circle;
import com.scwang.smartrefresh.layout.util.SmartUtil;

public class WaterDropView
extends View {
    protected Circle topCircle;
    protected Circle bottomCircle;
    protected Path mPath;
    protected Paint mPaint;
    protected int mMaxCircleRadius;
    protected int mMinCircleRadius;
    protected static int STROKE_WIDTH = 2;
    protected static final int BACK_ANIM_DURATION = 180;

    public WaterDropView(Context context) {
        super(context);
        WaterDropView thisView = this;
        this.topCircle = new Circle();
        this.bottomCircle = new Circle();
        this.mPath = new Path();
        this.mPaint = new Paint();
        this.mPaint.setColor(-7829368);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        STROKE_WIDTH = SmartUtil.dp2px((float)1.0f);
        this.mPaint.setStrokeWidth((float)STROKE_WIDTH);
        this.mPaint.setShadowLayer((float)STROKE_WIDTH, (float)STROKE_WIDTH / 2.0f, (float)STROKE_WIDTH, -1728053248);
        thisView.setLayerType(1, null);
        int padding = 4 * STROKE_WIDTH;
        thisView.setPadding(padding, padding, padding, padding);
        this.mPaint.setColor(-7829368);
        this.mMaxCircleRadius = SmartUtil.dp2px((float)20.0f);
        this.mMinCircleRadius = this.mMaxCircleRadius / 5;
        this.topCircle.radius = this.mMaxCircleRadius;
        this.bottomCircle.radius = this.mMaxCircleRadius;
        this.topCircle.x = STROKE_WIDTH + this.mMaxCircleRadius;
        this.topCircle.y = STROKE_WIDTH + this.mMaxCircleRadius;
        this.bottomCircle.x = STROKE_WIDTH + this.mMaxCircleRadius;
        this.bottomCircle.y = STROKE_WIDTH + this.mMaxCircleRadius;
    }

    public int getMaxCircleRadius() {
        return this.mMaxCircleRadius;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        WaterDropView thisView = this;
        int width = (this.mMaxCircleRadius + STROKE_WIDTH) * 2;
        int height = (int)Math.ceil(this.bottomCircle.y + this.bottomCircle.radius + (float)(STROKE_WIDTH * 2));
        super.setMeasuredDimension(width + thisView.getPaddingLeft() + thisView.getPaddingRight(), View.resolveSize((int)(height + thisView.getPaddingTop() + thisView.getPaddingBottom()), (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        WaterDropView thisView = this;
        this.updateCompleteState(thisView.getHeight());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        WaterDropView thisView = this;
        int paddingTop = thisView.getPaddingTop();
        int paddingLeft = thisView.getPaddingLeft();
        int paddingBottom = thisView.getPaddingBottom();
        int height = thisView.getHeight();
        canvas.save();
        if ((float)height <= this.topCircle.radius * 2.0f + (float)paddingTop + (float)paddingBottom) {
            canvas.translate((float)paddingLeft, (float)height - this.topCircle.radius * 2.0f - (float)paddingBottom);
            canvas.drawCircle(this.topCircle.x, this.topCircle.y, this.topCircle.radius, this.mPaint);
        } else {
            canvas.translate((float)paddingLeft, (float)paddingTop);
            this.makeBezierPath();
            canvas.drawPath(this.mPath, this.mPaint);
        }
        canvas.restore();
    }

    protected void makeBezierPath() {
        this.mPath.reset();
        this.mPath.addCircle(this.topCircle.x, this.topCircle.y, this.topCircle.radius, Path.Direction.CCW);
        if (this.bottomCircle.y > this.topCircle.y + (float)SmartUtil.dp2px((float)1.0f)) {
            this.mPath.addCircle(this.bottomCircle.x, this.bottomCircle.y, this.bottomCircle.radius, Path.Direction.CCW);
            double angle = this.getAngle();
            float top_x1 = (float)((double)this.topCircle.x - (double)this.topCircle.radius * Math.cos(angle));
            float top_y1 = (float)((double)this.topCircle.y + (double)this.topCircle.radius * Math.sin(angle));
            float top_x2 = (float)((double)this.topCircle.x + (double)this.topCircle.radius * Math.cos(angle));
            float top_y2 = top_y1;
            float bottom_x1 = (float)((double)this.bottomCircle.x - (double)this.bottomCircle.radius * Math.cos(angle));
            float bottom_y1 = (float)((double)this.bottomCircle.y + (double)this.bottomCircle.radius * Math.sin(angle));
            float bottom_x2 = (float)((double)this.bottomCircle.x + (double)this.bottomCircle.radius * Math.cos(angle));
            float bottom_y2 = bottom_y1;
            this.mPath.moveTo(this.topCircle.x, this.topCircle.y);
            this.mPath.lineTo(top_x1, top_y1);
            this.mPath.quadTo(this.bottomCircle.x - this.bottomCircle.radius, (this.bottomCircle.y + this.topCircle.y) / 2.0f, bottom_x1, bottom_y1);
            this.mPath.lineTo(bottom_x2, bottom_y2);
            this.mPath.quadTo(this.bottomCircle.x + this.bottomCircle.radius, (this.bottomCircle.y + top_y2) / 2.0f, top_x2, top_y2);
        }
        this.mPath.close();
    }

    protected double getAngle() {
        if (this.bottomCircle.radius > this.topCircle.radius) {
            return 0.0;
        }
        return Math.asin((this.topCircle.radius - this.bottomCircle.radius) / (this.bottomCircle.y - this.topCircle.y));
    }

    public ValueAnimator createAnimator() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.001f}).setDuration(180L);
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator1) {
                WaterDropView.this.updateCompleteState(((Float)valueAnimator1.getAnimatedValue()).floatValue());
                WaterDropView thisView = WaterDropView.this;
                thisView.postInvalidate();
            }
        });
        return valueAnimator;
    }

    public void updateCompleteState(int offset, int maxHeight) {
    }

    public void updateCompleteState(float percent) {
        float top_r = (float)((double)this.mMaxCircleRadius - 0.25 * (double)percent * (double)this.mMaxCircleRadius);
        float bottom_r = (float)(this.mMinCircleRadius - this.mMaxCircleRadius) * percent + (float)this.mMaxCircleRadius;
        float bottomCircleOffset = 4.0f * percent * (float)this.mMaxCircleRadius;
        this.topCircle.radius = top_r;
        this.bottomCircle.radius = bottom_r;
        this.bottomCircle.y = this.topCircle.y + bottomCircleOffset;
    }

    public void updateCompleteState(int height) {
        int paddingBottom;
        WaterDropView thisView = this;
        int paddingTop = thisView.getPaddingTop();
        float space = this.mMaxCircleRadius * 2 + paddingTop + (paddingBottom = thisView.getPaddingBottom());
        if ((float)height < space) {
            this.topCircle.radius = this.mMaxCircleRadius;
            this.bottomCircle.radius = this.mMaxCircleRadius;
            this.bottomCircle.y = this.topCircle.y;
        } else {
            float limit = this.mMaxCircleRadius - this.mMinCircleRadius;
            float x = Math.max(0.0f, (float)height - space);
            float y = (float)((double)limit * (1.0 - Math.pow(100.0, -x / (float)SmartUtil.dp2px((float)200.0f))));
            this.topCircle.radius = (float)this.mMaxCircleRadius - y / 4.0f;
            this.bottomCircle.radius = (float)this.mMaxCircleRadius - y;
            int validHeight = height - paddingTop - paddingBottom;
            this.bottomCircle.y = (float)validHeight - this.bottomCircle.radius;
        }
    }

    public Circle getTopCircle() {
        return this.topCircle;
    }

    public Circle getBottomCircle() {
        return this.bottomCircle;
    }

    public void setIndicatorColor(@ColorInt int color) {
        this.mPaint.setColor(color);
    }

    public int getIndicatorColor() {
        return this.mPaint.getColor();
    }
}

