/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.fungame;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.scwang.smartrefresh.layout.api.RefreshContent;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshInternal;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.internal.InternalAbstract;
import com.scwang.smartrefresh.layout.util.SmartUtil;

@SuppressLint(value={"RestrictedApi"})
public abstract class FunGameBase
extends InternalAbstract
implements RefreshHeader {
    protected int mOffset;
    protected int mHeaderHeight;
    protected int mScreenHeightPixels;
    protected float mTouchY;
    protected boolean mIsFinish;
    protected boolean mLastFinish;
    protected boolean mManualOperation;
    protected RefreshState mState;
    protected RefreshKernel mRefreshKernel;
    protected RefreshContent mRefreshContent;

    public FunGameBase(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        FunGameBase thisView = this;
        thisView.setMinimumHeight(SmartUtil.dp2px((float)100.0f));
        this.mScreenHeightPixels = thisView.getResources().getDisplayMetrics().heightPixels;
        this.mSpinnerStyle = SpinnerStyle.MatchLayout;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mState == RefreshState.Refreshing || super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mState == RefreshState.Refreshing || this.mState == RefreshState.RefreshFinish) {
            if (!this.mManualOperation) {
                this.onManualOperationStart();
            }
            switch (event.getAction() & 0xFF) {
                case 0: {
                    this.mTouchY = event.getRawY();
                    this.mRefreshKernel.moveSpinner(0, true);
                    break;
                }
                case 2: {
                    float dy = event.getRawY() - this.mTouchY;
                    if (dy >= 0.0f) {
                        double M = this.mHeaderHeight * 2;
                        double H = (float)(this.mScreenHeightPixels * 2) / 3.0f;
                        double x = Math.max(0.0, (double)dy * 0.5);
                        double y = Math.min(M * (1.0 - Math.pow(100.0, -x / H)), x);
                        this.mRefreshKernel.moveSpinner(Math.max(1, (int)y), false);
                        break;
                    }
                    this.mRefreshKernel.moveSpinner(1, false);
                    break;
                }
                case 1: 
                case 3: {
                    this.onManualOperationRelease();
                    this.mTouchY = -1.0f;
                    if (!this.mIsFinish) break;
                    this.mRefreshKernel.moveSpinner(this.mHeaderHeight, true);
                }
            }
            return true;
        }
        return super.onTouchEvent(event);
    }

    protected void onManualOperationStart() {
        if (!this.mManualOperation) {
            this.mManualOperation = true;
            this.mRefreshContent = this.mRefreshKernel.getRefreshContent();
            View contentView = this.mRefreshContent.getView();
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)contentView.getLayoutParams();
            params.topMargin += this.mHeaderHeight;
            contentView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    protected abstract void onManualOperationMove(float var1, int var2, int var3, int var4);

    protected void onManualOperationRelease() {
        if (this.mIsFinish) {
            this.mManualOperation = false;
            if (this.mTouchY != -1.0f) {
                this.onFinish(this.mRefreshKernel.getRefreshLayout(), this.mLastFinish);
                this.mRefreshKernel.setState(RefreshState.RefreshFinish);
                this.mRefreshKernel.animSpinner(0);
            } else {
                this.mRefreshKernel.moveSpinner(this.mHeaderHeight, true);
            }
            View contentView = this.mRefreshContent.getView();
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)contentView.getLayoutParams();
            params.topMargin -= this.mHeaderHeight;
            contentView.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            this.mRefreshKernel.moveSpinner(0, true);
        }
    }

    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        if (this.mManualOperation) {
            this.onManualOperationMove(percent, offset, height, maxDragHeight);
        } else {
            this.mOffset = offset;
            FunGameBase thisView = this;
            thisView.setTranslationY(this.mOffset - this.mHeaderHeight);
        }
    }

    public void onStartAnimator(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        this.mIsFinish = false;
        FunGameBase thisView = this;
        thisView.setTranslationY(0.0f);
    }

    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        this.mState = newState;
    }

    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        this.mRefreshKernel = kernel;
        this.mHeaderHeight = height;
        FunGameBase thisView = this;
        if (!thisView.isInEditMode()) {
            thisView.setTranslationY(this.mOffset - this.mHeaderHeight);
            kernel.requestNeedTouchEventFor((RefreshInternal)this, true);
        }
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        this.mLastFinish = success;
        if (!this.mIsFinish) {
            this.mIsFinish = true;
            if (this.mManualOperation) {
                if (this.mTouchY == -1.0f) {
                    this.onManualOperationRelease();
                    this.onFinish(layout, success);
                    return 0;
                }
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }
}

