/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.waterdrop;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.scwang.smartrefresh.header.waterdrop.Circle;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class WaterDropView
extends View {
    private Circle topCircle;
    private Circle bottomCircle;
    private Path mPath;
    private Paint mPaint;
    private int mMaxCircleRadius;
    private int mMinCircleRadius;
    private static int STROKE_WIDTH = 2;
    private static final int BACK_ANIM_DURATION = 180;

    public WaterDropView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public WaterDropView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public WaterDropView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        this.topCircle = new Circle();
        this.bottomCircle = new Circle();
        this.mPath = new Path();
        this.mPaint = new Paint();
        this.mPaint.setColor(-7829368);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        STROKE_WIDTH = DensityUtil.dp2px((float)1.0f);
        this.mPaint.setStrokeWidth((float)STROKE_WIDTH);
        this.mPaint.setShadowLayer((float)STROKE_WIDTH, (float)(STROKE_WIDTH / 2), (float)STROKE_WIDTH, -1728053248);
        this.setLayerType(1, null);
        int padding = 4 * STROKE_WIDTH;
        this.setPadding(padding, padding, padding, padding);
        this.mMaxCircleRadius = DensityUtil.dp2px((float)20.0f);
        this.mMinCircleRadius = this.mMaxCircleRadius / 5;
        this.topCircle.radius = this.mMaxCircleRadius;
        this.bottomCircle.radius = this.mMaxCircleRadius;
        this.topCircle.x = STROKE_WIDTH + this.mMaxCircleRadius;
        this.topCircle.y = STROKE_WIDTH + this.mMaxCircleRadius;
        this.bottomCircle.x = STROKE_WIDTH + this.mMaxCircleRadius;
        this.bottomCircle.y = STROKE_WIDTH + this.mMaxCircleRadius;
    }

    public int getMaxCircleRadius() {
        return this.mMaxCircleRadius;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = (this.mMaxCircleRadius + STROKE_WIDTH) * 2;
        int height = (int)Math.ceil(this.bottomCircle.y + this.bottomCircle.radius + (float)(STROKE_WIDTH * 2));
        this.setMeasuredDimension(width + this.getPaddingLeft() + this.getPaddingRight(), WaterDropView.resolveSize((int)(height + this.getPaddingTop() + this.getPaddingBottom()), (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.updateCompleteState(this.getHeight());
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int paddingTop = this.getPaddingTop();
        int paddingLeft = this.getPaddingLeft();
        int paddingBottom = this.getPaddingBottom();
        int height = this.getHeight();
        canvas.save();
        if ((float)height <= this.topCircle.radius * 2.0f + (float)paddingTop + (float)paddingBottom) {
            canvas.translate((float)paddingLeft, (float)height - this.topCircle.radius * 2.0f - (float)paddingBottom);
            canvas.drawCircle(this.topCircle.x, this.topCircle.y, this.topCircle.radius, this.mPaint);
        } else {
            canvas.translate((float)paddingLeft, (float)paddingTop);
            this.makeBezierPath();
            canvas.drawPath(this.mPath, this.mPaint);
        }
        canvas.restore();
    }

    private void makeBezierPath() {
        this.mPath.reset();
        this.mPath.addCircle(this.topCircle.x, this.topCircle.y, this.topCircle.radius, Path.Direction.CCW);
        if (this.bottomCircle.y > this.topCircle.y + (float)DensityUtil.dp2px((float)1.0f)) {
            this.mPath.addCircle(this.bottomCircle.x, this.bottomCircle.y, this.bottomCircle.radius, Path.Direction.CCW);
            double angle = this.getAngle();
            float top_x1 = (float)((double)this.topCircle.x - (double)this.topCircle.radius * Math.cos(angle));
            float top_y1 = (float)((double)this.topCircle.y + (double)this.topCircle.radius * Math.sin(angle));
            float top_x2 = (float)((double)this.topCircle.x + (double)this.topCircle.radius * Math.cos(angle));
            float top_y2 = top_y1;
            float bottom_x1 = (float)((double)this.bottomCircle.x - (double)this.bottomCircle.radius * Math.cos(angle));
            float bottom_y1 = (float)((double)this.bottomCircle.y + (double)this.bottomCircle.radius * Math.sin(angle));
            float bottom_x2 = (float)((double)this.bottomCircle.x + (double)this.bottomCircle.radius * Math.cos(angle));
            float bottom_y2 = bottom_y1;
            this.mPath.moveTo(this.topCircle.x, this.topCircle.y);
            this.mPath.lineTo(top_x1, top_y1);
            this.mPath.quadTo(this.bottomCircle.x - this.bottomCircle.radius, (this.bottomCircle.y + this.topCircle.y) / 2.0f, bottom_x1, bottom_y1);
            this.mPath.lineTo(bottom_x2, bottom_y2);
            this.mPath.quadTo(this.bottomCircle.x + this.bottomCircle.radius, (this.bottomCircle.y + top_y2) / 2.0f, top_x2, top_y2);
        }
        this.mPath.close();
    }

    private double getAngle() {
        if (this.bottomCircle.radius > this.topCircle.radius) {
            throw new IllegalStateException("bottomCircle's radius must be less than the topCircle's");
        }
        return Math.asin((this.topCircle.radius - this.bottomCircle.radius) / (this.bottomCircle.y - this.topCircle.y));
    }

    public Animator createAnimator() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.001f}).setDuration(180L);
        valueAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator1) {
                WaterDropView.this.updateCompleteState(((Float)valueAnimator1.getAnimatedValue()).floatValue());
                WaterDropView.this.postInvalidate();
            }
        });
        return valueAnimator;
    }

    public void updateCompleteState(int offset, int maxHeight) {
    }

    public void updateCompleteState(float percent) {
        float top_r = (float)((double)this.mMaxCircleRadius - 0.25 * (double)percent * (double)this.mMaxCircleRadius);
        float bottom_r = (float)(this.mMinCircleRadius - this.mMaxCircleRadius) * percent + (float)this.mMaxCircleRadius;
        float bottomCircleOffset = 4.0f * percent * (float)this.mMaxCircleRadius;
        this.topCircle.radius = top_r;
        this.bottomCircle.radius = bottom_r;
        this.bottomCircle.y = this.topCircle.y + bottomCircleOffset;
    }

    public void updateCompleteState(int height) {
        int paddingBottom;
        int paddingTop = this.getPaddingTop();
        float space = this.mMaxCircleRadius * 2 + paddingTop + (paddingBottom = this.getPaddingBottom());
        if ((float)height < space) {
            this.topCircle.radius = this.mMaxCircleRadius;
            this.bottomCircle.radius = this.mMaxCircleRadius;
            this.bottomCircle.y = this.topCircle.y;
        } else {
            float limit = this.mMaxCircleRadius - this.mMinCircleRadius;
            float x = Math.max(0.0f, (float)height - space);
            float y = (float)((double)limit * (1.0 - Math.pow(100.0, -x / (float)DensityUtil.dp2px((float)200.0f))));
            this.topCircle.radius = (float)this.mMaxCircleRadius - y / 4.0f;
            this.bottomCircle.radius = (float)this.mMaxCircleRadius - y;
            int validHeight = height - paddingTop - paddingBottom;
            this.bottomCircle.y = (float)validHeight - this.bottomCircle.radius;
        }
    }

    public Circle getTopCircle() {
        return this.topCircle;
    }

    public Circle getBottomCircle() {
        return this.bottomCircle;
    }

    public void setIndicatorColor(@ColorInt int color) {
        this.mPaint.setColor(color);
    }

    public int getIndicatorColor() {
        return this.mPaint.getColor();
    }
}

