/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.fungame;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.text.TextPaint;
import android.util.AttributeSet;
import com.scwang.smartrefresh.header.R;
import com.scwang.smartrefresh.header.fungame.FunGameHeader;
import com.scwang.smartrefresh.header.util.ColorUtils;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public abstract class FunGameView
extends FunGameHeader {
    protected static final int STATUS_GAME_PREPAR = 0;
    protected static final int STATUS_GAME_PLAY = 1;
    protected static final int STATUS_GAME_OVER = 2;
    protected static final int STATUS_GAME_FINISHED = 3;
    protected static final int STATUS_GAME_FAIL = 4;
    protected static final float VIEW_HEIGHT_RATIO = 0.161f;
    public static String textGameOver = "\u6e38\u620f\u7ed3\u675f";
    public static String textLoading = "\u73a9\u4e2a\u6e38\u620f\u89e3\u89e3\u95f7";
    public static String textLoadingFinished = "\u5237\u65b0\u5b8c\u6210";
    public static String textLoadingFail = "\u5237\u65b0\u5931\u8d25";
    protected Paint mPaint;
    protected TextPaint textPaint;
    protected float controllerPosition;
    protected int controllerSize;
    protected int status = 0;
    protected int lModelColor;
    protected int rModelColor;
    protected int mModelColor;
    protected int mBackColor;
    protected int mBoundaryColor = -10461088;

    public FunGameView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public FunGameView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public FunGameView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    @RequiresApi(value=21)
    public FunGameView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FunGameView);
        this.mBackColor = ta.getColor(R.styleable.FunGameView_fgvBackColor, 0);
        this.lModelColor = ta.getColor(R.styleable.FunGameView_fgvLeftColor, Color.rgb((int)0, (int)0, (int)0));
        this.mModelColor = ta.getColor(R.styleable.FunGameView_fgvMiddleColor, -16777216);
        this.rModelColor = ta.getColor(R.styleable.FunGameView_fgvRightColor, Color.parseColor((String)"#A5A5A5"));
        if (ta.hasValue(R.styleable.FunGameView_fgvTextGameOver)) {
            textGameOver = ta.getString(R.styleable.FunGameView_fgvTextGameOver);
        }
        if (ta.hasValue(R.styleable.FunGameView_fgvTextGameOver)) {
            textLoading = ta.getString(R.styleable.FunGameView_fgvTextLoading);
        }
        if (ta.hasValue(R.styleable.FunGameView_fgvTextGameOver)) {
            textLoadingFinished = ta.getString(R.styleable.FunGameView_fgvTextLoadingFinished);
        }
        ta.recycle();
        this.initBaseTools();
        this.initBaseConfigParams();
        this.initConcreteView();
    }

    protected void initBaseTools() {
        this.textPaint = new TextPaint(1);
        this.textPaint.setColor(Color.parseColor((String)"#C1C2C2"));
        this.mPaint = new Paint(1);
        this.mPaint.setStrokeWidth(this.DIVIDING_LINE_SIZE);
    }

    protected void initBaseConfigParams() {
        this.controllerPosition = this.DIVIDING_LINE_SIZE;
    }

    protected abstract void initConcreteView();

    protected abstract void drawGame(Canvas var1, int var2, int var3);

    protected abstract void resetConfigParams();

    private void drawBoundary(Canvas canvas, int width, int height) {
        this.mPaint.setColor(this.mBackColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, this.mPaint);
        this.mPaint.setColor(this.mBoundaryColor);
        canvas.drawLine(0.0f, 0.0f, (float)width, 0.0f, this.mPaint);
        canvas.drawLine(0.0f, (float)height - this.DIVIDING_LINE_SIZE, (float)width, (float)height - this.DIVIDING_LINE_SIZE, this.mPaint);
    }

    protected void dispatchDraw(Canvas canvas) {
        int width = this.getWidth();
        int height = this.mHeaderHeight;
        this.drawBoundary(canvas, width, height);
        this.drawText(canvas, width, height);
        this.drawGame(canvas, width, height);
        super.dispatchDraw(canvas);
    }

    private void drawText(Canvas canvas, int width, int height) {
        switch (this.status) {
            case 0: 
            case 1: {
                this.textPaint.setTextSize((float)DensityUtil.dp2px((float)25.0f));
                this.promptText(canvas, textLoading, width, height);
                break;
            }
            case 3: {
                this.textPaint.setTextSize((float)DensityUtil.dp2px((float)20.0f));
                this.promptText(canvas, textLoadingFinished, width, height);
                break;
            }
            case 4: {
                this.textPaint.setTextSize((float)DensityUtil.dp2px((float)20.0f));
                this.promptText(canvas, textLoadingFail, width, height);
                break;
            }
            case 2: {
                this.textPaint.setTextSize((float)DensityUtil.dp2px((float)25.0f));
                this.promptText(canvas, textGameOver, width, height);
            }
        }
    }

    private void promptText(Canvas canvas, String text, int width, int height) {
        float textX = ((float)width - this.textPaint.measureText(text)) * 0.5f;
        float textY = (float)height * 0.5f - (this.textPaint.ascent() + this.textPaint.descent()) * 0.5f;
        canvas.drawText(text, textX, textY, (Paint)this.textPaint);
    }

    public int getCurrStatus() {
        return this.status;
    }

    public String getTextGameOver() {
        return textGameOver;
    }

    public void setTextGameOver(String textGameOver) {
        FunGameView.textGameOver = textGameOver;
    }

    public String getTextLoading() {
        return textLoading;
    }

    public void setTextLoading(String textLoading) {
        FunGameView.textLoading = textLoading;
    }

    public String getTextLoadingFinished() {
        return textLoadingFinished;
    }

    public void setTextLoadingFinished(String textLoadingFinished) {
        FunGameView.textLoadingFinished = textLoadingFinished;
    }

    @Override
    protected void onGameStart() {
        this.postStatus(1);
    }

    @Override
    protected void onManualOperationMove(float percent, int offset, int height, int extendHeight) {
        this.moveController(Math.max(offset, 0));
    }

    public void moveController(float distance) {
        float maxDistance = (float)this.mHeaderHeight - 2.0f * this.DIVIDING_LINE_SIZE - (float)this.controllerSize;
        if (distance > maxDistance) {
            distance = maxDistance;
        }
        this.controllerPosition = distance;
        this.postInvalidate();
    }

    public void postStatus(int status) {
        this.status = status;
        if (status == 0) {
            this.resetConfigParams();
        }
        this.postInvalidate();
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
        super.onInitialized(kernel, height, extendHeight);
        this.initConcreteView();
        this.postStatus(0);
    }

    @Override
    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        if (this.mManualOperation) {
            this.postStatus(success ? 3 : 4);
        } else {
            this.postStatus(0);
        }
        return super.onFinish(layout, success);
    }

    @Override
    @Deprecated
    public void setPrimaryColors(int ... colors) {
        super.setPrimaryColors(colors);
        if (colors.length > 0) {
            this.mBoundaryColor = this.mBackColor = colors[0];
            if (this.mBackColor == 0 || this.mBackColor == -1) {
                this.mBoundaryColor = -10461088;
            }
            if (colors.length > 1) {
                this.mModelColor = colors[1];
                this.lModelColor = ColorUtils.setAlphaComponent(colors[1], 225);
                this.rModelColor = ColorUtils.setAlphaComponent(colors[1], 200);
                this.textPaint.setColor(ColorUtils.setAlphaComponent(colors[1], 150));
            }
        }
    }
}

