/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.fungame;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.scwang.smartrefresh.header.R;
import com.scwang.smartrefresh.header.fungame.FunGameBase;
import com.scwang.smartrefresh.header.util.ColorUtils;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class FunGameHeader
extends FunGameBase
implements RefreshHeader {
    protected float DIVIDING_LINE_SIZE = 1.0f;
    private RelativeLayout curtainReLayout;
    private RelativeLayout maskReLayout;
    private TextView topMaskView;
    private TextView bottomMaskView;
    private int halfHitBlockHeight;
    private boolean isStart = false;
    private String topMaskViewText = "\u4e0b\u62c9\u5373\u5c06\u5c55\u5f00";
    private String bottomMaskViewText = "\u62d6\u52a8\u63a7\u5236\u6e38\u620f";
    private int topMaskTextSize;
    private int bottomMaskTextSize;

    public FunGameHeader(Context context) {
        super(context);
        this.initView(context, null);
    }

    public FunGameHeader(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public FunGameHeader(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    @RequiresApi(value=21)
    public FunGameHeader(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FunGameHeader);
        if (ta.hasValue(R.styleable.FunGameHeader_fgvMaskTopText)) {
            this.topMaskViewText = ta.getString(R.styleable.FunGameHeader_fgvMaskTopText);
        }
        if (ta.hasValue(R.styleable.FunGameHeader_fgvMaskBottomText)) {
            this.bottomMaskViewText = ta.getString(R.styleable.FunGameHeader_fgvMaskBottomText);
        }
        this.topMaskTextSize = (int)TypedValue.applyDimension((int)2, (float)16.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.bottomMaskTextSize = (int)TypedValue.applyDimension((int)2, (float)16.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.topMaskTextSize = ta.getDimensionPixelSize(R.styleable.FunGameHeader_fgvBottomTextSize, this.topMaskTextSize);
        this.bottomMaskTextSize = ta.getDimensionPixelSize(R.styleable.FunGameHeader_fgvBottomTextSize, this.bottomMaskTextSize);
        ta.recycle();
        this.curtainReLayout = new RelativeLayout(context);
        this.maskReLayout = new RelativeLayout(context);
        this.maskReLayout.setBackgroundColor(Color.parseColor((String)"#3A3A3A"));
        this.topMaskView = this.createMaskTextView(context, this.topMaskViewText, this.topMaskTextSize, 80);
        this.bottomMaskView = this.createMaskTextView(context, this.bottomMaskViewText, this.bottomMaskTextSize, 48);
        this.DIVIDING_LINE_SIZE = Math.max(1, DensityUtil.dp2px((float)0.5f));
    }

    private TextView createMaskTextView(Context context, String text, int textSize, int gravity) {
        TextView maskTextView = new TextView(context);
        maskTextView.setTextColor(-16777216);
        maskTextView.setBackgroundColor(-1);
        maskTextView.setGravity(gravity | 1);
        maskTextView.setTextSize(0, (float)textSize);
        maskTextView.setText((CharSequence)text);
        return maskTextView;
    }

    private void coverMaskView() {
        if (this.getChildCount() < 2 && !this.isInEditMode()) {
            FrameLayout.LayoutParams maskLp = new FrameLayout.LayoutParams(-1, this.mHeaderHeight);
            this.addView((View)this.maskReLayout, (ViewGroup.LayoutParams)maskLp);
            this.addView((View)this.curtainReLayout, (ViewGroup.LayoutParams)maskLp);
            this.halfHitBlockHeight = (int)((float)this.mHeaderHeight * 0.5f);
            RelativeLayout.LayoutParams topRelayLayoutParams = new RelativeLayout.LayoutParams(-1, this.halfHitBlockHeight);
            RelativeLayout.LayoutParams bottomRelayLayoutParams = new RelativeLayout.LayoutParams(-1, this.halfHitBlockHeight);
            bottomRelayLayoutParams.topMargin = this.mHeaderHeight - this.halfHitBlockHeight;
            this.curtainReLayout.addView((View)this.topMaskView, (ViewGroup.LayoutParams)topRelayLayoutParams);
            this.curtainReLayout.addView((View)this.bottomMaskView, (ViewGroup.LayoutParams)bottomRelayLayoutParams);
        }
    }

    private void doStart(long delay) {
        ObjectAnimator topMaskAnimator = ObjectAnimator.ofFloat((Object)this.topMaskView, (String)"translationY", (float[])new float[]{this.topMaskView.getTranslationY(), -this.halfHitBlockHeight});
        ObjectAnimator bottomMaskAnimator = ObjectAnimator.ofFloat((Object)this.bottomMaskView, (String)"translationY", (float[])new float[]{this.bottomMaskView.getTranslationY(), this.halfHitBlockHeight});
        ObjectAnimator maskShadowAnimator = ObjectAnimator.ofFloat((Object)this.maskReLayout, (String)"alpha", (float[])new float[]{this.maskReLayout.getAlpha(), 0.0f});
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.play((Animator)topMaskAnimator).with((Animator)bottomMaskAnimator).with((Animator)maskShadowAnimator);
        animatorSet.setDuration(800L);
        animatorSet.setStartDelay(delay);
        animatorSet.start();
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FunGameHeader.this.topMaskView.setVisibility(8);
                FunGameHeader.this.bottomMaskView.setVisibility(8);
                FunGameHeader.this.maskReLayout.setVisibility(8);
                FunGameHeader.this.onGameStart();
            }
        });
    }

    protected void onGameStart() {
    }

    public void postStart() {
        if (!this.isStart) {
            this.doStart(200L);
            this.isStart = true;
        }
    }

    public void postEnd() {
        this.isStart = false;
        this.topMaskView.setTranslationY(this.topMaskView.getTranslationY() + (float)this.halfHitBlockHeight);
        this.bottomMaskView.setTranslationY(this.bottomMaskView.getTranslationY() - (float)this.halfHitBlockHeight);
        this.maskReLayout.setAlpha(1.0f);
        this.topMaskView.setVisibility(0);
        this.bottomMaskView.setVisibility(0);
        this.maskReLayout.setVisibility(0);
    }

    public void setTopMaskViewText(String topMaskViewText) {
        this.topMaskViewText = topMaskViewText;
        this.topMaskView.setText((CharSequence)topMaskViewText);
    }

    public void setBottomMaskViewText(String bottomMaskViewText) {
        this.bottomMaskViewText = bottomMaskViewText;
        this.bottomMaskView.setText((CharSequence)bottomMaskViewText);
    }

    @Override
    @Deprecated
    public void setPrimaryColors(int ... colors) {
        super.setPrimaryColors(colors);
        if (colors.length > 0) {
            this.topMaskView.setTextColor(colors[0]);
            this.bottomMaskView.setTextColor(colors[0]);
            if (colors.length > 1) {
                this.maskReLayout.setBackgroundColor(ColorUtils.setAlphaComponent(colors[1], 200));
                this.topMaskView.setBackgroundColor(ColorUtils.setAlphaComponent(colors[1], 200));
                this.bottomMaskView.setBackgroundColor(ColorUtils.setAlphaComponent(colors[1], 200));
            }
        }
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
        super.onInitialized(kernel, height, extendHeight);
        this.coverMaskView();
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int extendHeight) {
        super.onStartAnimator(layout, height, extendHeight);
        this.postStart();
    }

    @Override
    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        if (!this.mManualOperation) {
            this.postEnd();
        }
        return super.onFinish(layout, success);
    }
}

