/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header.fungame;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.scwang.smartrefresh.layout.api.RefreshContent;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.util.DensityUtil;

@SuppressLint(value={"RestrictedApi"})
public class FunGameBase
extends FrameLayout
implements RefreshHeader {
    protected int mOffset;
    protected int mHeaderHeight;
    protected int mScreenHeightPixels;
    protected float mTouchY;
    protected boolean mIsFinish;
    protected boolean mLastFinish;
    protected boolean mManualOperation;
    protected RefreshState mState;
    protected RefreshKernel mRefreshKernel;
    protected RefreshContent mRefreshContent;
    boolean enableLoadmore;

    public FunGameBase(Context context) {
        super(context);
        this.initView(context);
    }

    public FunGameBase(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public FunGameBase(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    @RequiresApi(value=21)
    public FunGameBase(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(Context context) {
        this.setMinimumHeight(DensityUtil.dp2px((float)100.0f));
        this.mScreenHeightPixels = context.getResources().getDisplayMetrics().heightPixels;
    }

    public void setTranslationY(float translationY) {
        if (!this.isInEditMode()) {
            super.setTranslationY(translationY);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mState == RefreshState.Refreshing || super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mState == RefreshState.Refreshing || this.mState == RefreshState.RefreshFinish) {
            if (!this.mManualOperation) {
                this.onManualOperationStart();
            }
            switch (event.getAction() & 0xFF) {
                case 0: {
                    this.mTouchY = event.getRawY();
                    this.mRefreshKernel.moveSpinner(0, true);
                    break;
                }
                case 2: {
                    float dy = event.getRawY() - this.mTouchY;
                    if (dy >= 0.0f) {
                        double M = this.mHeaderHeight * 2;
                        double H = this.mScreenHeightPixels * 2 / 3;
                        double x = Math.max(0.0, (double)dy * 0.5);
                        double y = Math.min(M * (1.0 - Math.pow(100.0, -x / H)), x);
                        this.mRefreshKernel.moveSpinner((int)y, false);
                        break;
                    }
                    double M = this.mHeaderHeight * 2;
                    double H = this.mScreenHeightPixels * 2 / 3;
                    double x = -Math.min(0.0, (double)dy * 0.5);
                    double y = -Math.min(M * (1.0 - Math.pow(100.0, -x / H)), x);
                    this.mRefreshKernel.moveSpinner((int)y, false);
                    break;
                }
                case 1: 
                case 3: {
                    this.onManualOperationRelease();
                    this.mTouchY = -1.0f;
                    if (!this.mIsFinish) break;
                    this.mRefreshKernel.moveSpinner(this.mHeaderHeight, true);
                }
            }
            return true;
        }
        return super.onTouchEvent(event);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mRefreshKernel = null;
        this.mRefreshContent = null;
    }

    protected void onManualOperationStart() {
        if (!this.mManualOperation) {
            this.mManualOperation = true;
            this.mRefreshContent = this.mRefreshKernel.getRefreshContent();
            this.enableLoadmore = this.mRefreshKernel.getRefreshLayout().isEnableLoadMore();
            this.mRefreshKernel.getRefreshLayout().setEnableLoadMore(false);
            View contentView = this.mRefreshContent.getView();
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)contentView.getLayoutParams();
            params.topMargin += this.mHeaderHeight;
            contentView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
    }

    protected void onManualOperationMove(float percent, int offset, int height, int extendHeight) {
    }

    protected void onManualOperationRelease() {
        if (this.mIsFinish) {
            this.mManualOperation = false;
            this.mRefreshKernel.getRefreshLayout().setEnableLoadMore(this.enableLoadmore);
            if (this.mTouchY != -1.0f) {
                this.onFinish(this.mRefreshKernel.getRefreshLayout(), this.mLastFinish);
                this.mRefreshKernel.setState(RefreshState.RefreshFinish);
                this.mRefreshKernel.animSpinner(0);
            } else {
                this.mRefreshKernel.moveSpinner(this.mHeaderHeight, true);
            }
            View contentView = this.mRefreshContent.getView();
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)contentView.getLayoutParams();
            params.topMargin -= this.mHeaderHeight;
            contentView.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            this.mRefreshKernel.moveSpinner(0, true);
        }
    }

    public boolean isSupportHorizontalDrag() {
        return false;
    }

    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    public void onPulling(float percent, int offset, int height, int extendHeight) {
        if (this.mManualOperation) {
            this.onManualOperationMove(percent, offset, height, extendHeight);
        } else {
            this.mOffset = offset;
            this.setTranslationY(this.mOffset - this.mHeaderHeight);
        }
    }

    public void onReleasing(float percent, int offset, int height, int extendHeight) {
        this.onPulling(percent, offset, height, extendHeight);
    }

    public void onReleased(RefreshLayout layout, int height, int extendHeight) {
    }

    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int extendHeight) {
        this.mIsFinish = false;
        this.setTranslationY(0.0f);
    }

    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        this.mState = newState;
    }

    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
        this.mRefreshKernel = kernel;
        this.mHeaderHeight = height;
        this.setTranslationY(this.mOffset - this.mHeaderHeight);
        kernel.requestNeedTouchEventWhenRefreshing(true);
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        this.mLastFinish = success;
        if (!this.mIsFinish) {
            this.mIsFinish = true;
            if (this.mManualOperation) {
                if (this.mTouchY == -1.0f) {
                    this.onManualOperationRelease();
                    this.onFinish(layout, success);
                    return 0;
                }
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
    }

    @NonNull
    public View getView() {
        return this;
    }

    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.MatchLayout;
    }
}

