/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.scwang.smartrefresh.header.R;
import com.scwang.smartrefresh.header.internal.MaterialProgressDrawable;
import com.scwang.smartrefresh.header.waveswipe.AnimationImageView;
import com.scwang.smartrefresh.header.waveswipe.DisplayUtil;
import com.scwang.smartrefresh.header.waveswipe.WaveView;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class WaveSwipeHeader
extends ViewGroup
implements RefreshHeader {
    private static final float MAX_PROGRESS_ROTATION_RATE = 0.8f;
    private WaveView mWaveView;
    private RefreshState mState;
    private ProgressAnimationImageView mCircleView;
    private float mLastFirstBounds;

    public WaveSwipeHeader(Context context) {
        super(context);
        this.initView(context, null);
    }

    public WaveSwipeHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public WaveSwipeHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    @RequiresApi(value=21)
    public WaveSwipeHeader(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        this.mWaveView = new WaveView(context);
        this.addView(this.mWaveView);
        this.mCircleView = new ProgressAnimationImageView(this.getContext());
        this.addView((View)this.mCircleView);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.WaveSwipeHeader);
        int primaryColor = ta.getColor(R.styleable.WaveSwipeHeader_wshPrimaryColor, 0);
        int accentColor = ta.getColor(R.styleable.WaveSwipeHeader_wshAccentColor, 0);
        if (primaryColor != 0) {
            this.mWaveView.setWaveColor(primaryColor);
        }
        if (accentColor != 0) {
            this.mCircleView.setProgressColorSchemeColors(accentColor);
        } else {
            this.mCircleView.setProgressColorSchemeColors(-1);
        }
        if (ta.hasValue(R.styleable.WaveSwipeHeader_wshShadowRadius)) {
            int radius = ta.getDimensionPixelOffset(R.styleable.WaveSwipeHeader_wshShadowRadius, 0);
            int color = ta.getColor(R.styleable.WaveSwipeHeader_wshShadowColor, -16777216);
            this.mWaveView.setShadow(radius, color);
        }
        ta.recycle();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        this.mCircleView.measure();
        this.mWaveView.measure(View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)widthMeasureSpec), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)heightMeasureSpec), (int)0x40000000));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.mWaveView.layout(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
        int thisWidth = this.getMeasuredWidth();
        int circleWidth = this.mCircleView.getMeasuredWidth();
        int circleHeight = this.mCircleView.getMeasuredHeight();
        this.mCircleView.layout((thisWidth - circleWidth) / 2, -circleHeight, (thisWidth + circleWidth) / 2, 0);
        if (this.isInEditMode()) {
            this.onPulling(0.99f, DensityUtil.dp2px((float)99.0f), DensityUtil.dp2px((float)100.0f), DensityUtil.dp2px((float)100.0f));
        }
    }

    public void setColorSchemeColors(int ... colors) {
        this.mCircleView.setProgressColorSchemeColors(colors);
    }

    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
    }

    public boolean isSupportHorizontalDrag() {
        return false;
    }

    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    public void onPulling(float percent, int offset, int height, int extendHeight) {
        if (this.mState == RefreshState.Refreshing) {
            return;
        }
        float dragPercent = Math.min(1.0f, percent);
        float adjustedPercent = (float)Math.max((double)dragPercent - 0.4, 0.0) * 5.0f / 3.0f;
        float tensionSlingshotPercent = percent > 3.0f ? 2.0f : (percent > 1.0f ? percent - 1.0f : 0.0f);
        float tensionPercent = (4.0f - tensionSlingshotPercent) * tensionSlingshotPercent / 8.0f;
        if (percent < 1.0f) {
            float strokeStart = adjustedPercent * 0.8f;
            this.mCircleView.setProgressStartEndTrim(0.0f, Math.min(0.8f, strokeStart));
            this.mCircleView.setArrowScale(Math.min(1.0f, adjustedPercent));
        }
        float rotation = (-0.25f + 0.4f * adjustedPercent + tensionPercent * 2.0f) * 0.5f;
        this.mCircleView.setProgressRotation(rotation);
        this.mCircleView.setTranslationY(this.mWaveView.getCurrentCircleCenterY());
        float seed = 1.0f * (float)offset / (float)Math.min(this.getMeasuredWidth(), this.getMeasuredHeight());
        float firstBounds = seed * (5.0f - 2.0f * seed) / 3.5f;
        float secondBounds = firstBounds - VERTICAL_DRAG_THRESHOLD.FIRST.val;
        float finalBounds = (firstBounds - VERTICAL_DRAG_THRESHOLD.SECOND.val) / 5.0f;
        this.mLastFirstBounds = firstBounds;
        if (firstBounds < VERTICAL_DRAG_THRESHOLD.FIRST.val) {
            this.mWaveView.beginPhase(firstBounds);
        } else if (firstBounds < VERTICAL_DRAG_THRESHOLD.SECOND.val) {
            this.mWaveView.appearPhase(firstBounds, secondBounds);
        } else {
            this.mWaveView.expandPhase(firstBounds, secondBounds, finalBounds);
        }
    }

    public void onReleasing(float percent, int offset, int height, int extendHeight) {
    }

    public void onReleased(RefreshLayout layout, int height, int extendHeight) {
        this.mLastFirstBounds = 0.0f;
        this.mWaveView.animationDropCircle();
        this.mCircleView.makeProgressTransparent();
        this.mCircleView.startProgress();
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        animator.setDuration(500L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                WaveSwipeHeader.this.mCircleView.setTranslationY(WaveSwipeHeader.this.mWaveView.getCurrentCircleCenterY() + (float)WaveSwipeHeader.this.mCircleView.getHeight() / 2.0f);
            }
        });
        animator.start();
    }

    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int extendHeight) {
    }

    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        this.mState = newState;
        switch (newState) {
            case None: {
                break;
            }
            case PullDownToRefresh: {
                this.mCircleView.showArrow(true);
                this.mCircleView.scaleWithKeepingAspectRatio(1.0f);
                this.mCircleView.makeProgressTransparent();
                break;
            }
            case PullDownCanceled: {
                this.mCircleView.showArrow(false);
                this.mCircleView.setProgressRotation(0.0f);
                this.mCircleView.setProgressStartEndTrim(0.0f, 0.0f);
                this.mWaveView.startWaveAnimation(this.mLastFirstBounds);
                this.mLastFirstBounds = 0.0f;
                break;
            }
            case ReleaseToRefresh: {
                break;
            }
        }
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        Animation scaleDownAnimation = new Animation(){

            public void applyTransformation(float interpolatedTime, Transformation t) {
                WaveSwipeHeader.this.mCircleView.scaleWithKeepingAspectRatio(1.0f - interpolatedTime);
            }
        };
        scaleDownAnimation.setDuration(200L);
        this.mCircleView.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                WaveSwipeHeader.this.mCircleView.stopProgress();
                WaveSwipeHeader.this.mCircleView.makeProgressTransparent();
                WaveSwipeHeader.this.mWaveView.startDisappearCircleAnimation();
            }
        });
        this.mCircleView.clearAnimation();
        this.mCircleView.startAnimation(scaleDownAnimation);
        return 0;
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0) {
            this.mWaveView.setWaveColor(colors[0]);
            if (colors.length > 1) {
                this.mCircleView.setProgressColorSchemeColors(colors[1]);
            }
        }
    }

    @NonNull
    public View getView() {
        return this;
    }

    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.MatchLayout;
    }

    private class ProgressAnimationImageView
    extends AnimationImageView {
        private final MaterialProgressDrawable mProgress;

        public ProgressAnimationImageView(Context context) {
            super(context);
            this.mProgress = new MaterialProgressDrawable(context, (View)WaveSwipeHeader.this);
            this.mProgress.setBackgroundColor(0);
            if (DisplayUtil.isOver600dp(this.getContext())) {
                this.mProgress.updateSizes(0);
            }
            this.setImageDrawable(this.mProgress);
        }

        public void measure() {
            int circleDiameter = this.mProgress.getIntrinsicWidth();
            this.measure(this.makeMeasureSpecExactly(circleDiameter), this.makeMeasureSpecExactly(circleDiameter));
        }

        private int makeMeasureSpecExactly(int length) {
            return View.MeasureSpec.makeMeasureSpec((int)length, (int)0x40000000);
        }

        public void makeProgressTransparent() {
            this.mProgress.setAlpha(255);
        }

        public void showArrow(boolean show) {
            this.mProgress.showArrow(show);
        }

        public void setArrowScale(float scale) {
            this.mProgress.setArrowScale(scale);
        }

        public void setProgressAlpha(int alpha) {
            this.mProgress.setAlpha(alpha);
        }

        public void setProgressStartEndTrim(float startAngle, float endAngle) {
            this.mProgress.setStartEndTrim(startAngle, endAngle);
        }

        public void setProgressRotation(float rotation) {
            this.mProgress.setProgressRotation(rotation);
        }

        public void startProgress() {
            this.mProgress.start();
        }

        public void stopProgress() {
            this.mProgress.stop();
        }

        public void setProgressColorSchemeColors(int ... colors) {
            this.mProgress.setColorSchemeColors(colors);
        }

        public void setProgressColorSchemeColorsFromResource(int ... resources) {
            Resources res = this.getResources();
            int[] colorRes = new int[resources.length];
            for (int i = 0; i < resources.length; ++i) {
                colorRes[i] = res.getColor(resources[i]);
            }
            WaveSwipeHeader.this.setColorSchemeColors(colorRes);
        }

        public void scaleWithKeepingAspectRatio(float scale) {
            this.setScaleX(scale);
            this.setScaleY(scale);
        }
    }

    private static enum VERTICAL_DRAG_THRESHOLD {
        FIRST(0.1f),
        SECOND(0.16f + VERTICAL_DRAG_THRESHOLD.FIRST.val),
        THIRD(0.5f + VERTICAL_DRAG_THRESHOLD.FIRST.val);

        final float val;

        private VERTICAL_DRAG_THRESHOLD(float val) {
            this.val = val;
        }
    }
}

