/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.VisibleForTesting;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import com.scwang.smartrefresh.header.R;
import com.scwang.smartrefresh.header.internal.MaterialProgressDrawable;
import com.scwang.smartrefresh.header.material.CircleImageView;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class MaterialHeader
extends ViewGroup
implements RefreshHeader {
    public static final int SIZE_LARGE = 0;
    public static final int SIZE_DEFAULT = 1;
    private static final int CIRCLE_BG_LIGHT = -328966;
    private static final float MAX_PROGRESS_ANGLE = 0.8f;
    @VisibleForTesting
    private static final int CIRCLE_DIAMETER = 40;
    @VisibleForTesting
    private static final int CIRCLE_DIAMETER_LARGE = 56;
    private boolean mFinished;
    private int mCircleDiameter;
    private CircleImageView mCircleView;
    private MaterialProgressDrawable mProgress;
    private int mWaveHeight;
    private int mHeadHeight;
    private Path mBezierPath;
    private Paint mBezierPaint;
    private boolean mShowBezierWave = false;
    private RefreshState mState;

    public MaterialHeader(Context context) {
        super(context);
        this.initView(context, null);
    }

    public MaterialHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public MaterialHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    @RequiresApi(value=21)
    public MaterialHeader(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        this.setMinimumHeight(DensityUtil.dp2px((float)100.0f));
        this.mProgress = new MaterialProgressDrawable(context, (View)this);
        this.mProgress.setBackgroundColor(-328966);
        this.mProgress.setAlpha(255);
        this.mProgress.setColorSchemeColors(-16737844, -48060, -10053376, -5609780, -30720);
        this.mCircleView = new CircleImageView(context, -328966);
        this.mCircleView.setImageDrawable(this.mProgress);
        this.addView((View)this.mCircleView);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mCircleDiameter = (int)(40.0f * metrics.density);
        this.mBezierPath = new Path();
        this.mBezierPaint = new Paint();
        this.mBezierPaint.setAntiAlias(true);
        this.mBezierPaint.setStyle(Paint.Style.FILL);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.MaterialHeader);
        this.mShowBezierWave = ta.getBoolean(R.styleable.MaterialHeader_mhShowBezierWave, this.mShowBezierWave);
        this.mBezierPaint.setColor(ta.getColor(R.styleable.MaterialHeader_mhPrimaryColor, -15614977));
        if (ta.hasValue(R.styleable.MaterialHeader_mhShadowRadius)) {
            int radius = ta.getDimensionPixelOffset(R.styleable.MaterialHeader_mhShadowRadius, 0);
            int color = ta.getColor(R.styleable.MaterialHeader_mhShadowColor, -16777216);
            this.mBezierPaint.setShadowLayer((float)radius, 0.0f, 0.0f, color);
            this.setLayerType(1, null);
        }
        ta.recycle();
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
        this.mCircleView.measure(View.MeasureSpec.makeMeasureSpec((int)this.mCircleDiameter, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)this.mCircleDiameter, (int)0x40000000));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.getChildCount() == 0) {
            return;
        }
        int width = this.getMeasuredWidth();
        int circleWidth = this.mCircleView.getMeasuredWidth();
        int circleHeight = this.mCircleView.getMeasuredHeight();
        if (this.isInEditMode() && this.mHeadHeight > 0) {
            int circleTop = this.mHeadHeight - circleHeight / 2;
            this.mCircleView.layout(width / 2 - circleWidth / 2, circleTop, width / 2 + circleWidth / 2, circleTop + circleHeight);
            this.mProgress.showArrow(true);
            this.mProgress.setStartEndTrim(0.0f, 0.8f);
            this.mProgress.setArrowScale(1.0f);
            this.mCircleView.setAlpha(1.0f);
            this.mCircleView.setVisibility(0);
        } else {
            this.mCircleView.layout(width / 2 - circleWidth / 2, -this.mCircleDiameter, width / 2 + circleWidth / 2, circleHeight - this.mCircleDiameter);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mShowBezierWave) {
            this.mBezierPath.reset();
            this.mBezierPath.lineTo(0.0f, (float)this.mHeadHeight);
            this.mBezierPath.quadTo((float)(this.getMeasuredWidth() / 2), (float)this.mHeadHeight + (float)this.mWaveHeight * 1.9f, (float)this.getMeasuredWidth(), (float)this.mHeadHeight);
            this.mBezierPath.lineTo((float)this.getMeasuredWidth(), 0.0f);
            canvas.drawPath(this.mBezierPath, this.mBezierPaint);
        }
        super.dispatchDraw(canvas);
    }

    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
        if (!this.mShowBezierWave) {
            kernel.requestDefaultHeaderTranslationContent(false);
        }
        if (this.isInEditMode()) {
            this.mWaveHeight = this.mHeadHeight = height / 2;
        }
    }

    public boolean isSupportHorizontalDrag() {
        return false;
    }

    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    public void onPulling(float percent, int offset, int height, int extendHeight) {
        if (this.mShowBezierWave) {
            this.mHeadHeight = Math.min(offset, height);
            this.mWaveHeight = Math.max(0, offset - height);
            this.postInvalidate();
        }
        if (this.mState != RefreshState.Refreshing) {
            float originalDragPercent = 1.0f * (float)offset / (float)height;
            float dragPercent = Math.min(1.0f, Math.abs(originalDragPercent));
            float adjustedPercent = (float)Math.max((double)dragPercent - 0.4, 0.0) * 5.0f / 3.0f;
            float extraOS = Math.abs(offset) - height;
            float tensionSlingshotPercent = Math.max(0.0f, Math.min(extraOS, (float)height * 2.0f) / (float)height);
            float tensionPercent = (float)((double)(tensionSlingshotPercent / 4.0f) - Math.pow(tensionSlingshotPercent / 4.0f, 2.0)) * 2.0f;
            float strokeStart = adjustedPercent * 0.8f;
            this.mProgress.showArrow(true);
            this.mProgress.setStartEndTrim(0.0f, Math.min(0.8f, strokeStart));
            this.mProgress.setArrowScale(Math.min(1.0f, adjustedPercent));
            float rotation = (-0.25f + 0.4f * adjustedPercent + tensionPercent * 2.0f) * 0.5f;
            this.mProgress.setProgressRotation(rotation);
            this.mCircleView.setAlpha(Math.min(1.0f, originalDragPercent * 2.0f));
        }
        float targetY = offset / 2 + this.mCircleDiameter / 2;
        this.mCircleView.setTranslationY(Math.min((float)offset, targetY));
    }

    public void onReleasing(float percent, int offset, int height, int extendHeight) {
        if (!this.mProgress.isRunning() && !this.mFinished) {
            this.onPulling(percent, offset, height, extendHeight);
        } else if (this.mShowBezierWave) {
            this.mHeadHeight = Math.min(offset, height);
            this.mWaveHeight = Math.max(0, offset - height);
            this.postInvalidate();
        }
    }

    public void onReleased(RefreshLayout layout, int height, int extendHeight) {
        this.mProgress.start();
        if ((int)this.mCircleView.getTranslationY() != height / 2 + this.mCircleDiameter / 2) {
            this.mCircleView.animate().translationY((float)(height / 2 + this.mCircleDiameter / 2));
        }
    }

    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int extendHeight) {
    }

    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        this.mState = newState;
        switch (newState) {
            case None: {
                break;
            }
            case PullDownToRefresh: {
                this.mFinished = false;
                this.mCircleView.setVisibility(0);
                this.mCircleView.setScaleX(1.0f);
                this.mCircleView.setScaleY(1.0f);
                break;
            }
            case ReleaseToRefresh: {
                break;
            }
        }
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        this.mProgress.stop();
        this.mCircleView.animate().scaleX(0.0f).scaleY(0.0f);
        this.mFinished = true;
        return 0;
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0) {
            this.mBezierPaint.setColor(colors[0]);
        }
    }

    @NonNull
    public View getView() {
        return this;
    }

    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.MatchLayout;
    }

    public MaterialHeader setColorSchemeColors(int ... colors) {
        this.mProgress.setColorSchemeColors(colors);
        return this;
    }

    public MaterialHeader setSize(int size) {
        if (size != 0 && size != 1) {
            return this;
        }
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mCircleDiameter = size == 0 ? (int)(56.0f * metrics.density) : (int)(40.0f * metrics.density);
        this.mCircleView.setImageDrawable(null);
        this.mProgress.updateSizes(size);
        this.mCircleView.setImageDrawable(this.mProgress);
        return this;
    }

    public MaterialHeader setShowBezierWave(boolean show) {
        this.mShowBezierWave = show;
        return this;
    }
}

