/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import com.scwang.smartrefresh.header.R;
import com.scwang.smartrefresh.header.fungame.FunGameView;
import com.scwang.smartrefresh.header.util.ColorUtils;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import java.util.ArrayList;
import java.util.List;

public class FunGameHitBlockHeader
extends FunGameView {
    private static final int BLOCK_VERTICAL_NUM = 5;
    private static final int BLOCK_HORIZONTAL_NUM = 3;
    private static final float BLOCK_WIDTH_RATIO = 0.01806f;
    private static final float RACKET_POSITION_RATIO = 0.8f;
    private static final float BLOCK_POSITION_RATIO = 0.08f;
    private static final int DEFAULT_ANGLE = 30;
    static final float DIVIDING_LINE_SIZE = 1.0f;
    private static final int SPEED = 3;
    private float blockHeight;
    private float blockWidth;
    private float BALL_RADIUS;
    private Paint blockPaint;
    private float blockLeft;
    private float racketLeft;
    private float cx;
    private float cy;
    private List<Point> pointList;
    private boolean isleft;
    private int angle;
    private int blockHorizontalNum;
    private int speed;

    public FunGameHitBlockHeader(Context context) {
        super(context);
        this.initView(context, null);
    }

    public FunGameHitBlockHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public FunGameHitBlockHeader(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context, attrs);
    }

    @RequiresApi(value=21)
    public FunGameHitBlockHeader(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.FunGameHitBlockHeader);
        this.blockHorizontalNum = typedArray.getInt(R.styleable.FunGameHitBlockHeader_fgvBlockHorizontalNum, 3);
        this.speed = typedArray.getInt(R.styleable.FunGameHitBlockHeader_fgvBallSpeed, DensityUtil.dp2px((float)3.0f));
        typedArray.recycle();
        this.blockPaint = new Paint(1);
        this.blockPaint.setStyle(Paint.Style.FILL);
        this.BALL_RADIUS = DensityUtil.dp2px((float)4.0f);
    }

    @Override
    protected void initConcreteView() {
        int measuredWidth = this.getMeasuredWidth();
        this.controllerSize = (int)(this.blockHeight * 1.6f);
        this.blockHeight = (float)(this.mHeaderHeight / 5) - 1.0f;
        this.blockWidth = (float)measuredWidth * 0.01806f;
        this.blockLeft = (float)measuredWidth * 0.08f;
        this.racketLeft = (float)measuredWidth * 0.8f;
        this.controllerSize = (int)(this.blockHeight * 1.6f);
    }

    @Override
    protected void drawGame(Canvas canvas, int width, int height) {
        this.drawColorBlock(canvas);
        this.drawRacket(canvas);
        if (this.status == 1 || this.status == 3 || this.status == 4 || this.isInEditMode()) {
            this.makeBallPath(canvas, width);
        }
    }

    @Override
    protected void resetConfigParams() {
        this.cx = this.racketLeft - 3.0f * this.BALL_RADIUS;
        this.cy = (int)((float)this.mHeaderHeight * 0.5f);
        this.controllerPosition = 1.0f;
        this.angle = 30;
        this.isleft = true;
        if (this.pointList == null) {
            this.pointList = new ArrayList<Point>();
        } else {
            this.pointList.clear();
        }
    }

    private void drawRacket(Canvas canvas) {
        this.mPaint.setColor(this.rModelColor);
        canvas.drawRect(this.racketLeft, this.controllerPosition, this.racketLeft + this.blockWidth, this.controllerPosition + (float)this.controllerSize, this.mPaint);
    }

    private void makeBallPath(Canvas canvas, int width) {
        this.mPaint.setColor(this.mModelColor);
        if (this.cx <= this.blockLeft + (float)this.blockHorizontalNum * this.blockWidth + (float)(this.blockHorizontalNum - 1) * 1.0f + this.BALL_RADIUS && this.checkTouchBlock(this.cx, this.cy)) {
            this.isleft = false;
        }
        if (this.cx <= this.blockLeft + this.BALL_RADIUS) {
            this.isleft = false;
        }
        if (this.cx + this.BALL_RADIUS >= this.racketLeft && this.cx - this.BALL_RADIUS < this.racketLeft + this.blockWidth) {
            if (this.checkTouchRacket(this.cy)) {
                if (this.pointList.size() == this.blockHorizontalNum * 5) {
                    this.status = 2;
                    return;
                }
                this.isleft = true;
            }
        } else if (this.cx > (float)width) {
            this.status = 2;
        }
        if (this.cy <= this.BALL_RADIUS + 1.0f) {
            this.angle = 150;
        } else if (this.cy >= (float)this.mHeaderHeight - this.BALL_RADIUS - 1.0f) {
            this.angle = 210;
        }
        this.cx = this.isleft ? (this.cx -= (float)this.speed) : (this.cx += (float)this.speed);
        this.cy -= (float)Math.tan(Math.toRadians(this.angle)) * (float)this.speed;
        canvas.drawCircle(this.cx, this.cy, this.BALL_RADIUS, this.mPaint);
        this.invalidate();
    }

    private boolean checkTouchRacket(float y) {
        boolean flag = false;
        float diffVal = y - this.controllerPosition;
        if (diffVal >= 0.0f && diffVal <= (float)this.controllerSize) {
            flag = true;
        }
        return flag;
    }

    private boolean checkTouchBlock(float x, float y) {
        int columnX = (int)((x - this.blockLeft - this.BALL_RADIUS - (float)this.speed) / this.blockWidth);
        columnX = columnX == this.blockHorizontalNum ? columnX - 1 : columnX;
        int rowY = (int)(y / this.blockHeight);
        rowY = rowY == 5 ? rowY - 1 : rowY;
        Point p = new Point();
        p.set(columnX, rowY);
        boolean flag = false;
        for (Point point : this.pointList) {
            if (!point.equals(p.x, p.y)) continue;
            flag = true;
            break;
        }
        if (!flag) {
            this.pointList.add(p);
        }
        return !flag;
    }

    private void drawColorBlock(Canvas canvas) {
        for (int i = 0; i < this.blockHorizontalNum * 5; ++i) {
            int row = i / this.blockHorizontalNum;
            int column = i % this.blockHorizontalNum;
            boolean flag = false;
            for (Point point : this.pointList) {
                if (!point.equals(column, row)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            this.blockPaint.setColor(ColorUtils.setAlphaComponent(this.lModelColor, 255 / (column + 1)));
            float left = this.blockLeft + (float)column * (this.blockWidth + 1.0f);
            float top = 1.0f + (float)row * (this.blockHeight + 1.0f);
            canvas.drawRect(left, top, left + this.blockWidth, top + this.blockHeight, this.blockPaint);
        }
    }
}

