/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.util.SparseArray;
import com.scwang.smartrefresh.header.fungame.FunGameView;
import com.scwang.smartrefresh.layout.util.DensityUtil;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;

public class FunGameBattleCityHeader
extends FunGameView {
    private static int TANK_ROW_NUM = 3;
    private static final float TANK_BARREL_RATIO = 0.33333334f;
    private static final int DEFAULT_BULLET_NUM_SPACING = 360;
    private static final int DEFAULT_ENEMY_TANK_NUM_SPACING = 60;
    private static final int DEFAULT_TANK_MAGIC_TOTAL_NUM = 8;
    private SparseArray<Queue<RectF>> eTankSparseArray;
    private Queue<Point> mBulletList;
    private Point usedBullet;
    private Random random;
    private float bulletRadius;
    private int enemyTankSpace;
    private int bulletSpace;
    private int barrelSize;
    private int enemySpeed = 1;
    private int bulletSpeed = 4;
    private int offsetETankX;
    private int offsetMBulletX;
    private int overstepNum;
    private int levelNum;
    private int wipeOutNum;
    private boolean once = true;

    public FunGameBattleCityHeader(Context context) {
        super(context);
    }

    public FunGameBattleCityHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FunGameBattleCityHeader(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @RequiresApi(value=21)
    public FunGameBattleCityHeader(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void initConcreteView() {
        this.random = new Random();
        this.controllerSize = this.mHeaderHeight / TANK_ROW_NUM;
        this.barrelSize = (int)Math.floor((float)this.controllerSize * 0.33333334f + 0.5f);
        this.bulletRadius = ((float)this.barrelSize - 2.0f * this.DIVIDING_LINE_SIZE) * 0.5f;
        this.resetConfigParams();
    }

    @Override
    protected void drawGame(Canvas canvas, int width, int height) {
        this.drawSelfTank(canvas, width);
        if (this.status == 1 || this.status == 3 || this.status == 4) {
            this.drawEnemyTank(canvas, width);
            this.makeBulletPath(canvas, width);
        }
        if (this.isInEditMode()) {
            this.drawTank(canvas, new RectF((float)this.controllerSize, 0.0f, (float)(this.controllerSize * 2), (float)this.controllerSize));
            this.drawTank(canvas, new RectF(0.0f, (float)this.controllerSize, (float)this.controllerSize, (float)(this.controllerSize * 2)));
            this.drawTank(canvas, new RectF((float)(this.controllerSize * 3), (float)(this.controllerSize * 2), (float)(this.controllerSize * 4), (float)(this.controllerSize * 3)));
        }
    }

    @Override
    protected void resetConfigParams() {
        this.status = 0;
        this.controllerPosition = this.DIVIDING_LINE_SIZE;
        this.enemySpeed = DensityUtil.dp2px((float)1.0f);
        this.bulletSpeed = DensityUtil.dp2px((float)4.0f);
        this.levelNum = 8;
        this.wipeOutNum = 0;
        this.once = true;
        this.enemyTankSpace = this.controllerSize + this.barrelSize + 60;
        this.bulletSpace = 360;
        this.eTankSparseArray = new SparseArray();
        for (int i = 0; i < TANK_ROW_NUM; ++i) {
            LinkedList rectFQueue = new LinkedList();
            this.eTankSparseArray.put(i, rectFQueue);
        }
        this.mBulletList = new LinkedList<Point>();
    }

    private RectF generateEnemyTank(int index) {
        float left = -(this.controllerSize + this.barrelSize);
        float top = (float)(index * this.controllerSize) + this.DIVIDING_LINE_SIZE;
        return new RectF(left, top, left + (float)this.barrelSize * 2.5f, top + (float)this.controllerSize);
    }

    private void makeBulletPath(Canvas canvas, int width) {
        this.mPaint.setColor(this.mModelColor);
        this.offsetMBulletX += this.bulletSpeed;
        if (this.offsetMBulletX / this.bulletSpace == 1) {
            this.offsetMBulletX = 0;
        }
        if (this.offsetMBulletX == 0) {
            Point bulletPoint = new Point();
            bulletPoint.x = width - this.controllerSize - this.barrelSize;
            bulletPoint.y = (int)(this.controllerPosition + (float)this.controllerSize * 0.5f);
            this.mBulletList.offer(bulletPoint);
        }
        boolean isOversetp = false;
        for (Point point : this.mBulletList) {
            if (this.checkWipeOutETank(point)) {
                this.usedBullet = point;
                continue;
            }
            if ((float)point.x + this.bulletRadius <= 0.0f) {
                isOversetp = true;
            }
            this.drawBullet(canvas, point);
        }
        if (isOversetp) {
            this.mBulletList.poll();
        }
        this.mBulletList.remove(this.usedBullet);
        this.usedBullet = null;
    }

    private int getTrackIndex(int y) {
        int index = y / (this.mHeaderHeight / TANK_ROW_NUM);
        index = index >= TANK_ROW_NUM ? TANK_ROW_NUM - 1 : index;
        index = index < 0 ? 0 : index;
        return index;
    }

    private boolean checkWipeOutETank(Point point) {
        boolean beHit = false;
        int trackIndex = this.getTrackIndex(point.y);
        RectF rectF = (RectF)((Queue)this.eTankSparseArray.get(trackIndex)).peek();
        if (rectF != null && rectF.contains((float)point.x, (float)point.y)) {
            if (++this.wipeOutNum == this.levelNum) {
                this.upLevel();
            }
            ((Queue)this.eTankSparseArray.get(trackIndex)).poll();
            beHit = true;
        }
        return beHit;
    }

    private void upLevel() {
        this.levelNum += 8;
        this.enemySpeed += DensityUtil.dp2px((float)1.0f);
        this.bulletSpeed += DensityUtil.dp2px((float)1.0f);
        this.wipeOutNum = 0;
        if (this.enemyTankSpace > 12) {
            this.enemyTankSpace -= 12;
        }
        if (this.bulletSpace > 30) {
            this.bulletSpace -= 30;
        }
    }

    private void drawBullet(Canvas canvas, Point point) {
        point.x -= this.bulletSpeed;
        canvas.drawCircle((float)point.x, (float)point.y, this.bulletRadius, this.mPaint);
    }

    private boolean checkTankCrash(int index, float selfX, float selfY) {
        boolean isCrash = false;
        RectF rectF = (RectF)((Queue)this.eTankSparseArray.get(index)).peek();
        if (rectF != null && rectF.contains(selfX, selfY)) {
            isCrash = true;
        }
        return isCrash;
    }

    private void drawSelfTank(Canvas canvas, int width) {
        this.mPaint.setColor(this.rModelColor);
        boolean isAboveCrash = this.checkTankCrash(this.getTrackIndex((int)this.controllerPosition), width - this.controllerSize, this.controllerPosition);
        boolean isBelowCrash = this.checkTankCrash(this.getTrackIndex((int)(this.controllerPosition + (float)this.controllerSize)), width - this.controllerSize, this.controllerPosition + (float)this.controllerSize);
        if (isAboveCrash || isBelowCrash) {
            this.status = 2;
        }
        canvas.drawRect((float)(width - this.controllerSize), this.controllerPosition + this.DIVIDING_LINE_SIZE, (float)width, this.controllerPosition + (float)this.controllerSize + this.DIVIDING_LINE_SIZE, this.mPaint);
        canvas.drawRect((float)(width - this.controllerSize - this.barrelSize), this.controllerPosition + (float)(this.controllerSize - this.barrelSize) * 0.5f, (float)(width - this.controllerSize), this.controllerPosition + (float)(this.controllerSize - this.barrelSize) * 0.5f + (float)this.barrelSize, this.mPaint);
    }

    private void drawEnemyTank(Canvas canvas, int width) {
        this.mPaint.setColor(this.lModelColor);
        this.offsetETankX += this.enemySpeed;
        if (this.offsetETankX / this.enemyTankSpace == 1 || this.once) {
            this.offsetETankX = 0;
            this.once = false;
        }
        boolean isOverstep = false;
        int option = this.apperanceOption();
        for (int i = 0; i < TANK_ROW_NUM; ++i) {
            Queue rectFQueue = (Queue)this.eTankSparseArray.get(i);
            if (this.offsetETankX == 0 && i == option) {
                rectFQueue.offer(this.generateEnemyTank(i));
            }
            for (RectF rectF : rectFQueue) {
                if (rectF.left >= (float)width) {
                    isOverstep = true;
                    if (++this.overstepNum < 8) continue;
                    this.status = 2;
                    break;
                }
                this.drawTank(canvas, rectF);
            }
            if (this.status == 2) break;
            if (!isOverstep) continue;
            rectFQueue.poll();
            isOverstep = false;
        }
        this.invalidate();
    }

    private void drawTank(Canvas canvas, RectF rectF) {
        rectF.set(rectF.left + (float)this.enemySpeed, rectF.top, rectF.right + (float)this.enemySpeed, rectF.bottom);
        canvas.drawRect(rectF, this.mPaint);
        float barrelTop = rectF.top + (float)(this.controllerSize - this.barrelSize) * 0.5f;
        canvas.drawRect(rectF.right, barrelTop, rectF.right + (float)this.barrelSize, barrelTop + (float)this.barrelSize, this.mPaint);
    }

    private int apperanceOption() {
        return this.random.nextInt(TANK_ROW_NUM);
    }
}

