/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smartrefresh.header;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import com.scwang.smartrefresh.layout.api.RefreshHeader;
import com.scwang.smartrefresh.layout.api.RefreshKernel;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.constant.RefreshState;
import com.scwang.smartrefresh.layout.constant.SpinnerStyle;
import com.scwang.smartrefresh.layout.util.DensityUtil;

public class BezierCircleHeader
extends View
implements RefreshHeader {
    private static final int DURATION_FINISH = 800;
    private Path mPath;
    private Paint mBackPaint;
    private Paint mFrontPaint;
    private Paint mOuterPaint;
    private float mWaveHeight;
    private float mHeadHeight;
    private float mSpringRatio;
    private float mFinishRatio;
    private RefreshState mState;
    private float mBollY;
    private boolean mShowBoll;
    private boolean mShowBollTail;
    private boolean mShowOuter;
    private float mBollRadius;
    private int mRefreshStop = 90;
    private int mRefreshStart = 90;
    private boolean mOuterIsStart = true;
    private static final int TARGET_DEGREE = 270;

    public BezierCircleHeader(Context context) {
        super(context, null, 0);
        this.initView(context, null);
    }

    public BezierCircleHeader(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        this.initView(context, attrs);
    }

    public BezierCircleHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    @RequiresApi(value=21)
    public BezierCircleHeader(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs);
    }

    private void initView(Context context, AttributeSet attrs) {
        this.setMinimumHeight(DensityUtil.dp2px((float)100.0f));
        this.mBackPaint = new Paint();
        this.mBackPaint.setColor(-15614977);
        this.mBackPaint.setAntiAlias(true);
        this.mFrontPaint = new Paint();
        this.mFrontPaint.setColor(-1);
        this.mFrontPaint.setAntiAlias(true);
        this.mOuterPaint = new Paint();
        this.mOuterPaint.setAntiAlias(true);
        this.mOuterPaint.setColor(-1);
        this.mOuterPaint.setStyle(Paint.Style.STROKE);
        this.mOuterPaint.setStrokeWidth((float)DensityUtil.dp2px((float)2.0f));
        this.mPath = new Path();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(BezierCircleHeader.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), BezierCircleHeader.resolveSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isInEditMode()) {
            this.mShowBoll = true;
            this.mShowOuter = true;
            this.mHeadHeight = this.getHeight();
            this.mRefreshStop = 270;
            this.mBollY = this.mHeadHeight / 2.0f;
            this.mBollRadius = this.mHeadHeight / 6.0f;
        }
        int viewWidth = this.getWidth();
        int viewHeight = this.getHeight();
        this.drawWave(canvas, viewWidth, viewHeight);
        this.drawSpringUp(canvas, viewWidth);
        this.drawBoll(canvas, viewWidth);
        this.drawOuter(canvas, viewWidth);
        this.drawFinish(canvas, viewWidth);
    }

    private void drawWave(Canvas canvas, int viewWidth, int viewHeight) {
        float baseHeight = Math.min(this.mHeadHeight, (float)viewHeight);
        if (this.mWaveHeight != 0.0f) {
            this.mPath.reset();
            this.mPath.lineTo((float)viewWidth, 0.0f);
            this.mPath.lineTo((float)viewWidth, baseHeight);
            this.mPath.quadTo((float)(viewWidth / 2), baseHeight + this.mWaveHeight * 2.0f, 0.0f, baseHeight);
            this.mPath.close();
            canvas.drawPath(this.mPath, this.mBackPaint);
        } else {
            canvas.drawRect(0.0f, 0.0f, (float)viewWidth, baseHeight, this.mBackPaint);
        }
    }

    private void drawSpringUp(Canvas canvas, int viewWidth) {
        if (this.mSpringRatio > 0.0f) {
            float leftX = (float)(viewWidth / 2) - 4.0f * this.mBollRadius + this.mSpringRatio * 3.0f * this.mBollRadius;
            if ((double)this.mSpringRatio < 0.9) {
                this.mPath.reset();
                this.mPath.moveTo(leftX, this.mBollY);
                this.mPath.quadTo((float)(viewWidth / 2), this.mBollY - this.mBollRadius * this.mSpringRatio * 2.0f, (float)viewWidth - leftX, this.mBollY);
                canvas.drawPath(this.mPath, this.mFrontPaint);
            } else {
                canvas.drawCircle((float)(viewWidth / 2), this.mBollY, this.mBollRadius, this.mFrontPaint);
            }
        }
    }

    private void drawBoll(Canvas canvas, int viewWidth) {
        if (this.mShowBoll) {
            canvas.drawCircle((float)(viewWidth / 2), this.mBollY, this.mBollRadius, this.mFrontPaint);
            this.drawBollTail(canvas, viewWidth, (this.mHeadHeight + this.mWaveHeight) / this.mHeadHeight);
        }
    }

    private void drawBollTail(Canvas canvas, int viewWidth, float fraction) {
        if (this.mShowBollTail) {
            float bottom = this.mHeadHeight + this.mWaveHeight;
            float starty = this.mBollY + this.mBollRadius * fraction / 2.0f;
            float startx = (float)(viewWidth / 2) + (float)Math.sqrt(this.mBollRadius * this.mBollRadius * (1.0f - fraction * fraction / 4.0f));
            float bezier1x = (float)(viewWidth / 2) + this.mBollRadius * 3.0f / 4.0f * (1.0f - fraction);
            float bezier2x = bezier1x + this.mBollRadius;
            this.mPath.reset();
            this.mPath.moveTo(startx, starty);
            this.mPath.quadTo(bezier1x, bottom, bezier2x, bottom);
            this.mPath.lineTo((float)viewWidth - bezier2x, bottom);
            this.mPath.quadTo((float)viewWidth - bezier1x, bottom, (float)viewWidth - startx, starty);
            canvas.drawPath(this.mPath, this.mFrontPaint);
        }
    }

    private void drawOuter(Canvas canvas, int viewWidth) {
        if (this.mShowOuter) {
            float outerR = this.mBollRadius + this.mOuterPaint.getStrokeWidth() * 2.0f;
            this.mRefreshStart += this.mOuterIsStart ? 3 : 10;
            this.mRefreshStop += this.mOuterIsStart ? 10 : 3;
            this.mRefreshStart %= 360;
            this.mRefreshStop %= 360;
            int swipe = this.mRefreshStop - this.mRefreshStart;
            swipe = swipe < 0 ? swipe + 360 : swipe;
            canvas.drawArc(new RectF((float)(viewWidth / 2) - outerR, this.mBollY - outerR, (float)(viewWidth / 2) + outerR, this.mBollY + outerR), (float)this.mRefreshStart, (float)swipe, false, this.mOuterPaint);
            if (swipe >= 270) {
                this.mOuterIsStart = false;
            } else if (swipe <= 10) {
                this.mOuterIsStart = true;
            }
            this.invalidate();
        }
    }

    private void drawFinish(Canvas canvas, int viewWidth) {
        if (this.mFinishRatio > 0.0f) {
            int beforeColor = this.mOuterPaint.getColor();
            if ((double)this.mFinishRatio < 0.3) {
                canvas.drawCircle((float)(viewWidth / 2), this.mBollY, this.mBollRadius, this.mFrontPaint);
                int outerR = (int)(this.mBollRadius + this.mOuterPaint.getStrokeWidth() * 2.0f * (1.0f + this.mFinishRatio / 0.3f));
                int afterColor = Color.argb((int)((int)(255.0f * (1.0f - this.mFinishRatio / 0.3f))), (int)Color.red((int)beforeColor), (int)Color.green((int)beforeColor), (int)Color.blue((int)beforeColor));
                this.mOuterPaint.setColor(afterColor);
                canvas.drawArc(new RectF((float)(viewWidth / 2 - outerR), this.mBollY - (float)outerR, (float)(viewWidth / 2 + outerR), this.mBollY + (float)outerR), 0.0f, 360.0f, false, this.mOuterPaint);
            }
            this.mOuterPaint.setColor(beforeColor);
            if ((double)this.mFinishRatio >= 0.3 && (double)this.mFinishRatio < 0.7) {
                float fraction = (this.mFinishRatio - 0.3f) / 0.4f;
                this.mBollY = (int)(this.mHeadHeight / 2.0f + (this.mHeadHeight - this.mHeadHeight / 2.0f) * fraction);
                canvas.drawCircle((float)(viewWidth / 2), this.mBollY, this.mBollRadius, this.mFrontPaint);
                if (this.mBollY >= this.mHeadHeight - this.mBollRadius * 2.0f) {
                    this.mShowBollTail = true;
                    this.drawBollTail(canvas, viewWidth, fraction);
                }
                this.mShowBollTail = false;
            }
            if ((double)this.mFinishRatio >= 0.7 && this.mFinishRatio <= 1.0f) {
                float fraction = (this.mFinishRatio - 0.7f) / 0.3f;
                int leftX = (int)((float)(viewWidth / 2) - this.mBollRadius - 2.0f * this.mBollRadius * fraction);
                this.mPath.reset();
                this.mPath.moveTo((float)leftX, this.mHeadHeight);
                this.mPath.quadTo((float)(viewWidth / 2), this.mHeadHeight - this.mBollRadius * (1.0f - fraction), (float)(viewWidth - leftX), this.mHeadHeight);
                canvas.drawPath(this.mPath, this.mFrontPaint);
            }
        }
    }

    public void onInitialized(@NonNull RefreshKernel kernel, int height, int extendHeight) {
    }

    public boolean isSupportHorizontalDrag() {
        return false;
    }

    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
    }

    public void onPulling(float percent, int offset, int height, int extendHeight) {
        this.mHeadHeight = height;
        this.mWaveHeight = (float)Math.max(offset - height, 0) * 0.8f;
    }

    public void onReleased(RefreshLayout layout, int height, int extendHeight) {
        this.mHeadHeight = height;
        this.mBollRadius = height / 6;
        DecelerateInterpolator interpolator = new DecelerateInterpolator();
        final float reboundHeight = Math.min(this.mWaveHeight * 0.8f, this.mHeadHeight / 2.0f);
        ValueAnimator waveAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mWaveHeight, 0.0f, -(reboundHeight * 1.0f), 0.0f, -(reboundHeight * 0.4f), 0.0f});
        waveAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
            float speed = 0.0f;
            float springBollY;
            float springRatio = 0.0f;
            int springstatus = 0;

            public void onAnimationUpdate(ValueAnimator animation) {
                float curValue = ((Float)animation.getAnimatedValue()).floatValue();
                if (this.springstatus == 0 && curValue <= 0.0f) {
                    this.springstatus = 1;
                    this.speed = Math.abs(curValue - BezierCircleHeader.this.mWaveHeight);
                }
                if (this.springstatus == 1) {
                    this.springRatio = -curValue / reboundHeight;
                    if (this.springRatio >= BezierCircleHeader.this.mSpringRatio) {
                        BezierCircleHeader.this.mSpringRatio = this.springRatio;
                        BezierCircleHeader.this.mBollY = BezierCircleHeader.this.mHeadHeight + curValue;
                        this.speed = Math.abs(curValue - BezierCircleHeader.this.mWaveHeight);
                    } else {
                        this.springstatus = 2;
                        BezierCircleHeader.this.mSpringRatio = 0.0f;
                        BezierCircleHeader.this.mShowBoll = true;
                        BezierCircleHeader.this.mShowBollTail = true;
                        this.springBollY = BezierCircleHeader.this.mBollY;
                    }
                }
                if (this.springstatus == 2 && BezierCircleHeader.this.mBollY > BezierCircleHeader.this.mHeadHeight / 2.0f) {
                    BezierCircleHeader.this.mBollY = Math.max(BezierCircleHeader.this.mHeadHeight / 2.0f, BezierCircleHeader.this.mBollY - this.speed);
                    float bolly = animation.getAnimatedFraction() * (BezierCircleHeader.this.mHeadHeight / 2.0f - this.springBollY) + this.springBollY;
                    if (BezierCircleHeader.this.mBollY > bolly) {
                        BezierCircleHeader.this.mBollY = bolly;
                    }
                }
                if (BezierCircleHeader.this.mShowBollTail && curValue < BezierCircleHeader.this.mWaveHeight) {
                    BezierCircleHeader.this.mShowOuter = true;
                    BezierCircleHeader.this.mShowBollTail = false;
                    BezierCircleHeader.this.mOuterIsStart = true;
                    BezierCircleHeader.this.mRefreshStart = 90;
                    BezierCircleHeader.this.mRefreshStop = 90;
                }
                BezierCircleHeader.this.mWaveHeight = curValue;
                BezierCircleHeader.this.invalidate();
            }
        });
        waveAnimator.setInterpolator((TimeInterpolator)interpolator);
        waveAnimator.setDuration(1000L);
        waveAnimator.start();
    }

    public void onReleasing(float percent, int offset, int height, int extendHeight) {
        if (this.mState != RefreshState.Refreshing && this.mState != RefreshState.RefreshReleased) {
            this.onPulling(percent, offset, height, extendHeight);
        }
    }

    public void onStateChanged(RefreshLayout refreshLayout, RefreshState oldState, RefreshState newState) {
        this.mState = newState;
    }

    public void onStartAnimator(@NonNull RefreshLayout layout, int height, int extendHeight) {
    }

    public int onFinish(@NonNull RefreshLayout layout, boolean success) {
        this.mShowOuter = false;
        this.mShowBoll = false;
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                BezierCircleHeader.this.mFinishRatio = ((Float)animation.getAnimatedValue()).floatValue();
                BezierCircleHeader.this.invalidate();
            }
        });
        animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animator.setDuration(800L);
        animator.start();
        return 800;
    }

    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0) {
            this.mBackPaint.setColor(colors[0]);
            if (colors.length > 1) {
                this.mFrontPaint.setColor(colors[1]);
                this.mOuterPaint.setColor(colors[1]);
            }
        }
    }

    @NonNull
    public View getView() {
        return this;
    }

    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        return SpinnerStyle.Scale;
    }
}

