/*
 * Decompiled with CFR 0.152.
 */
package com.scglab.common.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.scglab.common.widget.R;

public class NetworkImageView
extends View {
    protected Paint paint;
    private String imageUrl;
    private String currentLoadedUrl;
    private boolean needResize;
    private boolean showRealImageSize;
    protected Bitmap drawImage;
    private EmptyImage emptyImage;
    private final SimpleTarget simpleTarget = new SimpleTarget<Bitmap>(){

        public void onResourceReady(Bitmap resource, GlideAnimation<? super Bitmap> glideAnimation) {
            if (null != resource) {
                NetworkImageView.this.setImage(resource);
            }
        }
    };

    public NetworkImageView(Context context) {
        super(context);
        this.init(null);
    }

    public NetworkImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context.getTheme().obtainStyledAttributes(attrs, this.getStyleable(), 0, 0));
    }

    public NetworkImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context.getTheme().obtainStyledAttributes(attrs, this.getStyleable(), defStyleAttr, 0));
    }

    public NetworkImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context.getTheme().obtainStyledAttributes(attrs, this.getStyleable(), defStyleAttr, defStyleRes));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        Point point = this.getResultSize();
        this.setMeasuredDimension(point.x, point.y);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.needResize) {
            boolean bl = this.needResize = !this.resizeImage();
        }
        if (null != this.drawImage) {
            canvas.drawBitmap(this.drawImage, 0.0f, 0.0f, null);
        } else if (null != this.getEmptyImage()) {
            canvas.drawBitmap(this.getEmptyImage().getBitmap(), (float)((canvas.getWidth() - this.getEmptyImage().getBitmap().getWidth()) / 2), (float)((canvas.getHeight() - this.getEmptyImage().getBitmap().getHeight()) / 2), null);
        }
    }

    public void setImage(int resId) {
        this.imageUrl = null;
        this.setImage(BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId));
    }

    public void setImage(Bitmap bitmap) {
        if (null == bitmap) {
            return;
        }
        this.currentLoadedUrl = this.imageUrl;
        this.drawImage = bitmap;
        this.needResize = true;
        this.requestLayout();
        this.invalidate();
    }

    public void clear() {
        this.currentLoadedUrl = null;
        this.imageUrl = null;
        this.drawImage = null;
        this.requestLayout();
        this.invalidate();
    }

    public void setImageUrl(String requestUrl) {
        if (null == requestUrl || requestUrl.isEmpty()) {
            this.clear();
            return;
        }
        if (null != this.imageUrl && this.imageUrl.equals(requestUrl)) {
            return;
        }
        if (null != this.currentLoadedUrl && this.currentLoadedUrl.equals(requestUrl)) {
            return;
        }
        this.clear();
        Glide.clear((Target)this.simpleTarget);
        this.imageUrl = requestUrl;
        Glide.with((Context)this.getContext()).load(this.imageUrl).asBitmap().into((Target)this.simpleTarget);
    }

    protected int[] getStyleable() {
        return R.styleable.NetworkImageView;
    }

    protected void initStyle(TypedArray typedArray) {
    }

    protected EmptyImage getEmptyImage() {
        return this.emptyImage;
    }

    protected Point getResultSize() {
        if (!this.showRealImageSize) {
            return new Point(this.getMeasuredWidth(), this.getMeasuredHeight());
        }
        if (null != this.drawImage) {
            return new Point(this.drawImage.getWidth(), this.drawImage.getHeight());
        }
        if (this.getEmptyImage().hasImage()) {
            return new Point(this.getEmptyImage().getBitmap().getWidth(), this.getEmptyImage().getBitmap().getHeight());
        }
        return new Point(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    protected void retouchDrawImage(Point point) {
        if (point.x != this.drawImage.getWidth() || point.y != this.drawImage.getHeight()) {
            this.drawImage = Bitmap.createScaledBitmap((Bitmap)this.drawImage, (int)point.x, (int)point.y, (boolean)true);
        }
    }

    private void init(TypedArray typedArray) {
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.showRealImageSize = typedArray.getBoolean(R.styleable.NetworkImageView_showRealImageSize, false);
        this.emptyImage = new EmptyImage(typedArray.getResourceId(R.styleable.NetworkImageView_emptyImage, -1));
        this.initStyle(typedArray);
        try {
            typedArray.recycle();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean resizeImage() {
        if (null == this.drawImage) {
            return false;
        }
        Point point = this.getResultSize();
        this.retouchDrawImage(point);
        return true;
    }

    public static interface Retouch {
        public Bitmap run(Bitmap var1);
    }

    public class EmptyImage {
        private Bitmap bitmap;
        private int res;

        public EmptyImage(int res) {
            this.res = res;
        }

        public Bitmap getBitmap() {
            if (!this.hasImage()) {
                return null;
            }
            if (null == this.bitmap) {
                this.bitmap = BitmapFactory.decodeResource((Resources)NetworkImageView.this.getResources(), (int)this.res);
            }
            return this.bitmap;
        }

        public boolean hasImage() {
            return this.res != -1;
        }

        public void retouch(Retouch retouch) {
            if (null != retouch) {
                this.bitmap = retouch.run(this.getBitmap());
            } else {
                Log.e((String)"ROOEX", (String)"retouch is null");
            }
        }
    }
}

