/*
 * Decompiled with CFR 0.152.
 */
package com.scglab.common.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.scglab.common.util.BitmapHelper;
import com.scglab.common.widget.NetworkImageView;
import com.scglab.common.widget.R;

public class CircleImageView
extends NetworkImageView {
    private int frameColor;
    private int frameStroke;
    private int circleSize;
    private NetworkImageView.Retouch retouch = new NetworkImageView.Retouch(){

        @Override
        public Bitmap run(Bitmap bitmap) {
            return BitmapHelper.circle((Bitmap)bitmap, (int)CircleImageView.this.circleSize, (int)CircleImageView.this.frameStroke, (int)CircleImageView.this.frameColor);
        }
    };

    public CircleImageView(Context context) {
        super(context);
        this.initEmptyImage();
    }

    public CircleImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initEmptyImage();
    }

    public CircleImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initEmptyImage();
    }

    public CircleImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initEmptyImage();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(this.circleSize, this.circleSize);
    }

    @Override
    protected int[] getStyleable() {
        return R.styleable.CircleImageView;
    }

    @Override
    protected void initStyle(TypedArray typedArray) {
        super.initStyle(typedArray);
        float density = this.getResources().getDisplayMetrics().density;
        this.frameColor = typedArray.getColor(R.styleable.CircleImageView_frameColor, -1);
        this.frameStroke = typedArray.getInt(R.styleable.CircleImageView_frameStroke, 0);
        this.frameStroke = (int)(density * (float)this.frameStroke);
        this.circleSize = typedArray.getInt(R.styleable.CircleImageView_circleSize, 100);
        this.circleSize = (int)(density * (float)this.circleSize);
    }

    @Override
    protected Point getResultSize() {
        float tempHeight;
        float tempWidth;
        if (null != this.drawImage) {
            tempWidth = this.drawImage.getWidth();
            tempHeight = this.drawImage.getHeight();
        } else if (this.getEmptyImage().hasImage()) {
            tempWidth = this.getEmptyImage().getBitmap().getWidth();
            tempHeight = this.getEmptyImage().getBitmap().getHeight();
        } else {
            return new Point(this.circleSize, this.circleSize);
        }
        float rate = tempWidth > tempHeight ? tempHeight / (float)this.circleSize : tempWidth / (float)this.circleSize;
        return new Point((int)(tempWidth /= rate), (int)(tempHeight /= rate));
    }

    @Override
    protected void retouchDrawImage(Point point) {
        super.retouchDrawImage(point);
        this.drawImage = this.retouch.run(this.drawImage);
    }

    private void initEmptyImage() {
        if (this.getEmptyImage().hasImage()) {
            this.getEmptyImage().retouch(this.retouch);
        }
    }
}

