/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.tracking.ui.overlay;

import android.view.View;
import com.scandit.datacapture.barcode.tracking.ui.overlay.AnchorPointCalculator$WhenMappings;
import com.scandit.datacapture.barcode.tracking.ui.overlay.BarcodeTrackingAdvancedOverlayKt;
import com.scandit.datacapture.core.common.geometry.Anchor;
import com.scandit.datacapture.core.common.geometry.FloatWithUnit;
import com.scandit.datacapture.core.common.geometry.MeasureUnit;
import com.scandit.datacapture.core.common.geometry.Point;
import com.scandit.datacapture.core.common.geometry.PointWithUnit;
import com.scandit.datacapture.core.common.geometry.Quadrilateral;
import com.scandit.datacapture.core.impl.utils.PixelExtensionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J!\u0010\t\u001a\u00020\u00042\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010\rJ/\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u001a\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/scandit/datacapture/barcode/tracking/ui/overlay/AnchorPointCalculator;", "", "()V", "calculateAnchorPoint", "Lcom/scandit/datacapture/core/common/geometry/PointWithUnit;", "location", "Lcom/scandit/datacapture/core/common/geometry/Quadrilateral;", "anchor", "Lcom/scandit/datacapture/core/common/geometry/Anchor;", "calculateAverage", "points", "", "Lcom/scandit/datacapture/core/common/geometry/Point;", "([Lcom/scandit/datacapture/core/common/geometry/Point;)Lcom/scandit/datacapture/core/common/geometry/PointWithUnit;", "calculateLocationInPixels", "trackedBarcodeLocation", "offset", "view", "Landroid/view/View;", "calculateLocationInPixels$sdc_barcode_android_release", "calculateOffset", "calculateSingleDimensionOffset", "Lcom/scandit/datacapture/core/common/geometry/FloatWithUnit;", "viewSizeInPixels", "", "sdc-barcode-android_release"})
public final class AnchorPointCalculator {
    public static final AnchorPointCalculator INSTANCE;

    @NotNull
    public final PointWithUnit calculateLocationInPixels$sdc_barcode_android_release(@NotNull Quadrilateral trackedBarcodeLocation, @NotNull Anchor anchor, @NotNull PointWithUnit offset, @Nullable View view) {
        Intrinsics.checkParameterIsNotNull((Object)trackedBarcodeLocation, (String)"trackedBarcodeLocation");
        Intrinsics.checkParameterIsNotNull((Object)anchor, (String)"anchor");
        Intrinsics.checkParameterIsNotNull((Object)offset, (String)"offset");
        return BarcodeTrackingAdvancedOverlayKt.access$plus(this.calculateAnchorPoint(trackedBarcodeLocation, anchor), this.calculateOffset(offset, view));
    }

    private final PointWithUnit calculateAnchorPoint(Quadrilateral location, Anchor anchor) {
        PointWithUnit pointWithUnit;
        switch (AnchorPointCalculator$WhenMappings.$EnumSwitchMapping$0[anchor.ordinal()]) {
            case 1: {
                Point[] pointArray = new Point[1];
                Point point = location.getTopLeft();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"location.topLeft");
                pointArray[0] = point;
                pointWithUnit = this.calculateAverage(pointArray);
                break;
            }
            case 2: {
                Point[] pointArray = new Point[2];
                Point point = location.getTopLeft();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"location.topLeft");
                pointArray[0] = point;
                Point point2 = location.getTopRight();
                Intrinsics.checkExpressionValueIsNotNull((Object)point2, (String)"location.topRight");
                pointArray[1] = point2;
                pointWithUnit = this.calculateAverage(pointArray);
                break;
            }
            case 3: {
                Point[] pointArray = new Point[1];
                Point point = location.getTopRight();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"location.topRight");
                pointArray[0] = point;
                pointWithUnit = this.calculateAverage(pointArray);
                break;
            }
            case 4: {
                Point[] pointArray = new Point[2];
                Point point = location.getTopLeft();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"location.topLeft");
                pointArray[0] = point;
                Point point3 = location.getBottomLeft();
                Intrinsics.checkExpressionValueIsNotNull((Object)point3, (String)"location.bottomLeft");
                pointArray[1] = point3;
                pointWithUnit = this.calculateAverage(pointArray);
                break;
            }
            case 5: {
                Point[] pointArray = new Point[4];
                Point point = location.getTopRight();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"location.topRight");
                pointArray[0] = point;
                Point point4 = location.getTopLeft();
                Intrinsics.checkExpressionValueIsNotNull((Object)point4, (String)"location.topLeft");
                pointArray[1] = point4;
                Point point5 = location.getBottomLeft();
                Intrinsics.checkExpressionValueIsNotNull((Object)point5, (String)"location.bottomLeft");
                pointArray[2] = point5;
                Point point6 = location.getBottomRight();
                Intrinsics.checkExpressionValueIsNotNull((Object)point6, (String)"location.bottomRight");
                pointArray[3] = point6;
                pointWithUnit = this.calculateAverage(pointArray);
                break;
            }
            case 6: {
                Point[] pointArray = new Point[2];
                Point point = location.getTopRight();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"location.topRight");
                pointArray[0] = point;
                Point point7 = location.getBottomRight();
                Intrinsics.checkExpressionValueIsNotNull((Object)point7, (String)"location.bottomRight");
                pointArray[1] = point7;
                pointWithUnit = this.calculateAverage(pointArray);
                break;
            }
            case 7: {
                Point[] pointArray = new Point[1];
                Point point = location.getBottomLeft();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"location.bottomLeft");
                pointArray[0] = point;
                pointWithUnit = this.calculateAverage(pointArray);
                break;
            }
            case 8: {
                Point[] pointArray = new Point[2];
                Point point = location.getBottomLeft();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"location.bottomLeft");
                pointArray[0] = point;
                Point point8 = location.getBottomRight();
                Intrinsics.checkExpressionValueIsNotNull((Object)point8, (String)"location.bottomRight");
                pointArray[1] = point8;
                pointWithUnit = this.calculateAverage(pointArray);
                break;
            }
            case 9: {
                Point[] pointArray = new Point[1];
                Point point = location.getBottomRight();
                Intrinsics.checkExpressionValueIsNotNull((Object)point, (String)"location.bottomRight");
                pointArray[0] = point;
                pointWithUnit = this.calculateAverage(pointArray);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pointWithUnit;
    }

    /*
     * WARNING - void declaration
     */
    private final PointWithUnit calculateAverage(Point ... points) {
        void $this$fold$iv;
        int n;
        void $this$fold$iv2;
        Point[] pointArray = points;
        float initial$iv22 = 0.0f;
        boolean $i$f$fold = false;
        float accumulator$iv = initial$iv22;
        void var7_10 = $this$fold$iv2;
        int n2 = ((void)var7_10).length;
        for (n = 0; n < n2; ++n) {
            void point;
            void element$iv;
            void var11_17 = element$iv = var7_10[n];
            float sum = accumulator$iv;
            boolean bl = false;
            accumulator$iv = sum + point.getX();
        }
        float avgX = accumulator$iv / (float)points.length;
        Point[] initial$iv22 = points;
        float initial$iv = 0.0f;
        boolean $i$f$fold2 = false;
        float accumulator$iv2 = initial$iv;
        void var8_13 = $this$fold$iv;
        n = ((void)var8_13).length;
        for (int i = 0; i < n; ++i) {
            void point;
            void element$iv;
            void sum = element$iv = var8_13[i];
            float sum2 = accumulator$iv2;
            boolean bl = false;
            accumulator$iv2 = sum2 + point.getY();
        }
        float avgY = accumulator$iv2 / (float)points.length;
        return new PointWithUnit(new FloatWithUnit(avgX, MeasureUnit.PIXEL), new FloatWithUnit(avgY, MeasureUnit.PIXEL));
    }

    private final PointWithUnit calculateOffset(PointWithUnit offset, View view) {
        FloatWithUnit floatWithUnit = offset.getX();
        Intrinsics.checkExpressionValueIsNotNull((Object)floatWithUnit, (String)"offset.x");
        View view2 = view;
        FloatWithUnit floatWithUnit2 = this.calculateSingleDimensionOffset(floatWithUnit, view2 != null ? view2.getWidth() : 0);
        FloatWithUnit floatWithUnit3 = offset.getY();
        Intrinsics.checkExpressionValueIsNotNull((Object)floatWithUnit3, (String)"offset.y");
        View view3 = view;
        return new PointWithUnit(floatWithUnit2, this.calculateSingleDimensionOffset(floatWithUnit3, view3 != null ? view3.getHeight() : 0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final FloatWithUnit calculateSingleDimensionOffset(FloatWithUnit offset, int viewSizeInPixels) {
        MeasureUnit measureUnit = offset.getUnit();
        if (measureUnit == null) throw (Throwable)new IllegalStateException("Unit of a FloatWithUnit has to be non-null");
        switch (AnchorPointCalculator$WhenMappings.$EnumSwitchMapping$1[measureUnit.ordinal()]) {
            case 1: {
                FloatWithUnit floatWithUnit = offset;
                return floatWithUnit;
            }
            case 2: {
                FloatWithUnit floatWithUnit = new FloatWithUnit(PixelExtensionsKt.pxFromDp((float)offset.getValue()), MeasureUnit.PIXEL);
                return floatWithUnit;
            }
            case 3: {
                FloatWithUnit floatWithUnit = new FloatWithUnit(offset.getValue() * (float)viewSizeInPixels, MeasureUnit.PIXEL);
                return floatWithUnit;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private AnchorPointCalculator() {
    }

    static {
        AnchorPointCalculator anchorPointCalculator;
        INSTANCE = anchorPointCalculator = new AnchorPointCalculator();
    }
}

