/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.tracking.impl.ui.overlay;

import com.scandit.datacapture.barcode.tracking.impl.capture.NativeBarcodeTracking;
import com.scandit.datacapture.barcode.tracking.impl.data.NativeTrackedBarcode;
import com.scandit.datacapture.barcode.tracking.impl.ui.overlay.NativeBarcodeTrackingBasicOverlayListener;
import com.scandit.datacapture.core.impl.ui.overlay.NativeDataCaptureOverlay;
import com.scandit.datacapture.core.impl.ui.style.NativeBrush;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeBarcodeTrackingBasicOverlay {
    public abstract NativeDataCaptureOverlay asDataCaptureOverlay();

    public abstract NativeBrush getDefaultBrush();

    public abstract void setDefaultBrush(NativeBrush var1);

    public abstract void setTrackedBarcodeBrush(NativeTrackedBarcode var1, NativeBrush var2);

    public abstract void setListener(NativeBarcodeTrackingBasicOverlayListener var1);

    public abstract NativeBarcodeTrackingBasicOverlayListener getListener();

    public abstract void setShouldShowScanAreaGuides(boolean var1);

    public abstract boolean getShouldShowScanAreaGuides();

    public static NativeBarcodeTrackingBasicOverlay create(NativeBarcodeTracking mode) {
        return CppProxy.create(mode);
    }

    public static NativeBrush defaultBrush() {
        return CppProxy.defaultBrush();
    }

    private static final class CppProxy
    extends NativeBarcodeTrackingBasicOverlay {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public NativeDataCaptureOverlay asDataCaptureOverlay() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_asDataCaptureOverlay(this.nativeRef);
        }

        private native NativeDataCaptureOverlay native_asDataCaptureOverlay(long var1);

        @Override
        public NativeBrush getDefaultBrush() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getDefaultBrush(this.nativeRef);
        }

        private native NativeBrush native_getDefaultBrush(long var1);

        @Override
        public void setDefaultBrush(NativeBrush brush) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setDefaultBrush(this.nativeRef, brush);
        }

        private native void native_setDefaultBrush(long var1, NativeBrush var3);

        @Override
        public void setTrackedBarcodeBrush(NativeTrackedBarcode trackedBarcode, NativeBrush brush) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setTrackedBarcodeBrush(this.nativeRef, trackedBarcode, brush);
        }

        private native void native_setTrackedBarcodeBrush(long var1, NativeTrackedBarcode var3, NativeBrush var4);

        @Override
        public void setListener(NativeBarcodeTrackingBasicOverlayListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setListener(this.nativeRef, listener);
        }

        private native void native_setListener(long var1, NativeBarcodeTrackingBasicOverlayListener var3);

        @Override
        public NativeBarcodeTrackingBasicOverlayListener getListener() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getListener(this.nativeRef);
        }

        private native NativeBarcodeTrackingBasicOverlayListener native_getListener(long var1);

        @Override
        public void setShouldShowScanAreaGuides(boolean show) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setShouldShowScanAreaGuides(this.nativeRef, show);
        }

        private native void native_setShouldShowScanAreaGuides(long var1, boolean var3);

        @Override
        public boolean getShouldShowScanAreaGuides() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getShouldShowScanAreaGuides(this.nativeRef);
        }

        private native boolean native_getShouldShowScanAreaGuides(long var1);

        public static native NativeBarcodeTrackingBasicOverlay create(NativeBarcodeTracking var0);

        public static native NativeBrush defaultBrush();
    }
}

