/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.tracking.impl.capture;

import com.scandit.datacapture.barcode.data.Symbology;
import com.scandit.datacapture.barcode.impl.capture.NativeSymbologySettings;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeBarcodeTrackingSettings {
    public abstract int getExpectedNumberOfBarcodesPerFrame();

    public abstract void setExpectedNumberOfBarcodesPerFrame(int var1);

    public abstract NativeSymbologySettings getSymbologySettings(Symbology var1);

    public abstract void setSymbologyEnabled(Symbology var1, boolean var2);

    public abstract void enableSymbologies(HashSet<Symbology> var1);

    public abstract HashSet<Symbology> getEnabledSymbologies();

    public abstract int getProperty(String var1);

    public abstract void setProperty(String var1, int var2);

    public static NativeBarcodeTrackingSettings create() {
        return CppProxy.create();
    }

    private static final class CppProxy
    extends NativeBarcodeTrackingSettings {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public int getExpectedNumberOfBarcodesPerFrame() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getExpectedNumberOfBarcodesPerFrame(this.nativeRef);
        }

        private native int native_getExpectedNumberOfBarcodesPerFrame(long var1);

        @Override
        public void setExpectedNumberOfBarcodesPerFrame(int expectedObjectsPerFrame) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setExpectedNumberOfBarcodesPerFrame(this.nativeRef, expectedObjectsPerFrame);
        }

        private native void native_setExpectedNumberOfBarcodesPerFrame(long var1, int var3);

        @Override
        public NativeSymbologySettings getSymbologySettings(Symbology symbology) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getSymbologySettings(this.nativeRef, symbology);
        }

        private native NativeSymbologySettings native_getSymbologySettings(long var1, Symbology var3);

        @Override
        public void setSymbologyEnabled(Symbology symbology, boolean enabled) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setSymbologyEnabled(this.nativeRef, symbology, enabled);
        }

        private native void native_setSymbologyEnabled(long var1, Symbology var3, boolean var4);

        @Override
        public void enableSymbologies(HashSet<Symbology> symbologies) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_enableSymbologies(this.nativeRef, symbologies);
        }

        private native void native_enableSymbologies(long var1, HashSet<Symbology> var3);

        @Override
        public HashSet<Symbology> getEnabledSymbologies() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getEnabledSymbologies(this.nativeRef);
        }

        private native HashSet<Symbology> native_getEnabledSymbologies(long var1);

        @Override
        public int getProperty(String key) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getProperty(this.nativeRef, key);
        }

        private native int native_getProperty(long var1, String var3);

        @Override
        public void setProperty(String key, int value) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setProperty(this.nativeRef, key, value);
        }

        private native void native_setProperty(long var1, String var3, int var4);

        public static native NativeBarcodeTrackingSettings create();
    }
}

