/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.tracking.impl.capture;

import com.scandit.datacapture.barcode.tracking.impl.capture.NativeBarcodeTrackingListener;
import com.scandit.datacapture.barcode.tracking.impl.capture.NativeBarcodeTrackingSession;
import com.scandit.datacapture.barcode.tracking.impl.capture.NativeBarcodeTrackingSettings;
import com.scandit.datacapture.core.impl.capture.NativeDataCaptureContext;
import com.scandit.datacapture.core.impl.capture.NativeDataCaptureMode;
import com.scandit.datacapture.core.impl.common.async.NativeWrappedFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeBarcodeTracking {
    public abstract boolean isEnabled();

    public abstract void setEnabled(boolean var1);

    public abstract NativeDataCaptureMode asDataCaptureMode();

    public abstract void addListenerAsync(NativeBarcodeTrackingListener var1, int var2);

    public abstract void removeListenerAsync(NativeBarcodeTrackingListener var1);

    public abstract NativeWrappedFuture applySettingsAndroid(NativeBarcodeTrackingSettings var1);

    public abstract NativeBarcodeTrackingSession getSession();

    public abstract NativeDataCaptureContext getContext();

    public static NativeBarcodeTracking create(NativeDataCaptureContext context, NativeBarcodeTrackingSettings settings) {
        return CppProxy.create(context, settings);
    }

    private static final class CppProxy
    extends NativeBarcodeTracking {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public boolean isEnabled() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isEnabled(this.nativeRef);
        }

        private native boolean native_isEnabled(long var1);

        @Override
        public void setEnabled(boolean enabled) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setEnabled(this.nativeRef, enabled);
        }

        private native void native_setEnabled(long var1, boolean var3);

        @Override
        public NativeDataCaptureMode asDataCaptureMode() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_asDataCaptureMode(this.nativeRef);
        }

        private native NativeDataCaptureMode native_asDataCaptureMode(long var1);

        @Override
        public void addListenerAsync(NativeBarcodeTrackingListener listener, int priority) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_addListenerAsync(this.nativeRef, listener, priority);
        }

        private native void native_addListenerAsync(long var1, NativeBarcodeTrackingListener var3, int var4);

        @Override
        public void removeListenerAsync(NativeBarcodeTrackingListener listener) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_removeListenerAsync(this.nativeRef, listener);
        }

        private native void native_removeListenerAsync(long var1, NativeBarcodeTrackingListener var3);

        @Override
        public NativeWrappedFuture applySettingsAndroid(NativeBarcodeTrackingSettings settings) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_applySettingsAndroid(this.nativeRef, settings);
        }

        private native NativeWrappedFuture native_applySettingsAndroid(long var1, NativeBarcodeTrackingSettings var3);

        @Override
        public NativeBarcodeTrackingSession getSession() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getSession(this.nativeRef);
        }

        private native NativeBarcodeTrackingSession native_getSession(long var1);

        @Override
        public NativeDataCaptureContext getContext() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getContext(this.nativeRef);
        }

        private native NativeDataCaptureContext native_getContext(long var1);

        public static native NativeBarcodeTracking create(NativeDataCaptureContext var0, NativeBarcodeTrackingSettings var1);
    }
}

