/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.impl.ui;

import com.scandit.datacapture.barcode.impl.capture.NativeBarcodeCapture;
import com.scandit.datacapture.core.impl.ui.overlay.NativeDataCaptureOverlay;
import com.scandit.datacapture.core.impl.ui.style.NativeBrush;
import com.scandit.datacapture.core.impl.ui.viewfinder.NativeViewfinder;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeBarcodeCaptureOverlay {
    public abstract NativeBrush getBrush();

    public abstract void setBrush(NativeBrush var1);

    public abstract NativeDataCaptureOverlay asDataCaptureOverlay();

    public abstract void setShouldShowScanAreaGuides(boolean var1);

    public abstract boolean getShouldShowScanAreaGuides();

    public abstract void setViewfinder(NativeViewfinder var1);

    public abstract NativeViewfinder getViewfinder();

    public static NativeBarcodeCaptureOverlay create(NativeBarcodeCapture mode) {
        return CppProxy.create(mode);
    }

    public static NativeBrush defaultBrush() {
        return CppProxy.defaultBrush();
    }

    private static final class CppProxy
    extends NativeBarcodeCaptureOverlay {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public NativeBrush getBrush() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getBrush(this.nativeRef);
        }

        private native NativeBrush native_getBrush(long var1);

        @Override
        public void setBrush(NativeBrush brush) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setBrush(this.nativeRef, brush);
        }

        private native void native_setBrush(long var1, NativeBrush var3);

        @Override
        public NativeDataCaptureOverlay asDataCaptureOverlay() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_asDataCaptureOverlay(this.nativeRef);
        }

        private native NativeDataCaptureOverlay native_asDataCaptureOverlay(long var1);

        @Override
        public void setShouldShowScanAreaGuides(boolean show) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setShouldShowScanAreaGuides(this.nativeRef, show);
        }

        private native void native_setShouldShowScanAreaGuides(long var1, boolean var3);

        @Override
        public boolean getShouldShowScanAreaGuides() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getShouldShowScanAreaGuides(this.nativeRef);
        }

        private native boolean native_getShouldShowScanAreaGuides(long var1);

        @Override
        public void setViewfinder(NativeViewfinder viewfinder) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setViewfinder(this.nativeRef, viewfinder);
        }

        private native void native_setViewfinder(long var1, NativeViewfinder var3);

        @Override
        public NativeViewfinder getViewfinder() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getViewfinder(this.nativeRef);
        }

        private native NativeViewfinder native_getViewfinder(long var1);

        public static native NativeBarcodeCaptureOverlay create(NativeBarcodeCapture var0);

        public static native NativeBrush defaultBrush();
    }
}

