/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.impl.data;

import com.scandit.datacapture.barcode.data.Symbology;
import com.scandit.datacapture.core.data.Range;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeSymbologyDescription {
    public abstract String getIdentifier();

    public abstract String getReadableName();

    public abstract boolean isAvailable();

    public abstract boolean isColorInvertible();

    public abstract Range getActiveSymbolCountRange();

    public abstract HashSet<String> getPublicExtensions();

    public static NativeSymbologyDescription create(Symbology symbology) {
        return CppProxy.create(symbology);
    }

    public static Symbology symbologyFromIdentifier(String identifier) {
        return CppProxy.symbologyFromIdentifier(identifier);
    }

    private static final class CppProxy
    extends NativeSymbologyDescription {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public String getIdentifier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getIdentifier(this.nativeRef);
        }

        private native String native_getIdentifier(long var1);

        @Override
        public String getReadableName() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getReadableName(this.nativeRef);
        }

        private native String native_getReadableName(long var1);

        @Override
        public boolean isAvailable() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isAvailable(this.nativeRef);
        }

        private native boolean native_isAvailable(long var1);

        @Override
        public boolean isColorInvertible() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isColorInvertible(this.nativeRef);
        }

        private native boolean native_isColorInvertible(long var1);

        @Override
        public Range getActiveSymbolCountRange() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getActiveSymbolCountRange(this.nativeRef);
        }

        private native Range native_getActiveSymbolCountRange(long var1);

        @Override
        public HashSet<String> getPublicExtensions() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getPublicExtensions(this.nativeRef);
        }

        private native HashSet<String> native_getPublicExtensions(long var1);

        public static native NativeSymbologyDescription create(Symbology var0);

        public static native Symbology symbologyFromIdentifier(String var0);
    }
}

