/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.impl.data;

import com.scandit.datacapture.barcode.data.CompositeFlag;
import com.scandit.datacapture.barcode.data.Symbology;
import com.scandit.datacapture.core.common.buffer.EncodingRange;
import com.scandit.datacapture.core.common.geometry.Quadrilateral;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeBarcode {
    public abstract Symbology getSymbology();

    public abstract ArrayList<EncodingRange> getDataEncoding();

    public abstract Quadrilateral getLocation();

    public abstract boolean isGs1DataCarrier();

    public abstract CompositeFlag getCompositeFlag();

    public abstract int getFrameId();

    public abstract int getSymbolCount();

    public abstract boolean isColorInverted();

    public abstract byte[] getData();

    private static final class CppProxy
    extends NativeBarcode {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public Symbology getSymbology() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getSymbology(this.nativeRef);
        }

        private native Symbology native_getSymbology(long var1);

        @Override
        public ArrayList<EncodingRange> getDataEncoding() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getDataEncoding(this.nativeRef);
        }

        private native ArrayList<EncodingRange> native_getDataEncoding(long var1);

        @Override
        public Quadrilateral getLocation() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getLocation(this.nativeRef);
        }

        private native Quadrilateral native_getLocation(long var1);

        @Override
        public boolean isGs1DataCarrier() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isGs1DataCarrier(this.nativeRef);
        }

        private native boolean native_isGs1DataCarrier(long var1);

        @Override
        public CompositeFlag getCompositeFlag() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getCompositeFlag(this.nativeRef);
        }

        private native CompositeFlag native_getCompositeFlag(long var1);

        @Override
        public int getFrameId() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getFrameId(this.nativeRef);
        }

        private native int native_getFrameId(long var1);

        @Override
        public int getSymbolCount() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getSymbolCount(this.nativeRef);
        }

        private native int native_getSymbolCount(long var1);

        @Override
        public boolean isColorInverted() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isColorInverted(this.nativeRef);
        }

        private native boolean native_isColorInverted(long var1);

        @Override
        public byte[] getData() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getData(this.nativeRef);
        }

        private native byte[] native_getData(long var1);
    }
}

