/*
 * Decompiled with CFR 0.152.
 */
package com.scandit.datacapture.barcode.impl.capture;

import com.scandit.datacapture.barcode.data.Checksum;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class NativeSymbologySettings {
    public abstract boolean isEnabled();

    public abstract void setEnabled(boolean var1);

    public abstract boolean isColorInvertedEnabled();

    public abstract void setColorInvertedEnabled(boolean var1);

    public abstract boolean isExtensionEnabled(String var1);

    public abstract HashSet<String> getEnabledExtensions();

    public abstract void setExtensionEnabled(String var1, boolean var2);

    public abstract HashSet<Short> getActiveSymbolCounts();

    public abstract void setActiveSymbolCounts(HashSet<Short> var1);

    public abstract EnumSet<Checksum> getChecksumBits();

    public abstract void setChecksumBits(EnumSet<Checksum> var1);

    private static final class CppProxy
    extends NativeSymbologySettings {
        private final long nativeRef;
        private final AtomicBoolean destroyed = new AtomicBoolean(false);

        private CppProxy(long nativeRef) {
            if (nativeRef == 0L) {
                throw new RuntimeException("nativeRef is zero");
            }
            this.nativeRef = nativeRef;
        }

        private native void nativeDestroy(long var1);

        public void _djinni_private_destroy() {
            boolean destroyed = this.destroyed.getAndSet(true);
            if (!destroyed) {
                this.nativeDestroy(this.nativeRef);
            }
        }

        protected void finalize() throws Throwable {
            this._djinni_private_destroy();
            super.finalize();
        }

        @Override
        public boolean isEnabled() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isEnabled(this.nativeRef);
        }

        private native boolean native_isEnabled(long var1);

        @Override
        public void setEnabled(boolean enabled) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setEnabled(this.nativeRef, enabled);
        }

        private native void native_setEnabled(long var1, boolean var3);

        @Override
        public boolean isColorInvertedEnabled() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isColorInvertedEnabled(this.nativeRef);
        }

        private native boolean native_isColorInvertedEnabled(long var1);

        @Override
        public void setColorInvertedEnabled(boolean enabled) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setColorInvertedEnabled(this.nativeRef, enabled);
        }

        private native void native_setColorInvertedEnabled(long var1, boolean var3);

        @Override
        public boolean isExtensionEnabled(String extension) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_isExtensionEnabled(this.nativeRef, extension);
        }

        private native boolean native_isExtensionEnabled(long var1, String var3);

        @Override
        public HashSet<String> getEnabledExtensions() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getEnabledExtensions(this.nativeRef);
        }

        private native HashSet<String> native_getEnabledExtensions(long var1);

        @Override
        public void setExtensionEnabled(String extension, boolean enabled) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setExtensionEnabled(this.nativeRef, extension, enabled);
        }

        private native void native_setExtensionEnabled(long var1, String var3, boolean var4);

        @Override
        public HashSet<Short> getActiveSymbolCounts() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getActiveSymbolCounts(this.nativeRef);
        }

        private native HashSet<Short> native_getActiveSymbolCounts(long var1);

        @Override
        public void setActiveSymbolCounts(HashSet<Short> activeCountsSet) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setActiveSymbolCounts(this.nativeRef, activeCountsSet);
        }

        private native void native_setActiveSymbolCounts(long var1, HashSet<Short> var3);

        @Override
        public EnumSet<Checksum> getChecksumBits() {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            return this.native_getChecksumBits(this.nativeRef);
        }

        private native EnumSet<Checksum> native_getChecksumBits(long var1);

        @Override
        public void setChecksumBits(EnumSet<Checksum> checksum) {
            assert (!this.destroyed.get()) : "trying to use a destroyed object";
            this.native_setChecksumBits(this.nativeRef, checksum);
        }

        private native void native_setChecksumBits(long var1, EnumSet<Checksum> var3);
    }
}

